/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.DoublePredicate;
import java.util.function.UnaryOperator;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.optim.PointValuePair;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv.Simplex;

public class MultiDirectionalTransform
implements Simplex.TransformFactory {
    private static final double ALPHA = 1.0;
    private static final double DEFAULT_GAMMA = 2.0;
    private static final double DEFAULT_SIGMA = 0.5;
    private final double gamma;
    private final double sigma;

    public MultiDirectionalTransform(double gamma, double sigma) {
        if (gamma < 1.0) {
            throw new IllegalArgumentException("gamma: " + gamma);
        }
        if (sigma < 0.0 || sigma > 1.0) {
            throw new IllegalArgumentException("sigma: " + sigma);
        }
        this.gamma = gamma;
        this.sigma = sigma;
    }

    public MultiDirectionalTransform() {
        this(2.0, 0.5);
    }

    @Override
    public UnaryOperator<Simplex> create(MultivariateFunction evaluationFunction, Comparator<PointValuePair> comparator, DoublePredicate sa) {
        return original -> {
            PointValuePair best = original.get(0);
            Simplex reflectedSimplex = this.transform((Simplex)original, 1.0, comparator, evaluationFunction);
            PointValuePair reflectedBest = reflectedSimplex.get(0);
            if (comparator.compare(reflectedBest, best) < 0) {
                Simplex expandedSimplex = this.transform((Simplex)original, this.gamma, comparator, evaluationFunction);
                PointValuePair expandedBest = expandedSimplex.get(0);
                if (comparator.compare(expandedBest, reflectedBest) <= 0 || sa != null && sa.test((Double)expandedBest.getValue() - (Double)reflectedBest.getValue())) {
                    return expandedSimplex;
                }
                return reflectedSimplex;
            }
            return original.shrink(this.sigma, evaluationFunction);
        };
    }

    private Simplex transform(Simplex original, double coeff, Comparator<PointValuePair> comp, MultivariateFunction evalFunc) {
        int replSize = original.getSize() - 1;
        ArrayList<PointValuePair> replacement = new ArrayList<PointValuePair>();
        double[] bestPoint = original.get(0).getPoint();
        for (int i = 0; i < replSize; ++i) {
            replacement.add(Simplex.newPoint(bestPoint, -coeff, original.get(i + 1).getPoint(), evalFunc));
        }
        return original.replaceLast(replacement).evaluate(evalFunc, comp);
    }

    public String toString() {
        return "Multidirectional [g=" + this.gamma + " s=" + this.sigma + "]";
    }
}

