/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class PrecisionTest {
    @Test
    public void testEqualsWithRelativeTolerance() {
        Assert.assertTrue((boolean)Precision.equalsWithRelativeTolerance((double)0.0, (double)0.0, (double)0.0));
        Assert.assertTrue((boolean)Precision.equalsWithRelativeTolerance((double)0.0, (double)-0.0, (double)0.0));
        double eps = 1.0E-14;
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)1.987654687654968, (double)1.987654687654988, (double)1.0E-14));
        Assert.assertTrue((boolean)Precision.equalsWithRelativeTolerance((double)1.987654687654968, (double)1.987654687654987, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)1.987654687654968, (double)1.987654687654948, (double)1.0E-14));
        Assert.assertTrue((boolean)Precision.equalsWithRelativeTolerance((double)1.987654687654968, (double)1.987654687654949, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)Precision.SAFE_MIN, (double)0.0, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)1.0000000000001E-300, (double)1.0E-300, (double)1.0E-14));
        Assert.assertTrue((boolean)Precision.equalsWithRelativeTolerance((double)1.00000000000001E-300, (double)1.0E-300, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)Double.NEGATIVE_INFINITY, (double)1.23, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)Double.POSITIVE_INFINITY, (double)1.23, (double)1.0E-14));
        Assert.assertTrue((boolean)Precision.equalsWithRelativeTolerance((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)1.0E-14));
        Assert.assertTrue((boolean)Precision.equalsWithRelativeTolerance((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)Double.NaN, (double)1.23, (double)1.0E-14));
        Assert.assertFalse((boolean)Precision.equalsWithRelativeTolerance((double)Double.NaN, (double)Double.NaN, (double)1.0E-14));
    }

    @Test
    public void testEqualsIncludingNaN() {
        double[] testArray = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.0, 0.0};
        for (int i = 0; i < testArray.length; ++i) {
            for (int j = 0; j < testArray.length; ++j) {
                if (i == j) {
                    Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)testArray[i], (double)testArray[j]));
                    Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)testArray[j], (double)testArray[i]));
                    continue;
                }
                Assert.assertTrue((!Precision.equalsIncludingNaN((double)testArray[i], (double)testArray[j]) ? 1 : 0) != 0);
                Assert.assertTrue((!Precision.equalsIncludingNaN((double)testArray[j], (double)testArray[i]) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testEqualsWithAllowedDelta() {
        Assert.assertTrue((boolean)Precision.equals((double)153.0, (double)153.0, (double)0.0625));
        Assert.assertTrue((boolean)Precision.equals((double)153.0, (double)153.0625, (double)0.0625));
        Assert.assertTrue((boolean)Precision.equals((double)152.9375, (double)153.0, (double)0.0625));
        Assert.assertFalse((boolean)Precision.equals((double)153.0, (double)153.0625, (double)0.0624));
        Assert.assertFalse((boolean)Precision.equals((double)152.9374, (double)153.0, (double)0.0625));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NaN, (double)Double.NaN, (double)1.0));
        Assert.assertTrue((boolean)Precision.equals((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0));
        Assert.assertTrue((boolean)Precision.equals((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)1.0));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0));
    }

    @Test
    public void testMath475() {
        double a = 1.7976931348623182E16;
        double b = FastMath.nextUp((double)1.7976931348623182E16);
        double diff = FastMath.abs((double)(1.7976931348623182E16 - b));
        Assert.assertTrue((boolean)Precision.equals((double)1.7976931348623182E16, (double)b, (double)(0.5 * diff)));
        double c = FastMath.nextUp((double)b);
        diff = FastMath.abs((double)(1.7976931348623182E16 - c));
        Assert.assertTrue((boolean)Precision.equals((double)1.7976931348623182E16, (double)c, (double)diff));
        Assert.assertFalse((boolean)Precision.equals((double)1.7976931348623182E16, (double)c, (double)(0.9999999999999999 * diff)));
    }

    @Test
    public void testEqualsIncludingNaNWithAllowedDelta() {
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)153.0, (double)153.0, (double)0.0625));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)153.0, (double)153.0625, (double)0.0625));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)152.9375, (double)153.0, (double)0.0625));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)Double.NaN, (double)Double.NaN, (double)1.0));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)1.0));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)1.0));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)153.0, (double)153.0625, (double)0.0624));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)152.9374, (double)153.0, (double)0.0625));
    }

    @Test
    public void testFloatEqualsWithAllowedUlps() {
        Assert.assertTrue((String)"+0.0f == -0.0f", (boolean)Precision.equals((float)0.0f, (float)-0.0f));
        Assert.assertTrue((String)"+0.0f == -0.0f (1 ulp)", (boolean)Precision.equals((float)0.0f, (float)-0.0f, (int)1));
        float oneFloat = 1.0f;
        Assert.assertTrue((String)"1.0f == 1.0f + 1 ulp", (boolean)Precision.equals((float)oneFloat, (float)Float.intBitsToFloat(1 + Float.floatToIntBits(oneFloat))));
        Assert.assertTrue((String)"1.0f == 1.0f + 1 ulp (1 ulp)", (boolean)Precision.equals((float)oneFloat, (float)Float.intBitsToFloat(1 + Float.floatToIntBits(oneFloat)), (int)1));
        Assert.assertFalse((String)"1.0f != 1.0f + 2 ulp (1 ulp)", (boolean)Precision.equals((float)oneFloat, (float)Float.intBitsToFloat(2 + Float.floatToIntBits(oneFloat)), (int)1));
        Assert.assertTrue((boolean)Precision.equals((float)153.0f, (float)153.0f, (int)1));
        Assert.assertTrue((boolean)Precision.equals((float)Float.POSITIVE_INFINITY, (float)Float.POSITIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)Double.MAX_VALUE, (double)Double.POSITIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equals((float)Float.NEGATIVE_INFINITY, (float)Float.NEGATIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equals((float)-3.4028235E38f, (float)Float.NEGATIVE_INFINITY, (int)1));
        Assert.assertFalse((boolean)Precision.equals((float)Float.NaN, (float)Float.NaN, (int)1));
        Assert.assertFalse((boolean)Precision.equals((float)Float.NaN, (float)Float.NaN, (int)0));
        Assert.assertFalse((boolean)Precision.equals((float)Float.NaN, (float)0.0f, (int)0));
        Assert.assertFalse((boolean)Precision.equals((float)Float.NaN, (float)Float.POSITIVE_INFINITY, (int)0));
        Assert.assertFalse((boolean)Precision.equals((float)Float.NaN, (float)Float.NEGATIVE_INFINITY, (int)0));
        Assert.assertFalse((boolean)Precision.equals((float)Float.NEGATIVE_INFINITY, (float)Float.POSITIVE_INFINITY, (int)100000));
    }

    @Test
    public void testEqualsWithAllowedUlps() {
        Assert.assertTrue((boolean)Precision.equals((double)0.0, (double)-0.0, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)1.0, (double)(1.0 + FastMath.ulp((double)1.0)), (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)1.0, (double)(1.0 + 2.0 * FastMath.ulp((double)1.0)), (int)1));
        double nUp1 = FastMath.nextAfter((double)1.0, (double)Double.POSITIVE_INFINITY);
        double nnUp1 = FastMath.nextAfter((double)nUp1, (double)Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)Precision.equals((double)1.0, (double)nUp1, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)nUp1, (double)nnUp1, (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)1.0, (double)nnUp1, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)0.0, (double)FastMath.ulp((double)0.0), (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)0.0, (double)(-FastMath.ulp((double)0.0)), (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)153.0, (double)153.0, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)153.0, (double)153.00000000000003, (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)153.0, (double)153.00000000000006, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)153.0, (double)152.99999999999997, (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)153.0, (double)152.99999999999994, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)-128.0, (double)-127.99999999999999, (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)-128.0, (double)-127.99999999999997, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)-128.0, (double)-128.00000000000003, (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)-128.0, (double)-128.00000000000006, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)Double.MAX_VALUE, (double)Double.POSITIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)-1.7976931348623157E308, (double)Double.NEGATIVE_INFINITY, (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NaN, (double)Double.NaN, (int)1));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NaN, (double)Double.NaN, (int)0));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NaN, (double)0.0, (int)0));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NaN, (double)Double.POSITIVE_INFINITY, (int)0));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NaN, (double)Double.NEGATIVE_INFINITY, (int)0));
        Assert.assertFalse((boolean)Precision.equals((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (int)100000));
    }

    @Test
    public void testEqualsIncludingNaNWithAllowedUlps() {
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)0.0, (double)-0.0, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)1.0, (double)(1.0 + FastMath.ulp((double)1.0)), (int)1));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)1.0, (double)(1.0 + 2.0 * FastMath.ulp((double)1.0)), (int)1));
        double nUp1 = FastMath.nextAfter((double)1.0, (double)Double.POSITIVE_INFINITY);
        double nnUp1 = FastMath.nextAfter((double)nUp1, (double)Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)1.0, (double)nUp1, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)nUp1, (double)nnUp1, (int)1));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)1.0, (double)nnUp1, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)0.0, (double)FastMath.ulp((double)0.0), (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)0.0, (double)(-FastMath.ulp((double)0.0)), (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)153.0, (double)153.0, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)153.0, (double)153.00000000000003, (int)1));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)153.0, (double)153.00000000000006, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)153.0, (double)152.99999999999997, (int)1));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)153.0, (double)152.99999999999994, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)-128.0, (double)-127.99999999999999, (int)1));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)-128.0, (double)-127.99999999999997, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)-128.0, (double)-128.00000000000003, (int)1));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)-128.0, (double)-128.00000000000006, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)Double.MAX_VALUE, (double)Double.POSITIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)-1.7976931348623157E308, (double)Double.NEGATIVE_INFINITY, (int)1));
        Assert.assertTrue((boolean)Precision.equalsIncludingNaN((double)Double.NaN, (double)Double.NaN, (int)1));
        Assert.assertFalse((boolean)Precision.equalsIncludingNaN((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (int)100000));
    }

    @Test
    public void testCompareToEpsilon() {
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)152.33, (double)152.32, (double)0.011));
        Assert.assertTrue((Precision.compareTo((double)152.308, (double)152.32, (double)0.011) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Precision.compareTo((double)152.33, (double)152.318, (double)0.011) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)Double.MIN_VALUE, (double)0.0, (double)Double.MIN_VALUE));
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)Double.MIN_VALUE, (double)-0.0, (double)Double.MIN_VALUE));
    }

    @Test
    public void testCompareToMaxUlps() {
        double a = 152.32;
        double delta = FastMath.ulp((double)a);
        for (int i = 0; i <= 10; ++i) {
            if (i <= 5) {
                Assert.assertEquals((long)0L, (long)Precision.compareTo((double)a, (double)(a + (double)i * delta), (int)5));
                Assert.assertEquals((long)0L, (long)Precision.compareTo((double)a, (double)(a - (double)i * delta), (int)5));
                continue;
            }
            Assert.assertEquals((long)-1L, (long)Precision.compareTo((double)a, (double)(a + (double)i * delta), (int)5));
            Assert.assertEquals((long)1L, (long)Precision.compareTo((double)a, (double)(a - (double)i * delta), (int)5));
        }
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)-0.0, (double)0.0, (int)0));
        Assert.assertEquals((long)-1L, (long)Precision.compareTo((double)-4.9E-324, (double)-0.0, (int)0));
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)-4.9E-324, (double)-0.0, (int)1));
        Assert.assertEquals((long)-1L, (long)Precision.compareTo((double)-4.9E-324, (double)0.0, (int)0));
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)-4.9E-324, (double)0.0, (int)1));
        Assert.assertEquals((long)1L, (long)Precision.compareTo((double)Double.MIN_VALUE, (double)-0.0, (int)0));
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)Double.MIN_VALUE, (double)-0.0, (int)1));
        Assert.assertEquals((long)1L, (long)Precision.compareTo((double)Double.MIN_VALUE, (double)0.0, (int)0));
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)Double.MIN_VALUE, (double)0.0, (int)1));
        Assert.assertEquals((long)-1L, (long)Precision.compareTo((double)-4.9E-324, (double)Double.MIN_VALUE, (int)0));
        Assert.assertEquals((long)-1L, (long)Precision.compareTo((double)-4.9E-324, (double)Double.MIN_VALUE, (int)1));
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)-4.9E-324, (double)Double.MIN_VALUE, (int)2));
        Assert.assertEquals((long)0L, (long)Precision.compareTo((double)Double.MAX_VALUE, (double)Double.POSITIVE_INFINITY, (int)1));
        Assert.assertEquals((long)-1L, (long)Precision.compareTo((double)Double.MAX_VALUE, (double)Double.POSITIVE_INFINITY, (int)0));
        Assert.assertEquals((long)1L, (long)Precision.compareTo((double)Double.MAX_VALUE, (double)Double.NaN, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)Precision.compareTo((double)Double.NaN, (double)Double.MAX_VALUE, (int)Integer.MAX_VALUE));
    }

    @Test
    public void testRoundDouble() {
        double x = 1.23456789;
        Assert.assertEquals((double)1.23, (double)Precision.round((double)x, (int)2), (double)0.0);
        Assert.assertEquals((double)1.235, (double)Precision.round((double)x, (int)3), (double)0.0);
        Assert.assertEquals((double)1.2346, (double)Precision.round((double)x, (int)4), (double)0.0);
        Assert.assertEquals((double)39.25, (double)Precision.round((double)39.245, (int)2), (double)0.0);
        Assert.assertEquals((double)39.24, (double)Precision.round((double)39.245, (int)2, (int)1), (double)0.0);
        double xx = 39.0;
        Assert.assertEquals((double)39.25, (double)Precision.round((double)(xx += 0.245), (int)2), (double)0.0);
        Assert.assertEquals((double)30.1, (double)Precision.round((double)30.095, (int)2), (double)0.0);
        Assert.assertEquals((double)30.1, (double)Precision.round((double)30.095, (int)1), (double)0.0);
        Assert.assertEquals((double)33.1, (double)Precision.round((double)33.095, (int)1), (double)0.0);
        Assert.assertEquals((double)33.1, (double)Precision.round((double)33.095, (int)2), (double)0.0);
        Assert.assertEquals((double)50.09, (double)Precision.round((double)50.085, (int)2), (double)0.0);
        Assert.assertEquals((double)50.19, (double)Precision.round((double)50.185, (int)2), (double)0.0);
        Assert.assertEquals((double)50.01, (double)Precision.round((double)50.005, (int)2), (double)0.0);
        Assert.assertEquals((double)30.01, (double)Precision.round((double)30.005, (int)2), (double)0.0);
        Assert.assertEquals((double)30.65, (double)Precision.round((double)30.645, (int)2), (double)0.0);
        Assert.assertEquals((double)1.24, (double)Precision.round((double)x, (int)2, (int)2), (double)0.0);
        Assert.assertEquals((double)1.235, (double)Precision.round((double)x, (int)3, (int)2), (double)0.0);
        Assert.assertEquals((double)1.2346, (double)Precision.round((double)x, (int)4, (int)2), (double)0.0);
        Assert.assertEquals((double)-1.23, (double)Precision.round((double)(-x), (int)2, (int)2), (double)0.0);
        Assert.assertEquals((double)-1.234, (double)Precision.round((double)(-x), (int)3, (int)2), (double)0.0);
        Assert.assertEquals((double)-1.2345, (double)Precision.round((double)(-x), (int)4, (int)2), (double)0.0);
        Assert.assertEquals((double)1.23, (double)Precision.round((double)x, (int)2, (int)1), (double)0.0);
        Assert.assertEquals((double)1.234, (double)Precision.round((double)x, (int)3, (int)1), (double)0.0);
        Assert.assertEquals((double)1.2345, (double)Precision.round((double)x, (int)4, (int)1), (double)0.0);
        Assert.assertEquals((double)-1.23, (double)Precision.round((double)(-x), (int)2, (int)1), (double)0.0);
        Assert.assertEquals((double)-1.234, (double)Precision.round((double)(-x), (int)3, (int)1), (double)0.0);
        Assert.assertEquals((double)-1.2345, (double)Precision.round((double)(-x), (int)4, (int)1), (double)0.0);
        Assert.assertEquals((double)1.23, (double)Precision.round((double)x, (int)2, (int)3), (double)0.0);
        Assert.assertEquals((double)1.234, (double)Precision.round((double)x, (int)3, (int)3), (double)0.0);
        Assert.assertEquals((double)1.2345, (double)Precision.round((double)x, (int)4, (int)3), (double)0.0);
        Assert.assertEquals((double)-1.24, (double)Precision.round((double)(-x), (int)2, (int)3), (double)0.0);
        Assert.assertEquals((double)-1.235, (double)Precision.round((double)(-x), (int)3, (int)3), (double)0.0);
        Assert.assertEquals((double)-1.2346, (double)Precision.round((double)(-x), (int)4, (int)3), (double)0.0);
        Assert.assertEquals((double)1.23, (double)Precision.round((double)x, (int)2, (int)5), (double)0.0);
        Assert.assertEquals((double)1.235, (double)Precision.round((double)x, (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)1.2346, (double)Precision.round((double)x, (int)4, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.23, (double)Precision.round((double)(-x), (int)2, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.235, (double)Precision.round((double)(-x), (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.2346, (double)Precision.round((double)(-x), (int)4, (int)5), (double)0.0);
        Assert.assertEquals((double)1.234, (double)Precision.round((double)1.2345, (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.234, (double)Precision.round((double)-1.2345, (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)1.23, (double)Precision.round((double)x, (int)2, (int)6), (double)0.0);
        Assert.assertEquals((double)1.235, (double)Precision.round((double)x, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)1.2346, (double)Precision.round((double)x, (int)4, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.23, (double)Precision.round((double)(-x), (int)2, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.235, (double)Precision.round((double)(-x), (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.2346, (double)Precision.round((double)(-x), (int)4, (int)6), (double)0.0);
        Assert.assertEquals((double)1.234, (double)Precision.round((double)1.2345, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.234, (double)Precision.round((double)-1.2345, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)1.236, (double)Precision.round((double)1.2355, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.236, (double)Precision.round((double)-1.2355, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)1.23, (double)Precision.round((double)x, (int)2, (int)4), (double)0.0);
        Assert.assertEquals((double)1.235, (double)Precision.round((double)x, (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)1.2346, (double)Precision.round((double)x, (int)4, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.23, (double)Precision.round((double)(-x), (int)2, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.235, (double)Precision.round((double)(-x), (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.2346, (double)Precision.round((double)(-x), (int)4, (int)4), (double)0.0);
        Assert.assertEquals((double)1.235, (double)Precision.round((double)1.2345, (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.235, (double)Precision.round((double)-1.2345, (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.23, (double)Precision.round((double)-1.23, (int)2, (int)7), (double)0.0);
        Assert.assertEquals((double)1.23, (double)Precision.round((double)1.23, (int)2, (int)7), (double)0.0);
        try {
            Precision.round((double)1.234, (int)2, (int)7);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        Assert.assertEquals((double)1.24, (double)Precision.round((double)x, (int)2, (int)0), (double)0.0);
        Assert.assertEquals((double)1.235, (double)Precision.round((double)x, (int)3, (int)0), (double)0.0);
        Assert.assertEquals((double)1.2346, (double)Precision.round((double)x, (int)4, (int)0), (double)0.0);
        Assert.assertEquals((double)-1.24, (double)Precision.round((double)(-x), (int)2, (int)0), (double)0.0);
        Assert.assertEquals((double)-1.235, (double)Precision.round((double)(-x), (int)3, (int)0), (double)0.0);
        Assert.assertEquals((double)-1.2346, (double)Precision.round((double)(-x), (int)4, (int)0), (double)0.0);
        try {
            Precision.round((double)1.234, (int)2, (int)1923);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((double)39.25, (double)Precision.round((double)39.245, (int)2, (int)4), (double)0.0);
        TestUtils.assertEquals(Double.NaN, Precision.round((double)Double.NaN, (int)2), 0.0);
        Assert.assertEquals((double)0.0, (double)Precision.round((double)0.0, (int)2), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Precision.round((double)Double.POSITIVE_INFINITY, (int)2), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)Precision.round((double)Double.NEGATIVE_INFINITY, (int)2), (double)0.0);
        Assert.assertEquals((Object)"-0.0", (Object)Double.toString(Precision.round((double)-0.0, (int)0)));
        Assert.assertEquals((Object)"-0.0", (Object)Double.toString(Precision.round((double)-1.0E-10, (int)0)));
    }

    @Test
    public void testRoundFloat() {
        float x = 1.2345679f;
        Assert.assertEquals((double)1.23f, (double)Precision.round((float)x, (int)2), (double)0.0);
        Assert.assertEquals((double)1.235f, (double)Precision.round((float)x, (int)3), (double)0.0);
        Assert.assertEquals((double)1.2346f, (double)Precision.round((float)x, (int)4), (double)0.0);
        Assert.assertEquals((float)30.1f, (float)Precision.round((float)30.095f, (int)2), (float)0.0f);
        Assert.assertEquals((float)30.1f, (float)Precision.round((float)30.095f, (int)1), (float)0.0f);
        Assert.assertEquals((float)50.09f, (float)Precision.round((float)50.085f, (int)2), (float)0.0f);
        Assert.assertEquals((float)50.19f, (float)Precision.round((float)50.185f, (int)2), (float)0.0f);
        Assert.assertEquals((float)50.01f, (float)Precision.round((float)50.005f, (int)2), (float)0.0f);
        Assert.assertEquals((float)30.01f, (float)Precision.round((float)30.005f, (int)2), (float)0.0f);
        Assert.assertEquals((float)30.65f, (float)Precision.round((float)30.645f, (int)2), (float)0.0f);
        Assert.assertEquals((double)1.24f, (double)Precision.round((float)x, (int)2, (int)2), (double)0.0);
        Assert.assertEquals((double)1.235f, (double)Precision.round((float)x, (int)3, (int)2), (double)0.0);
        Assert.assertEquals((double)1.2346f, (double)Precision.round((float)x, (int)4, (int)2), (double)0.0);
        Assert.assertEquals((double)-1.23f, (double)Precision.round((float)(-x), (int)2, (int)2), (double)0.0);
        Assert.assertEquals((double)-1.234f, (double)Precision.round((float)(-x), (int)3, (int)2), (double)0.0);
        Assert.assertEquals((double)-1.2345f, (double)Precision.round((float)(-x), (int)4, (int)2), (double)0.0);
        Assert.assertEquals((double)1.23f, (double)Precision.round((float)x, (int)2, (int)1), (double)0.0);
        Assert.assertEquals((double)1.234f, (double)Precision.round((float)x, (int)3, (int)1), (double)0.0);
        Assert.assertEquals((double)1.2345f, (double)Precision.round((float)x, (int)4, (int)1), (double)0.0);
        Assert.assertEquals((double)-1.23f, (double)Precision.round((float)(-x), (int)2, (int)1), (double)0.0);
        Assert.assertEquals((double)-1.234f, (double)Precision.round((float)(-x), (int)3, (int)1), (double)0.0);
        Assert.assertEquals((double)-1.2345f, (double)Precision.round((float)(-x), (int)4, (int)1), (double)0.0);
        Assert.assertEquals((double)1.23f, (double)Precision.round((float)x, (int)2, (int)3), (double)0.0);
        Assert.assertEquals((double)1.234f, (double)Precision.round((float)x, (int)3, (int)3), (double)0.0);
        Assert.assertEquals((double)1.2345f, (double)Precision.round((float)x, (int)4, (int)3), (double)0.0);
        Assert.assertEquals((double)-1.24f, (double)Precision.round((float)(-x), (int)2, (int)3), (double)0.0);
        Assert.assertEquals((double)-1.235f, (double)Precision.round((float)(-x), (int)3, (int)3), (double)0.0);
        Assert.assertEquals((double)-1.2346f, (double)Precision.round((float)(-x), (int)4, (int)3), (double)0.0);
        Assert.assertEquals((double)1.23f, (double)Precision.round((float)x, (int)2, (int)5), (double)0.0);
        Assert.assertEquals((double)1.235f, (double)Precision.round((float)x, (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)1.2346f, (double)Precision.round((float)x, (int)4, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.23f, (double)Precision.round((float)(-x), (int)2, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.235f, (double)Precision.round((float)(-x), (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.2346f, (double)Precision.round((float)(-x), (int)4, (int)5), (double)0.0);
        Assert.assertEquals((double)1.234f, (double)Precision.round((float)1.2345f, (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)-1.234f, (double)Precision.round((float)-1.2345f, (int)3, (int)5), (double)0.0);
        Assert.assertEquals((double)1.23f, (double)Precision.round((float)x, (int)2, (int)6), (double)0.0);
        Assert.assertEquals((double)1.235f, (double)Precision.round((float)x, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)1.2346f, (double)Precision.round((float)x, (int)4, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.23f, (double)Precision.round((float)(-x), (int)2, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.235f, (double)Precision.round((float)(-x), (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.2346f, (double)Precision.round((float)(-x), (int)4, (int)6), (double)0.0);
        Assert.assertEquals((double)1.234f, (double)Precision.round((float)1.2345f, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.234f, (double)Precision.round((float)-1.2345f, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)1.236f, (double)Precision.round((float)1.2355f, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)-1.236f, (double)Precision.round((float)-1.2355f, (int)3, (int)6), (double)0.0);
        Assert.assertEquals((double)1.23f, (double)Precision.round((float)x, (int)2, (int)4), (double)0.0);
        Assert.assertEquals((double)1.235f, (double)Precision.round((float)x, (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)1.2346f, (double)Precision.round((float)x, (int)4, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.23f, (double)Precision.round((float)(-x), (int)2, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.235f, (double)Precision.round((float)(-x), (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.2346f, (double)Precision.round((float)(-x), (int)4, (int)4), (double)0.0);
        Assert.assertEquals((double)1.235f, (double)Precision.round((float)1.2345f, (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.235f, (double)Precision.round((float)-1.2345f, (int)3, (int)4), (double)0.0);
        Assert.assertEquals((double)-1.23f, (double)Precision.round((float)-1.23f, (int)2, (int)7), (double)0.0);
        Assert.assertEquals((double)1.23f, (double)Precision.round((float)1.23f, (int)2, (int)7), (double)0.0);
        try {
            Precision.round((float)1.234f, (int)2, (int)7);
            Assert.fail();
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        Assert.assertEquals((double)1.24f, (double)Precision.round((float)x, (int)2, (int)0), (double)0.0);
        Assert.assertEquals((double)1.235f, (double)Precision.round((float)x, (int)3, (int)0), (double)0.0);
        Assert.assertEquals((double)1.2346f, (double)Precision.round((float)x, (int)4, (int)0), (double)0.0);
        Assert.assertEquals((double)-1.24f, (double)Precision.round((float)(-x), (int)2, (int)0), (double)0.0);
        Assert.assertEquals((double)-1.235f, (double)Precision.round((float)(-x), (int)3, (int)0), (double)0.0);
        Assert.assertEquals((double)-1.2346f, (double)Precision.round((float)(-x), (int)4, (int)0), (double)0.0);
        try {
            Precision.round((float)1.234f, (int)2, (int)1923);
            Assert.fail();
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        TestUtils.assertEquals(Double.NaN, Precision.round((float)Float.NaN, (int)2), 0.0);
        Assert.assertEquals((float)0.0f, (float)Precision.round((float)0.0f, (int)2), (float)0.0f);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)Precision.round((float)Float.POSITIVE_INFINITY, (int)2), (float)0.0f);
        Assert.assertEquals((float)Float.NEGATIVE_INFINITY, (float)Precision.round((float)Float.NEGATIVE_INFINITY, (int)2), (float)0.0f);
        Assert.assertEquals((Object)"-0.0", (Object)Float.toString(Precision.round((float)-0.0f, (int)0)));
        Assert.assertEquals((Object)"-0.0", (Object)Float.toString(Precision.round((float)-1.0E-10f, (int)0)));
        Assert.assertEquals((float)0.0f, (float)Precision.round((float)0.0f, (int)2, (int)0), (float)0.0f);
        Assert.assertEquals((float)0.05f, (float)Precision.round((float)0.05f, (int)2, (int)0), (float)0.0f);
        Assert.assertEquals((float)0.06f, (float)Precision.round((float)0.051f, (int)2, (int)0), (float)0.0f);
        Assert.assertEquals((float)0.06f, (float)Precision.round((float)0.0505f, (int)2, (int)0), (float)0.0f);
        Assert.assertEquals((float)0.06f, (float)Precision.round((float)0.059f, (int)2, (int)0), (float)0.0f);
    }

    @Test
    public void testIssue721() {
        Assert.assertEquals((long)-53L, (long)FastMath.getExponent((double)Precision.EPSILON));
        Assert.assertEquals((long)-1022L, (long)FastMath.getExponent((double)Precision.SAFE_MIN));
    }

    @Test
    public void testRepresentableDelta() {
        int nonRepresentableCount = 0;
        double x = 100.0;
        int numTrials = 10000;
        for (int i = 0; i < 10000; ++i) {
            double originalDelta = FastMath.random();
            double delta = Precision.representableDelta((double)100.0, (double)originalDelta);
            if (delta == originalDelta) continue;
            ++nonRepresentableCount;
        }
        Assert.assertTrue(((double)nonRepresentableCount / 10000.0 > 0.9 ? 1 : 0) != 0);
    }

    @Test
    public void testMath843() {
        double afterEpsilon = FastMath.nextAfter((double)Precision.EPSILON, (double)Double.POSITIVE_INFINITY);
        Assert.assertTrue((1.0 + Precision.EPSILON == 1.0 ? 1 : 0) != 0);
        Assert.assertFalse((1.0 + afterEpsilon == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMath1127() {
        Assert.assertFalse((boolean)Precision.equals((double)2.0, (double)-2.0, (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)0.0, (double)-0.0, (int)0));
        Assert.assertFalse((boolean)Precision.equals((float)2.0f, (float)-2.0f, (int)1));
        Assert.assertTrue((boolean)Precision.equals((float)0.0f, (float)-0.0f, (int)0));
    }
}

