/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.gradient;

import java.util.ArrayList;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunctionGradient;

public class CircleScalar {
    private ArrayList<Vector2D> points = new ArrayList();

    public void addPoint(double px, double py) {
        this.points.add(new Vector2D(px, py));
    }

    public double getRadius(Vector2D center) {
        double r = 0.0;
        for (Vector2D point : this.points) {
            r += point.distance((Vector)center);
        }
        return r / (double)this.points.size();
    }

    public ObjectiveFunction getObjectiveFunction() {
        return new ObjectiveFunction(new MultivariateFunction(){

            public double value(double[] params) {
                Vector2D center = new Vector2D(params[0], params[1]);
                double radius = CircleScalar.this.getRadius(center);
                double sum = 0.0;
                for (Vector2D point : CircleScalar.this.points) {
                    double di = point.distance((Vector)center) - radius;
                    sum += di * di;
                }
                return sum;
            }
        });
    }

    public ObjectiveFunctionGradient getObjectiveFunctionGradient() {
        return new ObjectiveFunctionGradient(new MultivariateVectorFunction(){

            public double[] value(double[] params) {
                Vector2D center = new Vector2D(params[0], params[1]);
                double radius = CircleScalar.this.getRadius(center);
                double dJdX = 0.0;
                double dJdY = 0.0;
                for (Vector2D pk : CircleScalar.this.points) {
                    double dk = pk.distance((Vector)center);
                    dJdX += (center.getX() - pk.getX()) * (dk - radius) / dk;
                    dJdY += (center.getY() - pk.getY()) * (dk - radius) / dk;
                }
                return new double[]{dJdX *= 2.0, dJdY *= 2.0};
            }
        });
    }
}

