/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.oned;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializerFactory;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.oned.NeuronString;
import org.junit.Assert;
import org.junit.Test;

public class NeuronStringTest {
    final FeatureInitializer init = FeatureInitializerFactory.uniform((double)0.0, (double)2.0);

    @Test
    public void testSegmentNetwork() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronString(4, false, initArray).getNetwork();
        Collection neighbours = net.getNeighbours(net.getNeuron(0L));
        for (long nId : new long[]{1L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)1L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(1L));
        for (long nId : new long[]{0L, 2L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)2L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(2L));
        for (long nId : new long[]{1L, 3L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)2L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(3L));
        for (long nId : new long[]{2L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)1L, (long)neighbours.size());
    }

    @Test
    public void testCircleNetwork() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronString(4, true, initArray).getNetwork();
        Collection neighbours = net.getNeighbours(net.getNeuron(0L));
        for (long nId : new long[]{1L, 3L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)2L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(1L));
        for (long nId : new long[]{0L, 2L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)2L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(2L));
        for (long nId : new long[]{1L, 3L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)2L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(3L));
        for (long nId : new long[]{0L, 2L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)2L, (long)neighbours.size());
    }

    @Test
    public void testGetNeighboursWithExclude() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronString(5, true, initArray).getNetwork();
        ArrayList<Neuron> exclude = new ArrayList<Neuron>();
        exclude.add(net.getNeuron(1L));
        Collection neighbours = net.getNeighbours(net.getNeuron(0L), exclude);
        Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(4L)));
        Assert.assertEquals((long)1L, (long)neighbours.size());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        NeuronString out = new NeuronString(4, false, initArray);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(out);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        NeuronString in = (NeuronString)ois.readObject();
        for (Neuron nOut : out.getNetwork()) {
            Neuron nIn = in.getNetwork().getNeuron(nOut.getIdentifier());
            double[] outF = nOut.getFeatures();
            double[] inF = nIn.getFeatures();
            Assert.assertEquals((long)outF.length, (long)inF.length);
            for (int i = 0; i < outF.length; ++i) {
                Assert.assertEquals((double)outF[i], (double)inF[i], (double)0.0);
            }
            Collection outNeighbours = out.getNetwork().getNeighbours(nOut);
            Collection inNeighbours = in.getNetwork().getNeighbours(nIn);
            Assert.assertEquals((long)outNeighbours.size(), (long)inNeighbours.size());
            for (Neuron oN : outNeighbours) {
                Assert.assertTrue((boolean)inNeighbours.contains(in.getNetwork().getNeuron(oN.getIdentifier())));
            }
        }
    }
}

