/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.test.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.Embedded;
import org.xml.sax.InputSource;

public class TestEmbedded
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)TestEmbedded.suite());
    }

    public static Test suite() {
        return new TestSuite(TestEmbedded.class);
    }

    public TestEmbedded(String testName) {
        super(testName);
    }

    public void testStringAsScript() {
        Embedded embedded = new Embedded();
        String jellyScript = "<?xml version=\"1.0\"?> <j:jelly xmlns:j=\"jelly:core\">jelly-test-case </j:jelly>";
        embedded.setScript(jellyScript);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        embedded.setOutputStream((OutputStream)baos);
        boolean status = embedded.execute();
        TestEmbedded.assertTrue((String)"Emebedded execution failed", (boolean)status);
        TestEmbedded.assertEquals((String)"jelly-test-case", (String)new String(baos.toByteArray()));
        embedded.setScript(jellyScript + "obnoxious-part");
        status = embedded.execute();
        TestEmbedded.assertFalse((String)"A script with bad XML was executed successfully", (boolean)status);
        TestEmbedded.assertNotNull((String)"A script with bad XML didn't generate an error message", (Object)embedded.getErrorMsg());
    }

    public void testInputStreamAsScript() {
        Embedded embedded = new Embedded();
        String jellyScript = "<?xml version=\"1.0\"?> <j:jelly xmlns:j=\"jelly:core\">jelly-test-case </j:jelly>";
        embedded.setScript((InputStream)new ByteArrayInputStream(jellyScript.getBytes()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        embedded.setOutputStream((OutputStream)baos);
        boolean status = embedded.execute();
        TestEmbedded.assertEquals((boolean)status, (boolean)true);
        TestEmbedded.assertEquals((String)"jelly-test-case", (String)new String(baos.toByteArray()));
    }

    public void testRawExecuteAsString() throws Exception {
        String message = "<?xml version=\"1.0\"?> <j:jelly xmlns:j=\"jelly:core\">jelly-test-case </j:jelly>";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)output);
        InputSource script = new InputSource(new StringReader(message.toString()));
        JellyContext context = new JellyContext();
        context.runScript(script, xmlOutput);
        output.close();
        TestEmbedded.assertEquals((String)"jelly-test-case", (String)new String(output.toByteArray()));
    }
}

