/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.XXHash32;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class XXHash32Test {
    private Path file;
    private String expectedChecksum;

    XXHash32Test() {
    }

    private static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IOUtils.copyLarge((InputStream)input, (OutputStream)output, (byte[])new byte[bufferSize]);
    }

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"org/apache/commons/codec/bla.tar", "fbb5c8d1"}), Arguments.of((Object[])new Object[]{"org/apache/commons/codec/bla.tar.xz", "4106a208"}), Arguments.of((Object[])new Object[]{"org/apache/commons/codec/small.bin", "f66c26f8"}));
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XXHash32Test.copy(input, output, 10240);
        return output.toByteArray();
    }

    public void initData(String path, String c) throws Exception {
        URL url = XXHash32Test.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("couldn't find " + path);
        }
        this.file = Paths.get(url.toURI());
        this.expectedChecksum = c;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void verifyChecksum(String path, String c) throws Exception {
        this.initData(path, c);
        XXHash32 hasher = new XXHash32();
        try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);){
            byte[] bytes = XXHash32Test.toByteArray(in);
            hasher.update(bytes, 0, bytes.length);
        }
        Assertions.assertEquals((Object)this.expectedChecksum, (Object)Long.toHexString(hasher.getValue()), (String)("checksum for " + this.file));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void verifyIncrementalChecksum(String path, String c) throws Exception {
        this.initData(path, c);
        XXHash32 hasher = new XXHash32();
        try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);){
            byte[] bytes = XXHash32Test.toByteArray(in);
            hasher.update((int)bytes[0]);
            hasher.reset();
            hasher.update((int)bytes[0]);
            hasher.update(bytes, 1, bytes.length - 2);
            hasher.update(bytes, bytes.length - 1, 1);
            hasher.update(bytes, 0, -1);
        }
        Assertions.assertEquals((Object)this.expectedChecksum, (Object)Long.toHexString(hasher.getValue()), (String)("checksum for " + this.file));
    }
}

