/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CommandLineTest {
    CommandLineTest() {
    }

    private static Stream<Arguments> createHasOptionParameters() throws ParseException {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        Option optT = Option.builder().option("T").longOpt("tee").deprecated().optionalArg(true).get();
        Option optU = Option.builder((String)"U").longOpt("you").optionalArg(true).get();
        OptionGroup optionGroup = new OptionGroup().addOption(optT).addOption(optU);
        String[] foobar = new String[]{"foo", "bar"};
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optT, optionGroup, true, true, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "foo"}, optT, optionGroup, true, true, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optT, optionGroup, true, true, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "foo"}, optT, optionGroup, true, true, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optT, optionGroup, false, false, false, true, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "foo", "bar"}, optT, optionGroup, false, false, false, true, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optT, optionGroup, false, false, false, true, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "foo", "bar"}, optT, optionGroup, false, false, false, true, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optU, optionGroup, false, false, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "foo", "bar"}, optU, optionGroup, false, false, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optU, optionGroup, false, false, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "foo", "bar"}, optU, optionGroup, false, false, true, true, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optU, optionGroup, false, true, false, true, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "foo", "bar"}, optU, optionGroup, false, true, false, true, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optU, optionGroup, false, true, false, true, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "foo", "bar"}, optU, optionGroup, false, true, false, true, optU}));
        return lst.stream();
    }

    private static Stream<Arguments> createOptionValueParameters() throws ParseException {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        Option optT = Option.builder().option("T").longOpt("tee").deprecated().optionalArg(true).get();
        Option optU = Option.builder((String)"U").longOpt("you").optionalArg(true).get();
        OptionGroup optionGroup = new OptionGroup().addOption(optT).addOption(optU);
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "foo"}, optT, optionGroup, true, "foo", true, "foo", optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "foo"}, optT, optionGroup, true, "foo", true, "foo", optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "foo"}, optT, optionGroup, false, null, false, "foo", optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "foo"}, optT, optionGroup, false, null, false, "foo", optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "foo"}, optU, optionGroup, false, null, true, "foo", optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "foo"}, optU, optionGroup, false, null, true, "foo", optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "foo"}, optU, optionGroup, false, "foo", false, "foo", optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "foo"}, optU, optionGroup, false, "foo", false, "foo", optU}));
        return lst.stream();
    }

    private static Stream<Arguments> createOptionValuesParameters() throws ParseException {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        Option optT = Option.builder().option("T").longOpt("tee").numberOfArgs(2).deprecated().optionalArg(true).get();
        Option optU = Option.builder((String)"U").longOpt("you").numberOfArgs(2).optionalArg(true).get();
        OptionGroup optionGroup = new OptionGroup().addOption(optT).addOption(optU);
        String[] foobar = new String[]{"foo", "bar"};
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "foo", "bar"}, optT, optionGroup, true, foobar, true, foobar, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "foo", "bar"}, optT, optionGroup, true, foobar, true, foobar, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "foo", "bar"}, optT, optionGroup, false, null, false, foobar, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "foo", "bar"}, optT, optionGroup, false, null, false, foobar, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "foo", "bar"}, optU, optionGroup, false, null, true, foobar, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "foo", "bar"}, optU, optionGroup, false, null, true, foobar, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "foo", "bar"}, optU, optionGroup, false, foobar, false, foobar, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "foo", "bar"}, optU, optionGroup, false, foobar, false, foobar, optU}));
        return lst.stream();
    }

    private static Stream<Arguments> createParsedOptionValueParameters() throws ParseException {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        Option optT = Option.builder().option("T").longOpt("tee").deprecated().type(Integer.class).optionalArg(true).get();
        Option optU = Option.builder((String)"U").longOpt("you").type(Integer.class).optionalArg(true).get();
        OptionGroup optionGroup = new OptionGroup().addOption(optT).addOption(optU);
        Integer expected = 1;
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "1"}, optT, optionGroup, true, expected, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "1"}, optT, optionGroup, true, expected, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "1"}, optT, optionGroup, false, null, false, expected, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "1"}, optT, optionGroup, false, null, false, expected, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "1"}, optU, optionGroup, false, null, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "1"}, optU, optionGroup, false, null, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "1"}, optU, optionGroup, false, expected, false, expected, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "1"}, optU, optionGroup, false, expected, false, expected, optU}));
        return lst.stream();
    }

    private static Stream<Arguments> createParsedOptionValuesParameters() throws ParseException {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        Option optT = Option.builder().option("T").longOpt("tee").deprecated().type(Integer.class).optionalArg(true).hasArgs().get();
        Option optU = Option.builder((String)"U").longOpt("you").type(Integer.class).optionalArg(true).hasArgs().get();
        OptionGroup optionGroup = new OptionGroup().addOption(optT).addOption(optU);
        Integer[] expected = new Integer[]{1, 2};
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "1", "2"}, optT, optionGroup, true, expected, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optT, optionGroup, true, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "1", "2"}, optT, optionGroup, true, expected, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "1", "2"}, optT, optionGroup, false, null, false, expected, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optT, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "1", "2"}, optT, optionGroup, false, null, false, expected, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-T", "1", "2"}, optU, optionGroup, false, null, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee"}, optU, optionGroup, false, null, true, null, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--tee", "1", "2"}, optU, optionGroup, false, null, true, expected, optT}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"-U", "1", "2"}, optU, optionGroup, false, expected, false, expected, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you"}, optU, optionGroup, false, null, false, null, optU}));
        lst.add(Arguments.of((Object[])new Object[]{new String[]{"--you", "1", "2"}, optU, optionGroup, false, expected, false, expected, optU}));
        return lst.stream();
    }

    char asChar(Option opt) {
        return opt.getOpt().charAt(0);
    }

    private void assertWritten(boolean optDep, ByteArrayOutputStream baos) {
        System.out.flush();
        if (optDep) {
            Assertions.assertEquals((Object)"Option 'T''tee': Deprecated", (Object)baos.toString().trim());
        } else {
            Assertions.assertEquals((Object)"", (Object)baos.toString());
        }
        baos.reset();
    }

    void checkHandler(boolean optDep, List<Option> handler, Option opt) {
        if (optDep) {
            Assertions.assertEquals((int)1, (int)handler.size());
            Assertions.assertEquals((Object)opt, (Object)handler.get(0));
        } else {
            Assertions.assertEquals((int)0, (int)handler.size());
        }
        handler.clear();
    }

    @Test
    void testBadGetParsedOptionValue() throws Exception {
        Options options = new Options();
        options.addOption(Option.builder((String)"i").hasArg().type(Number.class).get());
        options.addOption(Option.builder((String)"c").hasArg().converter(s -> Count.valueOf(s.toUpperCase())).get());
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "foo", "-c", "bar"});
        Assertions.assertEquals(NumberFormatException.class, ((ParseException)Assertions.assertThrows(ParseException.class, () -> cmd.getParsedOptionValue("i"))).getCause().getClass());
        Assertions.assertEquals(IllegalArgumentException.class, ((ParseException)Assertions.assertThrows(ParseException.class, () -> cmd.getParsedOptionValue("c"))).getCause().getClass());
    }

    @Test
    void testBuilderBuild() {
        CommandLine cmd = CommandLine.builder().addArg("foo").addArg("bar").addOption(Option.builder((String)"T").get()).build();
        Assertions.assertEquals((Object)"foo", (Object)cmd.getArgs()[0]);
        Assertions.assertEquals((Object)"bar", cmd.getArgList().get(1));
        Assertions.assertEquals((Object)"T", (Object)cmd.getOptions()[0].getOpt());
    }

    @Test
    void testBuilderGet() {
        CommandLine cmd = CommandLine.builder().addArg("foo").addArg("bar").addOption(Option.builder((String)"T").get()).get();
        Assertions.assertEquals((Object)"foo", (Object)cmd.getArgs()[0]);
        Assertions.assertEquals((Object)"bar", cmd.getArgList().get(1));
        Assertions.assertEquals((Object)"T", (Object)cmd.getOptions()[0].getOpt());
    }

    @Test
    void testBuilderNullArgs() {
        CommandLine.Builder builder = CommandLine.builder();
        builder.addArg(null).addArg(null);
        builder.addOption(Option.builder((String)"T").get());
        CommandLine cmd = builder.build();
        Assertions.assertEquals((int)0, (int)cmd.getArgs().length);
        Assertions.assertEquals((Object)"T", (Object)cmd.getOptions()[0].getOpt());
    }

    @Test
    void testBuilderNullOption() {
        CommandLine.Builder builder = CommandLine.builder();
        builder.addArg("foo").addArg("bar");
        builder.addOption(null);
        builder.addOption(null);
        builder.addOption(null);
        CommandLine cmd = builder.build();
        Assertions.assertEquals((Object)"foo", (Object)cmd.getArgs()[0]);
        Assertions.assertEquals((Object)"bar", cmd.getArgList().get(1));
        Assertions.assertEquals((int)0, (int)cmd.getOptions().length);
    }

    @Test
    void testGetOptionProperties() throws Exception {
        String[] args = new String[]{"-Dparam1=value1", "-Dparam2=value2", "-Dparam3", "-Dparam4=value4", "-D", "--property", "foo=bar"};
        Options options = new Options();
        options.addOption(Option.builder((String)"D").valueSeparator().optionalArg(true).numberOfArgs(2).get());
        options.addOption(Option.builder().valueSeparator().numberOfArgs(2).longOpt("property").get());
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(options, args);
        Properties props = cl.getOptionProperties("D");
        Assertions.assertNotNull((Object)props, (String)"null properties");
        Assertions.assertEquals((int)4, (int)props.size(), (String)("number of properties in " + props));
        Assertions.assertEquals((Object)"value1", (Object)props.getProperty("param1"), (String)"property 1");
        Assertions.assertEquals((Object)"value2", (Object)props.getProperty("param2"), (String)"property 2");
        Assertions.assertEquals((Object)"true", (Object)props.getProperty("param3"), (String)"property 3");
        Assertions.assertEquals((Object)"value4", (Object)props.getProperty("param4"), (String)"property 4");
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionProperties("property").getProperty("foo"), (String)"property with long format");
    }

    @Test
    void testGetOptionPropertiesWithOption() throws Exception {
        String[] args = new String[]{"-Dparam1=value1", "-Dparam2=value2", "-Dparam3", "-Dparam4=value4", "-D", "--property", "foo=bar"};
        Options options = new Options();
        Option optionD = Option.builder((String)"D").valueSeparator().numberOfArgs(2).optionalArg(true).get();
        Option optionProperty = Option.builder().valueSeparator().numberOfArgs(2).longOpt("property").get();
        options.addOption(optionD);
        options.addOption(optionProperty);
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(options, args);
        Properties props = cl.getOptionProperties(optionD);
        Assertions.assertNotNull((Object)props, (String)"null properties");
        Assertions.assertEquals((int)4, (int)props.size(), (String)("number of properties in " + props));
        Assertions.assertEquals((Object)"value1", (Object)props.getProperty("param1"), (String)"property 1");
        Assertions.assertEquals((Object)"value2", (Object)props.getProperty("param2"), (String)"property 2");
        Assertions.assertEquals((Object)"true", (Object)props.getProperty("param3"), (String)"property 3");
        Assertions.assertEquals((Object)"value4", (Object)props.getProperty("param4"), (String)"property 4");
        Assertions.assertEquals((Object)"bar", (Object)cl.getOptionProperties(optionProperty).getProperty("foo"), (String)"property with long format");
    }

    @Test
    void testGetOptionsBuilder() {
        CommandLine cmd = CommandLine.builder().build();
        Assertions.assertNotNull((Object)cmd.getOptions());
        Assertions.assertEquals((int)0, (int)cmd.getOptions().length);
        cmd.addOption(null);
        cmd.addOption(new Option("a", null));
        cmd.addOption(new Option("b", null));
        cmd.addOption(new Option("c", null));
        Assertions.assertEquals((int)3, (int)cmd.getOptions().length);
    }

    @Test
    void testGetOptionsCtor() {
        CommandLine cmd = new CommandLine();
        Assertions.assertNotNull((Object)cmd.getOptions());
        Assertions.assertEquals((int)0, (int)cmd.getOptions().length);
        cmd.addOption(new Option("a", null));
        cmd.addOption(new Option("b", null));
        cmd.addOption(new Option("c", null));
        cmd.addOption(null);
        Assertions.assertEquals((int)3, (int)cmd.getOptions().length);
    }

    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createOptionValueParameters"})
    void testGetOptionValue(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, String optValue, boolean grpDep, String grpValue, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        ArrayList<Option> handler = new ArrayList<Option>();
        CommandLine commandLine = DefaultParser.builder().setDeprecatedHandler(handler::add).get().parse(options, args);
        Supplier<String> thinger = () -> "thing";
        OptionGroup otherGroup = new OptionGroup().addOption(Option.builder((String)"o").longOpt("other").hasArg().get()).addOption(Option.builder().option("p").longOpt("part").hasArg().get());
        OptionGroup nullGroup = null;
        Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(this.asChar(opt)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(this.asChar(opt), "thing"));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(this.asChar(opt), thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt.getOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getOpt(), "thing"));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getOpt(), thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt.getLongOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getLongOpt(), "thing"));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getLongOpt(), thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt, "thing"));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt, thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)grpValue, (Object)commandLine.getOptionValue(optionGroup));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertEquals((Object)(grpValue == null ? "thing" : grpValue), (Object)commandLine.getOptionValue(optionGroup, "thing"));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertEquals((Object)(grpValue == null ? "thing" : grpValue), (Object)commandLine.getOptionValue(optionGroup, thinger));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getOptionValue(otherGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(otherGroup, "thing"));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(otherGroup, thinger));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getOptionValue(nullGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(nullGroup, "thing"));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(nullGroup, thinger));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getOptionValue("Nope"));
        this.checkHandler(false, handler, opt);
        Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue("Nope", "thing"));
        this.checkHandler(false, handler, opt);
        Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue("Nope", thinger));
        this.checkHandler(false, handler, opt);
    }

    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createOptionValuesParameters"})
    void testGetOptionValues(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, String[] optValue, boolean grpDep, String[] grpValue, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        ArrayList<Option> handler = new ArrayList<Option>();
        CommandLine commandLine = DefaultParser.builder().setDeprecatedHandler(handler::add).get().parse(options, args);
        OptionGroup otherGroup = new OptionGroup().addOption(Option.builder((String)"o").longOpt("other").hasArg().get()).addOption(Option.builder().option("p").longOpt("part").hasArg().get());
        OptionGroup nullGroup = null;
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getOptionValues(this.asChar(opt)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getOptionValues(opt.getOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getOptionValues(opt.getLongOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getOptionValues(opt));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])grpValue, (Object[])commandLine.getOptionValues(optionGroup));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getOptionValues("Nope"));
        this.checkHandler(false, handler, opt);
        Assertions.assertNull((Object)commandLine.getOptionValues(otherGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getOptionValues(nullGroup));
        this.checkHandler(false, handler, grpOpt);
    }

    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createParsedOptionValueParameters"})
    void testGetParsedOptionValue(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, Integer optValue, boolean grpDep, Integer grpValue, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        ArrayList<Option> handler = new ArrayList<Option>();
        CommandLine commandLine = DefaultParser.builder().setDeprecatedHandler(handler::add).get().parse(options, args);
        Supplier<Integer> thinger = () -> 2;
        OptionGroup otherGroup = new OptionGroup().addOption(Option.builder((String)"o").longOpt("other").hasArg().get()).addOption(Option.builder().option("p").longOpt("part").hasArg().get());
        OptionGroup nullGroup = null;
        Integer thing = 2;
        Assertions.assertEquals((Integer)optValue, (Integer)((Integer)commandLine.getParsedOptionValue(this.asChar(opt))));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(this.asChar(opt), (Object)thing)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(this.asChar(opt), thinger)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)optValue, (Integer)((Integer)commandLine.getParsedOptionValue(opt.getOpt())));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(opt.getOpt(), (Object)thing)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(opt.getOpt(), thinger)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)optValue, (Integer)((Integer)commandLine.getParsedOptionValue(opt.getLongOpt())));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(opt.getLongOpt(), (Object)thing)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(opt.getLongOpt(), thinger)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)optValue, (Integer)((Integer)commandLine.getParsedOptionValue(opt)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(opt, (Object)thing)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)(optValue == null ? thing : optValue), (Integer)((Integer)commandLine.getParsedOptionValue(opt, thinger)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Integer)grpValue, (Integer)((Integer)commandLine.getParsedOptionValue(optionGroup)));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertEquals((Integer)(grpValue == null ? thing : grpValue), (Integer)((Integer)commandLine.getParsedOptionValue(optionGroup, (Object)thing)));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertEquals((Integer)(grpValue == null ? thing : grpValue), (Integer)((Integer)commandLine.getParsedOptionValue(optionGroup, thinger)));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getParsedOptionValue(otherGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Integer)thing, (Integer)((Integer)commandLine.getParsedOptionValue(otherGroup, (Object)thing)));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Integer)thing, (Integer)((Integer)commandLine.getParsedOptionValue(otherGroup, thinger)));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getParsedOptionValue(nullGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Integer)thing, (Integer)((Integer)commandLine.getParsedOptionValue(nullGroup, (Object)thing)));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertEquals((Integer)thing, (Integer)((Integer)commandLine.getParsedOptionValue(nullGroup, thinger)));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getParsedOptionValue("Nope"));
        this.checkHandler(false, handler, opt);
        Assertions.assertEquals((Integer)thing, (Integer)((Integer)commandLine.getParsedOptionValue("Nope", (Object)thing)));
        this.checkHandler(false, handler, opt);
        Assertions.assertEquals((Integer)thing, (Integer)((Integer)commandLine.getParsedOptionValue("Nope", thinger)));
        this.checkHandler(false, handler, opt);
    }

    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createParsedOptionValuesParameters"})
    void testGetParsedOptionValues(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, Integer[] optValue, boolean grpDep, Integer[] grpValue, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        ArrayList<Option> handler = new ArrayList<Option>();
        CommandLine commandLine = DefaultParser.builder().setDeprecatedHandler(handler::add).get().parse(options, args);
        Supplier<Integer[]> thinger = () -> new Integer[]{2, 3};
        OptionGroup otherGroup = new OptionGroup().addOption(Option.builder((String)"o").longOpt("other").hasArg().get()).addOption(Option.builder().option("p").longOpt("part").hasArg().get());
        OptionGroup nullGroup = null;
        Object[] thing = new Integer[]{2, 3};
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getParsedOptionValues(this.asChar(opt)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(this.asChar(opt), thing));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(this.asChar(opt), thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getParsedOptionValues(opt.getOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(opt.getOpt(), thing));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(opt.getOpt(), thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getParsedOptionValues(opt.getLongOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(opt.getLongOpt(), thing));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(opt.getLongOpt(), thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])optValue, (Object[])commandLine.getParsedOptionValues(opt));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(opt, thing));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])(optValue == null ? thing : optValue), (Object[])commandLine.getParsedOptionValues(opt, thinger));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertArrayEquals((Object[])grpValue, (Object[])commandLine.getParsedOptionValues(optionGroup));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertArrayEquals((Object[])(grpValue == null ? thing : grpValue), (Object[])commandLine.getParsedOptionValues(optionGroup, thing));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertArrayEquals((Object[])(grpValue == null ? thing : grpValue), (Object[])commandLine.getParsedOptionValues(optionGroup, thinger));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getParsedOptionValues(otherGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertArrayEquals((Object[])thing, (Object[])commandLine.getParsedOptionValues(otherGroup, thing));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertArrayEquals((Object[])thing, (Object[])commandLine.getParsedOptionValues(otherGroup, thinger));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getParsedOptionValues(nullGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertArrayEquals((Object[])thing, (Object[])commandLine.getParsedOptionValues(nullGroup, thing));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertArrayEquals((Object[])thing, (Object[])commandLine.getParsedOptionValues(nullGroup, thinger));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertNull((Object)commandLine.getParsedOptionValues("Nope"));
        this.checkHandler(false, handler, opt);
        Assertions.assertArrayEquals((Object[])thing, (Object[])commandLine.getParsedOptionValues("Nope", thing));
        this.checkHandler(false, handler, opt);
        Assertions.assertArrayEquals((Object[])thing, (Object[])commandLine.getParsedOptionValues("Nope", thinger));
        this.checkHandler(false, handler, opt);
    }

    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createHasOptionParameters"})
    void testHasOption(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, boolean has, boolean grpDep, boolean hasGrp, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        ArrayList<Option> handler = new ArrayList<Option>();
        CommandLine commandLine = DefaultParser.builder().setDeprecatedHandler(handler::add).get().parse(options, args);
        OptionGroup otherGroup = new OptionGroup().addOption(Option.builder((String)"o").longOpt("other").hasArg().get()).addOption(Option.builder().option("p").longOpt("part").hasArg().get());
        OptionGroup nullGroup = null;
        Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(this.asChar(opt)));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt.getOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt.getLongOpt()));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt));
        this.checkHandler(optDep, handler, opt);
        Assertions.assertEquals((Object)hasGrp, (Object)commandLine.hasOption(optionGroup));
        this.checkHandler(grpDep, handler, grpOpt);
        Assertions.assertFalse((boolean)commandLine.hasOption(otherGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertFalse((boolean)commandLine.hasOption(nullGroup));
        this.checkHandler(false, handler, grpOpt);
        Assertions.assertFalse((boolean)commandLine.hasOption("Nope"));
        this.checkHandler(false, handler, opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createHasOptionParameters"})
    void testHasOptionNoDeprecationHandler(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, boolean has, boolean grpDep, boolean hasGrp, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CommandLine commandLine = DefaultParser.builder().get().parse(options, args);
        PrintStream ps = System.out;
        try {
            System.setOut(new PrintStream(baos));
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(this.asChar(opt)));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt.getOpt()));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt.getLongOpt()));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)hasGrp, (Object)commandLine.hasOption(optionGroup));
            this.assertWritten(grpDep, baos);
            Assertions.assertFalse((boolean)commandLine.hasOption("Nope"));
            this.assertWritten(false, baos);
        }
        finally {
            System.setOut(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createHasOptionParameters"})
    void testHasOptionNullDeprecationHandler(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, boolean has, boolean grpDep, boolean hasGrp, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CommandLine commandLine = DefaultParser.builder().setDeprecatedHandler(null).get().parse(options, args);
        PrintStream ps = System.out;
        try {
            System.setOut(new PrintStream(baos));
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(this.asChar(opt)));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt.getOpt()));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt.getLongOpt()));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)has, (Object)commandLine.hasOption(opt));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)hasGrp, (Object)commandLine.hasOption(optionGroup));
            this.assertWritten(false, baos);
            Assertions.assertFalse((boolean)commandLine.hasOption("Nope"));
            this.assertWritten(false, baos);
        }
        finally {
            System.setOut(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}, {1}")
    @MethodSource(value={"createOptionValueParameters"})
    void testNoDeprecationHandler(String[] args, Option opt, OptionGroup optionGroup, boolean optDep, String optValue, boolean grpDep, String grpValue, Option grpOpt) throws ParseException {
        Options options = new Options().addOptionGroup(optionGroup);
        CommandLine commandLine = DefaultParser.builder().get().parse(options, args);
        Supplier<String> thinger = () -> "thing";
        Supplier nullSupplier = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = System.out;
        try {
            System.setOut(new PrintStream(baos));
            OptionGroup otherGroup = new OptionGroup().addOption(Option.builder((String)"o").longOpt("other").hasArg().get()).addOption(Option.builder().option("p").longOpt("part").hasArg().get());
            OptionGroup nullGroup = null;
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(this.asChar(opt)));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(this.asChar(opt), "thing"));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(this.asChar(opt), thinger));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(this.asChar(opt), nullSupplier));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt.getOpt()));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getOpt(), "thing"));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getOpt(), thinger));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt.getOpt(), nullSupplier));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt.getLongOpt()));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getLongOpt(), "thing"));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt.getLongOpt(), thinger));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt.getLongOpt(), nullSupplier));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt, "thing"));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)(optValue == null ? "thing" : optValue), (Object)commandLine.getOptionValue(opt, thinger));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)optValue, (Object)commandLine.getOptionValue(opt, nullSupplier));
            this.assertWritten(optDep, baos);
            Assertions.assertEquals((Object)grpValue, (Object)commandLine.getOptionValue(optionGroup));
            this.assertWritten(grpDep, baos);
            Assertions.assertEquals((Object)(grpValue == null ? "thing" : grpValue), (Object)commandLine.getOptionValue(optionGroup, "thing"));
            this.assertWritten(grpDep, baos);
            Assertions.assertEquals((Object)(grpValue == null ? "thing" : grpValue), (Object)commandLine.getOptionValue(optionGroup, thinger));
            this.assertWritten(grpDep, baos);
            Assertions.assertEquals((Object)grpValue, (Object)commandLine.getOptionValue(optionGroup, nullSupplier));
            this.assertWritten(grpDep, baos);
            Assertions.assertNull((Object)commandLine.getOptionValue(otherGroup));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(otherGroup, "thing"));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(otherGroup, thinger));
            this.assertWritten(false, baos);
            Assertions.assertNull((Object)commandLine.getOptionValue(otherGroup, nullSupplier));
            this.assertWritten(false, baos);
            Assertions.assertNull((Object)commandLine.getOptionValue(nullGroup));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(nullGroup, "thing"));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue(nullGroup, thinger));
            this.assertWritten(false, baos);
            Assertions.assertNull((Object)commandLine.getOptionValue(nullGroup, nullSupplier));
            this.assertWritten(false, baos);
            Assertions.assertNull((Object)commandLine.getOptionValue("Nope"));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue("Nope", "thing"));
            this.assertWritten(false, baos);
            Assertions.assertEquals((Object)"thing", (Object)commandLine.getOptionValue("Nope", thinger));
            this.assertWritten(false, baos);
            Assertions.assertNull((Object)commandLine.getOptionValue("Nope", nullSupplier));
            this.assertWritten(false, baos);
        }
        finally {
            System.setOut(ps);
        }
    }

    @Test
    void testNullOption() throws Exception {
        Options options = new Options();
        Option optI = Option.builder((String)"i").hasArg().type(Number.class).get();
        Option optF = Option.builder((String)"f").hasArg().get();
        options.addOption(optI);
        options.addOption(optF);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, new String[]{"-i", "123", "-f", "foo"});
        Assertions.assertNull((Object)cmd.getOptionValue((Option)null));
        Assertions.assertNull((Object)cmd.getParsedOptionValue((Option)null));
        Assertions.assertNull((Object)cmd.getOptionValue((OptionGroup)null));
        Assertions.assertNull((Object)cmd.getParsedOptionValue((OptionGroup)null));
    }

    private static enum Count {
        ONE,
        TWO,
        THREE;

    }
}

