/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import com.datastax.driver.core.BatchStatement;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.transport.ProtocolVersion;

public class FQLQueryReader
implements ReadMarshallable {
    private FQLQuery query;

    public void readMarshallable(WireIn wireIn) throws IORuntimeException {
        this.verifyVersion(wireIn);
        String type = this.readType(wireIn);
        long queryStartTime = wireIn.read("query-start-time").int64();
        int protocolVersion = wireIn.read("protocol-version").int32();
        QueryOptions queryOptions = (QueryOptions)QueryOptions.codec.decode(Unpooled.wrappedBuffer((byte[])wireIn.read("query-options").bytes()), ProtocolVersion.decode((int)protocolVersion, (boolean)true));
        long generatedTimestamp = wireIn.read("generated-timestamp").int64();
        long generatedNowInSeconds = wireIn.read("generated-now-in-seconds").int64();
        String keyspace = wireIn.read("keyspace").text();
        switch (type) {
            case "single-query": {
                String queryString = wireIn.read("query").text();
                this.query = new FQLQuery.Single(keyspace, protocolVersion, queryOptions, queryStartTime, generatedTimestamp, generatedNowInSeconds, queryString, queryOptions.getValues());
                break;
            }
            case "batch": {
                BatchStatement.Type batchType = BatchStatement.Type.valueOf((String)wireIn.read("batch-type").text());
                ValueIn in = wireIn.read("queries");
                int queryCount = in.int32();
                ArrayList<String> queries = new ArrayList<String>(queryCount);
                for (int i = 0; i < queryCount; ++i) {
                    queries.add(in.text());
                }
                in = wireIn.read("values");
                int valueCount = in.int32();
                ArrayList<List<ByteBuffer>> values = new ArrayList<List<ByteBuffer>>(valueCount);
                for (int ii = 0; ii < valueCount; ++ii) {
                    ArrayList<ByteBuffer> subValues = new ArrayList<ByteBuffer>();
                    values.add(subValues);
                    int numSubValues = in.int32();
                    for (int zz = 0; zz < numSubValues; ++zz) {
                        byte[] valueBytes = in.bytes();
                        subValues.add(valueBytes == null ? null : ByteBuffer.wrap(valueBytes));
                    }
                }
                this.query = new FQLQuery.Batch(keyspace, protocolVersion, queryOptions, queryStartTime, generatedTimestamp, generatedNowInSeconds, batchType, queries, values);
                break;
            }
            default: {
                throw new IORuntimeException("Unhandled record type: " + type);
            }
        }
    }

    private void verifyVersion(WireIn wireIn) {
        short version = wireIn.read("version").int16();
        if ((long)version > 0L) {
            throw new IORuntimeException("Unsupported record version [" + version + "] - highest supported version is [0]");
        }
    }

    private String readType(WireIn wireIn) throws IORuntimeException {
        String type = wireIn.read("type").text();
        if (!"single-query".equals(type) && !"batch".equals(type)) {
            throw new IORuntimeException("Unsupported record type field [" + type + "] - supported record types are [single-query, batch]");
        }
        return type;
    }

    public FQLQuery getQuery() {
        return this.query;
    }
}

