/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCredentials;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsTransport
implements Serializable {
    private final TOptions options;
    private final SettingsCredentials credentials;

    public SettingsTransport(TOptions options, SettingsCredentials credentials) {
        this.options = options;
        this.credentials = credentials;
    }

    public EncryptionOptions getEncryptionOptions() {
        EncryptionOptions encOptions = new EncryptionOptions().applyConfig();
        if (this.options.trustStore.present()) {
            encOptions = encOptions.withEnabled(true).withTrustStore(this.options.trustStore.value()).withTrustStorePassword(this.options.trustStorePw.setByUser() ? this.options.trustStorePw.value() : this.credentials.transportTruststorePassword).withAlgorithm(this.options.alg.value()).withProtocol(this.options.protocol.value()).withCipherSuites(this.options.ciphers.value().split(","));
            encOptions = this.options.keyStore.present() ? encOptions.withKeyStore(this.options.keyStore.value()).withKeyStorePassword(this.options.keyStorePw.setByUser() ? this.options.keyStorePw.value() : this.credentials.transportKeystorePassword) : encOptions.withKeyStore(encOptions.truststore).withKeyStorePassword(encOptions.truststore_password != null ? encOptions.truststore_password : this.credentials.transportTruststorePassword);
        }
        return encOptions;
    }

    public void printSettings(ResultLogger out) {
        String tPassword = this.options.trustStorePw.setByUser() ? this.options.trustStorePw.value() : this.credentials.transportTruststorePassword;
        tPassword = tPassword != null ? "*suppressed*" : tPassword;
        String kPassword = this.options.keyStorePw.setByUser() ? this.options.keyStore.value() : this.credentials.transportKeystorePassword;
        kPassword = kPassword != null ? "*suppressed*" : kPassword;
        out.printf("  Truststore: %s%n", this.options.trustStore.value());
        out.printf("  Truststore Password: %s%n", tPassword);
        out.printf("  Keystore: %s%n", this.options.keyStore.value());
        out.printf("  Keystore Password: %s%n", kPassword);
        out.printf("  SSL Protocol: %s%n", this.options.protocol.value());
        out.printf("  SSL Algorithm: %s%n", this.options.alg.value());
        out.printf("  SSL Ciphers: %s%n", this.options.ciphers.value());
    }

    public static SettingsTransport get(Map<String, String[]> clArgs, SettingsCredentials credentials) {
        String[] params = clArgs.remove("-transport");
        if (params == null) {
            return new SettingsTransport(new TOptions(), credentials);
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new TOptions[]{new TOptions()});
        if (options == null) {
            SettingsTransport.printHelp();
            System.out.println("Invalid -transport options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsTransport((TOptions)options, credentials);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-transport", new TOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsTransport.printHelp();
            }
        };
    }

    static class TOptions
    extends GroupedOptions
    implements Serializable {
        final OptionSimple trustStore = new OptionSimple("truststore=", ".*", null, "SSL: full path to truststore", false);
        final OptionSimple trustStorePw = new OptionSimple("truststore-password=", ".*", null, String.format("SSL: truststore password, when specified, it will override the value in credentials file of key '%s'", "transport.truststore.password"), false);
        final OptionSimple keyStore = new OptionSimple("keystore=", ".*", null, "SSL: full path to keystore", false);
        final OptionSimple keyStorePw = new OptionSimple("keystore-password=", ".*", null, String.format("SSL: keystore password, when specified, it will override the value in credentials file for key '%s'", "transport.keystore.password"), false);
        final OptionSimple protocol = new OptionSimple("ssl-protocol=", ".*", "TLS", "SSL: connection protocol to use", false);
        final OptionSimple alg = new OptionSimple("ssl-alg=", ".*", null, "SSL: algorithm", false);
        final OptionSimple ciphers = new OptionSimple("ssl-ciphers=", ".*", "TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA", "SSL: comma delimited list of encryption suites to use", false);

        TOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.trustStore, this.trustStorePw, this.keyStore, this.keyStorePw, this.protocol, this.alg, this.ciphers);
        }
    }
}

