/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntPredicate;
import net.openhft.chronicle.core.internal.invariant.ints.IntBiCondition;
import net.openhft.chronicle.core.internal.invariant.ints.IntCondition;
import net.openhft.chronicle.core.internal.invariant.ints.IntTriCondition;
import net.openhft.chronicle.core.util.IntBiPredicate;
import net.openhft.chronicle.core.util.IntTriPredicate;

public final class Ints {
    private Ints() {
    }

    public static int requireNonNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(Ints.failDescription(Ints.negative().negate(), value));
        }
        return value;
    }

    public static int require(IntPredicate requirement, int value) {
        return Ints.require(requirement, value, IllegalArgumentException::new);
    }

    public static <X extends RuntimeException> int require(IntPredicate requirement, int value, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value)) {
            throw (RuntimeException)exceptionMapper.apply(Ints.failDescription(requirement, value));
        }
        return value;
    }

    public static int require(IntBiPredicate requirement, int value, int otherValue) {
        if (!requirement.test(value, otherValue)) {
            throw new IllegalArgumentException(Ints.failDescription(requirement, value, otherValue));
        }
        return value;
    }

    public static <X extends RuntimeException> int require(IntBiPredicate requirement, int value, int otherValue, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value, otherValue)) {
            throw (RuntimeException)exceptionMapper.apply(Ints.failDescription(requirement, value, otherValue));
        }
        return value;
    }

    public static int require(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue) {
        return Ints.require(requirement, value, otherFirstValue, otherSecondValue, IllegalArgumentException::new);
    }

    public static <X extends RuntimeException> int require(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value, otherFirstValue, otherSecondValue)) {
            throw (RuntimeException)exceptionMapper.apply(Ints.failDescription(requirement, value, otherFirstValue, otherSecondValue));
        }
        return value;
    }

    public static boolean assertIfEnabled(IntPredicate requirement, int value) {
        return true;
    }

    public static boolean assertIfEnabled(IntBiPredicate requirement, int value, int otherValue) {
        return true;
    }

    public static boolean assertIfEnabled(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue) {
        return true;
    }

    public static String failDescription(IntPredicate requirement, int value) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s", value, value, requirement);
    }

    public static String failDescription(IntBiPredicate requirement, int value, int otherValue) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s %d", value, value, requirement, otherValue);
    }

    public static String failDescription(IntTriPredicate requirement, int value, int otherFirstValue, int otherSecondValue) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s (%d, %d)", value, value, requirement, otherFirstValue, otherSecondValue);
    }

    public static IntPredicate positive() {
        return IntCondition.POSITIVE;
    }

    public static IntPredicate negative() {
        return IntCondition.NEGATIVE;
    }

    public static IntPredicate nonNegative() {
        return IntCondition.NON_NEGATIVE;
    }

    public static IntPredicate zero() {
        return IntCondition.ZERO;
    }

    public static IntPredicate byteConvertible() {
        return IntCondition.BYTE_CONVERTIBLE;
    }

    public static IntPredicate shortConvertible() {
        return IntCondition.SHORT_CONVERTIBLE;
    }

    public static IntPredicate evenPowerOfTwo() {
        return IntCondition.EVEN_POWER_OF_TWO;
    }

    public static IntPredicate shortAligned() {
        return IntCondition.SHORT_ALIGNED;
    }

    public static IntPredicate intAligned() {
        return IntCondition.INT_ALIGNED;
    }

    public static IntPredicate longAligned() {
        return IntCondition.LONG_ALIGNED;
    }

    public static IntBiPredicate equalTo() {
        return IntBiCondition.EQUAL_TO;
    }

    public static IntBiPredicate greaterThan() {
        return IntBiCondition.GREATER_THAN;
    }

    public static IntBiPredicate greaterOrEqual() {
        return IntBiCondition.GREATER_OR_EQUAL;
    }

    public static IntBiPredicate lessThan() {
        return IntBiCondition.LESS_THAN;
    }

    public static IntBiPredicate lessOrEqual() {
        return IntBiCondition.LESS_OR_EQUAL;
    }

    public static IntBiPredicate betweenZeroAnd() {
        return IntBiCondition.BETWEEN_ZERO_AND;
    }

    public static IntBiPredicate betweenZeroAndClosed() {
        return IntBiCondition.BETWEEN_ZERO_AND_CLOSED;
    }

    public static IntBiPredicate powerOfTwo() {
        return IntBiCondition.POWER_OF_TWO;
    }

    public static IntBiPredicate log2() {
        return IntBiCondition.LOG2;
    }

    public static IntTriPredicate between() {
        return IntTriCondition.BETWEEN;
    }

    public static IntTriPredicate betweenClosed() {
        return IntTriCondition.BETWEEN_CLOSED;
    }

    public static IntTriPredicate betweenZeroAndReserving() {
        return IntTriCondition.BETWEEN_ZERO_AND_ENSURING;
    }
}

