/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.IteratorWithLowerBound;

public abstract class MergeIterator<In, Out>
extends AbstractIterator<Out>
implements IMergeIterator<In, Out> {
    protected final Reducer<In, Out> reducer;
    protected final List<? extends Iterator<In>> iterators;

    protected MergeIterator(List<? extends Iterator<In>> iters, Reducer<In, Out> reducer) {
        this.iterators = iters;
        this.reducer = reducer;
    }

    public static <In, Out> MergeIterator<In, Out> get(List<? extends Iterator<In>> sources, Comparator<? super In> comparator, Reducer<In, Out> reducer) {
        if (sources.size() == 1) {
            return reducer.trivialReduceIsTrivial() ? new TrivialOneToOne<In, Out>(sources, reducer) : new OneToOne<In, Out>(sources, reducer);
        }
        return new ManyToOne<In, Out>(sources, comparator, reducer);
    }

    @Override
    public Iterable<? extends Iterator<In>> iterators() {
        return this.iterators;
    }

    @Override
    public void close() {
        int isize = this.iterators.size();
        for (int i = 0; i < isize; ++i) {
            Iterator<In> iterator = this.iterators.get(i);
            try {
                if (!(iterator instanceof AutoCloseable)) continue;
                ((AutoCloseable)((Object)iterator)).close();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.reducer.close();
    }

    private static class TrivialOneToOne<In, Out>
    extends MergeIterator<In, Out> {
        private final Iterator<In> source;

        public TrivialOneToOne(List<? extends Iterator<In>> sources, Reducer<In, Out> reducer) {
            super(sources, reducer);
            this.source = sources.get(0);
        }

        @Override
        protected Out computeNext() {
            if (!this.source.hasNext()) {
                return (Out)this.endOfData();
            }
            return (Out)this.source.next();
        }
    }

    private static class OneToOne<In, Out>
    extends MergeIterator<In, Out> {
        private final Iterator<In> source;

        public OneToOne(List<? extends Iterator<In>> sources, Reducer<In, Out> reducer) {
            super(sources, reducer);
            this.source = sources.get(0);
        }

        @Override
        protected Out computeNext() {
            if (!this.source.hasNext()) {
                return (Out)this.endOfData();
            }
            this.reducer.onKeyChange();
            this.reducer.reduce(0, this.source.next());
            return this.reducer.getReduced();
        }
    }

    public static abstract class Reducer<In, Out> {
        public boolean trivialReduceIsTrivial() {
            return false;
        }

        public abstract void reduce(int var1, In var2);

        protected abstract Out getReduced();

        protected void onKeyChange() {
        }

        public void close() {
        }
    }

    protected static final class Candidate<In>
    implements Comparable<Candidate<In>> {
        private final Iterator<? extends In> iter;
        private final Comparator<? super In> comp;
        private final int idx;
        private In item;
        private In lowerBound;
        boolean equalParent;

        public Candidate(int idx, Iterator<? extends In> iter, Comparator<? super In> comp) {
            this.iter = iter;
            this.comp = comp;
            this.idx = idx;
            this.lowerBound = iter instanceof IteratorWithLowerBound ? ((IteratorWithLowerBound)((Object)iter)).lowerBound() : null;
        }

        protected Candidate<In> advance() {
            if (this.lowerBound != null) {
                this.item = this.lowerBound;
                return this;
            }
            if (!this.iter.hasNext()) {
                return null;
            }
            this.item = this.iter.next();
            return this;
        }

        @Override
        public int compareTo(Candidate<In> that) {
            assert (this.item != null && that.item != null);
            int ret = this.comp.compare(this.item, that.item);
            if (ret == 0 && this.isLowerBound() ^ that.isLowerBound()) {
                return this.isLowerBound() ? -1 : 1;
            }
            return ret;
        }

        private boolean isLowerBound() {
            assert (this.item != null);
            return this.item == this.lowerBound;
        }

        public <Out> void consume(Reducer<In, Out> reducer) {
            if (this.isLowerBound()) {
                this.item = null;
                this.lowerBound = null;
            } else {
                reducer.reduce(this.idx, this.item);
                this.item = null;
            }
        }

        public boolean needsAdvance() {
            return this.item == null;
        }
    }

    static final class ManyToOne<In, Out>
    extends MergeIterator<In, Out> {
        protected final Candidate<In>[] heap;
        int size;
        int needingAdvance;
        static final int SORTED_SECTION_SIZE = 4;

        public ManyToOne(List<? extends Iterator<In>> iters, Comparator<? super In> comp, Reducer<In, Out> reducer) {
            super(iters, reducer);
            Candidate[] heap = new Candidate[iters.size()];
            this.heap = heap;
            this.size = 0;
            for (int i = 0; i < iters.size(); ++i) {
                Candidate<? super In> candidate = new Candidate<In>(i, iters.get(i), comp);
                heap[this.size++] = candidate;
            }
            this.needingAdvance = this.size;
        }

        @Override
        protected final Out computeNext() {
            this.advance();
            return this.consume();
        }

        private void advance() {
            for (int i = this.needingAdvance - 1; i >= 0; --i) {
                Candidate<In> candidate = this.heap[i];
                if (!candidate.needsAdvance()) continue;
                this.replaceAndSink(candidate.advance(), i);
            }
        }

        private Out consume() {
            int i;
            block4: {
                if (this.size == 0) {
                    return (Out)this.endOfData();
                }
                this.reducer.onKeyChange();
                assert (!this.heap[0].equalParent);
                this.heap[0].consume(this.reducer);
                int size = this.size;
                int sortedSectionSize = Math.min(size, 4);
                for (i = 1; i < sortedSectionSize; ++i) {
                    if (this.heap[i].equalParent) {
                        this.heap[i].consume(this.reducer);
                        continue;
                    }
                    break block4;
                }
                i = Math.max(i, this.consumeHeap(i) + 1);
            }
            this.needingAdvance = i;
            return this.reducer.getReduced();
        }

        private int consumeHeap(int idx) {
            if (idx >= this.size || !this.heap[idx].equalParent) {
                return -1;
            }
            this.heap[idx].consume(this.reducer);
            int nextIdx = (idx << 1) - 3;
            return Math.max(idx, Math.max(this.consumeHeap(nextIdx), this.consumeHeap(nextIdx + 1)));
        }

        private void replaceAndSink(Candidate<In> candidate, int currIdx) {
            int cmp;
            int nextIdx;
            if (candidate == null) {
                candidate = this.heap[--this.size];
                this.heap[this.size] = null;
            }
            candidate.equalParent = false;
            int size = this.size;
            int sortedSectionSize = Math.min(size - 1, 4);
            while ((nextIdx = currIdx + 1) <= sortedSectionSize) {
                if (!this.heap[nextIdx].equalParent && (cmp = candidate.compareTo(this.heap[nextIdx])) <= 0) {
                    this.heap[nextIdx].equalParent = cmp == 0;
                    this.heap[currIdx] = candidate;
                    return;
                }
                this.heap[currIdx] = this.heap[nextIdx];
                currIdx = nextIdx;
            }
            while ((nextIdx = currIdx * 2 - (sortedSectionSize - 1)) + 1 < size) {
                if (!this.heap[nextIdx].equalParent) {
                    if (!this.heap[nextIdx + 1].equalParent) {
                        int cmp2;
                        int siblingCmp = this.heap[nextIdx + 1].compareTo(this.heap[nextIdx]);
                        if (siblingCmp < 0) {
                            ++nextIdx;
                        }
                        if ((cmp2 = candidate.compareTo(this.heap[nextIdx])) <= 0) {
                            if (cmp2 == 0) {
                                this.heap[nextIdx].equalParent = true;
                                if (siblingCmp == 0) {
                                    this.heap[nextIdx + 1].equalParent = true;
                                }
                            }
                            this.heap[currIdx] = candidate;
                            return;
                        }
                        if (siblingCmp == 0) {
                            this.heap[nextIdx + 1].equalParent = true;
                        }
                    } else {
                        ++nextIdx;
                    }
                }
                this.heap[currIdx] = this.heap[nextIdx];
                currIdx = nextIdx;
            }
            if (nextIdx >= size) {
                this.heap[currIdx] = candidate;
                return;
            }
            if (!this.heap[nextIdx].equalParent && (cmp = candidate.compareTo(this.heap[nextIdx])) <= 0) {
                this.heap[nextIdx].equalParent = cmp == 0;
                this.heap[currIdx] = candidate;
                return;
            }
            this.heap[currIdx] = this.heap[nextIdx];
            this.heap[nextIdx] = candidate;
        }
    }
}

