/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;

public final class Indexes
implements Iterable<IndexMetadata> {
    private final ImmutableMap<String, IndexMetadata> indexesByName;
    private final ImmutableMap<UUID, IndexMetadata> indexesById;

    private Indexes(Builder builder) {
        this.indexesByName = builder.indexesByName.build();
        this.indexesById = builder.indexesById.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Indexes none() {
        return Indexes.builder().build();
    }

    public static Indexes of(IndexMetadata ... indexes) {
        return Indexes.builder().add(indexes).build();
    }

    public static Indexes of(Iterable<IndexMetadata> indexes) {
        return Indexes.builder().add(indexes).build();
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indexesByName.values().iterator();
    }

    public Stream<IndexMetadata> stream() {
        return this.indexesById.values().stream();
    }

    public int size() {
        return this.indexesByName.size();
    }

    public boolean isEmpty() {
        return this.indexesByName.isEmpty();
    }

    public Optional<IndexMetadata> get(String name) {
        return Optional.ofNullable((IndexMetadata)this.indexesByName.get((Object)name));
    }

    public boolean has(String name) {
        return this.indexesByName.containsKey((Object)name);
    }

    public Optional<IndexMetadata> get(UUID id) {
        return Optional.ofNullable((IndexMetadata)this.indexesById.get((Object)id));
    }

    public boolean has(UUID id) {
        return this.indexesById.containsKey((Object)id);
    }

    public Indexes with(IndexMetadata index) {
        if (this.get(index.name).isPresent()) {
            throw new IllegalStateException(String.format("Index %s already exists", index.name));
        }
        return Indexes.builder().add(this).add(index).build();
    }

    public Indexes without(String name) {
        IndexMetadata index = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Index %s doesn't exist", name)));
        return Indexes.builder().add(Iterables.filter((Iterable)this, v -> v != index)).build();
    }

    public Indexes replace(IndexMetadata index) {
        return this.without(index.name).with(index);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Indexes && this.indexesByName.equals(((Indexes)o).indexesByName);
    }

    public void validate(TableMetadata table) {
        this.indexesByName.values().forEach(i -> i.validate(table));
    }

    public int hashCode() {
        return this.indexesByName.hashCode();
    }

    public String toString() {
        return this.indexesByName.values().toString();
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, IndexMetadata> indexesByName = new ImmutableMap.Builder();
        final ImmutableMap.Builder<UUID, IndexMetadata> indexesById = new ImmutableMap.Builder();

        private Builder() {
        }

        public Indexes build() {
            return new Indexes(this);
        }

        public Builder add(IndexMetadata index) {
            this.indexesByName.put((Object)index.name, (Object)index);
            this.indexesById.put((Object)index.id, (Object)index);
            return this;
        }

        public Builder add(IndexMetadata ... indexes) {
            for (IndexMetadata index : indexes) {
                this.add(index);
            }
            return this;
        }

        public Builder add(Iterable<IndexMetadata> indexes) {
            indexes.forEach(this::add);
            return this;
        }
    }
}

