/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IOOptions;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.CompressionInfoComponent;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.TOCComponent;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableReaderLoadingBuilder<R extends SSTableReader, B extends SSTableReader.Builder<R, B>> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReaderLoadingBuilder.class);
    protected final Descriptor descriptor;
    protected final Set<Component> components;
    protected final TableMetadataRef tableMetadataRef;
    protected final IOOptions ioOptions;
    protected final ChunkCache chunkCache;

    public SSTableReaderLoadingBuilder(SSTable.Builder<?, ?> builder) {
        this.descriptor = builder.descriptor;
        this.components = builder.getComponents() != null ? ImmutableSet.copyOf(builder.getComponents()) : TOCComponent.loadOrCreate(this.descriptor);
        this.tableMetadataRef = builder.getTableMetadataRef() != null ? builder.getTableMetadataRef() : this.resolveTableMetadataRef();
        this.ioOptions = builder.getIOOptions() != null ? builder.getIOOptions() : IOOptions.fromDatabaseDescriptor();
        this.chunkCache = builder.getChunkCache() != null ? builder.getChunkCache() : ChunkCache.instance;
        Preconditions.checkNotNull(this.components);
        Preconditions.checkNotNull((Object)this.tableMetadataRef);
    }

    public R build(SSTable.Owner owner, boolean validate, boolean online) {
        Preconditions.checkArgument((boolean)this.components.contains(SSTableFormat.Components.DATA), (String)"Data component is missing for sstable %s", (Object)this.descriptor);
        if (validate) {
            Preconditions.checkArgument((boolean)this.components.containsAll(this.descriptor.getFormat().primaryComponents()), (String)"Some required components (%s) are missing for sstable %s", (Object)Sets.difference(this.descriptor.getFormat().primaryComponents(), this.components), (Object)this.descriptor);
        }
        SSTableReader.Builder<?, ?> builder = this.descriptor.getFormat().getReaderFactory().builder(this.descriptor);
        builder.setOpenReason(SSTableReader.OpenReason.NORMAL);
        builder.setMaxDataAge(Clock.Global.currentTimeMillis());
        builder.setTableMetadataRef(this.tableMetadataRef);
        builder.setComponents(this.components);
        SSTableReader reader = null;
        try {
            CompressionInfoComponent.verifyCompressionInfoExistenceIfApplicable(this.descriptor, builder.getComponents());
            long t0 = Clock.Global.currentTimeMillis();
            this.openComponents(builder, owner, validate, online);
            if (logger.isTraceEnabled()) {
                logger.trace("SSTable {} loaded in {}ms", (Object)this.descriptor, (Object)(Clock.Global.currentTimeMillis() - t0));
            }
            reader = builder.build(owner, validate, online);
            return (R)reader;
        }
        catch (IOException | Error | RuntimeException ex) {
            if (reader != null) {
                reader.selfRef().release();
            }
            JVMStabilityInspector.inspectThrowable(ex);
            if (ex instanceof CorruptSSTableException) {
                throw (CorruptSSTableException)ex;
            }
            throw new CorruptSSTableException(ex, this.descriptor.baseFile());
        }
    }

    public abstract KeyReader buildKeyReader(TableMetrics var1) throws IOException;

    protected abstract void openComponents(B var1, SSTable.Owner var2, boolean var3, boolean var4) throws IOException;

    protected void validatePartitioner(TableMetadata metadata, ValidationMetadata validationMetadata) {
        String partitionerName = metadata.partitioner.getClass().getCanonicalName();
        if (validationMetadata != null && !partitionerName.equals(validationMetadata.partitioner)) {
            throw new CorruptSSTableException((Throwable)new IOException(String.format("Cannot open %s; partitioner %s does not match system partitioner %s. Note that the default partitioner starting with Cassandra 1.2 is Murmur3Partitioner, so you will need to edit that to match your old partitioner if upgrading.", this.descriptor, validationMetadata.partitioner, partitionerName)), this.descriptor.fileFor(SSTableFormat.Components.STATS));
        }
    }

    private TableMetadataRef resolveTableMetadataRef() {
        TableMetadataRef metadata;
        if (this.descriptor.cfname.contains(".")) {
            int i = this.descriptor.cfname.indexOf(".");
            String indexName = this.descriptor.cfname.substring(i + 1);
            metadata = Schema.instance.getIndexTableMetadataRef(this.descriptor.ksname, indexName);
            if (metadata == null) {
                throw new AssertionError((Object)("Could not find index metadata for index cf " + i));
            }
        } else {
            metadata = Schema.instance.getTableMetadataRef(this.descriptor.ksname, this.descriptor.cfname);
        }
        return metadata;
    }
}

