/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;

@NotThreadSafe
public class KeyRangeOrderingIterator
extends KeyRangeIterator {
    private final KeyRangeIterator input;
    private final int chunkSize;
    private final Function<List<PrimaryKey>, KeyRangeIterator> nextRangeFunction;
    private final ArrayList<PrimaryKey> nextKeys;
    private KeyRangeIterator nextIterator;

    public KeyRangeOrderingIterator(KeyRangeIterator input, int chunkSize, Function<List<PrimaryKey>, KeyRangeIterator> nextRangeFunction) {
        super(input, () -> {});
        this.input = input;
        this.chunkSize = chunkSize;
        this.nextRangeFunction = nextRangeFunction;
        this.nextKeys = new ArrayList(chunkSize);
    }

    @Override
    public PrimaryKey computeNext() {
        if (this.nextIterator == null || !this.nextIterator.hasNext()) {
            do {
                if (!this.input.hasNext()) {
                    return (PrimaryKey)this.endOfData();
                }
                this.nextKeys.clear();
                do {
                    this.nextKeys.add((PrimaryKey)this.input.next());
                } while (this.nextKeys.size() < this.chunkSize && this.input.hasNext());
                KeyRangeIterator previousIterator = this.nextIterator;
                this.nextIterator = this.nextRangeFunction.apply(this.nextKeys);
                if (previousIterator == null) continue;
                FileUtils.closeQuietly(previousIterator);
            } while (!this.nextIterator.hasNext());
        }
        return (PrimaryKey)this.nextIterator.next();
    }

    @Override
    protected void performSkipTo(PrimaryKey nextToken) {
        this.input.skipTo(nextToken);
        if (this.nextIterator != null) {
            this.nextIterator.skipTo(nextToken);
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.input);
        FileUtils.closeQuietly(this.nextIterator);
    }
}

