/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.File;

public final class ComponentManifest
implements Iterable<Component> {
    private final LinkedHashMap<Component, Long> components;
    public static final Map<String, IVersionedSerializer<ComponentManifest>> serializers;

    public ComponentManifest(Map<Component, Long> components) {
        this.components = new LinkedHashMap<Component, Long>(components);
    }

    @VisibleForTesting
    public static ComponentManifest create(SSTable sstable) {
        Set<Component> streamingComponents = sstable.getStreamingComponents();
        LinkedHashMap<Component, Long> components = new LinkedHashMap<Component, Long>(streamingComponents.size());
        for (Component component : streamingComponents) {
            File file = sstable.descriptor.fileFor(component);
            if (!file.exists()) continue;
            components.put(component, file.length());
        }
        return new ComponentManifest(components);
    }

    public long sizeOf(Component component) {
        Long size = this.components.get(component);
        if (size == null) {
            throw new IllegalArgumentException("Component " + component + " is not present in the manifest");
        }
        return size;
    }

    public long totalSize() {
        long totalSize = 0L;
        for (Long size : this.components.values()) {
            totalSize += size.longValue();
        }
        return totalSize;
    }

    public List<Component> components() {
        return new ArrayList<Component>(this.components.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentManifest)) {
            return false;
        }
        ComponentManifest that = (ComponentManifest)o;
        return this.components.equals(that.components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public String toString() {
        return "ComponentManifest{components=" + this.components + "}";
    }

    @Override
    public Iterator<Component> iterator() {
        return Iterators.unmodifiableIterator(this.components.keySet().iterator());
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (final SSTableFormat format : DatabaseDescriptor.getSSTableFormats().values()) {
            IVersionedSerializer<ComponentManifest> serializer = new IVersionedSerializer<ComponentManifest>(){

                @Override
                public void serialize(ComponentManifest manifest, DataOutputPlus out, int version) throws IOException {
                    out.writeUnsignedVInt32(manifest.components.size());
                    for (Map.Entry<Component, Long> entry : manifest.components.entrySet()) {
                        out.writeUTF(entry.getKey().name);
                        out.writeUnsignedVInt(entry.getValue());
                    }
                }

                @Override
                public ComponentManifest deserialize(DataInputPlus in, int version) throws IOException {
                    int size = in.readUnsignedVInt32();
                    LinkedHashMap<Component, Long> components = new LinkedHashMap<Component, Long>(size);
                    for (int i = 0; i < size; ++i) {
                        Component component = Component.parse(in.readUTF(), format);
                        long length = in.readUnsignedVInt();
                        components.put(component, length);
                    }
                    return new ComponentManifest(components);
                }

                @Override
                public long serializedSize(ComponentManifest manifest, int version) {
                    long size = TypeSizes.sizeofUnsignedVInt(manifest.components.size());
                    for (Map.Entry<Component, Long> entry : manifest.components.entrySet()) {
                        size += (long)TypeSizes.sizeof(entry.getKey().name);
                        size += (long)TypeSizes.sizeofUnsignedVInt(entry.getValue());
                    }
                    return size;
                }
            };
            b.put((Object)format.name(), (Object)serializer);
        }
        serializers = b.build();
    }
}

