/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flushing {
    private static final Logger logger = LoggerFactory.getLogger(Flushing.class);

    private Flushing() {
    }

    public static List<FlushRunnable> flushRunnables(ColumnFamilyStore cfs, Memtable memtable, LifecycleTransaction txn) {
        LifecycleTransaction ongoingFlushTransaction = memtable.setFlushTransaction(txn);
        Preconditions.checkState((ongoingFlushTransaction == null ? 1 : 0) != 0, (String)"Attempted to flush Memtable more than once on %s.%s", (Object)cfs.keyspace.getName(), (Object)cfs.name);
        DiskBoundaries diskBoundaries = cfs.getDiskBoundaries();
        ImmutableList<PartitionPosition> boundaries = diskBoundaries.positions;
        List<Directories.DataDirectory> locations = diskBoundaries.directories;
        if (boundaries == null) {
            FlushRunnable runnable = Flushing.flushRunnable(cfs, memtable, null, null, txn, null);
            return Collections.singletonList(runnable);
        }
        ArrayList<FlushRunnable> runnables = new ArrayList<FlushRunnable>(boundaries.size());
        PartitionPosition rangeStart = ((PartitionPosition)boundaries.get(0)).getPartitioner().getMinimumToken().minKeyBound();
        try {
            for (int i = 0; i < boundaries.size(); ++i) {
                PartitionPosition t = (PartitionPosition)boundaries.get(i);
                FlushRunnable runnable = Flushing.flushRunnable(cfs, memtable, rangeStart, t, txn, locations.get(i));
                runnables.add(runnable);
                rangeStart = t;
            }
            return runnables;
        }
        catch (Throwable e) {
            Throwable t = Flushing.abortRunnables(runnables, e);
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    static FlushRunnable flushRunnable(ColumnFamilyStore cfs, Memtable memtable, PartitionPosition from, PartitionPosition to, LifecycleTransaction txn, Directories.DataDirectory flushLocation) {
        Memtable.FlushablePartitionSet<?> flushSet = memtable.getFlushSet(from, to);
        SSTableFormat<?, ?> format = DatabaseDescriptor.getSelectedSSTableFormat();
        long estimatedSize = format.getWriterFactory().estimateSize(flushSet);
        Descriptor descriptor = flushLocation == null ? cfs.newSSTableDescriptor(cfs.getDirectories().getWriteableLocationAsFile(estimatedSize), format) : cfs.newSSTableDescriptor(cfs.getDirectories().getLocationForDisk(flushLocation), format);
        SSTableMultiWriter writer = Flushing.createFlushWriter(cfs, flushSet, txn, descriptor, flushSet.partitionCount());
        return new FlushRunnable(flushSet, writer, cfs.metric, true);
    }

    public static Throwable abortRunnables(List<FlushRunnable> runnables, Throwable t) {
        if (runnables != null) {
            for (FlushRunnable runnable : runnables) {
                t = runnable.writer.abort(t);
            }
        }
        return t;
    }

    public static SSTableMultiWriter createFlushWriter(ColumnFamilyStore cfs, Memtable.FlushablePartitionSet<?> flushSet, LifecycleTransaction txn, Descriptor descriptor, long partitionCount) {
        return cfs.createSSTableMultiWriter(descriptor, partitionCount, 0L, ActiveRepairService.NO_PENDING_REPAIR, false, new IntervalSet<CommitLogPosition>(flushSet.commitLogLowerBound(), flushSet.commitLogUpperBound()), new SerializationHeader(true, flushSet.metadata(), flushSet.columns(), flushSet.encodingStats()), txn);
    }

    public static class FlushRunnable
    implements Callable<SSTableMultiWriter> {
        private final Memtable.FlushablePartitionSet<?> toFlush;
        private final SSTableMultiWriter writer;
        private final TableMetrics metrics;
        private final boolean isBatchLogTable;
        private final boolean logCompletion;

        public FlushRunnable(Memtable.FlushablePartitionSet<?> flushSet, SSTableMultiWriter writer, TableMetrics metrics, boolean logCompletion) {
            this.toFlush = flushSet;
            this.writer = writer;
            this.metrics = metrics;
            this.isBatchLogTable = this.toFlush.metadata() == SystemKeyspace.Batches;
            this.logCompletion = logCompletion;
        }

        private void writeSortedContents() {
            logger.info("Writing {}, flushed range = [{}, {})", new Object[]{this.toFlush.memtable(), this.toFlush.from(), this.toFlush.to()});
            for (Partition partition : this.toFlush) {
                if (this.isBatchLogTable && !partition.partitionLevelDeletion().isLive() && partition.hasRows() || partition.isEmpty()) continue;
                UnfilteredRowIterator iter = partition.unfilteredIterator();
                try {
                    this.writer.append(iter);
                }
                finally {
                    if (iter == null) continue;
                    iter.close();
                }
            }
            if (this.logCompletion) {
                long bytesFlushed = this.writer.getBytesWritten();
                logger.info("Completed flushing {} ({}) for commitlog position {}", new Object[]{this.writer.getFilename(), FBUtilities.prettyPrintMemory(bytesFlushed), this.toFlush.memtable().getFinalCommitLogUpperBound()});
                this.metrics.bytesFlushed.inc(bytesFlushed);
            }
        }

        @Override
        public SSTableMultiWriter call() {
            this.writeSortedContents();
            return this.writer;
        }

        public String toString() {
            return "Flush " + this.toFlush.metadata().keyspace + "." + this.toFlush.metadata().name;
        }
    }
}

