/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.stress.report.StressMetrics;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class StressGraph {
    private StressSettings stressSettings;
    private String[] stressArguments;

    public StressGraph(StressSettings stressSetttings, String[] stressArguments) {
        this.stressSettings = stressSetttings;
        this.stressArguments = stressArguments;
    }

    public void generateGraph() {
        JSONObject stats;
        File htmlFile = new File(this.stressSettings.graph.file);
        if (htmlFile.isFile()) {
            try {
                String html = new String(Files.readAllBytes(Paths.get(htmlFile.toURI())), StandardCharsets.UTF_8);
                stats = this.parseExistingStats(html);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't load existing stats html.");
            }
            stats = this.createJSONStats(stats);
        } else {
            stats = this.createJSONStats(null);
        }
        try {
            PrintWriter out = new PrintWriter(htmlFile);
            String statsBlock = "/* stats start */\nstats = " + stats.toJSONString() + ";\n/* stats end */\n";
            String html = this.getGraphHTML().replaceFirst("/\\* stats start \\*/\n\n/\\* stats end \\*/\n", statsBlock);
            out.write(html);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write stats html.");
        }
    }

    private JSONObject parseExistingStats(String html) {
        Pattern pattern = Pattern.compile("(?s).*/\\* stats start \\*/\\nstats = (.*);\\n/\\* stats end \\*/.*");
        Matcher matcher = pattern.matcher(html);
        matcher.matches();
        JSONObject stats = (JSONObject)JSONValue.parse((String)matcher.group(1));
        return stats;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getGraphHTML() {
        try (InputStream graphHTMLRes = StressGraph.class.getClassLoader().getResourceAsStream("org/apache/cassandra/stress/graph/graph.html");){
            String string = new String(ByteStreams.toByteArray((InputStream)graphHTMLRes));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONArray parseLogStats(InputStream log, JSONArray stats) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(log));
        JSONObject json = new JSONObject();
        JSONArray intervals = new JSONArray();
        boolean runningMultipleThreadCounts = false;
        String currentThreadCount = null;
        Pattern threadCountMessage = Pattern.compile("Running ([A-Z]+) with ([0-9]+) threads .*");
        ReadingMode mode = ReadingMode.START;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher tc;
                if (line.startsWith("Thread count was not specified")) {
                    runningMultipleThreadCounts = true;
                }
                if (runningMultipleThreadCounts && (tc = threadCountMessage.matcher(line)).matches()) {
                    currentThreadCount = tc.group(2);
                }
                if (line.equals(StressMetrics.HEAD)) {
                    mode = ReadingMode.METRICS;
                    continue;
                }
                if (line.equals("Results:")) {
                    mode = ReadingMode.AGGREGATES;
                    continue;
                }
                if (mode == ReadingMode.AGGREGATES && line.equals("")) {
                    mode = ReadingMode.NEXTITERATION;
                } else if (line.equals("END") || line.equals("FAILURE")) break;
                if (mode == ReadingMode.METRICS) {
                    JSONArray metrics = new JSONArray();
                    String[] parts = line.split(",");
                    if (parts.length != StressMetrics.HEADMETRICS.length) continue;
                    for (String m : parts) {
                        try {
                            metrics.add((Object)new BigDecimal(m.trim()));
                        }
                        catch (NumberFormatException e) {
                            metrics.add(null);
                        }
                    }
                    intervals.add((Object)metrics);
                    continue;
                }
                if (mode == ReadingMode.AGGREGATES) {
                    String[] parts = line.split(":", 2);
                    if (parts.length != 2) continue;
                    json.put((Object)parts[0].trim().toLowerCase(), (Object)parts[1].trim());
                    continue;
                }
                if (mode != ReadingMode.NEXTITERATION) continue;
                json.put((Object)"metrics", Arrays.asList(StressMetrics.HEADMETRICS));
                json.put((Object)"test", (Object)this.stressSettings.graph.operation);
                if (currentThreadCount == null) {
                    json.put((Object)"revision", (Object)this.stressSettings.graph.revision);
                } else {
                    json.put((Object)"revision", (Object)String.format("%s - %s threads", this.stressSettings.graph.revision, currentThreadCount));
                }
                String command = StringUtils.join((Object[])this.stressArguments, (String)" ").replaceAll("password=.*? ", "password=******* ");
                json.put((Object)"command", (Object)command);
                json.put((Object)"intervals", (Object)intervals);
                stats.add((Object)json);
                json = new JSONObject();
                intervals = new JSONArray();
                mode = ReadingMode.START;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read from temporary stress log file");
        }
        if (json.size() != 0) {
            stats.add((Object)json);
        }
        return stats;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject createJSONStats(JSONObject json) {
        try (InputStream logStream = Files.newInputStream(this.stressSettings.graph.temporaryLogFile.toPath(), new OpenOption[0]);){
            JSONArray stats;
            if (json == null) {
                json = new JSONObject();
                stats = new JSONArray();
            } else {
                stats = (JSONArray)json.get((Object)"stats");
            }
            stats = this.parseLogStats(logStream, stats);
            json.put((Object)"title", (Object)this.stressSettings.graph.title);
            json.put((Object)"stats", (Object)stats);
            JSONObject jSONObject = json;
            return jSONObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum ReadingMode {
        START,
        METRICS,
        AGGREGATES,
        NEXTITERATION;

    }
}

