/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.AbstractPollTableEntry;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;

public abstract class AbstractPollingTransportListener<T extends AbstractPollTableEntry>
extends AbstractTransportListenerEx<T> {
    private Timer timer;

    @Override
    protected void doInit() throws AxisFault {
        this.timer = new Timer("PollTimer");
    }

    @Override
    public void destroy() {
        super.destroy();
        this.timer.cancel();
        this.timer = null;
    }

    void schedulePoll(T entry) {
        TimerTask timerTask;
        long pollInterval = ((AbstractPollTableEntry)entry).getPollInterval();
        ((AbstractPollTableEntry)entry).timerTask = timerTask = new TimerTask((AbstractPollTableEntry)entry){
            final /* synthetic */ AbstractPollTableEntry val$entry;
            {
                this.val$entry = abstractPollTableEntry;
            }

            @Override
            public void run() {
                AbstractPollingTransportListener.this.workerPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractPollingTransportListener.this.state == 2) {
                            if (AbstractPollingTransportListener.this.log.isDebugEnabled()) {
                                AbstractPollingTransportListener.this.log.debug((Object)("Transport " + AbstractPollingTransportListener.this.getTransportName() + " poll trigger : Transport is currently paused.."));
                            }
                        } else {
                            AbstractPollingTransportListener.this.poll(val$entry);
                        }
                    }
                });
            }
        };
        if (((AbstractPollTableEntry)entry).isConcurrentPollingAllowed()) {
            this.timer.scheduleAtFixedRate(timerTask, pollInterval, pollInterval);
        } else {
            this.timer.schedule(timerTask, pollInterval);
        }
    }

    @Override
    protected void startEndpoint(T endpoint) throws AxisFault {
        this.schedulePoll(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopEndpoint(T endpoint) {
        T t = endpoint;
        synchronized (t) {
            ((AbstractPollTableEntry)endpoint).timerTask.cancel();
            ((AbstractPollTableEntry)endpoint).canceled = true;
        }
    }

    protected abstract void poll(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPollCompletion(T entry) {
        if (!((AbstractPollTableEntry)entry).isConcurrentPollingAllowed()) {
            T t = entry;
            synchronized (t) {
                if (!((AbstractPollTableEntry)entry).canceled) {
                    this.schedulePoll(entry);
                }
            }
        }
    }

    protected void processFailure(String msg, Exception e, T entry) {
        if (e == null) {
            this.log.error((Object)msg);
        } else {
            this.log.error((Object)msg, (Throwable)e);
        }
        long now = System.currentTimeMillis();
        ((AbstractPollTableEntry)entry).setLastPollState(2);
        ((AbstractPollTableEntry)entry).setLastPollTime(now);
        ((AbstractPollTableEntry)entry).setNextPollTime(now + ((AbstractPollTableEntry)entry).getPollInterval());
        this.onPollCompletion(entry);
    }

    @Override
    public void pause() throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        this.log.info((Object)"Listener paused");
    }

    @Override
    public void resume() throws AxisFault {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        this.log.info((Object)"Listener resumed");
    }

    @Override
    public void maintenenceShutdown(long millis) throws AxisFault {
        if (this.state != 1) {
            return;
        }
        this.stop();
        this.state = 0;
        this.log.info((Object)"Listener shutdown");
    }
}

