/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.moshi;

import com.squareup.moshi.JsonReader;
import java.io.InputStream;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.moshi.MoshiXMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonBuilder
implements Builder {
    Log log = LogFactory.getLog(JsonBuilder.class);

    public OMElement processDocument(InputStream inputStream, String s, MessageContext messageContext) throws AxisFault {
        messageContext.setProperty("isJsonStream", (Object)true);
        String charSetEncoding = null;
        if (inputStream != null) {
            try {
                charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
                if (charSetEncoding != null && charSetEncoding.indexOf("UTF-8") == -1) {
                    this.log.warn((Object)("JsonBuilder.processDocument() detected encoding that is not UTF-8: " + charSetEncoding + " , Moshi JsonReader internally invokes new JsonUtf8Reader()"));
                }
                BufferedSource source = Okio.buffer((Source)Okio.source((InputStream)inputStream));
                JsonReader jsonReader = JsonReader.of((BufferedSource)source);
                jsonReader.setLenient(true);
                MoshiXMLStreamReader moshiXMLStreamReader = new MoshiXMLStreamReader(jsonReader);
                messageContext.setProperty("MoshiXMLStreamReader", (Object)moshiXMLStreamReader);
            }
            catch (Exception e) {
                this.log.error((Object)("Exception occurred while writting to JsonWriter from JsonFormatter: " + e.getMessage()), (Throwable)e);
                throw new AxisFault("Bad Request");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Inputstream is null, This is possible with GET request");
        }
        this.log.debug((Object)"JsonBuilder.processDocument() has completed, returning default envelope");
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        return soapFactory.getDefaultEnvelope();
    }
}

