/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.i18n.Messages;

public class AxisServiceGroup
extends AxisDescription {
    private boolean foundWebResources;
    private ArrayList<String> modulesList = new ArrayList();
    private HashMap<String, ModuleConfiguration> moduleConfigmap = new HashMap();
    private ClassLoader serviceGroupClassLoader;
    private String serviceGroupName;

    public AxisServiceGroup() {
    }

    public AxisServiceGroup(AxisConfiguration axisDescription) {
        this();
        this.setParent(axisDescription);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        if (this.moduleConfigmap == null) {
            this.moduleConfigmap = new HashMap();
        }
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleref(String moduleref) {
        this.modulesList.add(moduleref);
    }

    public void addService(AxisService service) throws AxisFault {
        if (service == null) {
            return;
        }
        if (this.serviceGroupName == null) {
            this.serviceGroupName = service.getName();
        }
        service.setParent(this);
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        if (axisConfig != null) {
            for (AxisModule o : this.getEngagedModules()) {
                AxisModule axisModule;
                if (o instanceof AxisModule) {
                    axisModule = o;
                } else if (o instanceof String) {
                    String moduleName = (String)((Object)o);
                    axisModule = axisConfig.getModule(moduleName);
                    if (axisModule == null) {
                        throw new AxisFault(Messages.getMessage("modulenotavailble", moduleName));
                    }
                } else {
                    throw new AxisFault(Messages.getMessage("modulenotavailble"));
                }
                service.engageModule(axisModule);
            }
        }
        service.setLastUpdate();
        this.addChild(service);
        if (axisConfig != null) {
            axisConfig.addToAllServicesMap(service);
        }
    }

    @Override
    protected void onEngage(AxisModule module, AxisDescription engager) throws AxisFault {
        Iterator<AxisService> serviceIter = this.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = serviceIter.next();
            axisService.engageModule(module, engager);
        }
    }

    @Override
    public void onDisengage(AxisModule module) throws AxisFault {
        Iterator<AxisService> serviceIter = this.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = serviceIter.next();
            axisService.disengageModule(module);
        }
    }

    public void removeService(String name) throws AxisFault {
        AxisService service = this.getService(name);
        if (service != null) {
            this.getAxisConfiguration().notifyObservers(new AxisEvent(0, service), service);
        }
        this.removeChild(name);
    }

    public ModuleConfiguration getModuleConfig(String moduleName) {
        return this.moduleConfigmap.get(moduleName);
    }

    public ArrayList<String> getModuleRefs() {
        return this.modulesList;
    }

    public AxisService getService(String name) throws AxisFault {
        return (AxisService)this.getChild(name);
    }

    public ClassLoader getServiceGroupClassLoader() {
        return this.serviceGroupClassLoader;
    }

    public String getServiceGroupName() {
        return this.serviceGroupName;
    }

    public Iterator<AxisService> getServices() {
        return this.getChildren();
    }

    public void setAxisDescription(AxisConfiguration axisDescription) {
        this.setParent(axisDescription);
    }

    public void setServiceGroupClassLoader(ClassLoader serviceGroupClassLoader) {
        this.serviceGroupClassLoader = serviceGroupClassLoader;
    }

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    @Override
    public Object getKey() {
        return this.serviceGroupName;
    }

    public boolean isFoundWebResources() {
        return this.foundWebResources;
    }

    public void setFoundWebResources(boolean foundWebResources) {
        this.foundWebResources = foundWebResources;
    }
}

