/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.jvm;

import java.util.Collection;
import org.openjdk.javax.lang.model.element.ElementKind;
import org.openjdk.tools.javac.code.Attribute;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.TargetType;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.Lower;
import org.openjdk.tools.javac.comp.Resolve;
import org.openjdk.tools.javac.jvm.CRTable;
import org.openjdk.tools.javac.jvm.Code;
import org.openjdk.tools.javac.jvm.Items;
import org.openjdk.tools.javac.jvm.Pool;
import org.openjdk.tools.javac.jvm.StringConcat;
import org.openjdk.tools.javac.jvm.Target;
import org.openjdk.tools.javac.jvm.UninitializedType;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.model.FilteredMemberList;
import org.openjdk.tools.javac.tree.EndPosTable;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.Pair;

public class Gen
extends JCTree.Visitor {
    protected static final Context.Key<Gen> genKey = new Context.Key();
    private final Log log;
    private final Symtab syms;
    private final Check chk;
    private final Resolve rs;
    private final TreeMaker make;
    private final Names names;
    private final Target target;
    private final Name accessDollar;
    private final Types types;
    private final Lower lower;
    private final Annotate annotate;
    private final StringConcat concat;
    private final Code.StackMapFormat stackMap;
    private final Type methodType;
    private int letExprDepth;
    private final Pool pool;
    private final boolean lineDebugInfo;
    private final boolean varDebugInfo;
    private final boolean genCrt;
    private final boolean debugCode;
    private final boolean allowBetterNullChecks;
    private Code code;
    private Items items;
    private Env<AttrContext> attrEnv;
    private JCTree.JCCompilationUnit toplevel;
    private int nerrs = 0;
    EndPosTable endPosTable;
    Env<GenContext> env;
    Type pt;
    Items.Item result;
    private ClassReferenceVisitor classReferenceVisitor = new ClassReferenceVisitor();

    public static Gen instance(Context context) {
        Gen gen = context.get(genKey);
        if (gen == null) {
            gen = new Gen(context);
        }
        return gen;
    }

    protected Gen(Context context) {
        context.put(genKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.chk = Check.instance(context);
        this.rs = Resolve.instance(context);
        this.make = TreeMaker.instance(context);
        this.target = Target.instance(context);
        this.types = Types.instance(context);
        this.concat = StringConcat.instance(context);
        this.methodType = new Type.MethodType(null, null, null, this.syms.methodClass);
        this.accessDollar = this.names.fromString("access" + this.target.syntheticNameChar());
        this.lower = Lower.instance(context);
        Options options = Options.instance(context);
        this.lineDebugInfo = options.isUnset(Option.G_CUSTOM) || options.isSet(Option.G_CUSTOM, "lines");
        this.varDebugInfo = options.isUnset(Option.G_CUSTOM) ? options.isSet(Option.G) : options.isSet(Option.G_CUSTOM, "vars");
        this.genCrt = options.isSet(Option.XJCOV);
        this.debugCode = options.isSet("debug.code");
        this.allowBetterNullChecks = options.getBoolean("allowBetterNullChecks", this.target.hasObjects());
        this.pool = new Pool(this.types);
        this.stackMap = Code.StackMapFormat.JSR202;
        this.annotate = Annotate.instance(context);
    }

    void loadIntConst(int n) {
        this.items.makeImmediateItem(this.syms.intType, n).load();
    }

    public static int zero(int n) {
        switch (n) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 14;
            }
        }
        throw new AssertionError((Object)"zero");
    }

    public static int one(int n) {
        return Gen.zero(n) + 1;
    }

    void emitMinusOne(int n) {
        if (n == 1) {
            this.items.makeImmediateItem(this.syms.longType, -1L).load();
        } else {
            this.code.emitop0(2);
        }
    }

    Symbol binaryQualifier(Symbol symbol, Type type) {
        if (type.hasTag(TypeTag.ARRAY)) {
            if (symbol == this.syms.lengthVar || symbol.owner != this.syms.arrayClass) {
                return symbol;
            }
            Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(1L, type.tsym.name, type, this.syms.noSymbol);
            return symbol.clone(classSymbol);
        }
        if (symbol.owner == type.tsym || (symbol.flags() & 0x1008L) == 4104L) {
            return symbol;
        }
        if (symbol.owner == this.syms.objectType.tsym) {
            return symbol;
        }
        return symbol.clone(type.tsym);
    }

    int makeRef(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkDimension(diagnosticPosition, type);
        if (type.isAnnotated()) {
            return this.pool.put(type);
        }
        return this.pool.put(type.hasTag(TypeTag.CLASS) ? type.tsym : type);
    }

    private void checkDimension(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        switch (type.getTag()) {
            case METHOD: {
                this.checkDimension(diagnosticPosition, type.getReturnType());
                List<Type> list = type.getParameterTypes();
                while (list.nonEmpty()) {
                    this.checkDimension(diagnosticPosition, (Type)list.head);
                    list = list.tail;
                }
                break;
            }
            case ARRAY: {
                if (this.types.dimensions(type) <= 255) break;
                this.log.error(diagnosticPosition, "limit.dimensions", new Object[0]);
                ++this.nerrs;
                break;
            }
        }
    }

    Items.LocalItem makeTemp(Type type) {
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(4096L, this.names.empty, type, this.env.enclMethod.sym);
        this.code.newLocal(varSymbol);
        return this.items.makeLocalItem(varSymbol);
    }

    void callMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name, List<Type> list, boolean bl) {
        Symbol.MethodSymbol methodSymbol = this.rs.resolveInternalMethod(diagnosticPosition, this.attrEnv, type, name, list, null);
        if (bl) {
            this.items.makeStaticItem(methodSymbol).invoke();
        } else {
            this.items.makeMemberItem(methodSymbol, name == this.names.init).invoke();
        }
    }

    private boolean isAccessSuper(JCTree.JCMethodDecl jCMethodDecl) {
        return (jCMethodDecl.mods.flags & 0x1000L) != 0L && this.isOddAccessName(jCMethodDecl.name);
    }

    private boolean isOddAccessName(Name name) {
        return name.startsWith(this.accessDollar) && (name.getByteAt(name.getByteLength() - 1) & 1) == 1;
    }

    void genFinalizer(Env<GenContext> env) {
        if (this.code.isAlive() && ((GenContext)env.info).finalize != null) {
            ((GenContext)env.info).finalize.gen();
        }
    }

    Env<GenContext> unwind(JCTree jCTree, Env<GenContext> env) {
        Env<GenContext> env2 = env;
        while (true) {
            this.genFinalizer(env2);
            if (env2.tree == jCTree) break;
            env2 = env2.next;
        }
        return env2;
    }

    void endFinalizerGap(Env<GenContext> env) {
        if (((GenContext)env.info).gaps != null && ((GenContext)env.info).gaps.length() % 2 == 1) {
            ((GenContext)env.info).gaps.append(this.code.curCP());
        }
    }

    void endFinalizerGaps(Env<GenContext> env, Env<GenContext> env2) {
        Env<GenContext> env3 = null;
        while (env3 != env2) {
            this.endFinalizerGap(env);
            env3 = env;
            env = env.next;
        }
    }

    boolean hasFinally(JCTree jCTree, Env<GenContext> env) {
        while (env.tree != jCTree) {
            if (env.tree.hasTag(JCTree.Tag.TRY) && ((GenContext)env.info).finalize.hasFinalizer()) {
                return true;
            }
            env = env.next;
        }
        return false;
    }

    List<JCTree> normalizeDefs(List<JCTree> list, Symbol.ClassSymbol classSymbol) {
        Object object;
        List<JCTree.JCStatement> list2;
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Object> listBuffer3 = new ListBuffer<Object>();
        ListBuffer<Attribute.TypeCompound> listBuffer4 = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<JCTree> listBuffer5 = new ListBuffer<JCTree>();
        Object object2 = list;
        while (((List)object2).nonEmpty()) {
            list2 = (JCTree)((List)object2).head;
            switch (((JCTree)((Object)list2)).getTag()) {
                case BLOCK: {
                    object = (JCTree.JCBlock)((Object)list2);
                    if ((((JCTree.JCBlock)object).flags & 8L) != 0L) {
                        listBuffer3.append(object);
                        break;
                    }
                    if ((((JCTree.JCBlock)object).flags & 0x1000L) != 0L) break;
                    listBuffer.append(object);
                    break;
                }
                case METHODDEF: {
                    listBuffer5.append((JCTree)((Object)list2));
                    break;
                }
                case VARDEF: {
                    JCTree.JCStatement jCStatement;
                    JCTree jCTree = (JCTree.JCVariableDecl)((Object)list2);
                    Symbol.VarSymbol varSymbol = ((JCTree.JCVariableDecl)jCTree).sym;
                    this.checkDimension(jCTree.pos(), varSymbol.type);
                    if (((JCTree.JCVariableDecl)jCTree).init == null) break;
                    if ((varSymbol.flags() & 8L) == 0L) {
                        jCStatement = this.make.at(jCTree.pos()).Assignment(varSymbol, ((JCTree.JCVariableDecl)jCTree).init);
                        listBuffer.append(jCStatement);
                        this.endPosTable.replaceTree(jCTree, jCStatement);
                        listBuffer2.addAll((Collection<Attribute.TypeCompound>)this.getAndRemoveNonFieldTAs(varSymbol));
                        break;
                    }
                    if (varSymbol.getConstValue() == null) {
                        jCStatement = this.make.at(((JCTree.JCVariableDecl)jCTree).pos).Assignment(varSymbol, ((JCTree.JCVariableDecl)jCTree).init);
                        listBuffer3.append(jCStatement);
                        this.endPosTable.replaceTree(jCTree, jCStatement);
                        listBuffer4.addAll((Collection<Attribute.TypeCompound>)this.getAndRemoveNonFieldTAs(varSymbol));
                        break;
                    }
                    this.checkStringConstant(((JCTree.JCVariableDecl)jCTree).init.pos(), varSymbol.getConstValue());
                    ((JCTree.JCVariableDecl)jCTree).init.accept(this.classReferenceVisitor);
                    break;
                }
                default: {
                    Assert.error();
                }
            }
            object2 = ((List)object2).tail;
        }
        if (listBuffer.length() != 0) {
            object2 = listBuffer.toList();
            listBuffer2.addAll((Collection<Attribute.TypeCompound>)classSymbol.getInitTypeAttributes());
            list2 = listBuffer2.toList();
            for (JCTree jCTree : listBuffer5) {
                this.normalizeMethod((JCTree.JCMethodDecl)jCTree, (List<JCTree.JCStatement>)object2, (List<Attribute.TypeCompound>)list2);
            }
        }
        if (listBuffer3.length() != 0) {
            object2 = new Symbol.MethodSymbol(8L | classSymbol.flags() & 0x800L, this.names.clinit, new Type.MethodType(List.nil(), this.syms.voidType, List.nil(), this.syms.methodClass), classSymbol);
            classSymbol.members().enter((Symbol)object2);
            list2 = listBuffer3.toList();
            object = this.make.at(((JCTree.JCStatement)list2.head).pos()).Block(0L, list2);
            ((JCTree.JCBlock)object).endpos = TreeInfo.endPos(list2.last());
            listBuffer5.append(this.make.MethodDef((Symbol.MethodSymbol)object2, (JCTree.JCBlock)object));
            if (!listBuffer4.isEmpty()) {
                ((Symbol)object2).appendUniqueTypeAttributes(listBuffer4.toList());
            }
            if (!classSymbol.getClassInitTypeAttributes().isEmpty()) {
                ((Symbol)object2).appendUniqueTypeAttributes(classSymbol.getClassInitTypeAttributes());
            }
        }
        return listBuffer5.toList();
    }

    private List<Attribute.TypeCompound> getAndRemoveNonFieldTAs(Symbol.VarSymbol varSymbol) {
        List<Attribute.TypeCompound> list = varSymbol.getRawTypeAttributes();
        ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeCompound : list) {
            Assert.check(typeCompound.getPosition().type != TargetType.UNKNOWN);
            if (typeCompound.getPosition().type == TargetType.FIELD) {
                listBuffer.add(typeCompound);
                continue;
            }
            listBuffer2.add(typeCompound);
        }
        varSymbol.setTypeAttributes(listBuffer.toList());
        return listBuffer2.toList();
    }

    private void checkStringConstant(JCDiagnostic.DiagnosticPosition diagnosticPosition, Object object) {
        if (this.nerrs != 0 || object == null || !(object instanceof String) || ((String)object).length() < 65535) {
            return;
        }
        this.log.error(diagnosticPosition, "limit.string", new Object[0]);
        ++this.nerrs;
    }

    void normalizeMethod(JCTree.JCMethodDecl jCMethodDecl, List<JCTree.JCStatement> list, List<Attribute.TypeCompound> list2) {
        if (jCMethodDecl.name == this.names.init && TreeInfo.isInitialConstructor(jCMethodDecl)) {
            List<JCTree.JCStatement> list3 = jCMethodDecl.body.stats;
            ListBuffer listBuffer = new ListBuffer();
            if (list3.nonEmpty()) {
                while (TreeInfo.isSyntheticInit((JCTree)list3.head)) {
                    listBuffer.append(list3.head);
                    list3 = list3.tail;
                }
                listBuffer.append(list3.head);
                list3 = list3.tail;
                while (list3.nonEmpty() && TreeInfo.isSyntheticInit((JCTree)list3.head)) {
                    listBuffer.append(list3.head);
                    list3 = list3.tail;
                }
                listBuffer.appendList(list);
                while (list3.nonEmpty()) {
                    listBuffer.append(list3.head);
                    list3 = list3.tail;
                }
            }
            jCMethodDecl.body.stats = listBuffer.toList();
            if (jCMethodDecl.body.endpos == -1) {
                jCMethodDecl.body.endpos = TreeInfo.endPos(jCMethodDecl.body.stats.last());
            }
            jCMethodDecl.sym.appendUniqueTypeAttributes(list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genDef(JCTree jCTree, Env<GenContext> env) {
        Env<GenContext> env2 = this.env;
        try {
            this.env = env;
            jCTree.accept(this);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(jCTree.pos(), completionFailure);
        }
        finally {
            this.env = env2;
        }
    }

    public void genStat(JCTree jCTree, Env<GenContext> env, int n) {
        if (!this.genCrt) {
            this.genStat(jCTree, env);
            return;
        }
        int n2 = this.code.curCP();
        this.genStat(jCTree, env);
        if (jCTree.hasTag(JCTree.Tag.BLOCK)) {
            n |= 2;
        }
        this.code.crt.put(jCTree, n, n2, this.code.curCP());
    }

    public void genStat(JCTree jCTree, Env<GenContext> env) {
        if (this.code.isAlive()) {
            this.code.statBegin(jCTree.pos);
            this.genDef(jCTree, env);
        } else if (((GenContext)env.info).isSwitch && jCTree.hasTag(JCTree.Tag.VARDEF)) {
            this.code.newLocal(((JCTree.JCVariableDecl)jCTree).sym);
        }
    }

    public void genStats(List<JCTree.JCStatement> list, Env<GenContext> env, int n) {
        if (!this.genCrt) {
            this.genStats(list, env);
            return;
        }
        if (list.length() == 1) {
            this.genStat((JCTree)list.head, env, n | 1);
        } else {
            int n2 = this.code.curCP();
            this.genStats(list, env);
            this.code.crt.put(list, n, n2, this.code.curCP());
        }
    }

    public void genStats(List<? extends JCTree> list, Env<GenContext> env) {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.genStat((JCTree)list2.head, env, 1);
            list2 = list2.tail;
        }
    }

    public Items.CondItem genCond(JCTree jCTree, int n) {
        if (!this.genCrt) {
            return this.genCond(jCTree, false);
        }
        int n2 = this.code.curCP();
        Items.CondItem condItem = this.genCond(jCTree, (n & 8) != 0);
        this.code.crt.put(jCTree, n, n2, this.code.curCP());
        return condItem;
    }

    public Items.CondItem genCond(JCTree jCTree, boolean bl) {
        JCTree jCTree2 = TreeInfo.skipParens(jCTree);
        if (jCTree2.hasTag(JCTree.Tag.CONDEXPR)) {
            JCTree.JCConditional jCConditional = (JCTree.JCConditional)jCTree2;
            Items.CondItem condItem = this.genCond((JCTree)jCConditional.cond, 8);
            if (condItem.isTrue()) {
                this.code.resolve(condItem.trueJumps);
                Items.CondItem condItem2 = this.genCond((JCTree)jCConditional.truepart, 16);
                if (bl) {
                    condItem2.tree = jCConditional.truepart;
                }
                return condItem2;
            }
            if (condItem.isFalse()) {
                this.code.resolve(condItem.falseJumps);
                Items.CondItem condItem3 = this.genCond((JCTree)jCConditional.falsepart, 16);
                if (bl) {
                    condItem3.tree = jCConditional.falsepart;
                }
                return condItem3;
            }
            Code.Chain chain = condItem.jumpFalse();
            this.code.resolve(condItem.trueJumps);
            Items.CondItem condItem4 = this.genCond((JCTree)jCConditional.truepart, 16);
            if (bl) {
                condItem4.tree = jCConditional.truepart;
            }
            Code.Chain chain2 = condItem4.jumpFalse();
            this.code.resolve(condItem4.trueJumps);
            Code.Chain chain3 = this.code.branch(167);
            this.code.resolve(chain);
            Items.CondItem condItem5 = this.genCond((JCTree)jCConditional.falsepart, 16);
            Items.CondItem condItem6 = this.items.makeCondItem(condItem5.opcode, Code.mergeChains(chain3, condItem5.trueJumps), Code.mergeChains(chain2, condItem5.falseJumps));
            if (bl) {
                condItem6.tree = jCConditional.falsepart;
            }
            return condItem6;
        }
        Items.CondItem condItem = this.genExpr(jCTree, this.syms.booleanType).mkCond();
        if (bl) {
            condItem.tree = jCTree;
        }
        return condItem;
    }

    public Code getCode() {
        return this.code;
    }

    public Items getItems() {
        return this.items;
    }

    public Env<AttrContext> getAttrEnv() {
        return this.attrEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Items.Item genExpr(JCTree jCTree, Type type) {
        Type type2 = this.pt;
        try {
            if (jCTree.type.constValue() != null) {
                jCTree.accept(this.classReferenceVisitor);
                this.checkStringConstant(jCTree.pos(), jCTree.type.constValue());
                this.result = this.items.makeImmediateItem(jCTree.type, jCTree.type.constValue());
            } else {
                this.pt = type;
                jCTree.accept(this);
            }
            Items.Item item = this.result.coerce(type);
            return item;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(jCTree.pos(), completionFailure);
            this.code.state.stacksize = 1;
            Items.Item item = this.items.makeStackItem(type);
            return item;
        }
        finally {
            this.pt = type2;
        }
    }

    public void genArgs(List<JCTree.JCExpression> list, List<Type> list2) {
        List<JCTree.JCExpression> list3 = list;
        while (list3.nonEmpty()) {
            this.genExpr((JCTree)list3.head, (Type)list2.head).load();
            list2 = list2.tail;
            list3 = list3.tail;
        }
        Assert.check(list2.isEmpty());
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        Env<GenContext> env = this.env.dup(jCMethodDecl);
        env.enclMethod = jCMethodDecl;
        this.pt = jCMethodDecl.sym.erasure(this.types).getReturnType();
        this.checkDimension(jCMethodDecl.pos(), jCMethodDecl.sym.erasure(this.types));
        this.genMethod(jCMethodDecl, env, false);
    }

    void genMethod(JCTree.JCMethodDecl jCMethodDecl, Env<GenContext> env, boolean bl) {
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        int n = 0;
        if (methodSymbol.isConstructor()) {
            ++n;
            if (methodSymbol.enclClass().isInner() && !methodSymbol.enclClass().isStatic()) {
                ++n;
            }
        } else if ((jCMethodDecl.mods.flags & 8L) == 0L) {
            ++n;
        }
        if (Code.width(this.types.erasure(env.enclMethod.sym.type).getParameterTypes()) + n > 255) {
            this.log.error(jCMethodDecl.pos(), "limit.parameters", new Object[0]);
            ++this.nerrs;
        } else if (jCMethodDecl.body != null) {
            int n2 = this.initCode(jCMethodDecl, env, bl);
            try {
                this.genStat(jCMethodDecl.body, env);
            }
            catch (CodeSizeOverflow codeSizeOverflow) {
                n2 = this.initCode(jCMethodDecl, env, bl);
                this.genStat(jCMethodDecl.body, env);
            }
            if (this.code.state.stacksize != 0) {
                this.log.error(jCMethodDecl.body.pos(), "stack.sim.error", jCMethodDecl);
                throw new AssertionError();
            }
            if (this.code.isAlive()) {
                this.code.statBegin(TreeInfo.endPos(jCMethodDecl.body));
                if (env.enclMethod == null || env.enclMethod.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                    this.code.emitop0(177);
                } else {
                    int n3 = this.code.entryPoint();
                    Items.CondItem condItem = this.items.makeCondItem(167);
                    this.code.resolve(condItem.jumpTrue(), n3);
                }
            }
            if (this.genCrt) {
                this.code.crt.put(jCMethodDecl.body, 2, n2, this.code.curCP());
            }
            this.code.endScopes(0);
            if (this.code.checkLimits(jCMethodDecl.pos(), this.log)) {
                ++this.nerrs;
                return;
            }
            if (!bl && this.code.fatcode) {
                this.genMethod(jCMethodDecl, env, true);
            }
            if (this.stackMap == Code.StackMapFormat.JSR202) {
                this.code.lastFrame = null;
                this.code.frameBeforeLast = null;
            }
            this.code.compressCatchTable();
            this.code.fillExceptionParameterPositions();
        }
    }

    private int initCode(JCTree.JCMethodDecl jCMethodDecl, Env<GenContext> env, boolean bl) {
        List list;
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        methodSymbol.code = this.code = new Code(methodSymbol, bl, this.lineDebugInfo ? this.toplevel.lineMap : null, this.varDebugInfo, this.stackMap, this.debugCode, this.genCrt ? new CRTable(jCMethodDecl, env.toplevel.endPositions) : null, this.syms, this.types, this.pool);
        this.items = new Items(this.pool, this.code, this.syms, this.types);
        if (this.code.debugCode) {
            System.err.println(methodSymbol + " for body " + jCMethodDecl);
        }
        if ((jCMethodDecl.mods.flags & 8L) == 0L) {
            list = methodSymbol.owner.type;
            if (methodSymbol.isConstructor() && list != this.syms.objectType) {
                list = UninitializedType.uninitializedThis((Type)((Object)list));
            }
            this.code.setDefined(this.code.newLocal(new Symbol.VarSymbol(16L, this.names._this, (Type)((Object)list), methodSymbol.owner)));
        }
        list = jCMethodDecl.params;
        while (list.nonEmpty()) {
            this.checkDimension(((JCTree.JCVariableDecl)list.head).pos(), ((JCTree.JCVariableDecl)list.head).sym.type);
            this.code.setDefined(this.code.newLocal(((JCTree.JCVariableDecl)list.head).sym));
            list = list.tail;
        }
        int n = this.genCrt ? this.code.curCP() : 0;
        this.code.entryPoint();
        this.code.pendingStackMap = false;
        return n;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
        this.code.newLocal(varSymbol);
        if (jCVariableDecl.init != null) {
            this.checkStringConstant(jCVariableDecl.init.pos(), varSymbol.getConstValue());
            if (varSymbol.getConstValue() == null || this.varDebugInfo) {
                Assert.check(this.letExprDepth != 0 || this.code.state.stacksize == 0);
                this.genExpr(jCVariableDecl.init, varSymbol.erasure(this.types)).load();
                this.items.makeLocalItem(varSymbol).store();
                Assert.check(this.letExprDepth != 0 || this.code.state.stacksize == 0);
            }
        }
        this.checkDimension(jCVariableDecl.pos(), varSymbol.type);
    }

    @Override
    public void visitSkip(JCTree.JCSkip jCSkip) {
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        int n = this.code.nextreg;
        Env<GenContext> env = this.env.dup(jCBlock, new GenContext());
        this.genStats(jCBlock.stats, env);
        if (!this.env.tree.hasTag(JCTree.Tag.METHODDEF)) {
            this.code.statBegin(jCBlock.endpos);
            this.code.endScopes(n);
            this.code.pendingStatPos = -1;
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        this.genLoop(jCDoWhileLoop, jCDoWhileLoop.body, jCDoWhileLoop.cond, List.nil(), false);
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        this.genLoop(jCWhileLoop, jCWhileLoop.body, jCWhileLoop.cond, List.nil(), true);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        int n = this.code.nextreg;
        this.genStats(jCForLoop.init, this.env);
        this.genLoop(jCForLoop, jCForLoop.body, jCForLoop.cond, jCForLoop.step, true);
        this.code.endScopes(n);
    }

    private void genLoop(JCTree.JCStatement jCStatement, JCTree.JCStatement jCStatement2, JCTree.JCExpression jCExpression, List<JCTree.JCExpressionStatement> list, boolean bl) {
        Object object;
        Env<GenContext> env = this.env.dup(jCStatement, new GenContext());
        int n = this.code.entryPoint();
        if (bl) {
            if (jCExpression != null) {
                this.code.statBegin(jCExpression.pos);
                Assert.check(this.code.state.stacksize == 0);
                object = this.genCond((JCTree)TreeInfo.skipParens(jCExpression), 8);
            } else {
                object = this.items.makeCondItem(167);
            }
            Code.Chain chain = ((Items.CondItem)object).jumpFalse();
            this.code.resolve(((Items.CondItem)object).trueJumps);
            Assert.check(this.code.state.stacksize == 0);
            this.genStat(jCStatement2, env, 17);
            this.code.resolve(((GenContext)env.info).cont);
            this.genStats(list, env);
            this.code.resolve(this.code.branch(167), n);
            this.code.resolve(chain);
        } else {
            this.genStat(jCStatement2, env, 17);
            this.code.resolve(((GenContext)env.info).cont);
            this.genStats(list, env);
            if (this.code.isAlive()) {
                if (jCExpression != null) {
                    this.code.statBegin(jCExpression.pos);
                    Assert.check(this.code.state.stacksize == 0);
                    object = this.genCond((JCTree)TreeInfo.skipParens(jCExpression), 8);
                } else {
                    object = this.items.makeCondItem(167);
                }
                this.code.resolve(((Items.CondItem)object).jumpTrue(), n);
                Assert.check(this.code.state.stacksize == 0);
                this.code.resolve(((Items.CondItem)object).falseJumps);
            }
        }
        object = ((GenContext)env.info).exit;
        if (object != null) {
            this.code.resolve((Code.Chain)object);
            ((Code.Chain)object).state.defined.excludeFrom(this.code.nextreg);
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        throw new AssertionError();
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        Env<GenContext> env = this.env.dup(jCLabeledStatement, new GenContext());
        this.genStat(jCLabeledStatement.body, env, 1);
        Code.Chain chain = ((GenContext)env.info).exit;
        if (chain != null) {
            this.code.resolve(chain);
            chain.state.defined.excludeFrom(this.code.nextreg);
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        int n = this.code.nextreg;
        Assert.check(!jCSwitch.selector.type.hasTag(TypeTag.CLASS));
        int n2 = this.genCrt ? this.code.curCP() : 0;
        Assert.check(this.code.state.stacksize == 0);
        Items.Item item = this.genExpr(jCSwitch.selector, this.syms.intType);
        List<JCTree.JCCase> list = jCSwitch.cases;
        if (list.isEmpty()) {
            item.load().drop();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(jCSwitch.selector), 8, n2, this.code.curCP());
            }
        } else {
            int n3;
            item.load();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(jCSwitch.selector), 8, n2, this.code.curCP());
            }
            Env<GenContext> env = this.env.dup(jCSwitch, new GenContext());
            ((GenContext)env.info).isSwitch = true;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MIN_VALUE;
            int n6 = 0;
            int[] nArray = new int[list.length()];
            int n7 = -1;
            List<JCTree.JCCase> list2 = list;
            for (int i = 0; i < nArray.length; ++i) {
                if (((JCTree.JCCase)list2.head).pat != null) {
                    int n8;
                    nArray[i] = n8 = ((Number)((JCTree.JCCase)list2.head).pat.type.constValue()).intValue();
                    if (n8 < n4) {
                        n4 = n8;
                    }
                    if (n5 < n8) {
                        n5 = n8;
                    }
                    ++n6;
                } else {
                    Assert.check(n7 == -1);
                    n7 = i;
                }
                list2 = list2.tail;
            }
            long l = 4L + ((long)n5 - (long)n4 + 1L);
            long l2 = 3L;
            long l3 = 3L + 2L * (long)n6;
            long l4 = n6;
            int n9 = n6 > 0 && l + 3L * l2 <= l3 + 3L * l4 ? 170 : 171;
            int n10 = this.code.curCP();
            this.code.emitop0(n9);
            this.code.align(4);
            int n11 = this.code.curCP();
            int[] nArray2 = null;
            this.code.emit4(-1);
            if (n9 == 170) {
                this.code.emit4(n4);
                this.code.emit4(n5);
                for (long i = (long)n4; i <= (long)n5; ++i) {
                    this.code.emit4(-1);
                }
            } else {
                this.code.emit4(n6);
                for (int i = 0; i < n6; ++i) {
                    this.code.emit4(-1);
                    this.code.emit4(-1);
                }
                nArray2 = new int[nArray.length];
            }
            Code.State state = this.code.state.dup();
            this.code.markDead();
            list2 = list;
            for (int i = 0; i < nArray.length; ++i) {
                JCTree.JCCase jCCase = (JCTree.JCCase)list2.head;
                list2 = list2.tail;
                n3 = this.code.entryPoint(state);
                if (i != n7) {
                    if (n9 == 170) {
                        this.code.put4(n11 + 4 * (nArray[i] - n4 + 3), n3 - n10);
                    } else {
                        nArray2[i] = n3 - n10;
                    }
                } else {
                    this.code.put4(n11, n3 - n10);
                }
                this.genStats(jCCase.stats, env, 16);
            }
            Code.Chain chain = ((GenContext)env.info).exit;
            if (chain != null) {
                this.code.resolve(chain);
                chain.state.defined.excludeFrom(n);
            }
            if (this.code.get4(n11) == -1) {
                this.code.put4(n11, this.code.entryPoint(state) - n10);
            }
            if (n9 == 170) {
                int n12 = this.code.get4(n11);
                for (long i = (long)n4; i <= (long)n5; ++i) {
                    int n13 = (int)((long)n11 + 4L * (i - (long)n4 + 3L));
                    if (this.code.get4(n13) != -1) continue;
                    this.code.put4(n13, n12);
                }
            } else {
                if (n7 >= 0) {
                    for (int i = n7; i < nArray.length - 1; ++i) {
                        nArray[i] = nArray[i + 1];
                        nArray2[i] = nArray2[i + 1];
                    }
                }
                if (n6 > 0) {
                    Gen.qsort2(nArray, nArray2, 0, n6 - 1);
                }
                for (int i = 0; i < n6; ++i) {
                    n3 = n11 + 8 * (i + 1);
                    this.code.put4(n3, nArray[i]);
                    this.code.put4(n3 + 4, nArray2[i]);
                }
            }
        }
        this.code.endScopes(n);
    }

    static void qsort2(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = nArray[(n3 + n4) / 2];
        while (true) {
            if (nArray[n3] < n5) {
                ++n3;
                continue;
            }
            while (n5 < nArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                int n7 = nArray2[n3];
                nArray2[n3] = nArray2[n4];
                nArray2[n4] = n7;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            Gen.qsort2(nArray, nArray2, n, n4);
        }
        if (n3 < n2) {
            Gen.qsort2(nArray, nArray2, n3, n2);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        int n = this.code.nextreg;
        final Items.LocalItem localItem = this.makeTemp(this.syms.objectType);
        Assert.check(this.code.state.stacksize == 0);
        this.genExpr(jCSynchronized.lock, jCSynchronized.lock.type).load().duplicate();
        localItem.store();
        this.code.emitop0(194);
        this.code.state.lock(localItem.reg);
        final Env<GenContext> env = this.env.dup(jCSynchronized, new GenContext());
        ((GenContext)env.info).finalize = new GenFinalizer(){

            @Override
            void gen() {
                this.genLast();
                Assert.check(((GenContext)env.info).gaps.length() % 2 == 0);
                ((GenContext)env.info).gaps.append(Gen.this.code.curCP());
            }

            @Override
            void genLast() {
                if (Gen.this.code.isAlive()) {
                    localItem.load();
                    Gen.this.code.emitop0(195);
                    ((Gen)Gen.this).code.state.unlock(localItem.reg);
                }
            }
        };
        ((GenContext)env.info).gaps = new ListBuffer();
        this.genTry(jCSynchronized.body, List.nil(), env);
        this.code.endScopes(n);
    }

    @Override
    public void visitTry(final JCTree.JCTry jCTry) {
        final Env<GenContext> env = this.env.dup(jCTry, new GenContext());
        final Env<GenContext> env2 = this.env;
        ((GenContext)env.info).finalize = new GenFinalizer(){

            @Override
            void gen() {
                Assert.check(((GenContext)env.info).gaps.length() % 2 == 0);
                ((GenContext)env.info).gaps.append(Gen.this.code.curCP());
                this.genLast();
            }

            @Override
            void genLast() {
                if (jCTry.finalizer != null) {
                    Gen.this.genStat(jCTry.finalizer, env2, 2);
                }
            }

            @Override
            boolean hasFinalizer() {
                return jCTry.finalizer != null;
            }
        };
        ((GenContext)env.info).gaps = new ListBuffer();
        this.genTry(jCTry.body, jCTry.catchers, env);
    }

    void genTry(JCTree jCTree, List<JCTree.JCCatch> list, Env<GenContext> env) {
        int n = this.code.nextreg;
        int n2 = this.code.curCP();
        Code.State state = this.code.state.dup();
        this.genStat(jCTree, env, 2);
        int n3 = this.code.curCP();
        boolean bl = ((GenContext)env.info).finalize != null && ((GenContext)env.info).finalize.hasFinalizer();
        List<Integer> list2 = ((GenContext)env.info).gaps.toList();
        this.code.statBegin(TreeInfo.endPos(jCTree));
        this.genFinalizer(env);
        this.code.statBegin(TreeInfo.endPos(env.tree));
        Code.Chain chain = this.code.branch(167);
        this.endFinalizerGap(env);
        if (n2 != n3) {
            List<JCTree.JCCatch> list3 = list;
            while (list3.nonEmpty()) {
                this.code.entryPoint(state, ((JCTree.JCCatch)list3.head).param.sym.type);
                this.genCatch((JCTree.JCCatch)list3.head, env, n2, n3, list2);
                this.genFinalizer(env);
                if (bl || list3.tail.nonEmpty()) {
                    this.code.statBegin(TreeInfo.endPos(env.tree));
                    chain = Code.mergeChains(chain, this.code.branch(167));
                }
                this.endFinalizerGap(env);
                list3 = list3.tail;
            }
        }
        if (bl) {
            this.code.newRegSegment();
            int n4 = this.code.entryPoint(state, this.syms.throwableType);
            int n5 = n2;
            while (((GenContext)env.info).gaps.nonEmpty()) {
                int n6 = ((GenContext)env.info).gaps.next();
                this.registerCatch(jCTree.pos(), n5, n6, n4, 0);
                n5 = ((GenContext)env.info).gaps.next();
            }
            this.code.statBegin(TreeInfo.finalizerPos(env.tree));
            this.code.markStatBegin();
            Items.LocalItem localItem = this.makeTemp(this.syms.throwableType);
            ((Items.Item)localItem).store();
            this.genFinalizer(env);
            ((Items.Item)localItem).load();
            this.registerCatch(jCTree.pos(), n5, ((GenContext)env.info).gaps.next(), n4, 0);
            this.code.emitop0(191);
            this.code.markDead();
            if (((GenContext)env.info).cont != null) {
                this.code.resolve(((GenContext)env.info).cont);
                this.code.statBegin(TreeInfo.finalizerPos(env.tree));
                this.code.markStatBegin();
                Items.LocalItem localItem2 = this.makeTemp(this.syms.throwableType);
                localItem2.store();
                ((GenContext)env.info).finalize.genLast();
                this.code.emitop1w(169, localItem2.reg);
                this.code.markDead();
            }
        }
        this.code.resolve(chain);
        this.code.endScopes(n);
    }

    void genCatch(JCTree.JCCatch jCCatch, Env<GenContext> env, int n, int n2, List<Integer> list) {
        if (n != n2) {
            int n3;
            JCTree.JCExpression jCExpression;
            List<Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>> list2 = this.catchTypesWithAnnotations(jCCatch);
            while (list.nonEmpty()) {
                for (Pair<List<Attribute.TypeCompound>, JCTree.JCExpression> pair : list2) {
                    jCExpression = (JCTree.JCExpression)pair.snd;
                    n3 = this.makeRef(jCCatch.pos(), jCExpression.type);
                    int n4 = (Integer)list.head;
                    this.registerCatch(jCCatch.pos(), n, n4, this.code.curCP(), n3);
                    for (Attribute.TypeCompound typeCompound : (List)pair.fst) {
                        typeCompound.position.setCatchInfo(n3, n);
                    }
                }
                list = list.tail;
                n = (Integer)list.head;
                list = list.tail;
            }
            if (n < n2) {
                for (Pair pair : list2) {
                    jCExpression = (JCTree.JCExpression)pair.snd;
                    n3 = this.makeRef(jCCatch.pos(), jCExpression.type);
                    this.registerCatch(jCCatch.pos(), n, n2, this.code.curCP(), n3);
                    for (Object object : (List)pair.fst) {
                        ((Attribute.TypeCompound)object).position.setCatchInfo(n3, n);
                    }
                }
            }
            Symbol.VarSymbol varSymbol = jCCatch.param.sym;
            this.code.statBegin(jCCatch.pos);
            this.code.markStatBegin();
            int n5 = this.code.nextreg;
            this.code.newLocal(varSymbol);
            this.items.makeLocalItem(varSymbol).store();
            this.code.statBegin(TreeInfo.firstStatPos(jCCatch.body));
            this.genStat(jCCatch.body, env, 2);
            this.code.endScopes(n5);
            this.code.statBegin(TreeInfo.endPos(jCCatch.body));
        }
    }

    List<Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>> catchTypesWithAnnotations(JCTree.JCCatch jCCatch) {
        return TreeInfo.isMultiCatch(jCCatch) ? this.catchTypesWithAnnotationsFromMulticatch((JCTree.JCTypeUnion)jCCatch.param.vartype, jCCatch.param.sym.getRawTypeAttributes()) : List.of(new Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>(jCCatch.param.sym.getRawTypeAttributes(), jCCatch.param.vartype));
    }

    List<Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>> catchTypesWithAnnotationsFromMulticatch(JCTree.JCTypeUnion jCTypeUnion, List<Attribute.TypeCompound> list) {
        List<JCTree.JCExpression> list2 = jCTypeUnion.alternatives;
        List<Pair<List<Attribute.TypeCompound>, Object>> list3 = List.of(new Pair(list, list2.head));
        list2 = list2.tail;
        while (list2 != null && list2.head != null) {
            JCTree.JCExpression jCExpression = (JCTree.JCExpression)list2.head;
            if (jCExpression instanceof JCTree.JCAnnotatedType) {
                JCTree.JCAnnotatedType jCAnnotatedType = (JCTree.JCAnnotatedType)jCExpression;
                list3 = list3.prepend(new Pair<List<Attribute.TypeCompound>, JCTree.JCExpression>(this.annotate.fromAnnotations(jCAnnotatedType.annotations), jCExpression));
            } else {
                list3 = list3.prepend(new Pair(List.nil(), jCExpression));
            }
            list2 = list2.tail;
        }
        return list3.reverse();
    }

    void registerCatch(JCDiagnostic.DiagnosticPosition diagnosticPosition, int n, int n2, int n3, int n4) {
        char c = (char)n;
        char c2 = (char)n2;
        char c3 = (char)n3;
        if (c == n && c2 == n2 && c3 == n3) {
            this.code.addCatch(c, c2, c3, (char)n4);
        } else {
            this.log.error(diagnosticPosition, "limit.code.too.large.for.try.stmt", new Object[0]);
            ++this.nerrs;
        }
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        int n = this.code.nextreg;
        Code.Chain chain = null;
        Assert.check(this.code.state.stacksize == 0);
        Items.CondItem condItem = this.genCond((JCTree)TreeInfo.skipParens(jCIf.cond), 8);
        Code.Chain chain2 = condItem.jumpFalse();
        Assert.check(this.code.state.stacksize == 0);
        if (!condItem.isFalse()) {
            this.code.resolve(condItem.trueJumps);
            this.genStat(jCIf.thenpart, this.env, 17);
            chain = this.code.branch(167);
        }
        if (chain2 != null) {
            this.code.resolve(chain2);
            if (jCIf.elsepart != null) {
                this.genStat(jCIf.elsepart, this.env, 17);
            }
        }
        this.code.resolve(chain);
        this.code.endScopes(n);
        Assert.check(this.code.state.stacksize == 0);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        JCTree.JCExpression jCExpression = jCExpressionStatement.expr;
        switch (jCExpression.getTag()) {
            case POSTINC: {
                ((JCTree.JCUnary)jCExpression).setTag(JCTree.Tag.PREINC);
                break;
            }
            case POSTDEC: {
                ((JCTree.JCUnary)jCExpression).setTag(JCTree.Tag.PREDEC);
            }
        }
        Assert.check(this.code.state.stacksize == 0);
        this.genExpr(jCExpressionStatement.expr, jCExpressionStatement.expr.type).drop();
        Assert.check(this.code.state.stacksize == 0);
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
        Env<GenContext> env = this.unwind(jCBreak.target, this.env);
        Assert.check(this.code.state.stacksize == 0);
        ((GenContext)env.info).addExit(this.code.branch(167));
        this.endFinalizerGaps(this.env, env);
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
        Env<GenContext> env = this.unwind(jCContinue.target, this.env);
        Assert.check(this.code.state.stacksize == 0);
        ((GenContext)env.info).addCont(this.code.branch(167));
        this.endFinalizerGaps(this.env, env);
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        Env<GenContext> env;
        int n = this.code.nextreg;
        int n2 = this.code.pendingStatPos;
        if (jCReturn.expr != null) {
            Assert.check(this.code.state.stacksize == 0);
            Items.Item item = this.genExpr(jCReturn.expr, this.pt).load();
            if (this.hasFinally(this.env.enclMethod, this.env)) {
                item = this.makeTemp(this.pt);
                item.store();
            }
            env = this.unwind(this.env.enclMethod, this.env);
            this.code.pendingStatPos = n2;
            item.load();
            this.code.emitop0(172 + Code.truncate(Code.typecode(this.pt)));
        } else {
            env = this.unwind(this.env.enclMethod, this.env);
            this.code.pendingStatPos = n2;
            this.code.emitop0(177);
        }
        this.endFinalizerGaps(this.env, env);
        this.code.endScopes(n);
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        Assert.check(this.code.state.stacksize == 0);
        this.genExpr(jCThrow.expr, jCThrow.expr.type).load();
        this.code.emitop0(191);
        Assert.check(this.code.state.stacksize == 0);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        this.setTypeAnnotationPositions(jCMethodInvocation.pos);
        Items.Item item = this.genExpr(jCMethodInvocation.meth, this.methodType);
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)TreeInfo.symbol(jCMethodInvocation.meth);
        this.genArgs(jCMethodInvocation.args, methodSymbol.externalType(this.types).getParameterTypes());
        if (!methodSymbol.isDynamic()) {
            this.code.statBegin(jCMethodInvocation.pos);
        }
        this.result = item.invoke();
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        int n;
        Code.Chain chain = null;
        this.code.statBegin(jCConditional.cond.pos);
        Items.CondItem condItem = this.genCond((JCTree)jCConditional.cond, 8);
        Code.Chain chain2 = condItem.jumpFalse();
        if (!condItem.isFalse()) {
            this.code.resolve(condItem.trueJumps);
            n = this.genCrt ? this.code.curCP() : 0;
            this.code.statBegin(jCConditional.truepart.pos);
            this.genExpr(jCConditional.truepart, this.pt).load();
            this.code.state.forceStackTop(jCConditional.type);
            if (this.genCrt) {
                this.code.crt.put(jCConditional.truepart, 16, n, this.code.curCP());
            }
            chain = this.code.branch(167);
        }
        if (chain2 != null) {
            this.code.resolve(chain2);
            n = this.genCrt ? this.code.curCP() : 0;
            this.code.statBegin(jCConditional.falsepart.pos);
            this.genExpr(jCConditional.falsepart, this.pt).load();
            this.code.state.forceStackTop(jCConditional.type);
            if (this.genCrt) {
                this.code.crt.put(jCConditional.falsepart, 16, n, this.code.curCP());
            }
        }
        this.code.resolve(chain);
        this.result = this.items.makeStackItem(this.pt);
    }

    private void setTypeAnnotationPositions(int n) {
        Symbol.MethodSymbol methodSymbol = this.code.meth;
        boolean bl = this.code.meth.getKind() == ElementKind.CONSTRUCTOR || this.code.meth.getKind() == ElementKind.STATIC_INIT;
        for (Attribute.TypeCompound object : methodSymbol.getRawTypeAttributes()) {
            if (object.hasUnknownPosition()) {
                object.tryFixPosition();
            }
            if (!object.position.matchesPos(n)) continue;
            object.position.updatePosOffset(this.code.cp);
        }
        if (!bl) {
            return;
        }
        for (Attribute.TypeCompound typeCompound : methodSymbol.owner.getRawTypeAttributes()) {
            if (typeCompound.hasUnknownPosition()) {
                typeCompound.tryFixPosition();
            }
            if (!typeCompound.position.matchesPos(n)) continue;
            typeCompound.position.updatePosOffset(this.code.cp);
        }
        Symbol.ClassSymbol classSymbol = methodSymbol.enclClass();
        for (Symbol symbol : new FilteredMemberList(classSymbol.members())) {
            if (!symbol.getKind().isField()) continue;
            for (Attribute.TypeCompound typeCompound : symbol.getRawTypeAttributes()) {
                if (typeCompound.hasUnknownPosition()) {
                    typeCompound.tryFixPosition();
                }
                if (!typeCompound.position.matchesPos(n)) continue;
                typeCompound.position.updatePosOffset(this.code.cp);
            }
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        Assert.check(jCNewClass.encl == null && jCNewClass.def == null);
        this.setTypeAnnotationPositions(jCNewClass.pos);
        this.code.emitop2(187, this.makeRef(jCNewClass.pos(), jCNewClass.type));
        this.code.emitop0(89);
        this.genArgs(jCNewClass.args, jCNewClass.constructor.externalType(this.types).getParameterTypes());
        this.items.makeMemberItem(jCNewClass.constructor, true).invoke();
        this.result = this.items.makeStackItem(jCNewClass.type);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        this.setTypeAnnotationPositions(jCNewArray.pos);
        if (jCNewArray.elems != null) {
            Type type = this.types.elemtype(jCNewArray.type);
            this.loadIntConst(jCNewArray.elems.length());
            Items.Item item = this.makeNewArray(jCNewArray.pos(), jCNewArray.type, 1);
            int n = 0;
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                item.duplicate();
                this.loadIntConst(n);
                ++n;
                this.genExpr((JCTree)list.head, type).load();
                this.items.makeIndexedItem(type).store();
                list = list.tail;
            }
            this.result = item;
        } else {
            List<JCTree.JCExpression> list = jCNewArray.dims;
            while (list.nonEmpty()) {
                this.genExpr((JCTree)list.head, this.syms.intType).load();
                list = list.tail;
            }
            this.result = this.makeNewArray(jCNewArray.pos(), jCNewArray.type, jCNewArray.dims.length());
        }
    }

    Items.Item makeNewArray(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, int n) {
        int n2;
        Type type2 = this.types.elemtype(type);
        if (this.types.dimensions(type) > 255) {
            this.log.error(diagnosticPosition, "limit.dimensions", new Object[0]);
            ++this.nerrs;
        }
        if ((n2 = Code.arraycode(type2)) == 0 || n2 == 1 && n == 1) {
            this.code.emitAnewarray(this.makeRef(diagnosticPosition, type2), type);
        } else if (n2 == 1) {
            this.code.emitMultianewarray(n, this.makeRef(diagnosticPosition, type), type);
        } else {
            this.code.emitNewarray(n2, type);
        }
        return this.items.makeStackItem(type);
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        this.result = this.genExpr(jCParens.expr, jCParens.expr.type);
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        Items.Item item = this.genExpr(jCAssign.lhs, jCAssign.lhs.type);
        this.genExpr(jCAssign.rhs, jCAssign.lhs.type).load();
        if (jCAssign.rhs.type.hasTag(TypeTag.BOT)) {
            this.code.state.forceStackTop(jCAssign.lhs.type);
        }
        this.result = this.items.makeAssignItem(item);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        Items.Item item;
        Symbol.OperatorSymbol operatorSymbol = jCAssignOp.operator;
        if (operatorSymbol.opcode == 256) {
            item = this.concat.makeConcat(jCAssignOp);
        } else {
            item = this.genExpr(jCAssignOp.lhs, jCAssignOp.lhs.type);
            if ((jCAssignOp.hasTag(JCTree.Tag.PLUS_ASG) || jCAssignOp.hasTag(JCTree.Tag.MINUS_ASG)) && item instanceof Items.LocalItem && jCAssignOp.lhs.type.getTag().isSubRangeOf(TypeTag.INT) && jCAssignOp.rhs.type.getTag().isSubRangeOf(TypeTag.INT) && jCAssignOp.rhs.type.constValue() != null) {
                int n = ((Number)jCAssignOp.rhs.type.constValue()).intValue();
                if (jCAssignOp.hasTag(JCTree.Tag.MINUS_ASG)) {
                    n = -n;
                }
                ((Items.LocalItem)item).incr(n);
                this.result = item;
                return;
            }
            item.duplicate();
            item.coerce((Type)operatorSymbol.type.getParameterTypes().head).load();
            this.completeBinop(jCAssignOp.lhs, jCAssignOp.rhs, operatorSymbol).coerce(jCAssignOp.lhs.type);
        }
        this.result = this.items.makeAssignItem(item);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        Symbol.OperatorSymbol operatorSymbol = jCUnary.operator;
        if (jCUnary.hasTag(JCTree.Tag.NOT)) {
            Items.CondItem condItem = this.genCond((JCTree)jCUnary.arg, false);
            this.result = condItem.negate();
        } else {
            Items.Item item = this.genExpr(jCUnary.arg, (Type)operatorSymbol.type.getParameterTypes().head);
            switch (jCUnary.getTag()) {
                case POS: {
                    this.result = item.load();
                    break;
                }
                case NEG: {
                    this.result = item.load();
                    this.code.emitop0(operatorSymbol.opcode);
                    break;
                }
                case COMPL: {
                    this.result = item.load();
                    this.emitMinusOne(item.typecode);
                    this.code.emitop0(operatorSymbol.opcode);
                    break;
                }
                case PREINC: 
                case PREDEC: {
                    item.duplicate();
                    if (item instanceof Items.LocalItem && (operatorSymbol.opcode == 96 || operatorSymbol.opcode == 100)) {
                        ((Items.LocalItem)item).incr(jCUnary.hasTag(JCTree.Tag.PREINC) ? 1 : -1);
                        this.result = item;
                        break;
                    }
                    item.load();
                    this.code.emitop0(Gen.one(item.typecode));
                    this.code.emitop0(operatorSymbol.opcode);
                    if (item.typecode != 0 && Code.truncate(item.typecode) == 0) {
                        this.code.emitop0(145 + item.typecode - 5);
                    }
                    this.result = this.items.makeAssignItem(item);
                    break;
                }
                case POSTINC: 
                case POSTDEC: {
                    item.duplicate();
                    if (item instanceof Items.LocalItem && (operatorSymbol.opcode == 96 || operatorSymbol.opcode == 100)) {
                        Items.Item item2 = item.load();
                        ((Items.LocalItem)item).incr(jCUnary.hasTag(JCTree.Tag.POSTINC) ? 1 : -1);
                        this.result = item2;
                        break;
                    }
                    Items.Item item3 = item.load();
                    item.stash(item.typecode);
                    this.code.emitop0(Gen.one(item.typecode));
                    this.code.emitop0(operatorSymbol.opcode);
                    if (item.typecode != 0 && Code.truncate(item.typecode) == 0) {
                        this.code.emitop0(145 + item.typecode - 5);
                    }
                    item.store();
                    this.result = item3;
                    break;
                }
                case NULLCHK: {
                    this.result = item.load();
                    this.code.emitop0(89);
                    this.genNullCheck(jCUnary.pos());
                    break;
                }
                default: {
                    Assert.error();
                }
            }
        }
    }

    private void genNullCheck(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (this.allowBetterNullChecks) {
            this.callMethod(diagnosticPosition, this.syms.objectsType, this.names.requireNonNull, List.of(this.syms.objectType), true);
        } else {
            this.callMethod(diagnosticPosition, this.syms.objectType, this.names.getClass, List.nil(), false);
        }
        this.code.emitop0(87);
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        Symbol.OperatorSymbol operatorSymbol = jCBinary.operator;
        if (operatorSymbol.opcode == 256) {
            this.result = this.concat.makeConcat(jCBinary);
        } else if (jCBinary.hasTag(JCTree.Tag.AND)) {
            Items.CondItem condItem = this.genCond((JCTree)jCBinary.lhs, 8);
            if (!condItem.isFalse()) {
                Code.Chain chain = condItem.jumpFalse();
                this.code.resolve(condItem.trueJumps);
                Items.CondItem condItem2 = this.genCond((JCTree)jCBinary.rhs, 16);
                this.result = this.items.makeCondItem(condItem2.opcode, condItem2.trueJumps, Code.mergeChains(chain, condItem2.falseJumps));
            } else {
                this.result = condItem;
            }
        } else if (jCBinary.hasTag(JCTree.Tag.OR)) {
            Items.CondItem condItem = this.genCond((JCTree)jCBinary.lhs, 8);
            if (!condItem.isTrue()) {
                Code.Chain chain = condItem.jumpTrue();
                this.code.resolve(condItem.falseJumps);
                Items.CondItem condItem3 = this.genCond((JCTree)jCBinary.rhs, 16);
                this.result = this.items.makeCondItem(condItem3.opcode, Code.mergeChains(chain, condItem3.trueJumps), condItem3.falseJumps);
            } else {
                this.result = condItem;
            }
        } else {
            Items.Item item = this.genExpr(jCBinary.lhs, (Type)operatorSymbol.type.getParameterTypes().head);
            item.load();
            this.result = this.completeBinop(jCBinary.lhs, jCBinary.rhs, operatorSymbol);
        }
    }

    Items.Item completeBinop(JCTree jCTree, JCTree jCTree2, Symbol.OperatorSymbol operatorSymbol) {
        Type.MethodType methodType = (Type.MethodType)operatorSymbol.type;
        int n = operatorSymbol.opcode;
        if (n >= 159 && n <= 164 && jCTree2.type.constValue() instanceof Number && ((Number)jCTree2.type.constValue()).intValue() == 0) {
            n += -6;
        } else if (n >= 165 && n <= 166 && TreeInfo.isNull(jCTree2)) {
            n += 33;
        } else {
            Type type = (Type)operatorSymbol.erasure((Types)this.types).getParameterTypes().tail.head;
            if (n >= 270 && n <= 275) {
                n += -150;
                type = this.syms.intType;
            }
            this.genExpr(jCTree2, type).load();
            if (n >= 512) {
                this.code.emitop0(n >> 9);
                n &= 0xFF;
            }
        }
        if (n >= 153 && n <= 166 || n == 198 || n == 199) {
            return this.items.makeCondItem(n);
        }
        this.code.emitop0(n);
        return this.items.makeStackItem(methodType.restype);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.result = this.genExpr(jCTypeCast.expr, jCTypeCast.clazz.type).load();
        this.setTypeAnnotationPositions(jCTypeCast.pos);
        if (!jCTypeCast.clazz.type.isPrimitive() && !this.types.isSameType(jCTypeCast.expr.type, jCTypeCast.clazz.type) && this.types.asSuper(jCTypeCast.expr.type, jCTypeCast.clazz.type.tsym) == null) {
            this.code.emitop2(192, this.makeRef(jCTypeCast.pos(), jCTypeCast.clazz.type));
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        throw new AssertionError((Object)this.getClass().getName());
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.genExpr(jCInstanceOf.expr, jCInstanceOf.expr.type).load();
        this.setTypeAnnotationPositions(jCInstanceOf.pos);
        this.code.emitop2(193, this.makeRef(jCInstanceOf.pos(), jCInstanceOf.clazz.type));
        this.result = this.items.makeStackItem(this.syms.booleanType);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.genExpr(jCArrayAccess.indexed, jCArrayAccess.indexed.type).load();
        this.genExpr(jCArrayAccess.index, this.syms.intType).load();
        this.result = this.items.makeIndexedItem(jCArrayAccess.type);
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        Symbol symbol = jCIdent.sym;
        if (jCIdent.name == this.names._this || jCIdent.name == this.names._super) {
            Items.Item item;
            Items.Item item2 = item = jCIdent.name == this.names._this ? this.items.makeThisItem() : this.items.makeSuperItem();
            if (symbol.kind == Kinds.Kind.MTH) {
                item.load();
                item = this.items.makeMemberItem(symbol, true);
            }
            this.result = item;
        } else if (symbol.kind == Kinds.Kind.VAR && symbol.owner.kind == Kinds.Kind.MTH) {
            this.result = this.items.makeLocalItem((Symbol.VarSymbol)symbol);
        } else if (this.isInvokeDynamic(symbol)) {
            this.result = this.items.makeDynamicItem(symbol);
        } else if ((symbol.flags() & 8L) != 0L) {
            if (!this.isAccessSuper(this.env.enclMethod)) {
                symbol = this.binaryQualifier(symbol, this.env.enclClass.type);
            }
            this.result = this.items.makeStaticItem(symbol);
        } else {
            this.items.makeThisItem().load();
            symbol = this.binaryQualifier(symbol, this.env.enclClass.type);
            this.result = this.items.makeMemberItem(symbol, (symbol.flags() & 2L) != 0L);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        Items.Item item;
        Symbol symbol = jCFieldAccess.sym;
        if (jCFieldAccess.name == this.names._class) {
            this.code.emitLdc(this.makeRef(jCFieldAccess.pos(), jCFieldAccess.selected.type));
            this.result = this.items.makeStackItem(this.pt);
            return;
        }
        Symbol symbol2 = TreeInfo.symbol(jCFieldAccess.selected);
        boolean bl = symbol2 != null && (symbol2.kind == Kinds.Kind.TYP || symbol2.name == this.names._super);
        boolean bl2 = this.isAccessSuper(this.env.enclMethod);
        Items.Item item2 = item = bl ? this.items.makeSuperItem() : this.genExpr(jCFieldAccess.selected, jCFieldAccess.selected.type);
        if (symbol.kind == Kinds.Kind.VAR && ((Symbol.VarSymbol)symbol).getConstValue() != null) {
            if ((symbol.flags() & 8L) != 0L) {
                if (!(bl || symbol2 != null && symbol2.kind == Kinds.Kind.TYP)) {
                    item = item.load();
                }
                item.drop();
            } else {
                item.load();
                this.genNullCheck(jCFieldAccess.selected.pos());
            }
            this.result = this.items.makeImmediateItem(symbol.type, ((Symbol.VarSymbol)symbol).getConstValue());
        } else {
            if (this.isInvokeDynamic(symbol)) {
                this.result = this.items.makeDynamicItem(symbol);
                return;
            }
            if (((symbol = this.binaryQualifier(symbol, jCFieldAccess.selected.type)).flags() & 8L) != 0L) {
                if (!(bl || symbol2 != null && symbol2.kind == Kinds.Kind.TYP)) {
                    item = item.load();
                }
                item.drop();
                this.result = this.items.makeStaticItem(symbol);
            } else {
                item.load();
                if (symbol == this.syms.lengthVar) {
                    this.code.emitop0(190);
                    this.result = this.items.makeStackItem(this.syms.intType);
                } else {
                    this.result = this.items.makeMemberItem(symbol, (symbol.flags() & 2L) != 0L || bl || bl2);
                }
            }
        }
    }

    public boolean isInvokeDynamic(Symbol symbol) {
        return symbol.kind == Kinds.Kind.MTH && ((Symbol.MethodSymbol)symbol).isDynamic();
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        if (jCLiteral.type.hasTag(TypeTag.BOT)) {
            this.code.emitop0(1);
            this.result = this.items.makeStackItem(jCLiteral.type);
        } else {
            this.result = this.items.makeImmediateItem(jCLiteral.type, jCLiteral.value);
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        ++this.letExprDepth;
        int n = this.code.nextreg;
        this.genStats(letExpr.defs, this.env);
        this.result = this.genExpr(letExpr.expr, letExpr.expr.type).load();
        this.code.endScopes(n);
        --this.letExprDepth;
    }

    private void generateReferencesToPrunedTree(Symbol.ClassSymbol classSymbol, Pool pool) {
        List<JCTree> list = this.lower.prunedTree.get(classSymbol);
        if (list != null) {
            for (JCTree jCTree : list) {
                jCTree.accept(this.classReferenceVisitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean genClass(Env<AttrContext> env, JCTree.JCClassDecl jCClassDecl) {
        try {
            this.attrEnv = env;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            this.toplevel = env.toplevel;
            this.endPosTable = this.toplevel.endPositions;
            classSymbol.pool = this.pool;
            this.pool.reset();
            jCClassDecl.defs = this.normalizeDefs(jCClassDecl.defs, classSymbol);
            this.generateReferencesToPrunedTree(classSymbol, this.pool);
            Env<GenContext> env2 = new Env<GenContext>(jCClassDecl, new GenContext());
            env2.toplevel = env.toplevel;
            env2.enclClass = jCClassDecl;
            List<JCTree> list = jCClassDecl.defs;
            while (list.nonEmpty()) {
                this.genDef((JCTree)list.head, env2);
                list = list.tail;
            }
            if (this.pool.numEntries() > 65535) {
                this.log.error(jCClassDecl.pos(), "limit.pool", new Object[0]);
                ++this.nerrs;
            }
            if (this.nerrs != 0) {
                list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF)) {
                        ((JCTree.JCMethodDecl)list.head).sym.code = null;
                    }
                    list = list.tail;
                }
            }
            jCClassDecl.defs = List.nil();
            boolean bl = this.nerrs == 0;
            return bl;
        }
        finally {
            this.attrEnv = null;
            this.env = null;
            this.toplevel = null;
            this.endPosTable = null;
            this.nerrs = 0;
        }
    }

    static class GenContext {
        Code.Chain exit = null;
        Code.Chain cont = null;
        GenFinalizer finalize = null;
        boolean isSwitch = false;
        ListBuffer<Integer> gaps = null;

        GenContext() {
        }

        void addExit(Code.Chain chain) {
            this.exit = Code.mergeChains(chain, this.exit);
        }

        void addCont(Code.Chain chain) {
            this.cont = Code.mergeChains(chain, this.cont);
        }
    }

    abstract class GenFinalizer {
        GenFinalizer() {
        }

        abstract void gen();

        abstract void genLast();

        boolean hasFinalizer() {
            return true;
        }
    }

    public static class CodeSizeOverflow
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
    }

    class ClassReferenceVisitor
    extends JCTree.Visitor {
        ClassReferenceVisitor() {
        }

        @Override
        public void visitTree(JCTree jCTree) {
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            jCBinary.lhs.accept(this);
            jCBinary.rhs.accept(this);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.selected.type.hasTag(TypeTag.CLASS)) {
                Gen.this.makeRef(jCFieldAccess.selected.pos(), jCFieldAccess.selected.type);
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.owner instanceof Symbol.ClassSymbol) {
                Gen.this.pool.put(jCIdent.sym.owner);
            }
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            jCConditional.cond.accept(this);
            jCConditional.truepart.accept(this);
            jCConditional.falsepart.accept(this);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            jCUnary.arg.accept(this);
        }

        @Override
        public void visitParens(JCTree.JCParens jCParens) {
            jCParens.expr.accept(this);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
            jCTypeCast.expr.accept(this);
        }
    }
}

