/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConsumer;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.util.JMSExceptionSupport;

public class ActiveMQContext
implements JMSContext {
    private static final boolean DEFAULT_AUTO_START = true;
    private final ActiveMQConnection activemqConnection;
    private final AtomicLong connectionCounter;
    protected ActiveMQSession activemqSession = null;
    private boolean autoStart = true;
    private final int sessionMode;
    private boolean closeInvoked = false;
    private final AtomicBoolean startInvoked = new AtomicBoolean(false);
    private ActiveMQMessageProducer activemqMessageProducer = null;

    ActiveMQContext(ActiveMQConnection activemqConnection) {
        this.activemqConnection = activemqConnection;
        this.sessionMode = 1;
        this.connectionCounter = new AtomicLong(1L);
    }

    ActiveMQContext(ActiveMQConnection activemqConnection, int sessionMode) {
        this.activemqConnection = activemqConnection;
        this.sessionMode = sessionMode;
        this.connectionCounter = new AtomicLong(1L);
    }

    private ActiveMQContext(ActiveMQConnection activemqConnection, int sessionMode, AtomicLong connectionCounter) {
        this.activemqConnection = activemqConnection;
        this.sessionMode = sessionMode;
        this.connectionCounter = connectionCounter;
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        if (this.connectionCounter.get() == 0L) {
            throw new JMSRuntimeException("Context already closed");
        }
        this.connectionCounter.incrementAndGet();
        return new ActiveMQContext(this.activemqConnection, sessionMode, this.connectionCounter);
    }

    @Override
    public JMSProducer createProducer() {
        return new ActiveMQProducer(this, this.getCreatedActiveMQMessageProducer());
    }

    @Override
    public String getClientID() {
        try {
            return this.activemqConnection.getClientID();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void setClientID(String clientID) {
        try {
            this.activemqConnection.setClientID(clientID);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public ConnectionMetaData getMetaData() {
        this.checkContextState();
        try {
            return this.activemqConnection.getMetaData();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public ExceptionListener getExceptionListener() {
        this.checkContextState();
        try {
            return this.activemqConnection.getExceptionListener();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) {
        this.checkContextState();
        try {
            this.activemqConnection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void start() {
        this.checkContextState();
        try {
            if (this.startInvoked.compareAndSet(false, true)) {
                this.activemqConnection.start();
            }
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void stop() {
        this.checkContextState();
        try {
            if (this.startInvoked.compareAndSet(true, false)) {
                this.activemqConnection.stop();
            }
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public boolean getAutoStart() {
        return this.autoStart;
    }

    @Override
    public synchronized void close() {
        JMSRuntimeException firstException;
        block12: {
            block11: {
                block10: {
                    firstException = null;
                    if (this.activemqMessageProducer != null) {
                        try {
                            this.activemqMessageProducer.close();
                        }
                        catch (JMSException e) {
                            if (firstException != null) break block10;
                            firstException = JMSExceptionSupport.convertToJMSRuntimeException(e);
                        }
                    }
                }
                if (this.activemqSession != null) {
                    try {
                        this.activemqSession.close();
                    }
                    catch (JMSException e) {
                        if (firstException != null) break block11;
                        firstException = JMSExceptionSupport.convertToJMSRuntimeException(e);
                    }
                }
            }
            if (this.connectionCounter.decrementAndGet() == 0L && this.activemqConnection != null) {
                try {
                    this.closeInvoked = true;
                    this.activemqConnection.close();
                }
                catch (JMSException e) {
                    if (firstException != null) break block12;
                    firstException = JMSExceptionSupport.convertToJMSRuntimeException(e);
                }
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    public BytesMessage createBytesMessage() {
        this.checkContextState();
        try {
            return this.activemqSession.createBytesMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public MapMessage createMapMessage() {
        this.checkContextState();
        try {
            return this.activemqSession.createMapMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public Message createMessage() {
        this.checkContextState();
        try {
            return this.activemqSession.createMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public ObjectMessage createObjectMessage() {
        this.checkContextState();
        try {
            return this.activemqSession.createObjectMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) {
        this.checkContextState();
        try {
            return this.activemqSession.createObjectMessage(object);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public StreamMessage createStreamMessage() {
        this.checkContextState();
        try {
            return this.activemqSession.createStreamMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public TextMessage createTextMessage() {
        this.checkContextState();
        try {
            return this.activemqSession.createTextMessage();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public TextMessage createTextMessage(String text) {
        this.checkContextState();
        try {
            return this.activemqSession.createTextMessage(text);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public boolean getTransacted() {
        this.checkContextState();
        try {
            return this.activemqSession.getTransacted();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public int getSessionMode() {
        return this.sessionMode;
    }

    @Override
    public void commit() {
        this.checkContextState();
        try {
            this.activemqSession.commit();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void rollback() {
        this.checkContextState();
        try {
            this.activemqSession.rollback();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void recover() {
        this.checkContextState();
        try {
            this.activemqSession.recover();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination) {
        this.checkContextState();
        try {
            if (this.getAutoStart()) {
                this.start();
            }
            return new ActiveMQConsumer(this, this.activemqSession.createConsumer(destination));
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.checkContextState();
        try {
            if (this.getAutoStart()) {
                this.start();
            }
            return new ActiveMQConsumer(this, this.activemqSession.createConsumer(destination, messageSelector));
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.checkContextState();
        try {
            if (this.getAutoStart()) {
                this.start();
            }
            return new ActiveMQConsumer(this, this.activemqSession.createConsumer(destination, messageSelector, noLocal));
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public Queue createQueue(String queueName) {
        this.checkContextState();
        try {
            return this.activemqSession.createQueue(queueName);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public Topic createTopic(String topicName) {
        this.checkContextState();
        try {
            return this.activemqSession.createTopic(topicName);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.checkContextState();
        try {
            if (this.getAutoStart()) {
                this.start();
            }
            return new ActiveMQConsumer(this, this.activemqSession.createDurableConsumer(topic, name));
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.checkContextState();
        try {
            if (this.getAutoStart()) {
                this.start();
            }
            return new ActiveMQConsumer(this, this.activemqSession.createDurableConsumer(topic, name, messageSelector, noLocal));
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        throw new UnsupportedOperationException("createSharedDurableConsumer(topic, name) is not supported");
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        throw new UnsupportedOperationException("createDurableConsumer(topic, name, messageSelector) is not supported");
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        throw new UnsupportedOperationException("createSharedConsumer(topic, sharedSubscriptionName) is not supported");
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        throw new UnsupportedOperationException("createSharedConsumer(topic, sharedSubscriptionName, messageSelector) is not supported");
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) {
        this.checkContextState();
        try {
            if (this.getAutoStart()) {
                this.start();
            }
            return this.activemqSession.createBrowser(queue);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        this.checkContextState();
        try {
            if (this.getAutoStart()) {
                this.start();
            }
            return this.activemqSession.createBrowser(queue, messageSelector);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public TemporaryQueue createTemporaryQueue() {
        this.checkContextState();
        try {
            return this.activemqSession.createTemporaryQueue();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() {
        this.checkContextState();
        try {
            return this.activemqSession.createTemporaryTopic();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void unsubscribe(String name) {
        this.checkContextState();
        try {
            this.activemqSession.unsubscribe(name);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    @Override
    public void acknowledge() {
        this.checkContextState();
        try {
            this.activemqSession.acknowledge();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    protected void checkContextState() {
        if (this.activemqConnection == null) {
            throw new JMSRuntimeException("Connection not available");
        }
        if (this.activemqSession == null) {
            if (this.closeInvoked) {
                throw new IllegalStateRuntimeException("Context is closed");
            }
            try {
                Session jmsSession = this.activemqConnection.createSession(0 == this.sessionMode, this.sessionMode);
                this.activemqSession = (ActiveMQSession)ActiveMQSession.class.cast(jmsSession);
            }
            catch (JMSException e) {
                throw JMSExceptionSupport.convertToJMSRuntimeException(e);
            }
        }
    }

    private ActiveMQMessageProducer getCreatedActiveMQMessageProducer() {
        this.checkContextState();
        if (this.activemqMessageProducer == null) {
            try {
                this.activemqMessageProducer = new ActiveMQMessageProducer(this.activemqSession, this.activemqSession.getNextProducerId(), null, this.activemqConnection.getSendTimeout());
            }
            catch (JMSException e) {
                throw JMSExceptionSupport.convertToJMSRuntimeException(e);
            }
        }
        return this.activemqMessageProducer;
    }
}

