/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class OfflineCommand
extends TableOperation {
    private boolean wait;
    private Option waitOpt;

    @Override
    public String description() {
        return "starts the process of taking table offline";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (tableName.equals(MetadataTable.NAME)) {
            Shell.log.info("  You cannot take the {} offline.", (Object)MetadataTable.NAME);
        } else {
            shellState.getAccumuloClient().tableOperations().offline(tableName, this.wait);
            Shell.log.info("Offline of table {} {}", (Object)tableName, (Object)(this.wait ? " completed." : " initiated..."));
        }
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        this.wait = cl.hasOption(this.waitOpt.getLongOpt());
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        this.waitOpt = new Option("w", "wait", false, "wait for offline to finish");
        opts.addOption(this.waitOpt);
        return opts;
    }
}

