/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.kll.KllDirectCompactDoublesSketch;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllDoublesSketchIterator;
import org.apache.datasketches.kll.KllDoublesSketchSortedView;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public abstract class KllDoublesSketch
extends KllSketch
implements QuantilesDoublesAPI {
    private KllDoublesSketchSortedView kllDoublesSV = null;

    KllDoublesSketch(WritableMemory wmem, MemoryRequestServer memReqSvr) {
        super(KllSketch.SketchType.DOUBLES_SKETCH, wmem, memReqSvr);
    }

    public static KllDoublesSketch heapify(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        return KllHeapDoublesSketch.heapifyImpl(srcMem);
    }

    public static KllDoublesSketch newDirectInstance(WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        return KllDoublesSketch.newDirectInstance(200, dstMem, memReqSvr);
    }

    public static KllDoublesSketch newDirectInstance(int k, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectDoublesSketch.newDirectInstance(k, 8, dstMem, memReqSvr);
    }

    public static KllDoublesSketch newHeapInstance() {
        return KllDoublesSketch.newHeapInstance(200);
    }

    public static KllDoublesSketch newHeapInstance(int k) {
        return new KllHeapDoublesSketch(k, 8);
    }

    public static KllDoublesSketch wrap(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.DOUBLES_SKETCH);
        if (KllPreambleUtil.getMemorySerVer(srcMem) == 3) {
            return new KllDirectDoublesSketch((WritableMemory)srcMem, null, memVal);
        }
        return new KllDirectCompactDoublesSketch(srcMem, memVal);
    }

    public static KllDoublesSketch writableWrap(WritableMemory srcMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)srcMem, KllSketch.SketchType.DOUBLES_SKETCH);
        if (KllPreambleUtil.getMemorySerVer((Memory)srcMem) == 3 && !srcMem.isReadOnly()) {
            Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
            return new KllDirectDoublesSketch(srcMem, memReqSvr, memVal);
        }
        return new KllDirectCompactDoublesSketch((Memory)srcMem, memVal);
    }

    public static int getMaxSerializedSizeBytes(int k, long n, boolean updatableMemoryFormat) {
        return KllDoublesSketch.getMaxSerializedSizeBytes(k, n, KllSketch.SketchType.DOUBLES_SKETCH, updatableMemoryFormat);
    }

    @Override
    public double[] getCDF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public double getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        return this.getMaxDoubleItem();
    }

    @Override
    public double getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        return this.getMinDoubleItem();
    }

    @Override
    public QuantilesDoublesAPI.DoublesPartitionBoundaries getPartitionBoundaries(int numEquallyWeighted, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        double[] ranks = QuantilesUtil.equallyWeightedRanks(numEquallyWeighted);
        double[] boundaries = this.getQuantiles(ranks, searchCrit);
        boundaries[0] = this.getMinItem();
        boundaries[boundaries.length - 1] = this.getMaxItem();
        QuantilesDoublesAPI.DoublesPartitionBoundaries dpb = new QuantilesDoublesAPI.DoublesPartitionBoundaries();
        dpb.N = this.getN();
        dpb.ranks = ranks;
        dpb.boundaries = boundaries;
        return dpb;
    }

    @Override
    public double[] getPMF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public double getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getQuantile(rank, searchCrit);
    }

    @Override
    public double[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        int len = ranks.length;
        double[] quantiles = new double[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.kllDoublesSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public double getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(double quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        return this.kllDoublesSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(double[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.kllDoublesSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="OK in this case.")
    public DoublesSortedView getSortedView() {
        this.refreshSortedView();
        return this.kllDoublesSV;
    }

    @Override
    public QuantilesDoublesSketchIterator iterator() {
        return new KllDoublesSketchIterator(this.getDoubleItemsArray(), this.getLevelsArray(), this.getNumLevels());
    }

    @Override
    public final void reset() {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinDoubleItem(Double.NaN);
        this.setMaxDoubleItem(Double.NaN);
        this.setDoubleItemsArray(new double[k]);
    }

    @Override
    public byte[] toByteArray() {
        return KllHelper.toCompactByteArrayImpl(this);
    }

    @Override
    public void update(double item) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllDoublesHelper.updateDouble(this, item);
        this.kllDoublesSV = null;
    }

    abstract double[] getDoubleItemsArray();

    abstract double getDoubleSingleItem();

    abstract double getMaxDoubleItem();

    abstract double getMinDoubleItem();

    private final void refreshSortedView() {
        this.kllDoublesSV = this.kllDoublesSV == null ? new KllDoublesSketchSortedView(this) : this.kllDoublesSV;
    }

    abstract void setDoubleItemsArray(double[] var1);

    abstract void setDoubleItemsArrayAt(int var1, double var2);

    abstract void setMaxDoubleItem(double var1);

    abstract void setMinDoubleItem(double var1);

    void nullSortedView() {
        this.kllDoublesSV = null;
    }
}

