/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class CompletableFutureUtil {
    public static <T> CompletableFuture<T> merge(List<CompletableFuture<T>> futures, BiFunction<T, T, T> mergeFunc, Supplier<T> nothing) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(nothing.get());
        }
        while (futures.size() > 1) {
            ArrayList<CompletableFuture<T>> mergedFutures = new ArrayList<CompletableFuture<T>>(futures.size() / 2);
            for (int i = 0; i < futures.size(); i += 2) {
                if (i + 1 == futures.size()) {
                    mergedFutures.add(futures.get(i));
                    continue;
                }
                mergedFutures.add((CompletableFuture<T>)futures.get(i).thenCombine(futures.get(i + 1), mergeFunc));
            }
            futures = mergedFutures;
        }
        return futures.get(0);
    }

    public static <T> CompletableFuture<T> iterateUntil(final Function<T, CompletableFuture<T>> step, final Predicate<T> isDone, T init) {
        Function go = new Function<T, CompletableFuture<T>>(){

            @Override
            public CompletableFuture<T> apply(T x) {
                if (isDone.test(x)) {
                    return CompletableFuture.completedFuture(x);
                }
                return ((CompletableFuture)step.apply(x)).thenCompose((Function)this);
            }
        };
        return CompletableFuture.completedFuture(init).thenCompose(go);
    }
}

