/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.iteratorsImpl.conf.ColumnSet;
import org.apache.accumulo.core.iteratorsImpl.conf.ColumnUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;

public class ColumnToClassMapping<K> {
    private final HashMap<ColumnUtil.ColFamHashKey, K> objectsCF;
    private final HashMap<ColumnUtil.ColHashKey, K> objectsCol;
    private final ColumnUtil.ColHashKey lookupCol = new ColumnUtil.ColHashKey();
    private final ColumnUtil.ColFamHashKey lookupCF = new ColumnUtil.ColFamHashKey();

    public ColumnToClassMapping() {
        this.objectsCF = new HashMap();
        this.objectsCol = new HashMap();
    }

    public ColumnToClassMapping(Map<String, String> objectStrings, Class<? extends K> c) throws ReflectiveOperationException {
        this(objectStrings, c, null);
    }

    public ColumnToClassMapping(Map<String, String> objectStrings, Class<? extends K> c, String context) throws ReflectiveOperationException {
        this();
        for (Map.Entry<String, String> entry : objectStrings.entrySet()) {
            String column = entry.getKey();
            String className = entry.getValue();
            Pair<Text, Text> pcic = ColumnSet.decodeColumns(column);
            Class<K> clazz = ClassLoaderUtil.loadClass(context, className, c);
            K inst = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (pcic.getSecond() == null) {
                this.addObject(pcic.getFirst(), inst);
                continue;
            }
            this.addObject(pcic.getFirst(), pcic.getSecond(), inst);
        }
    }

    protected void addObject(Text colf, K obj) {
        this.objectsCF.put(new ColumnUtil.ColFamHashKey(new Text(colf)), (ColumnUtil.ColFamHashKey)obj);
    }

    protected void addObject(Text colf, Text colq, K obj) {
        this.objectsCol.put(new ColumnUtil.ColHashKey(colf, colq), (ColumnUtil.ColHashKey)obj);
    }

    public K getObject(Key key) {
        K obj = null;
        if (!this.objectsCol.isEmpty()) {
            this.lookupCol.set(key);
            obj = this.objectsCol.get(this.lookupCol);
            if (obj != null) {
                return obj;
            }
        }
        if (!this.objectsCF.isEmpty()) {
            this.lookupCF.set(key);
            obj = this.objectsCF.get(this.lookupCF);
        }
        return obj;
    }

    public boolean isEmpty() {
        return this.objectsCol.isEmpty() && this.objectsCF.isEmpty();
    }
}

