/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.mapreduce.lib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

public class DistributedCacheHelper {
    public static void addCacheFile(String path, String fragment, Configuration conf) {
        DistributedCache.addCacheFile((URI)DistributedCacheHelper.getUri(path, fragment), (Configuration)conf);
    }

    public static void addCacheFile(Job job, String path, String fragment) {
        job.addCacheFile(DistributedCacheHelper.getUri(path, fragment));
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="arbitrary path provided by user, through MapReduce APIs")
    public static InputStream openCachedFile(String path, String fragment, Configuration conf) {
        File tempFile = new File(fragment);
        if (tempFile.exists()) {
            try {
                return new FileInputStream(tempFile);
            }
            catch (FileNotFoundException e) {
                throw new AssertionError("FileNotFoundException after verifying file exists", e);
            }
        }
        try {
            return FileSystem.get((Configuration)conf).open(new Path(path));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read file at DFS Path " + path, e);
        }
    }

    private static URI getUri(String path, String fragment) {
        String uriString = Objects.requireNonNull(path) + "#" + Objects.requireNonNull(fragment);
        if (path.contains("#")) {
            throw new IllegalArgumentException("Path to cache cannot contain a URI fragment");
        }
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI for item to cache", e);
        }
    }
}

