/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin.compaction;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.PluginEnvironment;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.client.admin.compaction.CompactionSelector;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.client.summary.summarizers.DeletesSummarizer;

public class TooManyDeletesSelector
implements CompactionSelector {
    private double threshold;
    private boolean proceed_bns;
    public static final String THRESHOLD_OPT = "threshold";
    public static final String THRESHOLD_OPT_DEFAULT = ".25";
    public static final String PROCEED_ZERO_NO_SUMMARY_OPT = "proceed_zero_no_summary";
    public static final String PROCEED_ZERO_NO_SUMMARY_OPT_DEFAULT = "false";

    @Override
    public void init(CompactionSelector.InitParameters iparams) {
        Map<String, String> options = iparams.getOptions();
        this.threshold = Double.parseDouble(options.getOrDefault(THRESHOLD_OPT, THRESHOLD_OPT_DEFAULT));
        if (this.threshold <= 0.0 || this.threshold > 1.0) {
            throw new IllegalArgumentException("Threshold must be in range (0.0, 1.0], saw : " + this.threshold);
        }
        this.proceed_bns = Boolean.parseBoolean(options.getOrDefault(PROCEED_ZERO_NO_SUMMARY_OPT, PROCEED_ZERO_NO_SUMMARY_OPT_DEFAULT));
    }

    @Override
    public CompactionSelector.Selection select(CompactionSelector.SelectionParameters sparams) {
        double ratio;
        PluginEnvironment.Configuration tableConf = sparams.getEnvironment().getConfiguration(sparams.getTableId());
        Collection<SummarizerConfiguration> configuredSummarizers = SummarizerConfiguration.fromTableProperties(tableConf);
        if (configuredSummarizers.stream().map(sc -> sc.getClassName()).noneMatch(cn -> cn.equals(DeletesSummarizer.class.getName()))) {
            return new CompactionSelector.Selection(List.of());
        }
        Predicate<SummarizerConfiguration> summarizerPredicate = conf -> conf.getClassName().equals(DeletesSummarizer.class.getName()) && conf.getOptions().isEmpty();
        long total = 0L;
        long deletes = 0L;
        for (CompactableFile file : sparams.getAvailableFiles()) {
            Collection<Summary> summaries = sparams.getSummaries(List.of(file), summarizerPredicate);
            if (summaries.size() == 1) {
                Summary summary = summaries.iterator().next();
                total += summary.getStatistics().get("total").longValue();
                deletes += summary.getStatistics().get("deletes").longValue();
                continue;
            }
            long numEntries = file.getEstimatedEntries();
            if (numEntries == 0L && !this.proceed_bns) {
                return new CompactionSelector.Selection(List.of());
            }
            total += numEntries;
        }
        long nonDeletes = total - deletes;
        if (nonDeletes >= 0L && (ratio = (double)deletes / (double)nonDeletes) >= this.threshold) {
            return new CompactionSelector.Selection(sparams.getAvailableFiles());
        }
        return new CompactionSelector.Selection(List.of());
    }
}

