/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.ClientIteratorEnvironment;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionReason;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironment;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironmentImpl;
import org.apache.accumulo.tserver.tablet.CompactableImpl;

public class MajCEnv
implements FileCompactor.CompactionEnv {
    private final CompactionKind kind;
    private final RateLimiter readLimiter;
    private final RateLimiter writeLimiter;
    private final boolean propagateDeletes;
    private final CompactableImpl.CompactionCheck compactionCheck;

    public MajCEnv(CompactionKind kind, CompactableImpl.CompactionCheck compactionCheck, RateLimiter readLimiter, RateLimiter writeLimiter, boolean propagateDeletes) {
        this.kind = kind;
        this.readLimiter = readLimiter;
        this.writeLimiter = writeLimiter;
        this.propagateDeletes = propagateDeletes;
        this.compactionCheck = compactionCheck;
    }

    public boolean isCompactionEnabled() {
        return this.compactionCheck.isCompactionEnabled();
    }

    public IteratorUtil.IteratorScope getIteratorScope() {
        return IteratorUtil.IteratorScope.majc;
    }

    public RateLimiter getReadLimiter() {
        return this.readLimiter;
    }

    public RateLimiter getWriteLimiter() {
        return this.writeLimiter;
    }

    public SystemIteratorEnvironment createIteratorEnv(ServerContext context, AccumuloConfiguration acuTableConf, TableId tableId) {
        ClientIteratorEnvironment.Builder builder = new SystemIteratorEnvironmentImpl.Builder(context).withScope(IteratorUtil.IteratorScope.majc).withTableId(tableId);
        if (this.kind == CompactionKind.USER) {
            builder.isUserCompaction();
        }
        if (!this.propagateDeletes) {
            builder.isFullMajorCompaction();
        }
        return (SystemIteratorEnvironment)builder.build();
    }

    public SortedKeyValueIterator<Key, Value> getMinCIterator() {
        throw new UnsupportedOperationException();
    }

    public TCompactionReason getReason() {
        switch (this.kind) {
            case USER: {
                return TCompactionReason.USER;
            }
            case CHOP: {
                return TCompactionReason.CHOP;
            }
        }
        return TCompactionReason.SYSTEM;
    }
}

