/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.replication.ReplicaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ReplicaSystemFactory {
    private static final Logger log = LoggerFactory.getLogger(ReplicaSystemFactory.class);

    public ReplicaSystem get(ServerContext context, String value) {
        Map.Entry<String, String> entry = this.parseReplicaSystemConfiguration(value);
        try {
            Class<?> clz = Class.forName(entry.getKey());
            if (ReplicaSystem.class.isAssignableFrom(clz)) {
                Object o = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ReplicaSystem rs = (ReplicaSystem)o;
                rs.configure(context, entry.getValue());
                return rs;
            }
            throw new IllegalArgumentException("Class is not assignable to ReplicaSystem: " + entry.getKey());
        }
        catch (ReflectiveOperationException e) {
            log.error("Error creating ReplicaSystem object", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public Map.Entry<String, String> parseReplicaSystemConfiguration(String value) {
        Objects.requireNonNull(value);
        int index = value.indexOf(44);
        if (index == -1) {
            throw new IllegalArgumentException("Expected comma separator between replication system name and configuration");
        }
        String name = value.substring(0, index);
        String configuration = value.substring(index + 1);
        return Maps.immutableEntry((Object)name, (Object)configuration);
    }

    public static String getPeerConfigurationValue(Class<? extends ReplicaSystem> system, String configuration) {
        String systemName = system.getName() + ",";
        if (configuration == null) {
            return systemName;
        }
        return systemName + configuration;
    }
}

