/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.iterators;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.ClientIteratorEnvironment;
import org.apache.accumulo.core.iteratorsImpl.system.MultiIterator;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironment;

public class SystemIteratorEnvironmentImpl
extends ClientIteratorEnvironment
implements SystemIteratorEnvironment {
    private final ServerContext ctx;
    private final ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators;

    protected SystemIteratorEnvironmentImpl(Builder builder) {
        super((ClientIteratorEnvironment.Builder)builder);
        this.ctx = builder.ctx;
        this.topLevelIterators = builder.topLevelIterators;
    }

    private SystemIteratorEnvironmentImpl(SystemIteratorEnvironmentImpl copy) {
        super((ClientIteratorEnvironment)copy);
        this.ctx = copy.ctx;
        this.topLevelIterators = copy.topLevelIterators;
    }

    public SamplerConfiguration getSamplerConfiguration() {
        if (this.samplerConfig == null || this.samplerConfig.isEmpty()) {
            SamplerConfigurationImpl sci = SamplerConfigurationImpl.newSamplerConfig((AccumuloConfiguration)this.ctx.getTableConfiguration(this.getTableId()));
            if (sci == null) {
                return null;
            }
            this.samplerConfig = Optional.of(sci.toSamplerConfiguration());
        }
        return this.samplerConfig.orElse(null);
    }

    public IteratorEnvironment cloneWithSamplingEnabled() {
        if (!this.getIteratorScope().equals((Object)IteratorUtil.IteratorScope.scan)) {
            throw new UnsupportedOperationException();
        }
        if (this.getSamplerConfiguration() == null) {
            throw new SampleNotPresentException();
        }
        return new SystemIteratorEnvironmentImpl(this);
    }

    @Override
    public ServerContext getServerContext() {
        return this.ctx;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> getTopLevelIterator(SortedKeyValueIterator<Key, Value> iter) {
        if (this.topLevelIterators.isEmpty()) {
            return iter;
        }
        ArrayList<SortedKeyValueIterator<Key, Value>> allIters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.topLevelIterators);
        allIters.add(iter);
        return new MultiIterator(allIters, false);
    }

    public static class Builder
    extends ClientIteratorEnvironment.Builder {
        private final ServerContext ctx;
        private ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators = new ArrayList();

        public Builder(ServerContext ctx) {
            this.ctx = ctx;
            this.env = Optional.of(new ServiceEnvironmentImpl(ctx));
        }

        public Builder withTopLevelIterators(ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators) {
            this.topLevelIterators = topLevelIterators;
            return this;
        }

        public Builder withClient(AccumuloClient client) {
            return this;
        }

        public SystemIteratorEnvironmentImpl build() {
            return new SystemIteratorEnvironmentImpl(this);
        }
    }
}

