/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store;

import java.util.Comparator;
import java.util.Objects;
import org.apache.accumulo.core.data.AbstractId;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropStoreKey<ID_TYPE extends AbstractId<ID_TYPE>>
implements Comparable<PropStoreKey<ID_TYPE>> {
    private static final Logger log = LoggerFactory.getLogger(PropStoreKey.class);
    public static final int TYPE_TOKEN_POSITION = 3;
    public static final int IID_TOKEN_POSITION = 2;
    public static final int ID_TOKEN_POSITION = 4;
    public static final String TABLES_NODE_NAME = "/tables".substring(1);
    public static final String NAMESPACE_NODE_NAME = "/namespaces".substring(1);
    public static final int EXPECTED_CONFIG_LEN = 6;
    public static final int EXPECTED_SYS_CONFIG_LEN = 4;
    protected final InstanceId instanceId;
    protected final ID_TYPE id;
    private final String path;

    protected PropStoreKey(InstanceId instanceId, String path, ID_TYPE id) {
        this.instanceId = instanceId;
        this.path = path;
        this.id = id;
    }

    public @NonNull String getPath() {
        return this.path;
    }

    public @NonNull ID_TYPE getId() {
        return this.id;
    }

    public static @Nullable PropStoreKey<?> fromPath(String path) {
        String[] tokens = path.split("/");
        if (tokens.length < 1 || tokens.length != 6 && tokens.length != 4) {
            log.warn("Path '{}' is an invalid path for a property cache key - bad length", (Object)path);
            return null;
        }
        InstanceId instanceId = InstanceId.of((String)tokens[2]);
        if (!path.startsWith(ZooUtil.getRoot((InstanceId)instanceId))) {
            log.warn("Path '{}' is invalid for a property cache key, expected to start with /accumulo/{}}", (Object)path, (Object)instanceId);
            return null;
        }
        String nodeName = "/" + tokens[tokens.length - 1];
        if (tokens.length == 6 && tokens[3].equals(TABLES_NODE_NAME) && nodeName.equals("/config")) {
            return TablePropKey.of(instanceId, TableId.of((String)tokens[4]));
        }
        if (tokens.length == 6 && tokens[3].equals(NAMESPACE_NODE_NAME) && nodeName.equals("/config")) {
            return NamespacePropKey.of(instanceId, NamespaceId.of((String)tokens[4]));
        }
        if (tokens.length == 4 && nodeName.equals("/config")) {
            return SystemPropKey.of(instanceId);
        }
        log.warn("Path '{}' is an invalid path for a property cache key", (Object)path);
        return null;
    }

    @Override
    public int compareTo(@NonNull PropStoreKey<ID_TYPE> other) {
        return Comparator.comparing(PropStoreKey::getPath).compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropStoreKey that = (PropStoreKey)o;
        if (this.getId().getClass() != that.getId().getClass()) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getId().getClass().getSimpleName() + "=" + this.getId().canonical() + "}";
    }
}

