/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.accumulo.hadoop.mapreduce.OutputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.OutputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;

public class OutputFormatBuilderImpl<T>
implements OutputFormatBuilder.ClientParams<T>,
OutputFormatBuilder.OutputOptions<T> {
    private final Class<?> callingClass;
    private Properties clientProps;
    private String clientPropsPath;
    private Optional<String> defaultTableName = Optional.empty();
    private boolean createTables = false;
    private final boolean simulationMode = false;

    public OutputFormatBuilderImpl(Class<?> callingClass) {
        this.callingClass = callingClass;
    }

    @Override
    public OutputFormatBuilder.OutputOptions<T> clientProperties(Properties clientProperties) {
        this.clientProps = Objects.requireNonNull(clientProperties, "clientProperties must not be null");
        return this;
    }

    @Override
    public OutputFormatBuilder.OutputOptions<T> clientPropertiesPath(String clientPropsPath) {
        this.clientPropsPath = Objects.requireNonNull(clientPropsPath, "clientPropsPath must not be null");
        return this;
    }

    @Override
    public OutputFormatBuilder.OutputOptions<T> defaultTable(String tableName) {
        this.defaultTableName = Optional.of(tableName);
        return this;
    }

    @Override
    public OutputFormatBuilder.OutputOptions<T> createTables(boolean value) {
        this.createTables = value;
        return this;
    }

    @Override
    public void store(T j) {
        if (j instanceof Job) {
            this.store((Job)j);
        } else if (j instanceof JobConf) {
            this.store((JobConf)j);
        } else {
            throw new IllegalArgumentException("Unexpected type " + j.getClass().getName());
        }
    }

    @Override
    private void store(Job job) {
        this._store(job.getConfiguration());
    }

    private void _store(Configuration conf) {
        OutputConfigurator.setClientProperties(this.callingClass, conf, this.clientProps, this.clientPropsPath);
        if (this.defaultTableName.isPresent()) {
            OutputConfigurator.setDefaultTableName(this.callingClass, conf, this.defaultTableName.orElseThrow());
        }
        OutputConfigurator.setCreateTables(this.callingClass, conf, this.createTables);
        OutputConfigurator.setSimulationMode(this.callingClass, conf, false);
        OutputConfigurator.setJobStored(this.callingClass, conf);
    }

    @Override
    private void store(JobConf jobConf) {
        this._store((Configuration)jobConf);
    }
}

