/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import net.sf.mpxj.Filter;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.reader.UniversalProjectReader;

public class MpxjFilter {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: MpxFilter <input file name> <filter name>");
            } else {
                MpxjFilter.filter(stringArray[0], stringArray[1]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static void filter(String string, String string2) throws Exception {
        ProjectFile projectFile = new UniversalProjectReader().read(string);
        Filter filter = projectFile.getFilters().getFilterByName(string2);
        if (filter == null) {
            MpxjFilter.displayAvailableFilters(projectFile);
        } else {
            System.out.println(filter);
            System.out.println();
            if (filter.isTaskFilter()) {
                MpxjFilter.processTaskFilter(projectFile, filter);
            } else {
                MpxjFilter.processResourceFilter(projectFile, filter);
            }
        }
    }

    private static void displayAvailableFilters(ProjectFile projectFile) {
        System.out.println("Unknown filter name supplied.");
        System.out.println("Available task filters:");
        for (Filter filter : projectFile.getFilters().getTaskFilters()) {
            System.out.println("   " + filter.getName());
        }
        System.out.println("Available resource filters:");
        for (Filter filter : projectFile.getFilters().getResourceFilters()) {
            System.out.println("   " + filter.getName());
        }
    }

    private static void processTaskFilter(ProjectFile projectFile, Filter filter) {
        for (Task task : projectFile.getTasks()) {
            if (!filter.evaluate(task, null)) continue;
            System.out.println(task.getID() + "," + task.getUniqueID() + "," + task.getName());
        }
    }

    private static void processResourceFilter(ProjectFile projectFile, Filter filter) {
        for (Resource resource : projectFile.getResources()) {
            if (!filter.evaluate(resource, null)) continue;
            System.out.println(resource.getID() + "," + resource.getUniqueID() + "," + resource.getName());
        }
    }
}

