/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class SecurityContextLoginModule
implements LoginModule {
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$security$providers$jaas$SecurityContextLoginModule == null ? (class$org$springframework$security$providers$jaas$SecurityContextLoginModule = SecurityContextLoginModule.class$("org.springframework.security.providers.jaas.SecurityContextLoginModule")) : class$org$springframework$security$providers$jaas$SecurityContextLoginModule));
    private Authentication authen;
    private Subject subject;
    private boolean ignoreMissingAuthentication = false;
    static /* synthetic */ Class class$org$springframework$security$providers$jaas$SecurityContextLoginModule;

    public boolean abort() throws LoginException {
        if (this.authen == null) {
            return false;
        }
        this.authen = null;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.authen == null) {
            return false;
        }
        this.subject.getPrincipals().add(this.authen);
        return true;
    }

    Authentication getAuthentication() {
        return this.authen;
    }

    Subject getSubject() {
        return this.subject;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        if (options != null) {
            this.ignoreMissingAuthentication = "true".equals(options.get("ignoreMissingAuthentication"));
        }
    }

    public boolean login() throws LoginException {
        this.authen = SecurityContextHolder.getContext().getAuthentication();
        if (this.authen == null) {
            String msg = "Login cannot complete, authentication not found in security context";
            if (this.ignoreMissingAuthentication) {
                log.warn((Object)msg);
                return false;
            }
            throw new LoginException(msg);
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.authen == null) {
            return false;
        }
        this.subject.getPrincipals().remove(this.authen);
        this.authen = null;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

