/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.util.Collections;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.gradle.internal.verifier.HttpRedirectVerifier;

final class RedirectVerifyingStrategyDecorator
implements RedirectStrategy {
    private final RedirectStrategy delegate;
    private final HttpRedirectVerifier verifier;

    public RedirectVerifyingStrategyDecorator(RedirectStrategy delegate, HttpRedirectVerifier verifier) {
        this.delegate = delegate;
        this.verifier = verifier;
    }

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        return this.delegate.isRedirected(request, response, context);
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        HttpUriRequest redirectRequest = this.delegate.getRedirect(request, response, context);
        this.verifier.validateRedirects(Collections.singletonList(redirectRequest.getURI()));
        return redirectRequest;
    }
}

