/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.solr.analytics.facet.RangeFacet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumericFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.DateMathParser;

public abstract class FacetRangeGenerator<T extends Comparable<T>> {
    protected final SchemaField field;
    protected final RangeFacet rangeFacet;

    public FacetRangeGenerator(RangeFacet rangeFacet) {
        this.field = rangeFacet.getField();
        this.rangeFacet = rangeFacet;
    }

    public String formatValue(T val) {
        return val.toString();
    }

    public final T getValue(String rawval) {
        try {
            return this.parseVal(rawval);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), (Throwable)e);
        }
    }

    protected abstract T parseVal(String var1) throws ParseException;

    public final Object getGap(String gap) {
        try {
            return this.parseGap(gap);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), (Throwable)e);
        }
    }

    protected Object parseGap(String rawval) throws ParseException {
        return this.parseVal(rawval);
    }

    public final T addGap(T value, String gap) {
        try {
            return this.parseAndAddGap(value, gap);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), (Throwable)e);
        }
    }

    protected abstract T parseAndAddGap(T var1, String var2) throws ParseException;

    public List<FacetRange> getRanges() {
        T start = this.getValue(this.rangeFacet.getStart());
        T end = this.getValue(this.rangeFacet.getEnd());
        if (end.compareTo(start) < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet 'end' comes before 'start': " + end + " < " + start);
        }
        List<String> gaps = this.rangeFacet.getGaps();
        String gap = gaps.get(0);
        EnumSet<FacetParams.FacetRangeInclude> include = this.rangeFacet.getInclude();
        T low = start;
        ArrayList<FacetRange> ranges = new ArrayList<FacetRange>();
        int gapCounter = 0;
        while (low.compareTo(end) < 0) {
            T high;
            if (gapCounter < gaps.size()) {
                gap = gaps.get(gapCounter++);
            }
            if (end.compareTo(high = this.addGap(low, gap)) < 0) {
                if (this.rangeFacet.isHardEnd()) {
                    high = end;
                } else {
                    end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            if (high.compareTo(low) == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop: gap is either zero, or too small relative start/end and caused underflow: " + low + " + " + gap + " = " + high);
            }
            boolean includeLower = include.contains(FacetParams.FacetRangeInclude.ALL) || include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(start);
            boolean includeUpper = include.contains(FacetParams.FacetRangeInclude.ALL) || include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
            String lowS = this.formatValue(low);
            String highS = this.formatValue(high);
            ranges.add(new FacetRange(lowS, lowS, highS, includeLower, includeUpper));
            low = high;
        }
        EnumSet<FacetParams.FacetRangeOther> others = this.rangeFacet.getOthers();
        if (null != others && 0 < others.size() && !others.contains(FacetParams.FacetRangeOther.NONE)) {
            boolean all = others.contains(FacetParams.FacetRangeOther.ALL);
            if (all || others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                ranges.add(new FacetRange(FacetParams.FacetRangeOther.BEFORE.toString(), null, this.formatValue(start), false, include.contains(FacetParams.FacetRangeInclude.OUTER) || include.contains(FacetParams.FacetRangeInclude.ALL) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)));
            }
            if (all || others.contains(FacetParams.FacetRangeOther.AFTER)) {
                ranges.add(new FacetRange(FacetParams.FacetRangeOther.AFTER.toString(), this.formatValue(end), null, include.contains(FacetParams.FacetRangeInclude.OUTER) || include.contains(FacetParams.FacetRangeInclude.ALL) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false));
            }
            if (all || others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                ranges.add(new FacetRange(FacetParams.FacetRangeOther.BETWEEN.toString(), this.formatValue(start), this.formatValue(end), include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) || include.contains(FacetParams.FacetRangeInclude.ALL), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) || include.contains(FacetParams.FacetRangeInclude.ALL)));
            }
        }
        return ranges;
    }

    public static FacetRangeGenerator<? extends Comparable<?>> create(RangeFacet rangeFacet) {
        FacetRangeGenerator calc;
        block8: {
            SchemaField sf;
            block7: {
                sf = rangeFacet.getField();
                FieldType ft = sf.getType();
                if (!(ft instanceof NumericFieldType)) break block7;
                switch (ft.getNumberType()) {
                    case FLOAT: {
                        calc = new FloatFacetRangeGenerator(rangeFacet);
                        break block8;
                    }
                    case DOUBLE: {
                        calc = new DoubleFacetRangeGenerator(rangeFacet);
                        break block8;
                    }
                    case INTEGER: {
                        calc = new IntegerFacetRangeGenerator(rangeFacet);
                        break block8;
                    }
                    case LONG: {
                        calc = new LongFacetRangeGenerator(rangeFacet);
                        break block8;
                    }
                    case DATE: {
                        calc = new DateFacetRangeGenerator(rangeFacet, null);
                        break block8;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on numeric field of unexpected type: " + sf.getName());
                    }
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on non-numeric field: " + sf);
        }
        return calc;
    }

    static class DateFacetRangeGenerator
    extends FacetRangeGenerator<Date> {
        private final Date now;

        public DateFacetRangeGenerator(RangeFacet rangeFacet, Date now) {
            super(rangeFacet);
            this.now = now;
        }

        @Override
        public String formatValue(Date val) {
            return val.toInstant().toString();
        }

        @Override
        protected Date parseVal(String rawval) {
            return DateMathParser.parseMath((Date)this.now, (String)rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Date value, String gap) throws ParseException {
            DateMathParser dmp = new DateMathParser();
            dmp.setNow(value);
            return dmp.parseMath(gap);
        }
    }

    static class DoubleFacetRangeGenerator
    extends FacetRangeGenerator<Double> {
        public DoubleFacetRangeGenerator(RangeFacet rangeFacet) {
            super(rangeFacet);
        }

        @Override
        protected Double parseVal(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Double value, String gap) {
            return value + Double.valueOf(gap);
        }
    }

    static class FloatFacetRangeGenerator
    extends FacetRangeGenerator<Float> {
        public FloatFacetRangeGenerator(RangeFacet rangeFacet) {
            super(rangeFacet);
        }

        @Override
        protected Float parseVal(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Float value, String gap) {
            return Float.valueOf(value.floatValue() + Float.valueOf(gap).floatValue());
        }
    }

    static class LongFacetRangeGenerator
    extends FacetRangeGenerator<Long> {
        public LongFacetRangeGenerator(RangeFacet rangeFacet) {
            super(rangeFacet);
        }

        @Override
        protected Long parseVal(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Long value, String gap) {
            return value + Long.valueOf(gap);
        }
    }

    static class IntegerFacetRangeGenerator
    extends FacetRangeGenerator<Integer> {
        public IntegerFacetRangeGenerator(RangeFacet rangeFacet) {
            super(rangeFacet);
        }

        @Override
        protected Integer parseVal(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Integer value, String gap) {
            return value + Integer.valueOf(gap);
        }
    }

    public static class FacetRange {
        public final String name;
        public final String lower;
        public final String upper;
        public final boolean includeLower;
        public final boolean includeUpper;
        private final String facetValue;

        public FacetRange(String name, String lower, String upper, boolean includeLower, boolean includeUpper) {
            this.name = name;
            this.lower = lower;
            this.upper = upper;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
            Object value = "(*";
            if (lower != null) {
                value = (includeLower ? "[" : "(") + lower;
            }
            value = (String)value + " TO ";
            value = upper == null ? (String)value + "*)" : (String)value + upper + (includeUpper ? "]" : ")");
            this.facetValue = value;
        }

        public String toString() {
            return this.facetValue;
        }
    }
}

