/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2006 Takuro Ashie
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __TOMOE_SCROLLABLE_H__
#define __TOMOE_SCROLLABLE_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS


#define TOMOE_TYPE_SCROLLABLE         (tomoe_scrollable_get_type())
#define TOMOE_SCROLLABLE(o)           (G_TYPE_CHECK_INSTANCE_CAST((o), TOMOE_TYPE_SCROLLABLE, TomoeScrollable))
#define TOMOE_IS_SCROLLABLE(o)        (G_TYPE_CHECK_INSTANCE_TYPE((o), TOMOE_TYPE_SCROLLABLE))
#define TOMOE_SCROLLABLE_GET_IFACE(o) (G_TYPE_INSTANCE_GET_INTERFACE((o), TOMOE_TYPE_SCROLLABLE, TomoeScrollableIFace))

typedef struct _TomoeScrollable      TomoeScrollable;
typedef struct _TomoeScrollableIFace TomoeScrollableIFace;

struct _TomoeScrollableIFace
{
    GTypeInterface g_iface;

    /* vtable */
    void (*set_adjustments) (TomoeScrollable *scrollable, 
                             GtkAdjustment   *h_adj, 
                             GtkAdjustment   *v_adj);
    void (*get_adjustments) (TomoeScrollable *scrollable,
                             GtkAdjustment  **h_adj,
                             GtkAdjustment  **v_adj);
};

GType     tomoe_scrollable_get_type             (void) G_GNUC_CONST;

void      tomoe_scrollable_setup_widget_class   (GtkWidgetClass *klass);

void      tomoe_scrollable_set_adjustments      (TomoeScrollable *scrollable,
                                                 GtkAdjustment   *h_adj,
                                                 GtkAdjustment   *v_adj);
void      tomoe_scrollable_set_own_adjustments  (TomoeScrollable *scrollable);
void      tomoe_scrollable_get_adjustments      (TomoeScrollable *scrollable,
                                                 GtkAdjustment  **h_adj,
                                                 GtkAdjustment  **v_adj);
/* FIXME!: use GtkScrollType? */
void      tomoe_scrollable_h_page_up            (TomoeScrollable *scrollable);
void      tomoe_scrollable_h_page_down          (TomoeScrollable *scrollable);
void      tomoe_scrollable_v_page_up            (TomoeScrollable *scrollable);
void      tomoe_scrollable_v_page_down          (TomoeScrollable *scrollable);

#if 0
/* API draft */
get_view_area (this, *x, *y, *width, *height);
get_virtual_size (this, *width, *height)
move_to (this, x, y)
move_to_by_percentage (this, x, y)
start_auto_scroll (this, ?)
stop_auto_scroll (this)
clamp_step (this)
clamp_page (this)
set_auto_clamp_step (this, bool)
set_auto_clamp_page (this, bool)
#endif

G_END_DECLS

#endif /* __TOMOE_SCROLLABLE_H__ */

/*
 * vi:ts=4:nowrap:ai:expandtab
 */
