/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.function.TriConsumer;
import org.jd.gui.util.swing.SwingUtil;
import org.jd.gui.view.bean.OpenTypeListCellBean;
import org.jd.gui.view.renderer.OpenTypeListCellRenderer;

public class OpenTypeView {
    protected static final int MAX_LINE_COUNT = 80;
    protected static final TypeNameComparator TYPE_NAME_COMPARATOR = new TypeNameComparator();
    protected API api;
    protected JDialog openTypeDialog;
    protected JTextField openTypeEnterTextField;
    protected JLabel openTypeMatchLabel;
    protected JList openTypeList;

    public OpenTypeView(API api, JFrame mainFrame, final Consumer<String> changedPatternCallback, final TriConsumer<Point, Collection<Container.Entry>, String> selectedTypeCallback) {
        this.api = api;
        SwingUtil.invokeLater(() -> {
            this.openTypeDialog = new JDialog(mainFrame, "Open Type", false);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            panel.setLayout(new BorderLayout());
            this.openTypeDialog.add(panel);
            Box vbox = Box.createVerticalBox();
            panel.add((Component)vbox, "North");
            Box hbox = Box.createHorizontalBox();
            hbox.add(new JLabel("Select a type to open (* = any string, ? = any character, TZ = TimeZone):"));
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(10));
            this.openTypeEnterTextField = new JTextField(30);
            vbox.add(this.openTypeEnterTextField);
            this.openTypeEnterTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    switch (e.getKeyChar()) {
                        case '(': 
                        case ')': 
                        case '=': 
                        case '[': 
                        case ']': 
                        case '{': 
                        case '}': {
                            e.consume();
                            break;
                        }
                        default: {
                            if (!Character.isDigit(e.getKeyChar()) || OpenTypeView.this.openTypeEnterTextField.getText().length() != 0) break;
                            e.consume();
                        }
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 40 && OpenTypeView.this.openTypeList.getModel().getSize() > 0) {
                        OpenTypeView.this.openTypeList.setSelectedIndex(0);
                        OpenTypeView.this.openTypeList.requestFocus();
                        e.consume();
                    }
                }
            });
            this.openTypeEnterTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    OpenTypeView.this.openTypeList.clearSelection();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            this.openTypeEnterTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.call(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.call(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.call(e);
                }

                protected void call(DocumentEvent e) {
                    block2: {
                        try {
                            changedPatternCallback.accept(e.getDocument().getText(0, e.getDocument().getLength()));
                        }
                        catch (BadLocationException ex) {
                            if ($assertionsDisabled || ExceptionUtil.printStackTrace(ex)) break block2;
                            throw new AssertionError();
                        }
                    }
                }
            });
            vbox.add(Box.createVerticalStrut(10));
            hbox = Box.createHorizontalBox();
            this.openTypeMatchLabel = new JLabel("Matching types:");
            hbox.add(this.openTypeMatchLabel);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(10));
            this.openTypeList = new JList();
            JScrollPane scrollPane = new JScrollPane(this.openTypeList);
            this.openTypeList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 38 && OpenTypeView.this.openTypeList.getSelectedIndex() == 0) {
                        OpenTypeView.this.openTypeEnterTextField.requestFocus();
                        e.consume();
                    }
                }
            });
            this.openTypeList.setModel(new DefaultListModel());
            this.openTypeList.setCellRenderer(new OpenTypeListCellRenderer());
            this.openTypeList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        OpenTypeView.this.onTypeSelected(selectedTypeCallback);
                    }
                }
            });
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setPreferredSize(new Dimension(400, 150));
            panel.add((Component)scrollPane, "Center");
            vbox = Box.createVerticalBox();
            panel.add((Component)vbox, "South");
            vbox.add(Box.createVerticalStrut(25));
            hbox = Box.createHorizontalBox();
            vbox.add(hbox);
            hbox.add(Box.createHorizontalGlue());
            JButton openTypeOpenButton = new JButton("Open");
            hbox.add(openTypeOpenButton);
            openTypeOpenButton.setEnabled(false);
            openTypeOpenButton.addActionListener(e -> this.onTypeSelected(selectedTypeCallback));
            hbox.add(Box.createHorizontalStrut(5));
            JButton openTypeCancelButton = new JButton("Cancel");
            hbox.add(openTypeCancelButton);
            AbstractAction openTypeCancelActionListener = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OpenTypeView.this.openTypeDialog.setVisible(false);
                }
            };
            openTypeCancelButton.addActionListener(openTypeCancelActionListener);
            JRootPane rootPane = this.openTypeDialog.getRootPane();
            rootPane.setDefaultButton(openTypeOpenButton);
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "OpenTypeView.cancel");
            rootPane.getActionMap().put("OpenTypeView.cancel", openTypeCancelActionListener);
            this.openTypeList.addListSelectionListener(e -> openTypeOpenButton.setEnabled(this.openTypeList.getSelectedValue() != null));
            this.openTypeDialog.setMinimumSize(this.openTypeDialog.getSize());
            this.openTypeDialog.pack();
            this.openTypeDialog.setLocationRelativeTo(mainFrame);
        });
    }

    public void show() {
        SwingUtil.invokeLater(() -> {
            this.openTypeEnterTextField.selectAll();
            this.openTypeDialog.setVisible(true);
            this.openTypeEnterTextField.requestFocus();
        });
    }

    public boolean isVisible() {
        return this.openTypeDialog.isVisible();
    }

    public String getPattern() {
        return this.openTypeEnterTextField.getText();
    }

    public void showWaitCursor() {
        SwingUtil.invokeLater(() -> this.openTypeDialog.setCursor(Cursor.getPredefinedCursor(3)));
    }

    public void hideWaitCursor() {
        SwingUtil.invokeLater(() -> this.openTypeDialog.setCursor(Cursor.getDefaultCursor()));
    }

    public void updateList(Map<String, Collection<Container.Entry>> map) {
        SwingUtil.invokeLater(() -> {
            DefaultListModel model = (DefaultListModel)this.openTypeList.getModel();
            ArrayList typeNames = new ArrayList(map.keySet());
            int index = 0;
            typeNames.sort(TYPE_NAME_COMPARATOR);
            model.removeAllElements();
            for (String typeName : typeNames) {
                if (index < 80) {
                    Collection entries = (Collection)map.get(typeName);
                    Container.Entry firstEntry = (Container.Entry)entries.iterator().next();
                    Type type = this.api.getTypeFactory(firstEntry).make(this.api, firstEntry, typeName);
                    if (type != null) {
                        model.addElement(new OpenTypeListCellBean(type.getDisplayTypeName(), type.getDisplayPackageName(), type.getIcon(), entries, typeName));
                        continue;
                    }
                    model.addElement(new OpenTypeListCellBean(typeName, entries, typeName));
                    continue;
                }
                if (index != 80) continue;
                model.addElement(null);
            }
            int count = typeNames.size();
            switch (count) {
                case 0: {
                    this.openTypeMatchLabel.setText("Matching types:");
                    break;
                }
                case 1: {
                    this.openTypeMatchLabel.setText("1 matching type:");
                    break;
                }
                default: {
                    this.openTypeMatchLabel.setText(count + " matching types:");
                }
            }
        });
    }

    public void focus() {
        SwingUtil.invokeLater(() -> this.openTypeList.requestFocus());
    }

    protected void onTypeSelected(TriConsumer<Point, Collection<Container.Entry>, String> selectedTypeCallback) {
        SwingUtil.invokeLater(() -> {
            int index = this.openTypeList.getSelectedIndex();
            if (index != -1) {
                OpenTypeListCellBean selectedCellBean = (OpenTypeListCellBean)this.openTypeList.getModel().getElementAt(index);
                Point listLocation = this.openTypeList.getLocationOnScreen();
                Rectangle cellBound = this.openTypeList.getCellBounds(index, index);
                Point leftBottom = new Point(listLocation.x + cellBound.x, listLocation.y + cellBound.y + cellBound.height);
                selectedTypeCallback.accept(leftBottom, selectedCellBean.entries, selectedCellBean.typeName);
            }
        });
    }

    protected static class TypeNameComparator
    implements Comparator<String> {
        protected TypeNameComparator() {
        }

        @Override
        public int compare(String tn1, String tn2) {
            int lasPackageSeparatorIndex = tn1.lastIndexOf(47);
            String shortName1 = tn1.substring(lasPackageSeparatorIndex + 1);
            lasPackageSeparatorIndex = tn2.lastIndexOf(47);
            String shortName2 = tn2.substring(lasPackageSeparatorIndex + 1);
            return shortName1.compareTo(shortName2);
        }
    }
}

