// -*- ++ -*- generated by wxGlade 0.3.2 on Wed Apr 14 15:59:52 2004

#include "wxzphoto.h"

// begin byHand
#include <wx/colordlg.h>
#include <wx/dnd.h>
#include <wx/dir.h> // for wxDir
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <ctype.h>
#include <zphoto.h>
#include "config.h"

#ifndef __WXMSW__
    #include "icon/wxzphoto.xpm"
#endif

enum
{
    Menu_File_Open_File,
    Menu_File_Open_Directory,
    Menu_File_Clear_Selected,
    Menu_File_Clear_All,
    Menu_File_Create,
    Menu_File_Exit,
    Menu_Help_About,

    Menu_Context_Open_File,
    Menu_Context_Open_Directory,
    Menu_Context_Clear_Selected,
    Menu_Context_Clear_All,

    Button_Create,
    Button_Output_Directory,
    Button_Template_Directory,
    Button_Flash_Font,
    Button_Background_Color,
    Button_Border_Active_Color,
    Button_Border_Inactive_Color,
    Button_Shadow_Color,
    Button_Caption_Border_Color,
    Button_Caption_Frame_Color,
    Button_Caption_Text_Color,
    Button_Progress_Bar_Color,
    Button_Progress_Bar_Text_Color,
    Button_Progress_Bar_Housing_Color,
    Button_Reset_Colors,

    Button_CSS_Background_Color,
    Button_CSS_Text_Color,
    Button_CSS_Footer_Color,
    Button_CSS_Horizontal_Line_Color,
    Button_CSS_Photo_Border_Color,
    Button_CSS_Thumbnail_Border_Color,
    Button_CSS_Navi_Link_Color,
    Button_CSS_Navi_Visited_Color,
    Button_CSS_Navi_Border_Color,
    Button_CSS_Navi_Hover_Color,
    Button_CSS_Reset_Colors,

    Textctrl_Gamma,
    Listbox_Input_Files,

    Button_Progress_OK
};

BEGIN_EVENT_TABLE(wxZphotoFrame, wxFrame)
    EVT_MENU(Menu_File_Open_File,
             wxZphotoFrame::OnOpenFile)
    EVT_MENU(Menu_File_Open_Directory,
             wxZphotoFrame::OnOpenDirectory)
    EVT_MENU(Menu_File_Clear_Selected, 
             wxZphotoFrame::OnClearSelected)
    EVT_MENU(Menu_File_Clear_All,
             wxZphotoFrame::OnClearAll)

    EVT_MENU(Menu_File_Create,
             wxZphotoFrame::OnCreatePhotoAlbum)
    EVT_MENU(Menu_File_Exit,
             wxZphotoFrame::OnQuit)
    EVT_MENU(Menu_Help_About,
             wxZphotoFrame::OnAbout)

    EVT_BUTTON(Button_Create,       
               wxZphotoFrame::OnCreatePhotoAlbum)
    EVT_BUTTON(Button_Flash_Font,       
               wxZphotoFrame::OnChooseFlashFont)
    EVT_BUTTON(Button_Template_Directory,       
               wxZphotoFrame::OnChooseTemplateDirectory)
    EVT_BUTTON(Button_Output_Directory,       
               wxZphotoFrame::OnChooseOutputDirectory)

    EVT_BUTTON(Button_Background_Color,
               wxZphotoFrame::OnChooseBackgroundColor)
    EVT_BUTTON(Button_Border_Active_Color,
               wxZphotoFrame::OnChooseBorderActiveColor)
    EVT_BUTTON(Button_Border_Inactive_Color,
               wxZphotoFrame::OnChooseBorderInactiveColor)
    EVT_BUTTON(Button_Shadow_Color,
               wxZphotoFrame::OnChooseShadowColor)
    EVT_BUTTON(Button_Caption_Border_Color,
               wxZphotoFrame::OnChooseCaptionBorderColor)
    EVT_BUTTON(Button_Caption_Frame_Color,
               wxZphotoFrame::OnChooseCaptionFrameColor)
    EVT_BUTTON(Button_Caption_Text_Color,
               wxZphotoFrame::OnChooseCaptionTextColor)
    EVT_BUTTON(Button_Progress_Bar_Color,
               wxZphotoFrame::OnChooseProgressBarColor)
    EVT_BUTTON(Button_Progress_Bar_Text_Color,
               wxZphotoFrame::OnChooseProgressBarTextColor)
    EVT_BUTTON(Button_Progress_Bar_Housing_Color,
               wxZphotoFrame::OnChooseProgressBarHousingColor)
    EVT_BUTTON(Button_Reset_Colors,
               wxZphotoFrame::OnResetFlashColors)

    EVT_BUTTON(Button_CSS_Background_Color,
               wxZphotoFrame::OnChooseCSSBackgroundColor)
    EVT_BUTTON(Button_CSS_Text_Color,
               wxZphotoFrame::OnChooseCSSTextColor)
    EVT_BUTTON(Button_CSS_Footer_Color,
               wxZphotoFrame::OnChooseCSSFooterColor)
    EVT_BUTTON(Button_CSS_Horizontal_Line_Color,
               wxZphotoFrame::OnChooseCSSHorizontalLineColor)
    EVT_BUTTON(Button_CSS_Photo_Border_Color,
               wxZphotoFrame::OnChooseCSSPhotoBorderColor)
    EVT_BUTTON(Button_CSS_Thumbnail_Border_Color,
               wxZphotoFrame::OnChooseCSSThumbnailBorderColor)
    EVT_BUTTON(Button_CSS_Navi_Link_Color,
               wxZphotoFrame::OnChooseCSSNaviLinkColor)
    EVT_BUTTON(Button_CSS_Navi_Visited_Color,
               wxZphotoFrame::OnChooseCSSNaviVisitedColor)
    EVT_BUTTON(Button_CSS_Navi_Border_Color,
               wxZphotoFrame::OnChooseCSSNaviBorderColor)
    EVT_BUTTON(Button_CSS_Navi_Hover_Color,
               wxZphotoFrame::OnChooseCSSNaviHoverColor)
    EVT_BUTTON(Button_CSS_Reset_Colors,
               wxZphotoFrame::OnResetCSSColors)

    EVT_UPDATE_UI(Button_Create,            wxZphotoFrame::OnUpdateUIHasFiles)
    EVT_UPDATE_UI(Menu_File_Create,         wxZphotoFrame::OnUpdateUIHasFiles)
    EVT_UPDATE_UI(Menu_File_Clear_All,      wxZphotoFrame::OnUpdateUIHasFiles)
    EVT_UPDATE_UI(Menu_File_Clear_Selected, wxZphotoFrame::OnUpdateUIIsSelected)

    EVT_CLOSE(wxZphotoFrame::OnClose)
    EVT_MENU_CLOSE(wxZphotoFrame::OnMenuClose)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(wxZphotoListBox, wxListBox)
    EVT_MENU(Menu_Context_Open_File,      wxZphotoListBox::OnOpenFile)
    EVT_MENU(Menu_Context_Open_Directory, wxZphotoListBox::OnOpenDirectory)
    EVT_MENU(Menu_Context_Clear_All,      wxZphotoListBox::OnClearAll)
    EVT_MENU(Menu_Context_Clear_Selected, wxZphotoListBox::OnClearSelected)

    EVT_CHAR(wxZphotoListBox::OnChar)
    EVT_CONTEXT_MENU(wxZphotoListBox::OnContextMenu)
    EVT_LISTBOX(Listbox_Input_Files, wxZphotoListBox::OnListbox)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(wxZphotoPanel, wxPanel)
    EVT_PAINT(wxZphotoPanel::OnPaint)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(wxZphotoTextCtrl, wxTextCtrl)
    EVT_SET_FOCUS(wxZphotoTextCtrl::OnFocusGot)
    EVT_KILL_FOCUS(wxZphotoTextCtrl::OnFocusLost)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(wxZphotoSpinCtrl, wxSpinCtrl)
    EVT_KILL_FOCUS(wxZphotoSpinCtrl::OnFocusLost)
END_EVENT_TABLE()


BEGIN_EVENT_TABLE(wxZphotoProgressDialog, wxDialog)
    EVT_CLOSE(wxZphotoProgressDialog::OnClose)
    EVT_BUTTON(Button_Progress_OK, wxZphotoProgressDialog::OnOK)
END_EVENT_TABLE()


void wxZphotoListBox::Attach(wxZphotoObserver* observer)
{
    observers.Append((wxObject *)observer);
}

void wxZphotoListBox::Notify()
{
    assert((int)inputFiles.GetCount() == GetCount());

    wxNode *node = observers.GetFirst();
    while (node) {
        wxZphotoObserver *observer = (wxZphotoObserver *)node->GetData();
        observer->Update(this);
        node = node->GetNext();
    }
}

static int CompareByBasename(const wxString& first, const wxString& second)
{
    char *basename1 = zphoto_basename(first.c_str());
    char *basename2 = zphoto_basename(second.c_str());
    return strcmp(basename1, basename2);
}

void wxZphotoListBox::Append(const wxString& item)
{
    if (inputFiles.Index(item) == wxNOT_FOUND) {
        inputFiles.Add(item);
        inputFiles.Sort(CompareByBasename);
        wxListBox::Append(zphoto_basename(item));
        Notify();
    }
}

void wxZphotoListBox::Delete(int n)
{
    inputFiles.RemoveAt(n);
    wxListBox::Delete(n);
    Notify();
}

void wxZphotoListBox::Clear(void)
{
    inputFiles.Clear();
    wxListBox::Clear();
    Notify();
}    

wxString wxZphotoListBox::GetInputFile(int n)
{
    return inputFiles[n];
}

void wxZphotoListBox::DeleteSelectedItem(void)
{
    int index = GetSelection();
    if (Selected(index)) {
        Delete(index);
        if (GetCount() == index) // the last item was selected
            index--;
        if (GetCount() > 0)
            SetSelection(index);
    }
}

void wxZphotoListBox::OnListbox(wxCommandEvent& event)
{
    Notify();
}

void wxZphotoListBox::OnOpenFile(wxCommandEvent& WXUNUSED(event))
{
    wxZphotoFrame *frame = (wxZphotoFrame *)wxTheApp->GetTopWindow();
    frame->OpenInputFiles();
}

void wxZphotoListBox::OnOpenDirectory(wxCommandEvent& WXUNUSED(event))
{
    wxZphotoFrame *frame = (wxZphotoFrame *)wxTheApp->GetTopWindow();
    frame->OpenInputDirectory();
}

void wxZphotoListBox::OnClearSelected(wxCommandEvent& WXUNUSED(event))
{
    DeleteSelectedItem();
}

void wxZphotoListBox::OnClearAll(wxCommandEvent& WXUNUSED(event))
{
    Clear();
}

void wxZphotoListBox::OnChar(wxKeyEvent& event)
{
    long keycode = event.GetKeyCode();
    if (keycode == WXK_DELETE && GetCount() > 0) {
        DeleteSelectedItem();
    } else {
        event.Skip();
    }
}

void wxZphotoListBox::OnContextMenu(wxContextMenuEvent& event)
{
    wxPoint pos = ScreenToClient(event.GetPosition());
    wxMenu menu(_T(""));
    menu.Append(Menu_Context_Open_File,      _("&Open File...\tCtrl-O"));
    menu.Append(Menu_Context_Open_Directory, _("Open &Directory...\tCtrl-D"));
    menu.AppendSeparator();
    menu.Append(Menu_Context_Clear_Selected, _("&Clear the selected file"));
    menu.Append(Menu_Context_Clear_All,      _("Clear &all files"));
    if (!Selected(GetSelection()))
        menu.Enable(Menu_Context_Clear_Selected, FALSE);
    if (GetCount() == 0)
        menu.Enable(Menu_Context_Clear_All, FALSE);
    PopupMenu(&menu, pos.x, pos.y);
}

//
// DnD codes are basically imported from samples/dnd.cpp in wxWindows.
//
class DnDFile : public wxFileDropTarget
{
public:
    DnDFile(wxZphotoListBox *pOwner) { m_pOwner = pOwner; }
    virtual bool OnDropFiles(wxCoord x, wxCoord y,
                             const wxArrayString& filenames);
private:
    wxZphotoListBox *m_pOwner;
};

bool DnDFile::OnDropFiles(wxCoord, wxCoord, const wxArrayString& filenames)
{
    size_t nFiles = filenames.GetCount();
    for ( size_t n = 0; n < nFiles; n++ ) {
        if (zphoto_supported_file_p(filenames[n]))
            m_pOwner->Append(filenames[n]);
    }
    return TRUE;
}

// end byHand


wxZphotoFrame::wxZphotoFrame(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxFrame(parent, id, title, pos, size, wxDEFAULT_FRAME_STYLE)
{
    // begin byHand

    //
    // We have to initialize the current locale before
    // calling zphoto_config_read_rcfile() to support
    // reading decimal numbers that uses a comma instead of
    // a period in European countries.
    //
    locale.Init(wxLANGUAGE_DEFAULT);
    ZphotoInit();

    //
    // We have to add the catalog after calling
    // zphoto_chdir_if_w32 to use the locale data in the
    // directory where the exe file exists.
    //
    locale.AddCatalogLookupPathPrefix(wxT("locale")); // for Windows
    locale.AddCatalog(wxT("zphoto"));

    // The following variables should be set beforehand.
    previewWidth  = 120;
    previewHeight = 120;
    assert(previewWidth == previewHeight);

    // The statusbar should be set before do_layout for correct layout.
    statusBar = new wxZphotoStatusBar(this, -1);
    SetStatusBar(statusBar);
    // end byHand

    // begin wxGlade: wxZphotoFrame::wxZphotoFrame
    mainPanel = new wxPanel(this, -1);
    rightNotebook = new wxNotebook(mainPanel, -1, wxDefaultPosition, wxDefaultSize, 0);
    cssColorsPanel = new wxPanel(rightNotebook, -1);
    colorsPanel = new wxPanel(rightNotebook, -1);
    advancedPanel = new wxPanel(rightNotebook, -1);
    basicPanel = new wxPanel(rightNotebook, -1);
    leftPanel = new wxPanel(mainPanel, -1);
    mainFrameMenuBar = new wxMenuBar();
    SetMenuBar(mainFrameMenuBar);
    wxMenu* wxglade_tmp_menu_1 = new wxMenu();
    wxglade_tmp_menu_1->Append(Menu_File_Open_File, _("&Open File...\tCtrl-O"), wxT(""), wxITEM_NORMAL);
    wxglade_tmp_menu_1->Append(Menu_File_Open_Directory, _("Open &Directory...\tCtrl-D"), wxT(""), wxITEM_NORMAL);
    wxglade_tmp_menu_1->AppendSeparator();
    wxglade_tmp_menu_1->Append(Menu_File_Clear_Selected, _("&Clear the selected file"), wxT(""), wxITEM_NORMAL);
    wxglade_tmp_menu_1->Append(Menu_File_Clear_All, _("Clear &all files"), wxT(""), wxITEM_NORMAL);
    wxglade_tmp_menu_1->AppendSeparator();
    wxglade_tmp_menu_1->Append(Menu_File_Create, _("&Create a photo album\tF5"), wxT(""), wxITEM_NORMAL);
    wxglade_tmp_menu_1->AppendSeparator();
    wxglade_tmp_menu_1->Append(Menu_File_Exit, _("E&xit\tAlt-X"), wxT(""), wxITEM_NORMAL);
    mainFrameMenuBar->Append(wxglade_tmp_menu_1, _("&File"));
    wxMenu* wxglade_tmp_menu_2 = new wxMenu();
    wxglade_tmp_menu_2->Append(Menu_Help_About, _("About zphoto..."), wxT(""), wxITEM_NORMAL);
    mainFrameMenuBar->Append(wxglade_tmp_menu_2, _("&Help"));
    const wxString inputFilesListBox_choices[] = {
        
    };
    inputFilesListBox = new wxZphotoListBox(leftPanel, Listbox_Input_Files, wxDefaultPosition, wxDefaultSize, 0, inputFilesListBox_choices, wxLB_HSCROLL|wxLB_ALWAYS_SB|wxLB_SORT);
    titleLabel = new wxStaticText(basicPanel, -1, _("Title"));
    titleTextCtrl = new wxTextCtrl(basicPanel, -1, _("sample title"));
    outputDirectoryLabel = new wxStaticText(basicPanel, -1, _("Output directory"));
    outputDirectoryTextCtrl = new wxTextCtrl(basicPanel, -1, _("sample output directory"));
    outputDirectoryButton = new wxButton(basicPanel, Button_Output_Directory, _("Choose..."));
    basicPanelLine = new wxStaticLine(basicPanel, -1);
    createButton = new wxButton(basicPanel, Button_Create, _("Create a photo album!"));
    previewPanel = new wxZphotoPanel(basicPanel, -1);
    infoLabel = new wxZphotoInfoLabel(basicPanel, -1, _("Size:\nDate:"), wxDefaultPosition, wxDefaultSize, wxST_NO_AUTORESIZE);
    infoContentLabel = new wxZphotoInfoContentLabel(basicPanel, -1, _("800x600\n2004-01-01 01:23:45"), wxDefaultPosition, wxDefaultSize, wxST_NO_AUTORESIZE);
    includeOriginalCheckBox = new wxCheckBox(advancedPanel, -1, _("Include original image files"));
    sequentialCheckBox = new wxCheckBox(advancedPanel, -1, _("Use serial numbers for output file names"));
    sortByFilenameCheckBox = new wxCheckBox(advancedPanel, -1, _("Sort by file name"));
    disableCaptionsCheckBox = new wxCheckBox(advancedPanel, -1, _("Disable captions"));
    noExifCheckBox = new wxCheckBox(advancedPanel, -1, _("Don't use EXIF's date information"));
    advancedPanelLine = new wxStaticLine(advancedPanel, -1);
    photoWidthLabel = new wxStaticText(advancedPanel, -1, _("Output photo width"));
    photoWidthSpinCtrl = new wxZphotoSpinCtrl(advancedPanel, -1, "1234", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 2048);
    flashSizeLabel = new wxStaticText(advancedPanel, -1, _("Flash size"));
    flashWidthSpinCtrl = new wxZphotoSpinCtrl(advancedPanel, -1, "1234", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 2048);
    flashHeightSpinCtrl = new wxZphotoSpinCtrl(advancedPanel, -1, "1234", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 1, 2048);
    gammaLabel = new wxStaticText(advancedPanel, -1, _("Gamma correction"));
    gammaTextCtrl = new wxZphotoTextCtrl(advancedPanel, Textctrl_Gamma, _("1.2345"));
    templateDirectoryLabel = new wxStaticText(advancedPanel, -1, _("Template directory"));
    templateDirectoryTextCtrl = new wxTextCtrl(advancedPanel, -1, wxT(""));
    templateDirectoryButton = new wxButton(advancedPanel, Button_Template_Directory, _("Choose..."));
    flashFontLabel = new wxStaticText(advancedPanel, -1, _("Flash Font"));
    flashFontTextCtrl = new wxTextCtrl(advancedPanel, -1, wxT(""));
    flashFontButton = new wxButton(advancedPanel, Button_Flash_Font, _("Choose..."));
    bacgroundColorLabel = new wxStaticText(colorsPanel, -1, _("Background"));
    backgroundColorButton = new wxButton(colorsPanel, Button_Background_Color, wxT(""));
    borderActiveColorLabel = new wxStaticText(colorsPanel, -1, _("Active photo's border"));
    borderActiveColorButton = new wxButton(colorsPanel, Button_Border_Active_Color, wxT(""));
    borderActiveColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    opacityLabel = new wxStaticText(colorsPanel, -1, _("percent of opacity"));
    borderInactiveColorLabel = new wxStaticText(colorsPanel, -1, _("Inactive photo's border"));
    borderInactiveColorButton = new wxButton(colorsPanel, Button_Border_Inactive_Color, wxT(""));
    borderInactiveColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    shadoColorLabel = new wxStaticText(colorsPanel, -1, _("Shadow"));
    shadowColorButton = new wxButton(colorsPanel, Button_Shadow_Color, wxT(""));
    shadowColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    captionBorderColorLabel = new wxStaticText(colorsPanel, -1, _("Caption border"));
    captionBorderColorButton = new wxButton(colorsPanel, Button_Caption_Border_Color, wxT(""));
    captionBorderColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    captionFrameColorLabel = new wxStaticText(colorsPanel, -1, _("Caption frame"));
    captionFrameColorButton = new wxButton(colorsPanel, Button_Caption_Frame_Color, wxT(""));
    captionFrameColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    captionTextColorLabel = new wxStaticText(colorsPanel, -1, _("Caption text"));
    captionTextColorButton = new wxButton(colorsPanel, Button_Caption_Text_Color, wxT(""));
    captionTextColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    progressBarColorLabel = new wxStaticText(colorsPanel, -1, _("Progress bar"));
    progressBarColorButton = new wxButton(colorsPanel, Button_Progress_Bar_Color, wxT(""));
    progressBarColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    progressBarTextColorLabel = new wxStaticText(colorsPanel, -1, _("Progress bar text"));
    progressBarTextColorButton = new wxButton(colorsPanel, Button_Progress_Bar_Text_Color, wxT(""));
    progressBarTextColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    progressBarHousingColorLabel = new wxStaticText(colorsPanel, -1, _("Progress bar housing"));
    progressBarHousingColorButton = new wxButton(colorsPanel, Button_Progress_Bar_Housing_Color, wxT(""));
    progressBarHousingColorSpinCtrl = new wxZphotoSpinCtrl(colorsPanel, -1, "100", wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 100);
    colorPanelLine = new wxStaticLine(colorsPanel, -1);
    resetColorsButton = new wxButton(colorsPanel, Button_Reset_Colors, _("Reset to the template's default"));
    cssBacgroundColorLabel = new wxStaticText(cssColorsPanel, -1, _("Background"));
    cssBackgroundColorButton = new wxButton(cssColorsPanel, Button_CSS_Background_Color, wxT(""));
    cssTextColorLabel = new wxStaticText(cssColorsPanel, -1, _("Text"));
    cssTextColorButton = new wxButton(cssColorsPanel, Button_CSS_Text_Color, wxT(""));
    cssFooterColorLabel = new wxStaticText(cssColorsPanel, -1, _("Footer"));
    cssFooterColorButton = new wxButton(cssColorsPanel, Button_CSS_Footer_Color, wxT(""));
    cssHorizontalLineColorLabel = new wxStaticText(cssColorsPanel, -1, _("Horizontal line"));
    cssHorizontalLineColorButton = new wxButton(cssColorsPanel, Button_CSS_Horizontal_Line_Color, wxT(""));
    cssPhotoBorderColorLabel = new wxStaticText(cssColorsPanel, -1, _("Photo border"));
    cssPhotoBorderColorButton = new wxButton(cssColorsPanel, Button_CSS_Photo_Border_Color, wxT(""));
    cssThumbnailBorderLabel = new wxStaticText(cssColorsPanel, -1, _("Thumbnail border"));
    cssThumbnailBorderColorButton = new wxButton(cssColorsPanel, Button_CSS_Thumbnail_Border_Color, wxT(""));
    cssNaviLinkColorLabel = new wxStaticText(cssColorsPanel, -1, _("Navigation link"));
    cssNaviLinkColorButton = new wxButton(cssColorsPanel, Button_CSS_Navi_Link_Color, wxT(""));
    cssNaviVisitedColorLabel = new wxStaticText(cssColorsPanel, -1, _("Navigation link (visited)"));
    cssNaviVisitedColorButton = new wxButton(cssColorsPanel, Button_CSS_Navi_Visited_Color, wxT(""));
    cssNaviBorderColorLabel = new wxStaticText(cssColorsPanel, -1, _("Navigation border"));
    cssNaviBorderColorButton = new wxButton(cssColorsPanel, Button_CSS_Navi_Border_Color, wxT(""));
    cssNaviHoverColorLabel = new wxStaticText(cssColorsPanel, -1, _("Navigation surface (focused)"));
    cssNaviHoverColorButton = new wxButton(cssColorsPanel, Button_CSS_Navi_Hover_Color, wxT(""));
    cssColorPanelLine = new wxStaticLine(cssColorsPanel, -1);
    cssResetColorsButton = new wxButton(cssColorsPanel, Button_CSS_Reset_Colors, _("Reset to the template's default"));

    set_properties();
    do_layout();
    // end wxGlade

    // begin byHand
    SetIcon(wxICON(wxzphoto));

    colorData.SetChooseFull(TRUE);
    for (int i = 0; i < 16; i++) {
        wxColour color(i*16, i*16, i*16);
        colorData.SetCustomColour(i, color);
    }
    SetDropTarget(new DnDFile(inputFilesListBox));
    lastVisitedDirectory = "";

    previewPanel->SetPreviewSize(previewWidth, previewHeight);
    previewPanel->Subscribe(inputFilesListBox);
    statusBar->Subscribe(inputFilesListBox);
    infoLabel->Subscribe(previewPanel);
    infoContentLabel->Subscribe(previewPanel);

    CollectFiles();
    ImportConfig();
    // end byHand
}

void wxZphotoFrame::set_properties()
{
    // begin wxGlade: wxZphotoFrame::set_properties
    SetTitle(_("zphoto"));
    inputFilesListBox->SetSize(wxSize(130, -1));
    inputFilesListBox->SetSelection(0);
    createButton->Enable(false);
    photoWidthLabel->SetToolTip(_("output photos are resized to the width"));
    photoWidthSpinCtrl->SetSize(wxSize(60, -1));
    flashSizeLabel->SetToolTip(_("Set the flash size by width and height."));
    flashWidthSpinCtrl->SetSize(wxSize(60, -1));
    flashHeightSpinCtrl->SetSize(wxSize(60, -1));
    gammaLabel->SetToolTip(_("acceptable range is 0 to 10"));
    gammaTextCtrl->SetSize(wxSize(40, -1));
    borderActiveColorSpinCtrl->SetSize(wxSize(50, -1));
    borderInactiveColorSpinCtrl->SetSize(wxSize(50, -1));
    shadowColorSpinCtrl->SetSize(wxSize(50, -1));
    captionBorderColorSpinCtrl->SetSize(wxSize(50, -1));
    captionFrameColorSpinCtrl->SetSize(wxSize(50, -1));
    captionTextColorSpinCtrl->SetSize(wxSize(50, -1));
    progressBarColorSpinCtrl->SetSize(wxSize(50, -1));
    progressBarTextColorSpinCtrl->SetSize(wxSize(50, -1));
    progressBarHousingColorSpinCtrl->SetSize(wxSize(50, -1));
    // end wxGlade

    // begin byHand
    // FIXME: Set it manually because wxGlade couldn't set it.
    previewPanel->SetSize(wxSize(previewWidth, previewHeight));
    // end byHand
}


void wxZphotoFrame::do_layout()
{
    // begin wxGlade: wxZphotoFrame::do_layout
    wxBoxSizer* mainSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* centerSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* cssColorPanelMainSizer = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* cssColorSizer = new wxFlexGridSizer(10, 2, 0, 0);
    wxBoxSizer* colorPanelMainSizer = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* colorSizer = new wxFlexGridSizer(10, 4, 0, 0);
    wxBoxSizer* advancedSizer = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* advancedBottomSizer = new wxFlexGridSizer(5, 2, 0, 0);
    wxBoxSizer* flashFontSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* templateDirectorySizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* flashSizeSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* advancedTopSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* basicSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* basicBottomSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* basicButtomSizer2 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* previewSizer = new wxStaticBoxSizer(new wxStaticBox(basicPanel, -1, _("Preview")), wxHORIZONTAL);
    wxFlexGridSizer* basicTopSizer = new wxFlexGridSizer(4, 2, 0, 0);
    wxBoxSizer* outputDirectorySizer = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* leftSizer = new wxStaticBoxSizer(new wxStaticBox(leftPanel, -1, _("Input Files")), wxHORIZONTAL);
    leftSizer->Add(inputFilesListBox, 0, wxALL|wxEXPAND, 4);
    leftPanel->SetAutoLayout(true);
    leftPanel->SetSizer(leftSizer);
    leftSizer->Fit(leftPanel);
    leftSizer->SetSizeHints(leftPanel);
    centerSizer->Add(leftPanel, 0, wxALL|wxEXPAND, 4);
    basicSizer->Add(0, 8, 0, 0, 0);
    basicTopSizer->Add(titleLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    basicTopSizer->Add(titleTextCtrl, 1, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL, 4);
    basicTopSizer->Add(outputDirectoryLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    outputDirectorySizer->Add(outputDirectoryTextCtrl, 2, wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL, 4);
    outputDirectorySizer->Add(outputDirectoryButton, 1, wxRIGHT|wxTOP|wxBOTTOM|wxALIGN_CENTER_VERTICAL, 0);
    basicTopSizer->Add(outputDirectorySizer, 0, wxEXPAND, 0);
    basicTopSizer->Add(20, 20, 0, 0, 0);
    basicTopSizer->Add(20, 20, 0, 0, 0);
    basicSizer->Add(basicTopSizer, 0, wxEXPAND, 0);
    basicBottomSizer->Add(basicPanelLine, 0, wxALL|wxEXPAND, 4);
    basicBottomSizer->Add(createButton, 0, wxTOP|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 8);
    basicBottomSizer->Add(1, 1, 1, 0, 0);
    previewSizer->Add(previewPanel, 0, wxALL|wxEXPAND, 4);
    basicButtomSizer2->Add(previewSizer, 0, wxALL, 8);
    basicButtomSizer2->Add(infoLabel, 0, wxBOTTOM|wxALIGN_BOTTOM, 16);
    basicButtomSizer2->Add(8, 0, 0, 0, 0);
    basicButtomSizer2->Add(infoContentLabel, 1, wxBOTTOM|wxALIGN_BOTTOM, 16);
    basicBottomSizer->Add(basicButtomSizer2, 0, wxEXPAND, 0);
    basicSizer->Add(basicBottomSizer, 1, wxEXPAND, 0);
    basicPanel->SetAutoLayout(true);
    basicPanel->SetSizer(basicSizer);
    basicSizer->Fit(basicPanel);
    basicSizer->SetSizeHints(basicPanel);
    advancedSizer->Add(0, 8, 0, 0, 0);
    advancedTopSizer->Add(includeOriginalCheckBox, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedTopSizer->Add(sequentialCheckBox, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedTopSizer->Add(sortByFilenameCheckBox, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedTopSizer->Add(disableCaptionsCheckBox, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedTopSizer->Add(noExifCheckBox, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedTopSizer->Add(advancedPanelLine, 0, wxALL|wxEXPAND, 4);
    advancedSizer->Add(advancedTopSizer, 0, wxEXPAND, 0);
    advancedBottomSizer->Add(photoWidthLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedBottomSizer->Add(photoWidthSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedBottomSizer->Add(flashSizeLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    flashSizeSizer->Add(flashWidthSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    flashSizeSizer->Add(flashHeightSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedBottomSizer->Add(flashSizeSizer, 1, wxEXPAND, 0);
    advancedBottomSizer->Add(gammaLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedBottomSizer->Add(gammaTextCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    advancedBottomSizer->Add(templateDirectoryLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    templateDirectorySizer->Add(templateDirectoryTextCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    templateDirectorySizer->Add(templateDirectoryButton, 0, wxRIGHT|wxTOP|wxBOTTOM|wxALIGN_CENTER_HORIZONTAL, 4);
    advancedBottomSizer->Add(templateDirectorySizer, 1, wxEXPAND, 0);
    advancedBottomSizer->Add(flashFontLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    flashFontSizer->Add(flashFontTextCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    flashFontSizer->Add(flashFontButton, 0, wxRIGHT|wxTOP|wxBOTTOM|wxALIGN_CENTER_VERTICAL, 4);
    advancedBottomSizer->Add(flashFontSizer, 1, wxEXPAND, 0);
    advancedSizer->Add(advancedBottomSizer, 1, wxEXPAND, 0);
    advancedPanel->SetAutoLayout(true);
    advancedPanel->SetSizer(advancedSizer);
    advancedSizer->Fit(advancedPanel);
    advancedSizer->SetSizeHints(advancedPanel);
    colorPanelMainSizer->Add(0, 8, 0, 0, 0);
    colorSizer->Add(bacgroundColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(backgroundColorButton, 0, wxALL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(borderActiveColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(borderActiveColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(borderActiveColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(opacityLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 2);
    colorSizer->Add(borderInactiveColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(borderInactiveColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(borderInactiveColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(shadoColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(shadowColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(shadowColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(captionBorderColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(captionBorderColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(captionBorderColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(captionFrameColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(captionFrameColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(captionFrameColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(captionTextColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(captionTextColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(captionTextColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(progressBarColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(progressBarColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(progressBarColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(progressBarTextColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(progressBarTextColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(progressBarTextColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorSizer->Add(progressBarHousingColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(progressBarHousingColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(progressBarHousingColorSpinCtrl, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    colorSizer->Add(0, 0, 0, 0, 0);
    colorPanelMainSizer->Add(colorSizer, 0, wxEXPAND, 0);
    colorPanelMainSizer->Add(colorPanelLine, 0, wxALL|wxEXPAND, 4);
    colorPanelMainSizer->Add(resetColorsButton, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 4);
    colorsPanel->SetAutoLayout(true);
    colorsPanel->SetSizer(colorPanelMainSizer);
    colorPanelMainSizer->Fit(colorsPanel);
    colorPanelMainSizer->SetSizeHints(colorsPanel);
    cssColorPanelMainSizer->Add(0, 8, 0, 0, 0);
    cssColorSizer->Add(cssBacgroundColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssBackgroundColorButton, 0, wxALL, 4);
    cssColorSizer->Add(cssTextColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssTextColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssFooterColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssFooterColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssHorizontalLineColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssHorizontalLineColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssPhotoBorderColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssPhotoBorderColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssThumbnailBorderLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssThumbnailBorderColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviLinkColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviLinkColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviVisitedColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviVisitedColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviBorderColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviBorderColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviHoverColorLabel, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorSizer->Add(cssNaviHoverColorButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 4);
    cssColorPanelMainSizer->Add(cssColorSizer, 0, wxEXPAND, 0);
    cssColorPanelMainSizer->Add(cssColorPanelLine, 0, wxALL|wxEXPAND, 4);
    cssColorPanelMainSizer->Add(cssResetColorsButton, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 4);
    cssColorsPanel->SetAutoLayout(true);
    cssColorsPanel->SetSizer(cssColorPanelMainSizer);
    cssColorPanelMainSizer->Fit(cssColorsPanel);
    cssColorPanelMainSizer->SetSizeHints(cssColorsPanel);
    rightNotebook->AddPage(basicPanel, _("Basic"));
    rightNotebook->AddPage(advancedPanel, _("Advanced"));
    rightNotebook->AddPage(colorsPanel, _("Flash Colors"));
    rightNotebook->AddPage(cssColorsPanel, _("Page Colors"));
    centerSizer->Add(new wxNotebookSizer(rightNotebook), 1, wxALL|wxEXPAND, 4);
    mainPanel->SetAutoLayout(true);
    mainPanel->SetSizer(centerSizer);
    centerSizer->Fit(mainPanel);
    centerSizer->SetSizeHints(mainPanel);
    mainSizer->Add(mainPanel, 1, wxEXPAND, 0);
    SetAutoLayout(true);
    SetSizer(mainSizer);
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);
    Layout();
    // end wxGlade
}



class wxZphotoApp: public wxApp {
public:
    bool OnInit();
};

IMPLEMENT_APP(wxZphotoApp)

bool wxZphotoApp::OnInit()
{
    wxInitAllImageHandlers();
    wxZphotoFrame* main_frame = new wxZphotoFrame(0, -1, "");
    SetTopWindow(main_frame);
    main_frame->Show();
    return true;
}

// begin byHand
void wxZphotoStatusBar::UpdateMessage()
{
    wxString message = defaultMessage;
    int count = inputFilesListBox->GetCount();
    if (count == 1) {
        message = zphoto_asprintf(_("1 file is targeted"));
    } else if (count > 1) {
        message = zphoto_asprintf(_("%d files are targeted"), count);
    } 
    SetStatusText(message, 0);
}

void wxZphotoStatusBar::Update(wxZphotoSubject* subject)
{
    assert(inputFilesListBox == subject);
    UpdateMessage();
    Refresh();
}

void wxZphotoStatusBar::Subscribe(wxZphotoSubject* subject)
{
    inputFilesListBox = (wxZphotoListBox *)subject;
    subject->Attach(this);
}

void wxZphotoInfoLabel::Update(wxZphotoSubject* subject)
{
    assert(previewPanel == subject);
    if (previewPanel->IsInputFileSelected()) {
        Show();
    } else {
        Hide();
    }
}

void wxZphotoInfoLabel::Subscribe(wxZphotoSubject* subject)
{
    previewPanel = (wxZphotoPanel *)subject;
    subject->Attach(this);
}

void wxZphotoInfoContentLabel::Update(wxZphotoSubject* subject)
{
    assert(previewPanel == subject);

    if (previewPanel->IsInputFileSelected()) {
        wxString filename = previewPanel->GetInputFileName();
        wxSize   size     = previewPanel->GetOriginalSize();

        wxZphotoFrame *frame = (wxZphotoFrame *)wxTheApp->GetTopWindow();
        int no_exif = frame->IsNoExif();

        time_t time = zphoto_image_get_time(filename.c_str(),
                                            no_exif);
        char *info = zphoto_asprintf("%dx%d\n%s", 
                                     size.GetWidth(), size.GetHeight(), 
                                     zphoto_time_string(time));
        SetLabel(info);
        Show();
        free(info);
    } else {
        Hide();
    }
}

void wxZphotoInfoContentLabel::Subscribe(wxZphotoSubject* subject)
{
    previewPanel = (wxZphotoPanel *)subject;
    subject->Attach(this);
}

void wxZphotoSpinCtrl::OnFocusLost(wxFocusEvent& WXUNUSED(event))
{
    // Reset values to clear an invalid value.
    SetValue(GetValue());
}

void wxZphotoTextCtrl::OnFocusGot(wxFocusEvent& WXUNUSED(event))
{
    previousValue = GetValue();
}

void wxZphotoTextCtrl::OnFocusLost(wxFocusEvent& WXUNUSED(event))
{
    char *err;
    wxString value = GetValue();
    double val = strtod(value, &err);
    if (*err != '\0' || val < 0 || val > 10 ) { // invalid value
        SetValue(previousValue);
    } else {
        previousValue = value;
    }
}

static void
xprintf_wx (const char *fmt, va_list args)
{
    char *error = "";
    if (fmt[0] != '\0' && fmt[strlen(fmt)-1] == ':')
	error = zphoto_asprintf(" %s", strerror(errno));

    int buflen = BUFSIZ + strlen(error);
    char *buf = (char *)zphoto_emalloc(buflen);

    vsnprintf(buf, buflen, fmt, args);
    strcat(buf, error);
    wxMessageBox(buf, "zphoto", wxICON_ERROR);
}

void
chdir_to_program_directory (void)
{
    char *program_file_name = zphoto_get_program_file_name();
    char *program_directory = zphoto_dirname(program_file_name);
    chdir(program_directory);
    free(program_file_name);
    free(program_directory);
}

void wxZphotoFrame::ZphotoInit()
{
    char current_dir[BUFSIZ];
    getcwd(current_dir, BUFSIZ);
    initial_dir = zphoto_strdup(current_dir);

    // To use files in the directory where the program file exists.
    if (zphoto_platform_w32_p())
        chdir_to_program_directory();

    zphoto_init_magick();
    zphoto_set_xprintf(xprintf_wx);

    zphotoConfig = zphoto_config_new();
    zphoto_config_read_rcfile(zphotoConfig);
    zphoto_config_parse(zphotoConfig, wxTheApp->argc, wxTheApp->argv);
}

void wxZphotoFrame::CollectFiles()
{
    for (int i = 0; i < zphotoConfig->nargs; i++) {
        char *file_name = zphotoConfig->args[i];
        if (zphoto_platform_w32_p() && zphoto_directory_p(initial_dir)) {
            // FIXME: the value will never be freed.
            file_name = zphoto_expand_path(zphotoConfig->args[i],
                                           initial_dir);
        }
        if (zphoto_supported_file_p(file_name))
            inputFilesListBox->Append(file_name);
    }
}

void wxZphotoFrame::ImportColor(const char *colorString,
                                wxButton *button,
                                wxZphotoSpinCtrl *spinctrl)
{
    int r, g, b, a;
    zphoto_decode_color_string(colorString, &r, &g, &b, &a);
    wxColour color(r, g, b);
    button->SetBackgroundColour(color);
    if (spinctrl != NULL)
        spinctrl->SetValue(a * 100 / 255);
}

void wxZphotoFrame::ImportConfig()
{
    // FIXME: The values will never be freed.
    char *tmp_output_dir   = zphoto_expand_path(zphotoConfig->output_dir, NULL);
    char *tmp_template_dir = zphoto_expand_path(zphotoConfig->template_dir, NULL);

    // For passing absolute paths to wxDialog.
    outputDirectoryTextCtrl->SetValue(tmp_output_dir);
    templateDirectoryTextCtrl->SetValue(tmp_template_dir);

    titleTextCtrl->SetValue(zphotoConfig->title);
    flashFontTextCtrl->SetValue(zphotoConfig->flash_font);
    noExifCheckBox->SetValue(zphotoConfig->no_exif != 0);
    includeOriginalCheckBox->SetValue(zphotoConfig->include_original != 0);
    disableCaptionsCheckBox->SetValue(zphotoConfig->disable_captions != 0);
    sequentialCheckBox->SetValue(zphotoConfig->sequential != 0);
    sortByFilenameCheckBox->SetValue(zphotoConfig->sort_by_filename != 0);

    photoWidthSpinCtrl->SetValue(zphotoConfig->photo_width);
    flashWidthSpinCtrl->SetValue(zphotoConfig->flash_width);
    flashHeightSpinCtrl->SetValue(zphotoConfig->flash_height);

    // FIXME: The value will never be freed.
    char *gamma = zphoto_asprintf("%.2f", zphotoConfig->gamma);
    gammaTextCtrl->SetValue(gamma);

    ImportColor(zphotoConfig->background_color,
                backgroundColorButton, 
                NULL);
    ImportColor(zphotoConfig->border_active_color,
                borderActiveColorButton, 
                borderActiveColorSpinCtrl);
    ImportColor(zphotoConfig->border_inactive_color,
                borderInactiveColorButton, 
                borderInactiveColorSpinCtrl);
    ImportColor(zphotoConfig->shadow_color,
                shadowColorButton, 
                shadowColorSpinCtrl);
    ImportColor(zphotoConfig->caption_border_color,
                captionBorderColorButton, 
                captionBorderColorSpinCtrl);
    ImportColor(zphotoConfig->caption_frame_color,
                captionFrameColorButton, 
                captionFrameColorSpinCtrl);
    ImportColor(zphotoConfig->caption_text_color,
                captionTextColorButton, 
                captionTextColorSpinCtrl);
    ImportColor(zphotoConfig->progress_bar_color,
                progressBarColorButton, 
                progressBarColorSpinCtrl);
    ImportColor(zphotoConfig->progress_bar_text_color,
                progressBarTextColorButton, 
                progressBarTextColorSpinCtrl);
    ImportColor(zphotoConfig->progress_bar_housing_color,
                progressBarHousingColorButton, 
                progressBarHousingColorSpinCtrl);

    ImportColor(zphotoConfig->css_background_color,
                cssBackgroundColorButton, NULL);
    ImportColor(zphotoConfig->css_text_color,
                cssTextColorButton, NULL);
    ImportColor(zphotoConfig->css_footer_color,
                cssFooterColorButton, NULL);
    ImportColor(zphotoConfig->css_horizontal_line_color,
                cssHorizontalLineColorButton, NULL);
    ImportColor(zphotoConfig->css_photo_border_color,
                cssPhotoBorderColorButton, NULL);
    ImportColor(zphotoConfig->css_thumbnail_border_color,
                cssThumbnailBorderColorButton, NULL);
    ImportColor(zphotoConfig->css_navi_link_color,
                cssNaviLinkColorButton, NULL);
    ImportColor(zphotoConfig->css_navi_visited_color,
                cssNaviVisitedColorButton, NULL);
    ImportColor(zphotoConfig->css_navi_border_color,
                cssNaviBorderColorButton, NULL);
    ImportColor(zphotoConfig->css_navi_hover_color,
                cssNaviHoverColorButton, NULL);
}

void wxZphotoFrame::ExportColor(char **colorString,
                                wxButton *button,
                                wxZphotoSpinCtrl *spinctrl)
{
    int alpha = -1;
    if (spinctrl != NULL)
        alpha = spinctrl->GetValue() * 255 / 100;

    wxColour color = button->GetBackgroundColour();
    // FIXME: the value will not be freed.
    *colorString = zphoto_encode_color_string(color.Red(), 
                                              color.Green(), 
                                              color.Blue(),
                                              alpha);
}

void wxZphotoFrame::ExportConfig(void)
{
    // FIXME: strdup'ed values will never be freed.
    zphotoConfig->title = 
        zphoto_strdup(titleTextCtrl->GetValue().c_str());
    zphotoConfig->output_dir = 
        zphoto_strdup(outputDirectoryTextCtrl->GetValue().c_str());
    zphotoConfig->no_exif = noExifCheckBox->GetValue();
    zphotoConfig->include_original = includeOriginalCheckBox->GetValue();
    zphotoConfig->disable_captions = disableCaptionsCheckBox->GetValue();
    zphotoConfig->sequential = sequentialCheckBox->GetValue();
    zphotoConfig->sort_by_filename = sortByFilenameCheckBox->GetValue();

    zphotoConfig->photo_width = photoWidthSpinCtrl->GetValue();
    zphotoConfig->flash_width = flashWidthSpinCtrl->GetValue();
    zphotoConfig->flash_height= flashHeightSpinCtrl->GetValue();

    zphotoConfig->template_dir = 
        zphoto_strdup(templateDirectoryTextCtrl->GetValue().c_str());
    zphotoConfig->flash_font = 
        zphoto_strdup(flashFontTextCtrl->GetValue().c_str());

    zphotoConfig->gamma = atof(gammaTextCtrl->GetValue().c_str());

    ExportColor(&zphotoConfig->background_color,
                backgroundColorButton, 
                NULL);
    ExportColor(&zphotoConfig->border_active_color,
                borderActiveColorButton, 
                borderActiveColorSpinCtrl);
    ExportColor(&zphotoConfig->border_inactive_color,
                borderInactiveColorButton, 
                borderInactiveColorSpinCtrl);
    ExportColor(&zphotoConfig->shadow_color,
                shadowColorButton, 
                shadowColorSpinCtrl);
    ExportColor(&zphotoConfig->caption_border_color,
                captionBorderColorButton, 
                captionBorderColorSpinCtrl);
    ExportColor(&zphotoConfig->caption_frame_color,
                captionFrameColorButton, 
                captionFrameColorSpinCtrl);
    ExportColor(&zphotoConfig->caption_text_color,
                captionTextColorButton, 
                captionTextColorSpinCtrl);
    ExportColor(&zphotoConfig->progress_bar_color,
                progressBarColorButton, 
                progressBarColorSpinCtrl);
    ExportColor(&zphotoConfig->progress_bar_text_color,
                progressBarTextColorButton, 
                progressBarTextColorSpinCtrl);
    ExportColor(&zphotoConfig->progress_bar_housing_color,
                progressBarHousingColorButton, 
                progressBarHousingColorSpinCtrl);

    ExportColor(&zphotoConfig->css_background_color,
                cssBackgroundColorButton, NULL);
    ExportColor(&zphotoConfig->css_text_color,
                cssTextColorButton, NULL);
    ExportColor(&zphotoConfig->css_footer_color,
                cssFooterColorButton, NULL);
    ExportColor(&zphotoConfig->css_horizontal_line_color,
                cssHorizontalLineColorButton, NULL);
    ExportColor(&zphotoConfig->css_photo_border_color,
                cssPhotoBorderColorButton, NULL);
    ExportColor(&zphotoConfig->css_thumbnail_border_color,
                cssThumbnailBorderColorButton, NULL);
    ExportColor(&zphotoConfig->css_navi_link_color,
                cssNaviLinkColorButton, NULL);
    ExportColor(&zphotoConfig->css_navi_visited_color,
                cssNaviVisitedColorButton, NULL);
    ExportColor(&zphotoConfig->css_navi_border_color,
                cssNaviBorderColorButton, NULL);
    ExportColor(&zphotoConfig->css_navi_hover_color,
                cssNaviHoverColorButton, NULL);
}

bool wxZphotoFrame::IsNoExif()
{
    return noExifCheckBox->GetValue();
}



void wxZphotoPanel::Attach(wxZphotoObserver* observer)
{
    observers.Append((wxObject *)observer);
}

void wxZphotoPanel::Notify()
{
    wxNode *node = observers.GetFirst();
    while (node) {
        wxZphotoObserver *observer = (wxZphotoObserver *)node->GetData();
        observer->Update(this);
        node = node->GetNext();
    }
}

void wxZphotoPanel::Update(wxZphotoSubject* subject)
{
    assert(inputFilesListBox == subject);
    Refresh();
}

void wxZphotoPanel::Subscribe(wxZphotoSubject* subject)
{
    inputFilesListBox = (wxZphotoListBox *)subject;
    subject->Attach(this);
}

void wxZphotoPanel::SetPreviewSize(int width, int height)
{
    previewWidth  = width;
    previewHeight = height;
}

void wxZphotoPanel::ClearPreview(wxDC &dc)
{
    // FIXME: We cannot do this because wxGTK2 uses white to
    // clear the panel and it's too misery.
    // dc.Clear(); 

    dc.SetPen(*wxTRANSPARENT_PEN);
    wxBrush brush(GetBackgroundColour(), wxSOLID);
    dc.SetBrush(brush);
    dc.DrawRectangle(0, 0, previewWidth, previewHeight);
}

wxBitmap* wxZphotoPanel::ResizeImage(wxBitmap bitmap)
{
    int resizedWidth, resizedHeight;
    if (bitmap.GetWidth() > bitmap.GetHeight()) {
        double scale  = (double)previewWidth / bitmap.GetWidth();
        resizedWidth  = previewWidth;
        resizedHeight = (int)((double)bitmap.GetHeight() * scale);
    } else {
        double scale  = (double)previewHeight / bitmap.GetHeight();
        resizedWidth  = (int)((double)bitmap.GetWidth() * scale);
        resizedHeight = previewHeight;
    }
    wxImage image = bitmap.ConvertToImage();
    return new wxBitmap(image.Scale(resizedWidth, resizedHeight));
}

void wxZphotoPanel::DrawLoadingMessage(wxDC &dc)
{
    wxString message = _("loading...");
    // dc.SetFont(wxFont(10, wxSWISS, wxNORMAL, wxBOLD));
    wxCoord w, h;
    dc.GetTextExtent(message, &w, &h);
    dc.DrawText(message, (previewWidth - w) / 2, 
                (previewHeight - h) / 2);
}

bool wxZphotoPanel::IsInputFileSelected()
{
    int index = inputFilesListBox->GetSelection();
    return inputFilesListBox->Selected(index);
}

wxString wxZphotoPanel::GetInputFileName()
{
    assert(IsInputFileSelected() == true);
    int index = inputFilesListBox->GetSelection();
    return inputFilesListBox->GetInputFile(index);
}

wxBitmap* wxZphotoPanel::GetThumbnail()
{
    wxString filename = GetInputFileName();
    return (wxBitmap *)thumbnails.Get(filename.c_str());
}

wxSize wxZphotoPanel::GetOriginalSize()
{
    wxString filename = GetInputFileName();
    wxSize *size = (wxSize *)originalSizes.Get(filename.c_str());

    return *size;
}

wxBitmap GetBitmap (wxString filename)
{
    if (zphoto_movie_file_p(filename.c_str())) {
        int width, height;
        unsigned char *bare_bitmap = 
            zphoto_image_get_bitmap(filename.c_str(), &width, &height);
        wxImage image = wxImage(width, height, bare_bitmap, FALSE);
        return wxBitmap(image);
    } else {
        return wxBitmap(filename, wxBITMAP_TYPE_ANY);
    }
}

void wxZphotoPanel::OnPaint(wxPaintEvent &event)
{
    wxPaintDC dc(this);
    assert(inputFilesListBox != NULL);

    if (IsInputFileSelected()) {
        wxBitmap *thumbnail = GetThumbnail();
        if (thumbnail == NULL) {
            wxString filename = GetInputFileName();
            DrawLoadingMessage(dc);
            wxBitmap bitmap = GetBitmap(filename);
            thumbnail = ResizeImage(bitmap);
            thumbnails.Put(filename.c_str(), thumbnail);

            wxSize *size = new wxSize(bitmap.GetWidth(), bitmap.GetHeight());
            originalSizes.Put(filename.c_str(), (wxObject *)size);
        }
        ClearPreview(dc);
        int x = (previewWidth  - thumbnail->GetWidth())  / 2;
        int y = (previewHeight - thumbnail->GetHeight()) / 2;
        dc.DrawBitmap(*thumbnail, x, y);
    } else {
        ClearPreview(dc);
    }
    Notify();
}

void wxZphotoFrame::OnUpdateUIHasFiles(wxUpdateUIEvent& event)
{
    event.Enable(inputFilesListBox->GetCount() > 0);
}

void wxZphotoFrame::OnUpdateUIIsSelected(wxUpdateUIEvent& event)
{
    int n = inputFilesListBox->GetSelection();
    event.Enable(inputFilesListBox->Selected(n));
}

void wxZphotoFrame::OnMenuClose(wxMenuEvent& event)
{
    statusBar->UpdateMessage();
}

void
not_found(wxString &message, const char *path, const char *name)
{
    char *tmp = zphoto_asprintf(_("%s is not found\n%s\n\n"), name, path);
    message.Append(tmp);
    free(tmp);
}

bool wxZphotoFrame::ConfirmOverwrite()
{
    wxMessageDialog 
        dialog(NULL,
               _("Output directory is not empty.\nDo you want to overwrite it?"),
               _("Confirm"), wxNO_DEFAULT|wxYES_NO|wxICON_WARNING);
    switch (dialog.ShowModal())
    {
    case wxID_YES:
        return true;
    case wxID_NO:
        return false;
    default:
        return false;
    }
}

bool wxZphotoFrame::EnsureOutputDirectoryIsSane()
{
    if (!zphoto_path_exist_p(zphotoConfig->output_dir)) {
        return true;
    } else if (zphoto_directory_p(zphotoConfig->output_dir)) {
        if (zphoto_directory_empty_p(zphotoConfig->output_dir)) {
            return true;
        } else {
            return ConfirmOverwrite();
        }
    } else {
        wxMessageBox("Unable to create the output directory",
                     _("Error"), wxICON_ERROR);
        return false;
    }
}

bool wxZphotoFrame::EnsureAllPathsAreSane()
{
    wxString message = "";

    if (!zphoto_directory_p(zphotoConfig->template_dir))
        not_found(message, zphotoConfig->template_dir, "Template directory");

    if (!zphoto_file_p(zphotoConfig->flash_font))
        not_found(message, zphotoConfig->flash_font, "Flash font");

    if (message.IsEmpty()) {
        return EnsureOutputDirectoryIsSane();
    } else {
        wxMessageBox(message, _("Error"), wxICON_ERROR);
        return false;
    }
}


void wxZphotoFrame::OnCreatePhotoAlbum(wxCommandEvent& WXUNUSED(event))
{
    assert(inputFilesListBox->GetCount() > 0);

    ExportConfig();
    if (EnsureAllPathsAreSane()) {
        wxZphotoProgressDialog* progressDialog = 
            new wxZphotoProgressDialog(this, -1, "");

        wxArrayString inputFiles;
        for (int i = 0; i < inputFilesListBox->GetCount(); i++) {
            inputFiles.Add(inputFilesListBox->GetInputFile(i));
        }

        // FIXME: the value will never be freed.
        char *indexPath = zphoto_asprintf("%s%c%s", 
                                          zphotoConfig->output_dir,
                                          zphoto_path_separator(),
                                          "index.html");
        progressDialog->Start(zphotoConfig, inputFiles, indexPath);
    }
}

static char *
make_pattern_internal (char *pattern, char *separator, 
                       char *description, char **suffixes)
{
    char *wildcard  = zphoto_strdup("");
    for (char *sep = "", **p = suffixes; *p; p++) {
        char *prev_wildcard = wildcard;
        wildcard = zphoto_asprintf("%s%s*.%s", wildcard, sep, *p);
        free(prev_wildcard);
        sep = ";";
    }
    char *prev_pattern = pattern;
    pattern = zphoto_asprintf("%s%s%s (%s)|%s", 
                              pattern, separator, description,
                              wildcard, wildcard);
    free(prev_pattern);
    return pattern;
}

static char *
make_pattern ()
{
    char *pattern = zphoto_strdup("");
    if (zphoto_support_image_p()) {
        pattern = make_pattern_internal(pattern, "",
                                        (char *) _("Image files"),
                                        zphoto_get_image_suffixes());
    }
    if (zphoto_support_movie_p()) {
        pattern = make_pattern_internal(pattern, "|", 
                                        (char*)_("Movie files"),
                                        zphoto_get_movie_suffixes());
    }
    return pattern;
}

void wxZphotoFrame::OpenInputFiles()
{
    char *pattern = make_pattern();
    wxFileDialog dialog(this, _("Choose one or more files"), 
                        lastVisitedDirectory, "",
                        pattern);
    dialog.SetStyle(wxMULTIPLE); // Open multiple files

    if(dialog.ShowModal() == wxID_OK) {
        wxArrayString paths;
        dialog.GetPaths(paths);
        size_t count = paths.GetCount();
        for (size_t i = 0; i < count; i++) {
            inputFilesListBox->Append(paths[i]);
        }
        lastVisitedDirectory = dialog.GetDirectory();
    }
    free(pattern);
}

void wxZphotoFrame::OnOpenFile(wxCommandEvent& WXUNUSED(event))
{
    OpenInputFiles();
}

wxString wxZphotoFrame::OpenDirectoryGeneric(wxString default_dir)
{
    if (default_dir.IsEmpty())
        default_dir = lastVisitedDirectory;

    wxDirDialog dialog(this, _("Choose a directory"), default_dir);
    if (dialog.ShowModal() == wxID_OK) {
        wxString path = dialog.GetPath();
        return path;
    } else {
        return "";
    }
}

void wxZphotoFrame::OnChooseFlashFont(wxCommandEvent& WXUNUSED(event))
{
    wxString default_dir = zphoto_dirname(flashFontTextCtrl->GetValue());
    wxFileDialog dialog(this, _("Choose a flash font"), default_dir,
                        "", "FDB file (*.fdb)|*.fdb");
    if(dialog.ShowModal() == wxID_OK) {
        flashFontTextCtrl->SetValue(dialog.GetPath());
    }
}

void wxZphotoFrame::OpenInputDirectory()
{
    wxString directory = OpenDirectoryGeneric();
    if (!directory.IsEmpty()) {
        wxArrayString paths;
        // don't recurse sub directories.
        size_t count = wxDir::GetAllFiles(directory, &paths, "",
                                          wxDIR_DEFAULT ^ wxDIR_DIRS);
        for (size_t i = 0; i < count; i++) {
            if (zphoto_supported_file_p(paths[i]))
                inputFilesListBox->Append(paths[i]);
        }
        lastVisitedDirectory = directory;
    }
}

void wxZphotoFrame::OnOpenDirectory(wxCommandEvent& WXUNUSED(event))
{
    OpenInputDirectory();
}

void wxZphotoFrame::OnClearSelected(wxCommandEvent& WXUNUSED(event))
{
    inputFilesListBox->DeleteSelectedItem();
}

void wxZphotoFrame::OnClearAll(wxCommandEvent& WXUNUSED(event))
{
    inputFilesListBox->Clear();
}

void wxZphotoFrame::OnChooseTemplateDirectory(wxCommandEvent& WXUNUSED(event))
{
    wxString default_dir = templateDirectoryTextCtrl->GetValue();
    wxString directory = OpenDirectoryGeneric(default_dir);
    if (!directory.IsEmpty())
        templateDirectoryTextCtrl->SetValue(directory);
}

void wxZphotoFrame::OnChooseOutputDirectory(wxCommandEvent& WXUNUSED(event))
{
    wxString default_dir = outputDirectoryTextCtrl->GetValue();
    wxString directory = OpenDirectoryGeneric(default_dir);
    if (!directory.IsEmpty())
        outputDirectoryTextCtrl->SetValue(directory);
}

void wxZphotoFrame::OnQuit(wxCommandEvent& WXUNUSED(event))
{
    Close(TRUE);
}

void wxZphotoFrame::OnClose(wxCloseEvent& event)
{
    ExportConfig();
    zphoto_config_save_rcfile(zphotoConfig);
    zphoto_finalize_magick();
    event.Skip();
}

void wxZphotoFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
    wxMessageBox(_("zphoto " VERSION
                   "\n\nCopyright (C) 2002-2004 Satoru Takabayashi"),
                 _("About zphoto"),
                 wxICON_INFORMATION);
}

void wxZphotoFrame::OnResetFlashColors(wxCommandEvent& WXUNUSED(event))
{
    ExportConfig();
    zphoto_config_reset_flash_colors(zphotoConfig);
    ImportConfig();
    Refresh();
}

void wxZphotoFrame::OnResetCSSColors(wxCommandEvent& WXUNUSED(event))
{
    ExportConfig();
    zphoto_config_reset_css_colors(zphotoConfig);
    ImportConfig();
    Refresh();
}

void wxZphotoFrame::ChooseColorGeneric(wxButton* button)
{
    wxColour col = button->GetBackgroundColour();
    colorData.SetColour(col);

    wxColourDialog dialog(this, &colorData);
    dialog.SetTitle(_("Choose a color"));
    if (dialog.ShowModal() == wxID_OK) {
        wxColourData retData = dialog.GetColourData();
        col = retData.GetColour();
        colorData = retData;  // to save custom palette.
        button->SetBackgroundColour(col);
        button->Refresh();
    }
}

void wxZphotoFrame::OnChooseBackgroundColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(backgroundColorButton); }

void wxZphotoFrame::OnChooseBorderActiveColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(borderActiveColorButton); }

void wxZphotoFrame::OnChooseBorderInactiveColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(borderInactiveColorButton); }

void wxZphotoFrame::OnChooseShadowColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(shadowColorButton); }

void wxZphotoFrame::OnChooseCaptionBorderColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(captionBorderColorButton); }

void wxZphotoFrame::OnChooseCaptionFrameColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(captionFrameColorButton); }

void wxZphotoFrame::OnChooseCaptionTextColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(captionTextColorButton); }

void wxZphotoFrame::OnChooseProgressBarColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(progressBarColorButton); }

void wxZphotoFrame::OnChooseProgressBarTextColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(progressBarTextColorButton); }

void wxZphotoFrame::OnChooseProgressBarHousingColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(progressBarHousingColorButton); }



void wxZphotoFrame::OnChooseCSSBackgroundColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssBackgroundColorButton); }

void wxZphotoFrame::OnChooseCSSTextColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssTextColorButton); }

void wxZphotoFrame::OnChooseCSSFooterColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssFooterColorButton); }

void wxZphotoFrame::OnChooseCSSHorizontalLineColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssHorizontalLineColorButton); }

void wxZphotoFrame::OnChooseCSSPhotoBorderColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssPhotoBorderColorButton); }

void wxZphotoFrame::OnChooseCSSThumbnailBorderColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssThumbnailBorderColorButton); }

void wxZphotoFrame::OnChooseCSSNaviLinkColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssNaviLinkColorButton); }

void wxZphotoFrame::OnChooseCSSNaviVisitedColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssNaviVisitedColorButton); }

void wxZphotoFrame::OnChooseCSSNaviBorderColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssNaviBorderColorButton); }

void wxZphotoFrame::OnChooseCSSNaviHoverColor(wxCommandEvent& WXUNUSED(event))
{ ChooseColorGeneric(cssNaviHoverColorButton); }


// end byHand


wxZphotoProgressDialog::wxZphotoProgressDialog(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxDialog(parent, id, title, pos, size, wxDEFAULT_DIALOG_STYLE)
{
    // begin wxGlade: wxZphotoProgressDialog::wxZphotoProgressDialog
    progressPanel = new wxPanel(this, -1);
    progressStatusLabel = new wxStaticText(progressPanel, -1, _("Current task"));
    progressBarCurrent = new wxGauge(progressPanel, -1, 100, wxDefaultPosition, wxDefaultSize, wxGA_HORIZONTAL|wxGA_PROGRESSBAR|wxGA_SMOOTH);
    progressStatusLabelTotal = new wxStaticText(progressPanel, -1, _("Total progress"));
    progressBarTotal = new wxGauge(progressPanel, -1, 100, wxDefaultPosition, wxDefaultSize, wxGA_HORIZONTAL|wxGA_PROGRESSBAR|wxGA_SMOOTH);
    launchCheckBox = new wxCheckBox(progressPanel, -1, _("Launch a browser"));
    progressOKButton = new wxButton(progressPanel, Button_Progress_OK, _("OK"));

    set_properties();
    do_layout();
    // end wxGlade

    // begin byHand
    busyP = false;
    // end byHand
}


void wxZphotoProgressDialog::set_properties()
{
    // begin wxGlade: wxZphotoProgressDialog::set_properties
    SetTitle(_("Creating a photo album..."));
    progressBarCurrent->SetSize(wxSize(-1, 14));
    progressBarTotal->SetSize(wxSize(-1, 14));
    launchCheckBox->SetValue(1);
    // end wxGlade
}


void wxZphotoProgressDialog::do_layout()
{
    // begin wxGlade: wxZphotoProgressDialog::do_layout
    wxBoxSizer* progressMainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* progressCenterSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* progressBottomSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* progressBarSizer = new wxBoxSizer(wxVERTICAL);
    progressBarSizer->Add(progressStatusLabel, 0, wxLEFT|wxRIGHT|wxTOP|wxALIGN_CENTER_VERTICAL, 8);
    progressBarSizer->Add(0, 4, 0, 0, 0);
    progressBarSizer->Add(progressBarCurrent, 0, wxLEFT|wxRIGHT|wxEXPAND, 8);
    progressBarSizer->Add(progressStatusLabelTotal, 0, wxLEFT|wxRIGHT|wxTOP|wxALIGN_CENTER_VERTICAL, 8);
    progressBarSizer->Add(0, 4, 0, 0, 0);
    progressBarSizer->Add(progressBarTotal, 0, wxLEFT|wxRIGHT|wxEXPAND, 8);
    progressCenterSizer->Add(progressBarSizer, 1, wxEXPAND, 0);
    progressBottomSizer->Add(launchCheckBox, 0, wxALL|wxALIGN_CENTER_VERTICAL, 8);
    progressBottomSizer->Add(40, 0, 0, 0, 0);
    progressBottomSizer->Add(progressOKButton, 0, wxALL|wxALIGN_CENTER_VERTICAL, 8);
    progressCenterSizer->Add(progressBottomSizer, 0, 0, 0);
    progressPanel->SetAutoLayout(true);
    progressPanel->SetSizer(progressCenterSizer);
    progressCenterSizer->Fit(progressPanel);
    progressCenterSizer->SetSizeHints(progressPanel);
    progressMainSizer->Add(progressPanel, 1, 0, 0);
    SetAutoLayout(true);
    SetSizer(progressMainSizer);
    progressMainSizer->Fit(this);
    progressMainSizer->SetSizeHints(this);
    Layout();
    // end wxGlade

    // begin byHand
    disableOtherWindows = new wxWindowDisabler(this);
    // end byHand
}

// begin byHand
char** wxZphotoProgressDialog::ConvertArrayString(wxArrayString arrayString)
{
    char **strings = (char **)zphoto_emalloc(sizeof(char *) * arrayString.GetCount());
    for (size_t i = 0; i < arrayString.GetCount(); i++)
        strings[i] = zphoto_strdup(arrayString[i].c_str());
    return strings;
}

void wxZphotoProgressDialog::FreeStrings(char **strings, size_t n)
{
    for (size_t i = 0; i < n; i++)
        free(strings[i]);
    free(strings);
}

void wxZphotoProgressDialog::OnClose(wxCloseEvent& event)
{
    delete disableOtherWindows;
    if (busyP) {
        zphoto_abort(zphoto);
        event.Skip();
        // No need to confirm...
        // if (wxMessageBox(_("Do you really want to cancel?"),
        //                  _("Confirm"), 
        //                  wxYES_NO | wxICON_QUESTION) == wxYES )
        // {
        //     zphoto_abort(zphoto);
        //     event.Skip();
        // } else {
        //     event.Veto();
        // }
    } else {
        event.Skip();
    }
}

void wxZphotoProgressDialog::OnOK(wxCommandEvent& WXUNUSED(event))
{
    if (launchCheckBox->GetValue()) {
        zphoto_launch_browser(indexPath);
    }
    Close();
}

void wxZphotoProgressDialog::UpdateStatus(ZphotoProgress *progress)
{
    char *status = zphoto_asprintf(_("%s: %s"),
                                   _(progress->task_long),
                                   progress->file_name);
    
    progressBarCurrent->SetValue(progress->current);
    progressBarTotal->SetValue(total + progress->current);
    progressStatusLabel->SetLabel(status);
    free(status);

    if (progress->is_finished)
        total += progress->current;
}

static void
progress_gui (ZphotoProgress *progress)
{
    wxZphotoProgressDialog *dialog =
        (wxZphotoProgressDialog *)progress->data;
    dialog->UpdateStatus(progress);
    wxTheApp->Yield();
}

void wxZphotoProgressDialog::Start(ZphotoConfig *config, 
                                   wxArrayString files,
                                   const char *path)
{
    indexPath = zphoto_strdup(path);

    if (!zphoto_support_browser_p()) {
        launchCheckBox->Hide();
    }

    total = 0;
    progressOKButton->Disable();
    progressBarCurrent->SetRange(files.GetCount());
    Show();

    inputFiles = ConvertArrayString(files);
    zphoto = zphoto_new(config);

    progressBarTotal->SetRange(files.GetCount() * zphoto_get_nsteps(zphoto));

    busyP = true;
    zphoto_add_file_names(zphoto, inputFiles, files.GetCount());
    zphoto_set_progress(zphoto, progress_gui, this);
    zphoto_make_all(zphoto);
    busyP = false;

    zphoto_destroy(zphoto);
    FreeStrings(inputFiles, files.GetCount());

    progressOKButton->Enable();
    SetTitle(_("A photo album is created!"));
}
// end byHand


