/*
 * Copyright (c) 1997, Mark Buser.
 * Copyright (c) 2001, 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/view.c,v 1.9 2004/03/11 21:56:00 danny Exp $
 */
#include <Xm/XmAll.h>
#include "xutil.h"

#ifdef	XQUOTE
#include "xquote.h"
#else
#include "xinvest.h"
#endif

/* Select table or tape view */
extern Widget Tape, Container, Menubar, Mainform, StatusForm;

static void viewWindowSet ( int which )
{
  static Dimension twidth = 0, theight;
  static Dimension swidth = 0, sheight;
  static Dimension cwidth = 0, cheight;

  fprintf(stderr, "viewWindowSet(%d)\n", which);
  AllowShellResize (per->Toplevel, ALLOW);

  if ( which == 1) {
    /* -tape, there may be no Scroll, else clause should not fire */
    if (Container) {
      XtVaGetValues(per->Toplevel,
	XmNheight, &sheight,
	XmNwidth, &swidth,
	NULL);
      XtVaGetValues(Container,
	XmNheight, &cheight,
	XmNwidth, &cwidth,
	NULL);
      XmMainWindowSetAreas(Mainform, Menubar, StatusForm, NULL, NULL, Tape);
      XtUnmanageChild(Container);
      XtManageChild(Tape);
    }

    if (twidth) {
      XtVaSetValues(per->Toplevel, XmNheight, theight, XmNwidth, twidth, NULL);
      fprintf(stderr, "Set TL height %d width %d\n", theight, twidth);
    }

  } else {
    XtVaGetValues(per->Toplevel, XmNheight, &theight, XmNwidth, &twidth, NULL);

    if (swidth) {
      XtVaSetValues(per->Toplevel, XmNheight, sheight, XmNwidth, swidth, NULL);
      AllowShellResize (per->Toplevel, DISALLOW);
      XtVaSetValues(Container, XmNheight, cheight, XmNwidth, cwidth, NULL);
    }

    XmMainWindowSetAreas(Mainform, Menubar, StatusForm, NULL, NULL, Container);
    XtUnmanageChild(Tape);
    XtManageChild(Container);
  }

  AllowShellResize (per->Toplevel, DISALLOW);
}

static void viewButtonSet (Widget parent, int which)
{
  WidgetList buttons;
  int numbuttons;

  XtVaGetValues ( parent, 
                  XmNchildren, &buttons,
                  XmNnumChildren, &numbuttons,
		  NULL );
  for (numbuttons--; numbuttons >= 0; numbuttons--)
    XmToggleButtonSetState ( buttons[numbuttons], 
                             (which == numbuttons)?True:False, 
                             False );
}

/* ARGSUSED */
void viewCB ( Widget w, int which, XtPointer call_data)
{
  viewButtonSet (XtParent(w), which);
  viewWindowSet (which);
}

int viewGet ()
{
  if (XtIsManaged(Tape))
    return (1);
  else
    return (0);
}

void viewSet ( int which )
{
  extern Widget Viewmenu;

  if (Viewmenu)
    viewButtonSet ( Viewmenu, which );
  viewWindowSet ( which );
}


