/*
 * Copyright (c) 1997, 2000, Mark Buser.
 * Copyright (c) 2001, 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/color.h,v 1.9 2003/11/19 19:35:09 danny Exp $
 */
#ifndef COLOR_H
#define COLOR_H

/* List of colors we allocate, names used by internal routines */
enum {
	USER0,  /* defined in app defaults */
	USER1,
	USER2,
	USER3,
	USER4,
	USER5,
	USER6,
	USER7,
	RED,    /* defined in app defaults, but we always need */
	GREEN, 
	GREY,
	WHITE,
	BLACK,
	PRINT_FOREGROUND,
	PRINT_BACKGROUND,
	PRINT_ILLUSTRATIONS,

	LAST_COLOR		/* Do not add anything after this */
} Colors;

#define COLOR_NUM (USER7+1)
#define COLOR_DEF (LAST_COLOR)

struct PerDisplay;

Colormap InitColor( Widget, Colormap, Pixel * );
Colormap NewColormap( Display *, Colormap );
Colormap GetColormap();
Pixel    GetColor( int );      /* Get named color from color table */
Pixel	GetNamedColor(struct PerDisplay *per, String name);
int isColorVisual (Display *); /* Return true if visual implies color */
int isDarkPixel (Display *, Pixel);

void AllocateAllColors(void);
#endif
