/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CALLBACK_FUNC_H
#define CALLBACK_FUNC_H     1

#include "shared.h"
#include <gtk/gtk.h>

/* callback_func.c */
gboolean Save_Pixbuf(gpointer save_data);
void Main_Window_Delete(void);
void New_Activate(void);
void Open_Input_Activate(void);
void Main_Save_Activate(int *saveas_width, int *saveas_height);
void Optimizer_Output_Toggled(GtkMenuItem *menuitem);
void Quit_Activate(void);
void On_Main_Rdpattern_Activate(GtkMenuItem *menuitem);
void On_Main_Plots_Activate(GtkMenuItem *menuitem);
void Common_Projection_Activate(GtkMenuItem *menuitem);
void Main_Freq_Spinbutton_Value_Changed(GtkSpinButton *spinbutton);
void Plots_Window_Delete(void);
void Plots_Save_Activate(int *saveas_width, int *saveas_height);
void Rdpattern_Window_Delete(void);
void Rdpattern_Save_Activate(int *saveas_width, int *saveas_height);
void Rdpattern_Freq_Spinbutton_Value_Changed(GtkSpinButton *spinbutton);
void Quit_Okbutton_Clicked(void);
void Nec2_Save_Dialog_Response(gint response_id);
void Nec2_Row_Add_Clicked(void);
void New_Viewer_Angle(double wr, double wi, GtkSpinButton *wr_spb, GtkSpinButton *wi_spb, projection_parameters_t *params);
void Motion_Event(GdkEventMotion *event, projection_parameters_t *params);
void Plot_Select(GtkToggleButton *togglebutton, unsigned long long int flag);
gboolean Nec2_Edit_Save(void);
void Delete_Event(gchar *mesg);
void Set_Pol_Menuitem(int window);
gboolean Open_Editor(GtkTreeView *view);
void Card_Clicked(GtkWidget **editor, GtkBuilder **editor_builder, GtkWidget *create_fun(GtkBuilder **), void editor_fun(int), int *editor_action);
void Main_Rdpattern_Activate(gboolean from_menu);
gboolean Main_Plots_Activate(void);
void Rdpattern_Gain_Togglebutton_Toggled(gboolean flag);
void Rdpattern_EH_Togglebutton_Toggled(gboolean flag);
void Main_Currents_Togglebutton_Toggled(gboolean flag);
void Main_Charges_Togglebutton_Toggled(gboolean flag);
GtkWidget *Open_Filechooser(GtkFileChooserAction action, char *pattern, const char *prefix, char *filename, char *foldername);
void Filechooser_Response(GtkDialog *dialog, gint response_id, int saveas_width, int saveas_height);
void Open_Nec2_Editor(int action);
gboolean Nec2_Apply_Checkbutton(void);
void Gtk_Quit(void);
void Pass_EH_Flags(void);
void Draw_Colorcode(cairo_t *cr);
void Gtk_Widget_Destroy(GtkWidget **widget);

#endif

