/*
 * Copyright (c) 1997, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/remoteXi.c,v 1.4 2004/05/01 14:09:53 danny Exp $
 */
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "account.h"

#define XINVEST_VERSION_PROP   "_XINVEST_VERSION"
#define XINVEST_COMMAND_PROP   "_XINVEST_COMMAND"
#define XINVEST_RESPONSE_PROP  "_XINVEST_RESPONSE"

static Atom XA_XINVEST_VERSION  = 0;
static Atom XA_XINVEST_COMMAND  = 0;
static Atom XA_XINVEST_RESPONSE = 0;

/* ARGSUSED */
static void remoteCommand (Widget shell, XtPointer client_data, 
                           XPropertyEvent *event)
{
  Display *dpy = XtDisplay(shell);
  Window win = XtWindow(shell);
  int status;
  Atom actual_type;
  int actual_format;
  unsigned long nitems, bytes_after;
  unsigned char *data = 0;

  char response[80];

  if (event->atom != XA_XINVEST_COMMAND)
    return;

  strcpy ( response, "500 Invalid command."); 

  status = XGetWindowProperty (dpy, win, XA_XINVEST_COMMAND,
                                   0, (65536 / sizeof (long)),
                                   True, /* delete */
                                   XA_STRING,
                                   &actual_type, &actual_format,
                                   &nitems, &bytes_after,
                                   &data);
  if (status == Success && data && *data) {
    char ticker[12];
    int month, day, year;
    double nav;

    /* "NAV ticker mm/dd/yyyy dd.dd" */
    status = sscanf ( (char *)data, "NAV %11s %d/%d/%d %lf", 
                      &(ticker[0]), &month, &day, &year, &nav);
    if (status == 5)
      strcpy ( response, "200 Ok."); 

    /* Do something useful, not found ticker is ok. */
    if ( !accountMatchTicker( ticker, month, day, year, nav) )
      strcpy ( response, "201 Ticker not found."); 

    XChangeProperty (dpy, win, XA_XINVEST_RESPONSE, XA_STRING, 8,
                     PropModeReplace, (unsigned char *) response,
                     strlen (response));
  }
}


void remoteInit (Widget Toplevel)
{
  Display *dpy = XtDisplay (Toplevel);
  Window win = XtWindow (Toplevel);
  char *version = "2.6";

  if (! XA_XINVEST_VERSION)
    XA_XINVEST_VERSION = XInternAtom (dpy, XINVEST_VERSION_PROP, False);
  if (! XA_XINVEST_COMMAND)
    XA_XINVEST_COMMAND = XInternAtom (dpy, XINVEST_COMMAND_PROP, False);
  if (! XA_XINVEST_RESPONSE)
    XA_XINVEST_RESPONSE = XInternAtom (dpy, XINVEST_RESPONSE_PROP, False);

  XtAddEventHandler (Toplevel, PropertyChangeMask, False, 
                     (XtEventHandler)remoteCommand, NULL);

  XChangeProperty (dpy, win, XA_XINVEST_VERSION, XA_STRING, 8,
                   PropModeReplace, (unsigned char *) version,
                   strlen (version));
}
