/* $Id: window.c,v 4.13 1996/06/16 20:14:55 lupus Exp lupus $ */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include "xfinans.h"
#include "window.h"
#include "konto.h"
#include "post.h"
#include "xfError.h"
#include "country.h"
#include "programConfig.h"

#include "check.h"
#include "search.h"
#include "info.h"
#include "sletKonto.h"
#include "opretKonto.h"
#include "datoPrint.h"
#include "date.h"
#include "icon.h"
#include "saldo.h"
#include "plot.h"
#include "str.h"
#include "flueben.h"
#include "menuMark.h"
#include "config.h"
#include "period.h"
#include "transNum.h"
#include "focus.h"
#include "fileView.h"
#include "displayLimit.h"
#include "category.h"
#include "categoryWindow.h"
#include "displayLimitWindow.h"
#if RECURRING_TRANSFER
#include "recur.h"
extern Boolean RunTransfers();
#endif
  
#define PANE_HEIGHT 30
#define VERTICAL_DIST 5

#define ABSOLUTE(x) ( ((x)<0.0) ? -(x):(x) )
#define MAX(x,y)      ( ((x)>(y)) ? (x):(y) )

/* Table of menu entries. Meaning of table entries:

   Entry text   |  Shown on menu  |  Opcode  |  Menu-id  |  Widget  
   (string)        0 = not shown     (int)      (int)       (Widget)
                   1 = shown
                  -1 = shown as line
*/

menu_item menu_names[] = {
  {PRINT,               1, 0, MAIN_MENU, 0},
  {SEARCH_LABEL,        1, 1, MAIN_MENU, 0},
  {INTEREST_LABEL,      1, 2, MAIN_MENU, 0},
  {PLOT_LABEL,          1, 3, MAIN_MENU, 0},
  {LIST_BALANCES,       1, 4, MAIN_MENU, 0},
#if RECURRING_TRANSFER
  {RECURRING_MENU_LABEL,1, 43, MAIN_MENU, 0},
#endif
  {CATEGORYWINDOW_LABEL,CATEGORY_SUPPORT,39, MAIN_MENU, 0},
/*  {VARIABLES_LABEL,     CATEGORY_SUPPORT,42, MAIN_MENU, 0}, */
  {SET_ZERO,            SET_ZERO_SUPPORT,24, MAIN_MENU, 0},
  {ALL_POSTINGS,        1, 6, CONFIG_MENU, 0},
  {SHOW_COMMIT_BAL,     COMMIT_SUPPORT, 5, CONFIG_MENU, 0},
  {SHOW_TRANS_NUM,      1,38, CONFIG_MENU, 0},
  {SHOW_CAT_NUM,        CATEGORY_SUPPORT, 40, CONFIG_MENU, 0},
  {SHOW_CAT_NAMES,      CATEGORY_SUPPORT, 41, CONFIG_MENU, 0},
  {TWO_COLUMN_AMOUNT,   1,19, CONFIG_MENU, 0},
  {"Line",             -1,17, CONFIG_MENU, 0},
  {DATE_FORMAT,         !CATEGORY_SUPPORT,18, CONFIG_MENU, 0},
  {"yymmdd",            1, 7, CONFIG_MENU, 0},
  {"ddmmyy",            0, 8, CONFIG_MENU, 0},
  {"mmddyy",            0, 9, CONFIG_MENU, 0},
  {"dd/mm/yy",          (LANGUAGE==DANISH),10, CONFIG_MENU, 0},
  {"mm/dd/yy",          (LANGUAGE!=DANISH),11, CONFIG_MENU, 0},
  {USER_DEFINED,        USER_DEFINED_DATE_SUPPORT, 25, CONFIG_MENU, 0},
  {"Line",             -1,20, CONFIG_MENU, 0},
  {PRINT_COMMAND,       1,21, CONFIG_MENU, 0},
  {POSTSCRIPT_LABEL,    1,22, CONFIG_MENU, 0},
  {ASCII_TEXT_LABEL,    1,23, CONFIG_MENU, 0},
  {"Line",             -1,20, CONFIG_MENU, 0},
  {DISPLAY_RANGE,       1,44, CONFIG_MENU, 0},
  {"Line",             -1,20, CONFIG_MENU, 0},
  {NUMBER_OF_DECIMALS,  1,29, CONFIG_MENU, 0},
  {"Line",             -1,15, CONFIG_MENU, 0},
  {SAVE_CONFIG,         1,16, CONFIG_MENU, 0},
  {DAY_MON_YEAR,        1,26, DATE_FORMAT_MENU, 0},
  {MON_DAY_YEAR,        1,27, DATE_FORMAT_MENU, 0},
  {YEAR_MON_DAY,        1,28, DATE_FORMAT_MENU, 0},
  {"Line",             -1,30, DATE_FORMAT_MENU, 0},
  {FOUR_DIGIT_YEAR,     1,31, DATE_FORMAT_MENU, 0},

  {DAY_LABEL,           1,32, TRANSACTION_UNIT_MENU, 0},
  {WEEK_LABEL,          1,33, TRANSACTION_UNIT_MENU, 0},
  {PAYDAY_LABEL,        1,34, TRANSACTION_UNIT_MENU, 0},
  {MONTH_LABEL,         1,35, TRANSACTION_UNIT_MENU, 0},
  {MONTH_ENDING_LABEL,  1,36, TRANSACTION_UNIT_MENU, 0},
  {YEAR_LABEL,          1,37, TRANSACTION_UNIT_MENU, 0},

  {DAY_LABEL,           1,32, RECUR_UNIT_MENU, 0},
  {WEEK_LABEL,          1,33, RECUR_UNIT_MENU, 0},
  {PAYDAY_LABEL,        1,34, RECUR_UNIT_MENU, 0},
  {MONTH_LABEL,         1,35, RECUR_UNIT_MENU, 0},
  {MONTH_ENDING_LABEL,  1,36, RECUR_UNIT_MENU, 0},
  {YEAR_LABEL,          1,37, RECUR_UNIT_MENU, 0},

  {DAY_LABEL,           1,32, RUN_RECUR_UNIT_MENU, 0},
  {WEEK_LABEL,          1,33, RUN_RECUR_UNIT_MENU, 0},
  {PAYDAY_LABEL,        1,34, RUN_RECUR_UNIT_MENU, 0},
  {MONTH_LABEL,         1,35, RUN_RECUR_UNIT_MENU, 0},
  {MONTH_ENDING_LABEL,  1,36, RUN_RECUR_UNIT_MENU, 0},
  {YEAR_LABEL,          1,37, RUN_RECUR_UNIT_MENU, 0},

  {0,0,0,MAIN_MENU,0}
};

int OvfIsUp;
Pixmap mark, menuButtonMark;

XtAppContext app_context;

extern char floatFormatString[];         /* in config.c */
extern char floatShortFormatString[];    /* in config.c */

Widget pshell, overfor, quit;    
Widget topLevel, vpane, buttonbox1, buttonbox2, 
/* viewports & lists: */
  kontoViewp, postBox, postHeader, postViewp, kontoList, postList, 
  
/* account buttons: */
  valgKonto, opretKonto, sletKontoKnap, 
  dagsDatoLabel,

/* display limit control box */
  displayLimitBox, displayLimitFromLabel, displayLimitFromInput=0, 
  displayLimitToLabel, displayLimitToInput=0, 
  /* displayLimitClearButton, */

/* user defined date format popup */ 
  dateFormatShell, dateFormatForm, dateFormatLabel, 
  dateFormatInput, dateFormatOk, dateFormatMenuButton,
  dateFormatMenu,

/* float format popup */ 
  floatFormatShell, floatFormatForm, floatFormatLabel, 
  floatFormatInput, floatFormatOk, 

/* opret konto-popup */
  opretKonShell,opretKonForm,opretKonFilLabel,opretKonFilIn,
  opretKonNavnLabel,opretKonNavnIn,opretKonKnrLabel,opretKonKnrIn,
  opretKonOk,opretKonCancel,

/* confirm delete account: */
  sletKontoShell, sletKontoForm, 
  sletKontoOk, sletKontoCancel, sletKontoAsk,

/* transaction buttons: */
  nyPost, retPost, sletPost, 
#if COMMIT_SUPPORT
  commitPost, 
#endif
  mainMenuKnap, mainMenu, configMenuButton, configMenu,
  infoKnap,

/* confirm delete transaction: */
  confirmShell, conform, confirm, confirmOk, confirmCancel, 

/* postering-popup: */
  posteringShell, posteringForm, 
  datoLabel, datoIn, dagsDato, plusDato, minusDato, 
  plusPeriod, minusPeriod, periodLabel, periodInput, periodUnit, unitMenu,
  transNumLabel, transNumInput, transNumMax, transNumIncr, transNumDecr,
#if CATEGORY_SUPPORT
  catNumLabel, catNumInput, catNameLabel,
#endif
  tekstLabel, tekstIn, 
  belLabel, belIn, amountSetPos, amountSetNeg,
  postOk, postCancel, postClear,

/* overfoer-popup: */
  ovfShell, ovfForm, 
  ovfFraTil,
  ovfdatoLabel, ovfdatoIn, ovfDagsDato, 
  ovfPlusDato, ovfMinusDato, ovfPlusPeriod, ovfMinusPeriod,
  ovfTransNumLabel, ovfTransNumInput, ovfTransNumMax, 
  ovfTransNumIncr, ovfTransNumDecr,
  ovftekstLabel, ovftekstIn, 
  ovfbelLabel, ovfbelIn, 
  ovfOk, ovfCancel, ovfClearAll, ovfClearText, 

#if EXPERIMENTAL
  skrivCheck,
/* skrivCheck-popup */
  scShell, scForm, scDatoLabel, scDatoIn,
  scTextIn, scBelLabel, scBelIn,
  scOk, scCancel, 
#endif

/* udskriv-popup: */
  udsShell, udsForm, udsLabel, udsInput, udsOk, udsCancel, 
  printerConfigShell, printerConfigForm, printerConfigLabel, 
  printerConfigInput, printerConfigOk,

/* rente-popup: */
  renteShell, renteForm,
  renteDato1Label, renteDato1In,
  renteDato2Label, renteDato2In,
  renteFod1Label,  renteFod1In,
  renteFod2Label,  renteFod2In,
  renteBeregn, renteResult,
  renteTilskriv, renteFortryd; 

static int whoIsPoping;     /* er det ny- eller retPost, der har gang i
			       popup-vinduet? */
int ovfFra=-1, ovfTil=-1;  /* index paa konti, der er valgt i kontoList,
			      ved to paa hinanden foelgende enkeltklik */
static int renteIsPopup=0, udsIsPopup=0;
int postIsPopup=0;
static int postNpress=0, editIndex;
static int printCommandUp=0;

void Quit(w, client_data, call_data)  /* funktionen der bliver kaldt
					 ved tryk paa "quit"-knappen */
Widget w;
XtPointer client_data, call_data;
{
  lukGnuplot();
  unlink("fplot.plt");
  unlink("xf.ps");
  unlink("xf.txt");
  unlink(TRANSACTION_FILE);
  unlink(PERL_OUTPUT_FILE);
  unlink(ENGINE_INIT_FILE);

  exit(0);
}

/*************************  Menu-selection      **************************/

int main_menu_label_to_number(char *label) {
  int i;
  char *item;
  for(i=0; (item=menu_names[i].text)!=0; i++) {
    if(menu_names[i].active>0 && !strcmp(item,label))
      return i;
  }
  return -1;
}

void updateMark(Widget w, int set) {
  if(!w)
    return;
  if(set)
    XtVaSetValues(w, 
		  XtNleftBitmap, mark,
		  NULL);
  else
    XtVaSetValues(w, 
		  XtNleftBitmap, None,
		  NULL);
}

void updateMarkNumber(int number, int set) {
  updateMark(menu_names[number].button, set);
}

void updateMarkWithText(char *text, int set) {
  int i;
  i=main_menu_label_to_number(text);
  if(i<0)
    return;
  updateMarkNumber(i,set);
}

void updateMarksWithOpcode(int opcode, int set) {
  int i;
  for(i=0; menu_names[i].text!=0; i++) {
    if(menu_names[i].opcode==opcode) {
      if(menu_names[i].button!=0)
	updateMark(menu_names[i].button, set);
    }
  }
}

/*
void updateAllMarksOnMenu(int menuID, int set) {
  int i;
  for(i=0; menu_names[i].text!=0; i++) 
    if(menu_names[i].menu==menuID) 
	updateMark(menu_names[i].button, set);
}
*/

void updateMarkOnMenu(int opcode, int menuID, int set) {
  int i;
  for(i=0; menu_names[i].text!=0; i++) {
    if(menu_names[i].opcode==opcode && menu_names[i].menu==menuID) {
      if(menu_names[i].button!=0)
	updateMark(menu_names[i].button, set);
    }
  }
}

int buttonWidgetToMenuID(Widget w) {  /* which menuID does w belong to? */
  int i;                              /* return -1 if w not found */
  for(i=0; menu_names[i].text!=0; i++) 
    if(menu_names[i].button==w) {
      return menu_names[i].menu;
    }
  return -1;
}

void date_format_change() {
  XtVaSetValues(dagsDatoLabel,
		XtNlabel, datoPrint(),	
		NULL);
  setDisplayFromLimit(get_display_before());
  setDisplayToLimit(get_display_after());
  opdaterPostList();
  updateMarkWithText("yymmdd", get_date_format()==yymmdd);
  updateMarkWithText("ddmmyy", get_date_format()==ddmmyy);
  updateMarkWithText("mmddyy", get_date_format()==mmddyy);
  updateMarkWithText("dd/mm/yy", get_date_format()==dd_mm_yy);
  updateMarkWithText("mm/dd/yy", get_date_format()==mm_dd_yy);
  updateMarkWithText(USER_DEFINED, get_date_format()==userdefined);
  updateMarkWithText(YEAR_MON_DAY, getDateOrder()==yymmdd);
  updateMarkWithText(MON_DAY_YEAR, getDateOrder()==mmddyy);
  updateMarkWithText(DAY_MON_YEAR, getDateOrder()==ddmmyy);
}

static void MenuSelect(w, client_data, garbage)
Widget w;
XtPointer client_data;
XtPointer garbage;  /* call_data */
{
  int pane_num = (int) client_data;
  char buf[32];
  int menuID;
  
  switch(pane_num) {
  case 0:          /* PRINT */
    UdsPopup(w,client_data, garbage);
    break;
  case 1:          /* SEARCH */
    SearchPopup(w,client_data, garbage);
    break; 
  case 2:        /* INTEREST */
    Rente(w,client_data, garbage);
    break;
  case 3:        /* PLOT */
    PlotPopup(w,client_data, garbage);
    break;
  case 4:        /* LIST_BALANCES */
    SaldoPopup(w,client_data, garbage);
    break;
  case 5:        /* Show committed */
    updateMark(w,invertShowCommitted());
    opdaterPostList();
    break;       
  case 6:        /* Show all transactions */
    toggle_show_all();
    break;
  case 7:        /* yymmdd */
    set_date_format(yymmdd);
    date_format_change();
    break;
  case 8:        /* ddmmyy */
    set_date_format(ddmmyy);
    date_format_change();
    break;
  case 9:        /* mmddyy */
    set_date_format(mmddyy);
    date_format_change();
    break;
  case 10:       /* dd/mm/yy */
    set_date_format(dd_mm_yy);
    date_format_change();
    break;
  case 11:       /* mm/dd/yy */
    set_date_format(mm_dd_yy);
    date_format_change();
    break;
  case 25:       /* user defined date format */
    XtVaSetValues(dateFormatInput, XtNstring, getDateFormatString(), NULL);
    XtPopup(dateFormatShell, XtGrabNone);
    jumpTo(dateFormatInput);
    set_date_format(userdefined);
    date_format_change();
    break;
  case 16:       /* save configuration */
    save_configuration();
    break;
  case 19:       /* two-column format */
    toggle_two_column();
    updateMarkWithText(TWO_COLUMN_AMOUNT, get_two_column());
    opdaterPostList();
    break;
  case 21:
    printCommandConfigPopup();    
    break;
  case 22:    /* PostScript */
    setPS(1);
    updateMarkWithText(POSTSCRIPT_LABEL, 1);
    updateMarkWithText(ASCII_TEXT_LABEL, 0);
    break;
  case 23:    /* ASCII */
    setPS(0);
    updateMarkWithText(POSTSCRIPT_LABEL, 0);
    updateMarkWithText(ASCII_TEXT_LABEL, 1);
    break;
  case 24:    /* Set bal. to zero */
    toggle_set_zero();
    break;
  case 26:   /* date order ddmmyy */
    setDateOrder(ddmmyy);
    set_date_format(userdefined);
    date_format_change();
    break;
  case 27:   /* date order mmddyy */
    setDateOrder(mmddyy);
    set_date_format(userdefined);
    date_format_change();
    break;
  case 28:   /* date order yymmdd */
    setDateOrder(yymmdd);
    set_date_format(userdefined);
    date_format_change();
    break;
  case 29:   /* number of decimals */
    sprintf(buf, "%d", getFloatFormat());
    XtVaSetValues(floatFormatInput, XtNstring, buf, NULL);
    XtPopup(floatFormatShell, XtGrabNone);
    jumpTo(floatFormatInput);
    break;
  case 31:   /* four digit year */
    toggle_four_digit_year();
    date_format_change();
    break;
  case 32:
    menuID=buttonWidgetToMenuID(w);
    if(menuID>=0) {
      set_period_unit(P_DAY, menuID);
    }
    break;
  case 33:
    menuID=buttonWidgetToMenuID(w);
    if(menuID>=0) {
      set_period_unit(P_WEEK, menuID);
    }
    break;
  case 34:
    menuID=buttonWidgetToMenuID(w);
    if(menuID>=0) {
      set_period_unit(P_PAYDAY, menuID);
    }
    break;
  case 35:
    menuID=buttonWidgetToMenuID(w);
    if(menuID>=0) {
      set_period_unit(P_MONTH, menuID);
    }
    break;
  case 36:
    menuID=buttonWidgetToMenuID(w);
    if(menuID>=0) {
      set_period_unit(P_MONTH_ENDING, menuID);
    }
    break;
  case 37:
    menuID=buttonWidgetToMenuID(w);
    if(menuID>=0) {
      set_period_unit(P_YEAR, menuID);
    }
    break;
  case 38:  /* show transaction numbers */
    toggle_show_trans_numbers();
    opdaterPostList();
    break;
#if CATEGORY_SUPPORT
  case 39: /* show categories */
    CategoryWindowPopup(NULL,NULL,NULL);
    break;
  case 40:  /* show category numbers */
    toggle_show_cat_numbers();
    opdaterPostList();
    break;
  case 41:  /* show category names */
    toggle_show_cat_names();
    opdaterPostList();
    break;
  case 42:  /* show/edit variables */
/*    FileViewDisplay(VARIABLES_FILE_NAME, VARIABLES_LABEL, 1); */
    break;
#endif
#if RECURRING_TRANSFER
  case 43: /* edit recurring transactions */
    EditRecurringTransfers(w,client_data, garbage);
    break;
#endif
  case 44: /* set display date range */
    displayLimitWindowPopup(0,0,0);
    break;
  default:  /* non-existing menu selection */
    break;
  }

/*  printf("Menu item %s has been selected.\n", XtName(w));
*/
}


/*************************  Action-funktioner   **************************/

static void DoQuit(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  Quit(w,0,0);
}

static void doPlotPopup(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  PlotPopup(NULL,NULL,NULL);
}

static void doSaldoPopup(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  SaldoPopup(NULL,NULL,NULL);
}

static void doRentePopup(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  Rente(NULL,NULL,NULL);
}

static void PopupNewTrans(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{ 
  int i;

  if( postIsPopup )
    return;
  
  i=aktKonto();
  if( i<0 ) {
    xfError(ERR_DO_SELECT, NONFATAL, "do select");
    return;
  }
  
  postNpress=0;

  whoIsPoping=NYPOST;
  NyPostCallBack(NULL,NULL,NULL);
}

static void doInterceptReturn(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  confirmAction(w);
}

static void NextAction(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  jumpNext(w);
}

static void PrevAction(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  jumpPrev(w);
}

static void HereAction(w,event,params,num_params)
Widget w;
XButtonEvent *event;
String *params;
Cardinal *num_params;
{
  jumpTo(w);
}

/******************  Menu-creation *********************************/

Widget create_menu(int menuOpcode, char *menuName, Widget activatingButton) {
  Widget res, menuEntry;
  String item;
  int i;

  res = XtCreatePopupShell(menuName,
			   simpleMenuWidgetClass,
			   activatingButton,
			   NULL,0);
  
  for(i=0; (item=menu_names[i].text)!=0; i++) {
    if(menu_names[i].menu==menuOpcode && menu_names[i].active>0) {
      menuEntry = menu_names[i].button = XtVaCreateManagedWidget(item, 
						 smeBSBObjectClass,
						 res, 
						 XtNlabel, item, 
						 XtNleftMargin, 30,
						 NULL);
      XtAddCallback(menuEntry, XtNcallback, MenuSelect, 
		    (XtPointer) menu_names[i].opcode);
    } else if(menu_names[i].menu==menuOpcode && menu_names[i].active==-1) { 
       /* line-entry */
      menuEntry = XtVaCreateManagedWidget(item, 
					  smeLineObjectClass,
					  res, 
					  NULL);
    }
  }
  return res;
}

/************************  mainWindow-function  ***************************/

void mainWindow(argc, argv)
int argc;
char **argv;
{
  static XtActionsRec xf_actions[] = {
    {"doquit", DoQuit},
    {"new-transaction", PopupNewTrans},
    {"plotpopup", doPlotPopup},
    {"interceptReturn", doInterceptReturn},
    {"confirm-action", doInterceptReturn},
    {"next-action", NextAction},
    {"prev-action", PrevAction},
    {"here-action", HereAction},
    {"saldopopup", doSaldoPopup},
    {"button_press", button1pressed}
  };

  static period_call_data transaction_period_call_data;

  int i;
  String item;

/* ===================  Top Level ===================*/
  topLevel = XtVaAppInitialize(
			       &app_context,
			       PNAME,
			       NULL, 0,
			       &argc, argv,
			       NULL,
			       NULL );
  
  vpane = XtVaCreateManagedWidget("vpane", panedWidgetClass, topLevel,
				  XtNwidth, S_WIDTH,
				  XtNheight, S_HEIGHT,
				  NULL);
  
  mark = XCreateBitmapFromData(XtDisplay(topLevel),
			       RootWindowOfScreen(XtScreen(topLevel)),
			       flueben_bits, flueben_width, flueben_height);

  menuButtonMark = XCreateBitmapFromData(XtDisplay(topLevel),
			       RootWindowOfScreen(XtScreen(topLevel)),
			       menuMark_bits, menuMark_width, menuMark_height);

  buttonbox1 = XtVaCreateManagedWidget("buttonbox1", 
				     boxWidgetClass, 
				     vpane, 
				     XtNmin, (Dimension)PANE_HEIGHT,
				     NULL);
  
  createXfinansIcon(topLevel);
  

/* ================= Konto-knapper ====================== */

  valgKonto = XtVaCreateManagedWidget(
				  "valgKonto",
				  commandWidgetClass,
				  buttonbox1,
				  XtNlabel, SELECT,
				  XtNwidth, KONTO_BUTW,
				  NULL);

  opretKonto = XtVaCreateManagedWidget(
				  "opretKonto",
				  commandWidgetClass,
				  buttonbox1,
				  XtNlabel, CREATE_ACCOUNT,
				  XtNwidth, KONTO_BUTW,
				  NULL);

  sletKontoKnap = XtVaCreateManagedWidget(
				  "sletKontoKnap",
				  commandWidgetClass,
				  buttonbox1,
				  XtNlabel, CLOSE_ACCOUNT,
				  XtNwidth, KONTO_BUTW,
				  NULL);

  overfor = XtVaCreateManagedWidget(
				  "overfor",
				  commandWidgetClass,
				  buttonbox1,
				  XtNlabel, TRANSFER,
				  NULL);

  quit = XtVaCreateManagedWidget(
				  "quit",
				  commandWidgetClass,
				  buttonbox1,
				  XtNlabel, QUIT,
				  XtNwidth, KONTO_BUTW,
				  NULL);

  dagsDatoLabel = XtVaCreateManagedWidget(
				  "dagsDatoLabel",
				  labelWidgetClass,
				  buttonbox1,
				  XtNlabel, datoPrint(),	
				  XtNfromHoriz, quit, 
				  XtNhorizDistance, 16,
				  /* XtNright, XtChainRight, */
				  NULL);

/* =======================  Konto liste ============================  */

  kontoViewp = XtVaCreateManagedWidget(
				  "kontoViewp",
				  viewportWidgetClass,
				  vpane,
				  XtNheight, 65,
				  XtNwidth, 440,
				  XtNallowVert, TRUE,
				  NULL);
 
  kontoList = XtVaCreateManagedWidget(
				      "kontoList",
				      listWidgetClass,
				      kontoViewp,
				      XtNlist, kontoStrings(),
				      NULL);

/* ===================  PosteringsKnapper  =============================*/
  buttonbox2 = XtVaCreateManagedWidget("buttonbox2", 
				     boxWidgetClass, 
				     vpane, 
				     XtNmin, (Dimension)PANE_HEIGHT,
				     NULL);

  nyPost = XtVaCreateManagedWidget(
				  "nyPost",
				  commandWidgetClass,
				  buttonbox2,
				  XtNlabel, NEW_POSTING,
				  XtNwidth, POST_BUTW,
				  NULL);

  retPost = XtVaCreateManagedWidget(
				  "retPost",
				  commandWidgetClass,
				  buttonbox2,
				  XtNlabel, EDIT_POSTING,
				  XtNwidth, POST_BUTW,
				  NULL);

  sletPost = XtVaCreateManagedWidget(
				  "sletPost",
				  commandWidgetClass,
				  buttonbox2,
				  XtNlabel, DELETE_POSTING,
				  XtNwidth, POST_BUTW,
				  NULL);

#if COMMIT_SUPPORT
  commitPost = XtVaCreateManagedWidget(
				  "commitPost",
				  commandWidgetClass,
				  buttonbox2,
				  XtNlabel, COMMIT_POST_LABEL,
				  XtNwidth, POST_BUTW,
				  NULL);
#endif
  mainMenuKnap =  XtVaCreateManagedWidget(
					  "mainMenuKnap",
					  menuButtonWidgetClass,
					  buttonbox2,
					  XtNmenuName, "mainMenu",
					  XtNlabel, FUNCTIONS,
					  XtNleftBitmap, menuButtonMark,
					  /* XtNwidth, POST_BUTW+8, */
					  NULL);
  
  mainMenu = create_menu(MAIN_MENU, "mainMenu", mainMenuKnap);

  configMenuButton =  XtVaCreateManagedWidget(
					  "configMenuButton",
					  menuButtonWidgetClass,
					  buttonbox2,
					  XtNmenuName, "configMenu",
					  XtNlabel, CONFIG_MENU_LABEL,
					  XtNleftBitmap, menuButtonMark,
					  NULL);
  
  configMenu = create_menu(CONFIG_MENU, "configMenu", configMenuButton);

  infoKnap = XtVaCreateManagedWidget(
				     "infoKnap",
				     commandWidgetClass,
				     buttonbox2,
				     XtNlabel, HELP,
				     XtNwidth, POST_BUTW,
				     NULL);

/* =======================  PosteringsListe ============================  */


  postBox = XtVaCreateManagedWidget(
				    "postBox",
				    boxWidgetClass,
				    vpane,
				    XtNmin, (Dimension)PANE_HEIGHT-5,
				    XtNmax, (Dimension)PANE_HEIGHT-5,
				    NULL);

  postHeader = XtVaCreateManagedWidget("postHeader",
					labelWidgetClass,
					postBox,
					XtNlabel, "                                                                         ",	
					NULL);

  postViewp = XtVaCreateManagedWidget(
				      "postViewp",
				      viewportWidgetClass,
				      vpane,
				      XtNheight, 165,
				      XtNwidth, 440,
				      XtNallowVert, TRUE,
				      /*XtNfromVert, postHeading,*/
				      /*XtNforceBars, TRUE,*/
				      NULL);
  
  postList = XtVaCreateManagedWidget(
				     "postList",
				     listWidgetClass,
				     postViewp,
				     XtNlist, postStrings(),
				     XtNdefaultColumns, 1,
				     XtNforceColumns, TRUE,
				     XtNpasteBuffer, TRUE,
				     NULL);

  /* =================  Display limit control ======================== */

  displayLimitBox = XtVaCreateManagedWidget("displayLimitBox", 
					    boxWidgetClass, 
					    vpane, 
					    XtNmin, (Dimension)PANE_HEIGHT,
					    XtNmax, (Dimension)PANE_HEIGHT,
					    NULL);

  displayLimitFromLabel = XtVaCreateManagedWidget("displayLimitFromLabel",
						  labelWidgetClass,
						  displayLimitBox,
						  XtNlabel, DISPLAY_LIMIT_FROM,
						  NULL);

  displayLimitFromInput = XtVaCreateManagedWidget(
				   "displayLimitFromInput",
				   asciiTextWidgetClass,
				   displayLimitBox,
				   XtNeditType, XawtextEdit,
				   XtNwidth, DATEWIDTH,
				   NULL);
  
  displayLimitToLabel = XtVaCreateManagedWidget("displayLimitFromLabel",
						  labelWidgetClass,
						  displayLimitBox,
						  XtNlabel, DISPLAY_LIMIT_TO,
						  NULL);

  displayLimitToInput = XtVaCreateManagedWidget(
				   "displayLimitToInput",
				   asciiTextWidgetClass,
				   displayLimitBox,
				   XtNeditType, XawtextEdit,
				   XtNwidth, DATEWIDTH,
				   NULL);

  saveFocusInfo(displayLimitFromInput, displayLimitToInput, vpane, valgKonto, 1);
  saveFocusInfo(displayLimitToInput, displayLimitFromInput, vpane, valgKonto, 0);
  jumpTo(displayLimitFromInput);

/*  displayLimitClearButton = XtVaCreateManagedWidget(
				      "displayLimitClearButton",
				      commandWidgetClass,
				      displayLimitBox,
				      XtNlabel, CLEAR_LABEL,
				      XtNwidth, BUTW,
				      NULL);

  XtAddCallback(displayLimitClearButton, XtNcallback, 
		DisplayLimitClearCallback, 0);
*/
  
  /* =================  Bekraeft slet-post =========================== */
  confirmShell = XtVaCreatePopupShell (
				       "confirmShell",
				       transientShellWidgetClass,
				       topLevel,
				       XtNtitle, WARNING_TITLE,
				       NULL );
  
  conform = XtVaCreateManagedWidget(
				    "conform",
				    formWidgetClass,
				    confirmShell,
				    NULL);
  
  confirm = XtVaCreateManagedWidget(
				    "confirm",
				    labelWidgetClass,
				    conform,
				    XtNlabel, WARNING_TEXT_POST,
				    NULL);

  confirmOk = XtVaCreateManagedWidget(
				      "confirmOk",
				      commandWidgetClass,
				      conform,
				      XtNlabel, CONFIRM_LABEL,
				      XtNwidth, BUTW,
				      XtNfromVert, confirm, 
				      NULL);
  
  confirmCancel = XtVaCreateManagedWidget(
					  "confirmCancel",
					  commandWidgetClass,
					  conform,
					  XtNlabel, CANCEL_LABEL,
					  XtNfromVert, confirm, 
					  XtNfromHoriz, confirmOk, 
					  NULL);
  
  
/*======================  Postering-Popup-vindue  ====================== */
/* rws transaction widget */

  posteringShell = XtVaCreatePopupShell (
					 "posteringShell",
					 transientShellWidgetClass,
					 topLevel,
					 XtNtitle, POSTING_TITLE,
					 NULL );
  
  posteringForm = XtVaCreateManagedWidget(
					  "posteringForm",
					  formWidgetClass,
					  posteringShell,
					  NULL);
  
  datoLabel = XtVaCreateManagedWidget(
				    "datoLabel",
				    labelWidgetClass,
				    posteringForm,
				    XtNlabel, DATE,
				    NULL);

  datoIn = XtVaCreateManagedWidget(
				  "datoIn",
				   asciiTextWidgetClass,
				   posteringForm,
				   XtNeditType, XawtextEdit,
				   XtNwidth, DATEWIDTH,
				   XtNfromHoriz, datoLabel,
				   NULL);
  
  dagsDato = XtVaCreateManagedWidget(
				     "dagsDato",
				     commandWidgetClass,
				     posteringForm,
				     XtNlabel, TODAY,
				     XtNfromHoriz, datoIn,
				     NULL);
  
  plusDato = XtVaCreateManagedWidget(
				     "plusDato",
				     commandWidgetClass,
				     posteringForm,
				     XtNlabel, INCR,
				     XtNwidth, PLUS_BUTW,
				     XtNfromHoriz, dagsDato,
				     NULL);
  
  minusDato = XtVaCreateManagedWidget(
				      "minusDato",
				      commandWidgetClass,
				      posteringForm,
				      XtNlabel, DECR,
				      XtNwidth, PLUS_BUTW,
				      XtNfromHoriz, plusDato,
				      NULL);

  plusPeriod = XtVaCreateManagedWidget(
				    "plusPeriod",
				    commandWidgetClass,
				    posteringForm,
				    XtNlabel, INCR_PERIOD,
				    XtNfromHoriz, minusDato,
				    NULL);
  
  minusPeriod = XtVaCreateManagedWidget(
				     "minusPeriod",
				     commandWidgetClass,
				     posteringForm,
				     XtNlabel, DECR_PERIOD,
				     XtNfromHoriz, plusPeriod,
				     NULL);

  periodLabel = XtVaCreateManagedWidget(
				    "periodLabel",
				    labelWidgetClass,
				    posteringForm,
				    XtNlabel, PERIOD_LABEL,
				    XtNfromHoriz, minusPeriod,
				    NULL);

  periodInput = XtVaCreateManagedWidget(
				  "periodInput",
				   asciiTextWidgetClass,
				   posteringForm,
				   XtNeditType, XawtextEdit,
				   XtNstring, "1",
				   XtNwidth, PERIODWIDTH,
				   XtNfromHoriz, periodLabel,
				   NULL);

  periodUnit =  XtVaCreateManagedWidget(
					"periodUnit",
					menuButtonWidgetClass,
					posteringForm,
					XtNmenuName, "unitMenu",
					XtNlabel, UNIT_LABEL,
					XtNleftBitmap, menuButtonMark,
					XtNfromHoriz, periodInput,
					NULL);

  unitMenu = create_menu(TRANSACTION_UNIT_MENU, "unitMenu", periodUnit);
  set_period_unit(P_MONTH, TRANSACTION_UNIT_MENU); 

  transNumLabel = XtVaCreateManagedWidget(
				     "transNumLabel",
				     labelWidgetClass,
				     posteringForm,
				     XtNlabel, TRANS_NUM_TEXT_LABEL,
				     XtNfromVert, datoIn,
				     XtNvertDistance, VERTICAL_DIST,
				     NULL);

  transNumInput = XtVaCreateManagedWidget(
				    "transNumInput",
				    asciiTextWidgetClass,
				    posteringForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, DATEWIDTH,
				    XtNfromHoriz, transNumLabel,
				    XtNfromVert, datoIn,
				    XtNvertDistance, VERTICAL_DIST,
				    NULL);

  transNumMax = XtVaCreateManagedWidget(
				     "transNumMax",
				     commandWidgetClass,
				     posteringForm,
				     XtNlabel, TRANS_NUM_MAX,
				     /* XtNwidth, PLUS_BUTW, */
				     XtNfromHoriz, transNumInput,
				     XtNfromVert, datoIn,
				     NULL);

  XtAddCallback(transNumMax, XtNcallback, TransNumMax, transNumInput);

  transNumIncr = XtVaCreateManagedWidget(
				     "transNumIncr",
				     commandWidgetClass,
				     posteringForm,
				     XtNlabel, INCR,
				     XtNwidth, PLUS_BUTW,
				     XtNfromHoriz, transNumMax,
				     XtNfromVert, datoIn,
				     NULL);

  XtAddCallback(transNumIncr, XtNcallback, IncrNum, transNumInput);
  
  transNumDecr = XtVaCreateManagedWidget(
				     "transNumDecr",
				     commandWidgetClass,
				     posteringForm,
				     XtNlabel, DECR,
				     XtNwidth, PLUS_BUTW,
				     XtNfromHoriz, transNumIncr,
				     XtNfromVert, datoIn,
				     NULL);
  
  XtAddCallback(transNumDecr, XtNcallback, DecrNum, transNumInput);

#if CATEGORY_SUPPORT
  catNumLabel = XtVaCreateManagedWidget(
				     "catNumLabel",
				     labelWidgetClass,
				     posteringForm,
				     XtNlabel, CAT_NUM_TEXT_LABEL,
				     XtNfromVert, transNumInput,
				     XtNvertDistance, VERTICAL_DIST,
				     NULL);

  catNumInput = XtVaCreateManagedWidget(
				    "catNumInput",
				    asciiTextWidgetClass,
				    posteringForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, DATEWIDTH,
				    XtNfromHoriz, catNumLabel,
				    XtNfromVert, transNumInput,
				    XtNvertDistance, VERTICAL_DIST,
				    NULL);

  catNameLabel = XtVaCreateManagedWidget(
				     "catNameLabel",
				     labelWidgetClass,
				     posteringForm,
				     XtNlabel, "                                       ",
				     XtNjustify, XtJustifyLeft, 
				     XtNresize, False,
				     XtNfromVert, transNumInput,
				     XtNfromHoriz, catNumInput,
				     XtNvertDistance, VERTICAL_DIST,
				     NULL);
#endif

  tekstLabel = XtVaCreateManagedWidget(
				     "tekstLabel",
				     labelWidgetClass,
				     posteringForm,
				     XtNlabel, TEXT_LABEL,
#if CATEGORY_SUPPORT
				     XtNfromVert, catNumLabel,
#else
				     XtNfromVert, transNumLabel,
#endif
				     XtNvertDistance, VERTICAL_DIST,
				     NULL);
  
  tekstIn = XtVaCreateManagedWidget(
				    "tekstIn",
				    asciiTextWidgetClass,
				    posteringForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, POST_TEXT_LENGTH*6+3,
				    XtNfromHoriz, tekstLabel,
#if CATEGORY_SUPPORT
				     XtNfromVert, catNumLabel,
#else
				     XtNfromVert, transNumLabel,
#endif
				    XtNvertDistance, VERTICAL_DIST,
				    NULL);
  
  belLabel = XtVaCreateManagedWidget(
				   "belLabel",
				   labelWidgetClass,
				   posteringForm,
				   XtNlabel, AMOUNT_LABEL,
				   XtNfromVert, tekstLabel,
				   XtNvertDistance, VERTICAL_DIST,
				   NULL);
  
  belIn = XtVaCreateManagedWidget(
				  "belIn",
				  asciiTextWidgetClass,
				  posteringForm,
				  XtNeditType, XawtextEdit,
				  XtNwidth, 10*6+3,
				  XtNfromHoriz, belLabel,
				  XtNfromVert, tekstLabel,
				  XtNvertDistance, VERTICAL_DIST,
				  NULL);

  amountSetPos = XtVaCreateManagedWidget(
				   "amountSetPositive",
				   commandWidgetClass,
				   posteringForm,
				   XtNlabel, AMOUNT_SET_POS_LABEL,
				   /* XtNwidth, BUTW, */
				   XtNfromVert, tekstLabel,
				   XtNvertDistance, VERTICAL_DIST, 
				   XtNfromHoriz, belIn,
				   NULL);

  amountSetNeg = XtVaCreateManagedWidget(
				   "amountSetNegative",
				   commandWidgetClass,
				   posteringForm,
				   XtNlabel, AMOUNT_SET_NEG_LABEL,
				   /* XtNwidth, BUTW, */
				   XtNfromVert, tekstLabel,
				   XtNvertDistance, VERTICAL_DIST,
				   XtNfromHoriz, amountSetPos,
				   NULL);

  XtAddCallback(amountSetNeg, XtNcallback, SetAmountNegative, belIn);
  XtAddCallback(amountSetPos, XtNcallback, SetAmountPositive, belIn);

  postOk = XtVaCreateManagedWidget(
				   "postOk",
				   commandWidgetClass,
				   posteringForm,
				   XtNlabel, CONFIRM_LABEL,
				   XtNwidth, BUTW,
				   XtNfromVert, belIn,
			           XtNvertDistance, VERTICAL_DIST,
				   NULL);
  
  postCancel = XtVaCreateManagedWidget(
				       "postCancel",
				       commandWidgetClass,
				       posteringForm,
				       XtNlabel, CANCEL_LABEL,
				       XtNfromVert, belIn,
				       XtNvertDistance, VERTICAL_DIST,
				       XtNfromHoriz, postOk,
				       NULL);
  
  postClear = XtVaCreateManagedWidget(
				      "postClear",
				      commandWidgetClass,
				      posteringForm,
				      XtNlabel, CLEAR_ALL,
				      XtNfromVert, belIn,
				      XtNvertDistance, VERTICAL_DIST,
				      XtNfromHoriz, postCancel,
				      NULL);
  
  saveFocusInfo(datoIn,  transNumInput, posteringShell, postOk, 1);
#if CATEGORY_SUPPORT
  saveFocusInfo(transNumInput, catNumInput, posteringShell, postOk, 0);
  saveFocusInfo(catNumInput, tekstIn, posteringShell, postOk, 0);
#else
  saveFocusInfo(transNumInput, tekstIn, posteringShell, postOk, 0);
#endif
  saveFocusInfo(tekstIn,         belIn, posteringShell, postOk, 0);
  saveFocusInfo(belIn,     periodInput, posteringShell, postOk, 0);
  saveFocusInfo(periodInput,    datoIn, posteringShell, postOk, 0);

/*======================  Overfoersel-Popup-vindue  ================ */
/* rws transfer widget */

  ovfShell = XtVaCreatePopupShell (
				   "ovfShell",
				   transientShellWidgetClass,
				   topLevel,
				   XtNtitle, TRANSFER_TITLE,
				   NULL );
  
  ovfForm = XtVaCreateManagedWidget(
				    "ovfForm",
				    formWidgetClass,
				    ovfShell,
				    NULL);
  
  ovfFraTil = XtVaCreateManagedWidget(
				      "ovfFraTil",
				      labelWidgetClass,
				      ovfForm,
				      NULL);
  
  ovfdatoLabel = XtVaCreateManagedWidget(
				       "ovfdatoLabel",
				       labelWidgetClass,
				       ovfForm,
				       XtNlabel, DATE,
				       XtNfromVert, ovfFraTil,
				       NULL);
  
  ovfdatoIn = XtVaCreateManagedWidget(
				      "ovfdatoIn",
				      asciiTextWidgetClass,
				      ovfForm,
				      XtNeditType, XawtextEdit,
				      XtNwidth, DATEWIDTH,
				      XtNfromVert, ovfFraTil,
				      XtNfromHoriz, ovfdatoLabel,
				      NULL);
  
  ovfDagsDato = XtVaCreateManagedWidget(
					"ovfDagsDato",
					commandWidgetClass,
					ovfForm,
					XtNlabel, TODAY,
					XtNfromVert, ovfFraTil,
					XtNfromHoriz, ovfdatoIn,
					NULL);
  
  ovfPlusDato = XtVaCreateManagedWidget(
					"ovfPlusDato",
					commandWidgetClass,
					ovfForm,
					XtNlabel, INCR,
					XtNfromVert, ovfFraTil,
					XtNwidth, PLUS_BUTW,
					XtNfromHoriz, ovfDagsDato,
					NULL);
  
  ovfMinusDato = XtVaCreateManagedWidget(
					 "ovfMinusDato",
					 commandWidgetClass,
					 ovfForm,
					 XtNlabel, DECR,
					 XtNwidth, PLUS_BUTW,
					 XtNfromVert, ovfFraTil,
					 XtNfromHoriz, ovfPlusDato,
					 NULL);
  
  ovfPlusPeriod = XtVaCreateManagedWidget(
				       "ovfPlusPeriod",
				       commandWidgetClass,
				       ovfForm,
				       XtNlabel, INCR_MONTH,
				       XtNwidth, PLUS_BUTW,
				       XtNfromVert, ovfFraTil,
				       XtNfromHoriz, ovfMinusDato,
				       NULL);

  ovfMinusPeriod = XtVaCreateManagedWidget(
					"ovfMinusPeriod",
					commandWidgetClass,
					ovfForm,
					XtNlabel, DECR_MONTH,
					XtNwidth, PLUS_BUTW,
					XtNfromVert, ovfFraTil,
					XtNfromHoriz,
					ovfPlusPeriod,
					NULL);

  ovfTransNumLabel = XtVaCreateManagedWidget(
				     "ovfTransNumLabel",
				     labelWidgetClass,
				     ovfForm,
				     XtNlabel, TRANS_NUM_TEXT_LABEL,
				     XtNfromVert, ovfdatoIn,
				     XtNvertDistance, VERTICAL_DIST,
				     NULL);

  ovfTransNumInput = XtVaCreateManagedWidget(
				    "ovfTransNumInput",
				    asciiTextWidgetClass,
				    ovfForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, DATEWIDTH,
				    XtNfromHoriz, ovfTransNumLabel,
				    XtNfromVert, ovfdatoIn,
				    XtNvertDistance, VERTICAL_DIST,
				    NULL);

  ovfTransNumMax = XtVaCreateManagedWidget(
				     "ovfTransNumMax",
				     commandWidgetClass,
				     ovfForm,
				     XtNlabel, TRANS_NUM_MAX,
				     /* XtNwidth, PLUS_BUTW, */
				     XtNfromHoriz, ovfTransNumInput,
				     XtNfromVert, ovfdatoIn,
				     NULL);

  XtAddCallback(ovfTransNumMax, XtNcallback, TransNumMax, ovfTransNumInput);

  ovfTransNumIncr = XtVaCreateManagedWidget(
				     "ovfTransNumIncr",
				     commandWidgetClass,
				     ovfForm,
				     XtNlabel, INCR,
				     XtNwidth, PLUS_BUTW,
				     XtNfromHoriz, ovfTransNumMax,
				     XtNfromVert, ovfdatoIn,
				     NULL);

  XtAddCallback(ovfTransNumIncr, XtNcallback, IncrNum, ovfTransNumInput);
  
  ovfTransNumDecr = XtVaCreateManagedWidget(
				     "ovfTransNumDecr",
				     commandWidgetClass,
				     ovfForm,
				     XtNlabel, DECR,
				     XtNwidth, PLUS_BUTW,
				     XtNfromHoriz, ovfTransNumIncr,
				     XtNfromVert, ovfdatoIn,
				     NULL);
  
  XtAddCallback(ovfTransNumDecr, XtNcallback, DecrNum, ovfTransNumInput);

  ovftekstLabel = XtVaCreateManagedWidget(
					"ovftekstLabel",
					labelWidgetClass,
					ovfForm,
					XtNlabel, TEXT_LABEL,
					XtNfromVert, ovfTransNumInput,
					NULL);
  
  ovftekstIn = XtVaCreateManagedWidget(
				       "ovftekstIn",
				       asciiTextWidgetClass,
				       ovfForm,
				       XtNeditType, XawtextEdit,
				       XtNwidth, POST_TEXT_LENGTH*6+3,
				       XtNfromVert, ovfTransNumInput,
				       XtNfromHoriz, ovftekstLabel,
				       NULL);
  
  ovfbelLabel = XtVaCreateManagedWidget(
				      "ovfbelLabel",
				      labelWidgetClass,
				      ovfForm,
				      XtNlabel, AMOUNT_LABEL,
				      XtNfromVert, ovftekstIn,
				      NULL);
  
  ovfbelIn = XtVaCreateManagedWidget(
				     "ovfbelIn",
				     asciiTextWidgetClass,
				     ovfForm,
				     XtNeditType, XawtextEdit,
				     XtNwidth, 10*6+3,
				     XtNfromVert, ovftekstIn,
				     XtNfromHoriz, ovfbelLabel,
				     NULL);
  
  ovfOk = XtVaCreateManagedWidget(
				  "ovfOk",
				  commandWidgetClass,
				  ovfForm,
				  XtNlabel, CONFIRM_LABEL,
				  XtNwidth, BUTW,
				  XtNfromVert, ovfbelLabel,
				  NULL);

  saveFocusInfo(ovfdatoIn, ovfTransNumInput, ovfShell, ovfOk, 1);
  saveFocusInfo(ovfTransNumInput, ovftekstIn, ovfShell, ovfOk, 0);
  saveFocusInfo(ovftekstIn, ovfbelIn, ovfShell, ovfOk, 0);
  saveFocusInfo(ovfbelIn, ovfdatoIn, ovfShell, ovfOk, 0);

  ovfCancel = XtVaCreateManagedWidget(
				      "ovfCancel",
				      commandWidgetClass,
				      ovfForm,
				      XtNlabel, CANCEL_LABEL,
				      XtNfromVert, ovfbelLabel,
				      XtNfromHoriz, ovfOk,
				      NULL);

  ovfClearAll = XtVaCreateManagedWidget(
				  "ovfClearAll",
				  commandWidgetClass,
				  ovfForm,
				  XtNlabel, CLEAR_ALL,
				  XtNfromVert, ovfbelLabel,
				  XtNfromHoriz, ovfCancel,
				  NULL);

  ovfClearText = XtVaCreateManagedWidget(
				  "ovfClearText",
				  commandWidgetClass,
				  ovfForm,
				  XtNlabel, CLEAR_TEXT,
				  XtNfromVert, ovfbelLabel,
				  XtNfromHoriz, ovfClearAll,
				  NULL);

#if EXPERIMENTAL
  skrivCheck = XtVaCreateManagedWidget(
				  "skrivCheck",
				  commandWidgetClass,
				  ovfForm,
				  XtNlabel, "Udskriv Check",
				  XtNfromVert, ovfbelLabel,
				  XtNfromHoriz, ovfClearText,
				  NULL);
#endif

/* =======================  Udskriv PopUP ==================*/
  udsShell = XtVaCreatePopupShell (
				 "udsShell",
				 transientShellWidgetClass,
				 topLevel,
				 XtNtitle, PRINT_TITLE,
				 NULL );

  udsForm = XtVaCreateManagedWidget(
				  "udsForm",
				  formWidgetClass,
				  udsShell,
				  NULL);

  udsLabel = XtVaCreateManagedWidget(
				     "udsLabel",
				     labelWidgetClass,
				     udsForm,
				     XtNlabel, PRINT_FROM_LABEL, 
				     NULL);

  udsInput = XtVaCreateManagedWidget(
				     "udsInput",
				     asciiTextWidgetClass,
				     udsForm,
				     XtNeditType, XawtextEdit,
				     XtNwidth, strlen(PRINT_FROM_LABEL)*6,
				     XtNfromVert, udsLabel,
				     NULL);

  udsOk = XtVaCreateManagedWidget(
				  "udsOk",
				  commandWidgetClass,
				  udsForm,
				  XtNlabel, CONFIRM_LABEL,
				  XtNwidth, BUTW,
				  XtNfromVert, udsInput,
				  NULL);

  udsCancel = XtVaCreateManagedWidget(
				  "udsCancel",
				  commandWidgetClass,
				  udsForm,
				  XtNlabel, CANCEL_LABEL,
				  XtNfromVert, udsInput,
				  XtNfromHoriz, udsOk,
				  NULL);

  saveFocusInfo(udsInput, udsInput, udsForm, udsOk, 1);

/* ==============  Printer-konfiguration ========================= */

  printerConfigShell = XtVaCreatePopupShell (
				 "printerConfigShell",
				 transientShellWidgetClass,
				 topLevel,
				 XtNtitle, PRINTER_CONFIG_TITLE,
				 NULL );

  printerConfigForm = XtVaCreateManagedWidget(
				  "printerConfigForm",
				  formWidgetClass,
				  printerConfigShell,
				  NULL);

  printerConfigLabel = XtVaCreateManagedWidget(
				     "printerConfigLabel",
				     labelWidgetClass,
				     printerConfigForm,
				     XtNlabel, DEFAULT_PRINTER_LABEL, 
				     NULL);

  printerConfigInput = XtVaCreateManagedWidget(
				     "printerConfigInput",
				     asciiTextWidgetClass,
				     printerConfigForm,
				     XtNeditType, XawtextEdit,
				     XtNstring, DEFAULT_PRINT_COMMAND,
				     XtNfromVert, printerConfigLabel,
				     NULL);

  printerConfigOk = XtVaCreateManagedWidget(
					    "printerConfigOk",
					    commandWidgetClass,
					    printerConfigForm,
					    XtNlabel, CONFIRM_LABEL,
					    XtNfromVert, printerConfigInput,
					    XtNwidth, 100,
					    NULL);

  saveFocusInfo(printerConfigInput, printerConfigInput, 
		printerConfigForm, printerConfigOk, 1);

/*======================  Rente-Popup-vindue  ====================== */
  renteShell = XtVaCreatePopupShell (
				 "renteShell",
				 transientShellWidgetClass,
				 topLevel,
				 XtNtitle, INTEREST_TITLE,
				 NULL );

  renteForm = XtVaCreateManagedWidget(
				  "renteForm",
				  formWidgetClass,
				  renteShell,
				  NULL);

  renteDato1Label = XtVaCreateManagedWidget(
				  "renteDato1Label",
				  labelWidgetClass,
				  renteForm,
				  XtNlabel, FROM_DATE, 
				  NULL);

  renteDato1In = XtVaCreateManagedWidget(
				  "renteDato1In",
				  asciiTextWidgetClass,
				  renteForm,
				  XtNeditType, XawtextEdit,
				  XtNwidth, DATEWIDTH,	
				  XtNfromHoriz, renteDato1Label,
				  NULL);

  renteFod1Label = XtVaCreateManagedWidget(
				  "renteFod1Label",
				  labelWidgetClass,
				  renteForm,
				  XtNlabel, INTEREST_RATE_POSITIVE, 
				  XtNfromHoriz, renteDato1In,
				  NULL);

  renteFod1In = XtVaCreateManagedWidget(
				  "renteFod1In",
				  asciiTextWidgetClass,
				  renteForm,
				  XtNeditType, XawtextEdit,
				  XtNwidth, DATEWIDTH,
				  XtNfromHoriz, renteFod1Label,
				  NULL);

  renteDato2Label = XtVaCreateManagedWidget(
				  "renteDato2Label",
				  labelWidgetClass,
				  renteForm,
				  XtNfromVert,renteDato1Label,
				  XtNlabel, TO_DATE, 
				  NULL);

  renteDato2In = XtVaCreateManagedWidget(
				  "renteDato2In",
				  asciiTextWidgetClass,
				  renteForm,
				  XtNeditType, XawtextEdit,
				  XtNwidth, DATEWIDTH,
				  XtNfromVert,renteDato1In,
				  XtNfromHoriz, renteDato2Label,
				  NULL);

  renteFod2Label = XtVaCreateManagedWidget(
				  "renteFod2Label",
				  labelWidgetClass,
				  renteForm,
				  XtNfromVert,renteFod1Label,
				  XtNfromHoriz, renteDato2In,
				  XtNlabel, INTEREST_RATE_NEGATIVE, 
				  NULL);

  renteFod2In = XtVaCreateManagedWidget(
				  "renteFod2In",
				  asciiTextWidgetClass,
				  renteForm,
				  XtNeditType, XawtextEdit,
				  XtNwidth, DATEWIDTH,
				  XtNfromVert,renteFod1In,
				  XtNfromHoriz, renteFod2Label,
				  NULL);

  renteBeregn = XtVaCreateManagedWidget(
				  "renteBeregn",
				  commandWidgetClass,
				  renteForm,
				  XtNlabel, INTEREST_COMPUTE, 
				  XtNfromVert, renteDato2Label,
				  NULL);

  saveFocusInfo(renteDato1In, renteDato2In, renteShell, renteBeregn, 1);
  saveFocusInfo(renteDato2In, renteFod1In,  renteShell, renteBeregn, 0);
  saveFocusInfo(renteFod1In,  renteFod2In,  renteShell, renteBeregn, 0);
  saveFocusInfo(renteFod2In,  renteDato1In, renteShell, renteBeregn, 0);

  renteResult = XtVaCreateManagedWidget(
				  "renteResult",
				  labelWidgetClass,
				  renteForm,
				  XtNlabel, "", 
				  XtNfromVert, renteBeregn,
				  NULL);

  renteTilskriv = XtVaCreateManagedWidget(
				  "renteTilskriv",
				  commandWidgetClass,
				  renteForm,
				  XtNlabel, INTEREST_ADD, 
				  XtNfromVert, renteResult,
				  NULL);

  renteFortryd = XtVaCreateManagedWidget(
				  "renteFortryd",
				  commandWidgetClass,
				  renteForm,
				  XtNlabel, CANCEL_LABEL, 
				  XtNfromVert, renteResult,
				  XtNfromHoriz, renteTilskriv,
				  NULL);

/* ========  User defined date format configuration ==================*/

  dateFormatShell = XtVaCreatePopupShell (
				 "dateFormatShell",
				 transientShellWidgetClass,
				 topLevel,
				 XtNtitle, DATE_FORMAT_TITLE,
				 NULL );

  dateFormatForm = XtVaCreateManagedWidget(
				  "dateFormatForm",
				  formWidgetClass,
				  dateFormatShell,
				  NULL);

  dateFormatLabel = XtVaCreateManagedWidget(
				     "dateFormatLabel",
				     labelWidgetClass,
				     dateFormatForm,
				     XtNlabel, DATE_FORMAT_STRING_LABEL, 
				     NULL);

  dateFormatInput = XtVaCreateManagedWidget(
				     "dateFormatInput",
				     asciiTextWidgetClass,
				     dateFormatForm,
				     XtNeditType, XawtextEdit,
				     XtNstring, DEFAULT_DATE_FORMAT_STRING,
				     XtNwidth, strlen(DATE_FORMAT_STRING_LABEL)*6,
				     XtNfromVert, dateFormatLabel,
				     NULL);

  dateFormatOk = XtVaCreateManagedWidget(
				  "dateFormatOk",
				  commandWidgetClass,
				  dateFormatForm,
				  XtNlabel, CONFIRM_LABEL,
				  XtNwidth, BUTW,
				  XtNfromVert, dateFormatInput,
				  NULL);

  saveFocusInfo(dateFormatInput, dateFormatInput, 
		dateFormatForm, dateFormatOk, 1);

  XtAddCallback(dateFormatOk, XtNcallback, DateFormatSelectionOk, 0);

  dateFormatMenuButton =  XtVaCreateManagedWidget(
					  "dateFormatMenuButton",
					  menuButtonWidgetClass,
					  dateFormatForm,
					  XtNmenuName, "dateFormatMenu",
					  XtNlabel, DATE_SEQUENCE,
					  XtNleftBitmap, menuButtonMark,
					  XtNfromVert, dateFormatInput,
					  XtNfromHoriz, dateFormatOk,
					  NULL);

  dateFormatMenu = create_menu(DATE_FORMAT_MENU, "dateFormatMenu", 
			       dateFormatMenuButton);

/* ========  Float format configuration ==================*/

  floatFormatShell = XtVaCreatePopupShell (
				 "floatFormatShell",
				 transientShellWidgetClass,
				 topLevel,
				 XtNtitle, FLOAT_FORMAT_TITLE,
				 NULL );

  floatFormatForm = XtVaCreateManagedWidget(
				  "floatFormatForm",
				  formWidgetClass,
				  floatFormatShell,
				  NULL);

  floatFormatLabel = XtVaCreateManagedWidget(
				     "floatFormatLabel",
				     labelWidgetClass,
				     floatFormatForm,
				     XtNlabel, FLOAT_FORMAT_STRING_LABEL, 
				     NULL);

  floatFormatInput = XtVaCreateManagedWidget(
				     "floatFormatInput",
				     asciiTextWidgetClass,
				     floatFormatForm,
				     XtNeditType, XawtextEdit,
				     XtNstring, "2",
				     XtNwidth, strlen(FLOAT_FORMAT_STRING_LABEL)*6,
				     XtNfromVert, floatFormatLabel,
				     NULL);

  floatFormatOk = XtVaCreateManagedWidget(
				  "floatFormatOk",
				  commandWidgetClass,
				  floatFormatForm,
				  XtNlabel, CONFIRM_LABEL,
				  XtNwidth, BUTW*2,
				  XtNfromVert, floatFormatInput,
				  NULL);

  saveFocusInfo(floatFormatInput, floatFormatInput, 
		floatFormatForm, floatFormatOk, 1);

  XtAddCallback(floatFormatOk, XtNcallback, FloatFormatSelectionOk, 0);

/* ************************  Registrer callbacks **************************/

  XtAddCallback(quit, XtNcallback, Quit, 0);
  XtAddCallback(valgKonto, XtNcallback, ValgKontoCallBack, topLevel);
  XtAddCallback(kontoList, XtNcallback, KontoListSelectionCallBack, topLevel);
  XtAddCallback(postList, XtNcallback, PostListSelectionCallBack, topLevel);

  XtAddCallback(sletKontoKnap, XtNcallback, SletKontoPopup, topLevel);
  XtAddCallback(opretKonto, XtNcallback, OpretKonPopup, topLevel);
  XtAddCallback(sletPost, XtNcallback, SletPostPopup, topLevel);
#if COMMIT_SUPPORT
  XtAddCallback(commitPost, XtNcallback, CommitCallback, topLevel);
#endif
  XtAddCallback(renteFortryd, XtNcallback, RenteFortryd, topLevel);
  XtAddCallback(renteBeregn, XtNcallback, RenteBeregn, topLevel);
  XtAddCallback(renteTilskriv, XtNcallback, RenteTilskriv, topLevel);

  XtAddCallback(udsOk, XtNcallback, UdsOk, topLevel);
  XtAddCallback(udsCancel, XtNcallback, UdsCancel, topLevel);
  XtAddCallback(printerConfigOk, XtNcallback, PrinterConfigOk, topLevel);

  XtAddCallback(confirmOk, XtNcallback, SletPostConfirm, confirm);
  XtAddCallback(confirmCancel, XtNcallback, SletPostCancel, confirm);
  
  XtAddCallback(nyPost, XtNcallback, PosteringPopup, (Widget)NYPOST);
  XtAddCallback(retPost, XtNcallback, PosteringPopup, (Widget)RETPOST);
  XtAddCallback(postOk, XtNcallback, PostConfirm, topLevel);
  XtAddCallback(postCancel, XtNcallback, PostCancel, topLevel);
  XtAddCallback(postClear, XtNcallback, PostClear, topLevel);
  XtAddCallback(dagsDato, XtNcallback, DagsDato, datoIn);
  XtAddCallback(plusDato, XtNcallback, PlusDato, datoIn);
  XtAddCallback(minusDato, XtNcallback, MinusDato, datoIn);

  transaction_period_call_data.dateField = datoIn;
  transaction_period_call_data.periodLengthField=  periodInput;
  transaction_period_call_data.menuID = TRANSACTION_UNIT_MENU;
  
  XtAddCallback(plusPeriod, XtNcallback, PlusPeriod, &transaction_period_call_data);
  XtAddCallback(minusPeriod, XtNcallback, MinusPeriod, &transaction_period_call_data);
  
  XtAddCallback(ovfDagsDato, XtNcallback, DagsDato, ovfdatoIn);
  XtAddCallback(ovfPlusDato, XtNcallback, PlusDato, ovfdatoIn);
  XtAddCallback(ovfMinusDato, XtNcallback, MinusDato, ovfdatoIn);
  XtAddCallback(ovfPlusPeriod, XtNcallback, PlusMon, ovfdatoIn);
  XtAddCallback(ovfMinusPeriod, XtNcallback, MinusMon, ovfdatoIn);

  XtAddCallback(overfor, XtNcallback, OvfPopup, topLevel);
  XtAddCallback(ovfOk, XtNcallback, OvfConfirm, topLevel);
  XtAddCallback(ovfCancel, XtNcallback, OvfCancel, topLevel);
  XtAddCallback(ovfClearAll, XtNcallback, OvfClearAll, topLevel);
  XtAddCallback(ovfClearText, XtNcallback, OvfClearText, topLevel);
#if EXPERIMENTAL
  XtAddCallback(skrivCheck, XtNcallback, ScPopup, topLevel); 
#endif
  XtAddCallback(infoKnap, XtNcallback, InfoPopup, topLevel); 

/*************  Bring hoved-vinduet frem og lad X klare resten *************/

  XtAppAddActions(app_context, xf_actions, XtNumber(xf_actions)); 

  XtRealizeWidget(topLevel);

  XtInstallAccelerators(vpane, quit);   /* define "hot-key" for quit */

  load_configuration();

#if RECURRING_TRANSFER
  ReadTransfers();
  XtAppAddWorkProc(app_context,RunTransfers,(XtPointer)today());
#endif

  XtAppMainLoop(app_context);
}

/* ====================  Konto-CallBacks ========================== */

int indxOfKontoSelection(void) {      /* returnerer -1, hvis ingen er valgt */
  XawListReturnStruct *res;
  res=XawListShowCurrent(kontoList);
  if( res->list_index==XAW_LIST_NONE )
    return -1;
  else
    return res->list_index;
}

void opdaterPostList(void) {
  postNpress=0;
  opdaterSearchList();
  winSetTransactionLabel();
  XawListChange(postList, postStrings(), 0,0, TRUE);
}

void opdaterKontoList(void) {
  XawListChange(kontoList, kontoStrings(), 0,0, TRUE);
}

static void ValgKontoCallBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  i=indxOfKontoSelection();
  if(i<0) {
    xfError(ERR_DO_CLICK, NONFATAL, "open");
    return;
  }
  loadKonto(i);
  unset_zero();

  addKontoToList(i);  /* tilbyd den valgte konto til listen i
	                 	"vis-saldo" vinduet. */
  opdaterPostList();
}

static void KontoListSelectionCallBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  static int indx=-1, npress=0;
  int i;
  char buf[KONTO_NAME_LENGTH+KONTO_NR_LENGTH+10];

  i=indxOfKontoSelection();
  if(i<0)
    return;

  sprintf(buf, "%s  %s", getKontoName(i), getKontoNr(i));
#if RECURRING_TRANSFER
  setToFromAccount(buf);
#endif

  ovfFra=ovfTil;
  ovfTil=i;

  if( i==indx ) {
    npress++;
  }
  else {
    indx=i;
    npress=1;
  }

  if( npress>=2 ) {
    npress=0;
    indx=-1;
    loadKonto(i);
    unset_zero();
    opdaterPostList();
  }
}

/* =================== Post-CallBacks ===================== */

int indxOfPostSelection(void) {      /* returnerer -1, hvis ingen er valgt */
  XawListReturnStruct *res;
  res=XawListShowCurrent(postList);
  if( res->list_index==XAW_LIST_NONE )
    return -1;
  else
    return res->list_index;
}

static void PostListSelectionCallBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  static int indx=-1;
  int i;

  if( postIsPopup )
    return;

  i=indxOfPostSelection();
  if(i<0)
    return;

  if( i==indx ) {
    postNpress++;
  }
  else {
    indx=i;
    postNpress=1;
  }

  if( postNpress>=2 ) {
    postNpress=0;
    indx=-1;
    PosteringPopup(0,(Widget)RETPOST,0);
  }
}

/* ==== slet-post-confirm-callbacks ====  */

void SletPostPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  Dimension width, height;
  int i;
  
  if( postIsPopup ) /* avoid trouble with several "concurrent" popup-windows */
    return;

  i=indxOfPostSelection();
  if( i<0 ) {
    xfError(ERR_DO_CLICK_POSTING, NONFATAL, "delete ");
    return;
  }

  postNpress=0;
  XtTranslateCoords(topLevel,(Position)110, (Position)Y_PPOS,
		    &x, &y);

  XtVaSetValues(confirmShell, XtNx, x,
		XtNy, y,
		NULL );
  XtSetSensitive(sletPost,FALSE); 
  XtPopup(confirmShell, XtGrabNonexclusive);
}

void SletPostConfirm(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  i=indxOfPostSelection();
  if( i<0 ) {
    xfError(ERR_DO_CLICK_POSTING, NONFATAL, "delete ");
    return;
  }

  okSletPost(i);
  saveKonto();
  opdaterPostList();

  XtPopdown(confirmShell);
  XtSetSensitive(sletPost, TRUE); 
}

void SletPostCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(confirmShell);
  XtSetSensitive(sletPost, TRUE);
}

/* ======== postering-popup-vindue-callback ========== */

void PosteringPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  
  if( postIsPopup )
    return;

  i=aktKonto();
  if( i<0 ) {
    xfError(ERR_DO_SELECT, NONFATAL, "do select");
    return;
  }

  postNpress=0;

  i=(int) client_data;
  switch(i) {
	case NYPOST:
	  whoIsPoping=NYPOST;
	  NyPostCallBack(w, client_data, call_data);
	  break;
	case RETPOST:
	  whoIsPoping=RETPOST;
	  editIndex=indxOfPostSelection();
	  RetPostCallBack(w, client_data, call_data);
	  break;
  }
}

void NyPostCallBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  Dimension width, height;
  int i, unit;
  char dato[32], text[POST_TEXT_LENGTH], bel[32], transNum[32], period[32];
  char catnum[32];

  i=indxOfPostSelection();
  if( i>=0 ) {
    getPostAsText(i, dato, text, bel, transNum, period, catnum, &unit);
    XtVaSetValues(datoIn,	
		  XtNstring, dato,
		  NULL);
    
    XtVaSetValues(tekstIn,	
		  XtNstring, text,
		  NULL);
    
    XtVaSetValues(belIn,
		  XtNstring, bel,
		  NULL);

    XtVaSetValues(periodInput,
		  XtNstring, period,
		  NULL);
    set_period_unit(unit, TRANSACTION_UNIT_MENU);

#if CATEGORY_SUPPORT
    SetCategory(catNumInput, catNameLabel, catnum);
#endif

  } 
#if CATEGORY_SUPPORT
  else {
  /* clear the category name label, otherwise it may be inconsistent
     with the category number field */
  XtVaSetValues(catNameLabel,
		XtNlabel, "",
		NULL);
  }
#endif
  sprintf(transNum, "%d", currentTransactionNumber()+1);
  XtVaSetValues(transNumInput,
		XtNstring, transNum,
		NULL);
  
  XtTranslateCoords(topLevel,(Position)X_PPOS, (Position)50,
		    &x, &y);
  
  XtVaSetValues(posteringShell, XtNx, x,
		XtNy, y,
		NULL );
  
  XtSetSensitive(nyPost,FALSE); 
  XtPopup(posteringShell, XtGrabNone);
  postIsPopup=1;
  jumpTo(datoIn);
}

void PostConfirm(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  switch(whoIsPoping) {
  case NYPOST:
    NyPostConfirm(w, client_data, call_data);
    break;
  case RETPOST:
    RetPostConfirm(w, client_data, call_data);
    break;
  }
}

void PostCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  switch(whoIsPoping) {
	case NYPOST:
	  NyPostCancel(w, client_data, call_data);
	  break;
	case RETPOST:
	  RetPostCancel(w, client_data, call_data);
	  break;
  }
}

void NyPostConfirm(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char dato[128], text[128], bel[128], numb[32], peri[32], catnum[32];
  String p;

  XtVaGetValues(datoIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(dato,p,127);

  XtVaGetValues(tekstIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(text,p,127);

  XtVaGetValues(belIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(bel,p,127);

  XtVaGetValues(periodInput, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(peri,p,sizeof(peri)-1);

  XtVaGetValues(transNumInput, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(numb,p,sizeof(numb)-1);

#if CATEGORY_SUPPORT
  XtVaGetValues(catNumInput, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(catnum,p,sizeof(catnum)-1);
#else
  catnum[0]=0;
#endif

  if( strlen(dato)==0 || strlen(bel)==0 ) {
    xfError(MUST_FILL_FIELDS, NONFATAL,"new");
    return;
  }

  postIsPopup=0;

  okNyPost(0,dato, text, bel, atoi(numb), atoi(peri), get_period_unit(TRANSACTION_UNIT_MENU), 
	   atoi(catnum));
  saveKonto();
  saveTransactionNumber(MAX(currentTransactionNumber(), atoi(numb)));
  opdaterPostList(); 

  XtPopdown(posteringShell);
  XtSetSensitive(nyPost, TRUE); 
}

void NyPostCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(posteringShell);
  XtSetSensitive(nyPost, TRUE);
  postIsPopup=0;
}

void PostClear(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtVaSetValues(datoIn, 
		XtNstring, "",
		NULL); 

  XtVaSetValues(tekstIn, 
		XtNstring, "",
		NULL); 

  XtVaSetValues(belIn, 
		XtNstring, "",
		NULL);   

  XtVaSetValues(periodInput,
		XtNstring, "1",
		NULL);
  set_period_unit(P_MONTH, TRANSACTION_UNIT_MENU);

  XtVaSetValues(transNumInput, 
		XtNstring, "",
		NULL);   

#if CATEGORY_SUPPORT
  XtVaSetValues(catNumInput, 
		XtNstring, "",
		NULL);   

  XtVaSetValues(catNameLabel, 
		XtNlabel, "",
		NULL);   
#endif
}

void DagsDato(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char datoT[32];
  Widget putIn;

  putIn=(Widget) client_data;

  strcpy(datoT, dateString(today()));

  XtVaSetValues(putIn, 
		XtNstring, datoT,
		NULL); 
}

void PlusDato(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;
  String p;
  long datoTal;

  putIn=(Widget) client_data;


  XtVaGetValues(putIn, 
		XtNstring, &p,
		NULL); 

  datoTal=parseDate(p);

  XtVaSetValues(putIn, 
		XtNstring, dateString(incr(datoTal)),
		NULL); 
}

void MinusDato(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;
  String p;
  long datoTal;

  putIn=(Widget) client_data;


  XtVaGetValues(putIn, 
		XtNstring, &p,
		NULL); 

  datoTal=parseDate(p);

  XtVaSetValues(putIn, 
		XtNstring, dateString(decr(datoTal)),
		NULL); 
}

void PlusMon(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;
  String p;
  long datoTal;

  putIn=(Widget) client_data;

  XtVaGetValues(putIn, 
		XtNstring, &p,
		NULL); 

  datoTal=parseDate(p);

  XtVaSetValues(putIn, 
		XtNstring, dateString(incrMon(datoTal)),
		NULL); 
}

void MinusMon(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;
  String p;
  long datoTal;

  putIn=(Widget) client_data;

  XtVaGetValues(putIn, 
		XtNstring, &p,
		NULL); 

  datoTal=parseDate(p);

  XtVaSetValues(putIn, 
		XtNstring, dateString(decrMon(datoTal)),
		NULL); 
}

void PlusPeriod(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  period_call_data *period;
  String p;
  long date;
  int periodLength;

  period=(period_call_data *) client_data;

  XtVaGetValues(period->dateField, 
		XtNstring, &p,
		NULL); 

  date=parseDate(p);

  XtVaGetValues(period->periodLengthField, 
		XtNstring, &p,
		NULL); 
  
  periodLength=atoi(p);

  XtVaSetValues(period->dateField, 
		XtNstring, dateString(nextDate(date,
					       get_period_unit(period->menuID), 
					       periodLength)),
		NULL); 
}

void MinusPeriod(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  period_call_data *period;
  String p;
  long date;
  int periodLength;

  period=(period_call_data *) client_data;

  XtVaGetValues(period->dateField, 
		XtNstring, &p,
		NULL); 

  date=parseDate(p);

  XtVaGetValues(period->periodLengthField, 
		XtNstring, &p,
		NULL); 
  
  periodLength=atoi(p);

  XtVaSetValues(period->dateField, 
		XtNstring, dateString(prevDate(date,
					       get_period_unit(period->menuID), 
					       periodLength)),
		NULL); 
}

void IncrNum(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;
  String p;
  int num;
  char buf[32];

  putIn=(Widget) client_data;

  XtVaGetValues(putIn, 
		XtNstring, &p,
		NULL); 

  num=atoi(p);
  sprintf(buf, "%d", ++num);

  XtVaSetValues(putIn, 
		XtNstring, buf,
		NULL); 
}

void DecrNum(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;
  String p;
  int num;
  char buf[32];

  putIn=(Widget) client_data;

  XtVaGetValues(putIn, 
		XtNstring, &p,
		NULL); 

  num=atoi(p);
  sprintf(buf, "%d", --num);

  XtVaSetValues(putIn, 
		XtNstring, buf,
		NULL); 
}

void TransNumMax(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget putIn;
  String p;
  int num;
  char buf[32];

  putIn=(Widget) client_data;

  num=currentTransactionNumber()+1;
  sprintf(buf, "%d", num);

  XtVaSetValues(putIn, 
		XtNstring, buf,
		NULL); 
}

/* =================== Overfoering-CallBacks ===================== */

void makePos(char *s) {
  int t=0;
  if(*s!='-')
    return;
  while( *(s+t) ) {
     *(s+t)=*(s+ ++t);
  }
}

/* ======== overfoering-popup-vindue-callback ========== */
/* rws transfer pop-up */

void OvfPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i, unit;
  char fratil[256];
  Position x,y;
  Dimension width, height;
  char dato[32], text[POST_TEXT_LENGTH], bel[32], transNum[32],
       period[32];
  char catnum[32];

  postNpress=0;

  if( ovfFra<0 || ovfTil<0 || ovfFra==ovfTil ) {
    xfError(ERR_DO_TWO_CLICK, NONFATAL,"transfer");
    return;
  }
  sprintf(fratil, "%s %s %s", TRANSFER_FROM, getKontoName(ovfFra), 
					   getKontoNr(ovfFra) );
  sprintf(fratil+strlen(fratil), "\n%s %s %s", TRANSFER_TO, 
						getKontoName(ovfTil), 
					        getKontoNr(ovfTil) );

  XtTranslateCoords(topLevel,(Position)X_PPOS, (Position)50,
		    &x, &y);

  XtVaSetValues(ovfShell, XtNx, x,
		XtNy, y,
		NULL );

  XtVaSetValues(ovfFraTil, 
	 	XtNlabel, fratil,
		XtNwidth, (7+POST_TEXT_LENGTH)*6,
		NULL);

  i=indxOfPostSelection();
  if( i>=0 ) {
    getPostAsText(i, dato, text, bel, transNum, period, catnum, &unit);
    makePos(bel);
    XtVaSetValues(ovfdatoIn,	
		  XtNstring, dato,
		  NULL);
    
    XtVaSetValues(ovftekstIn,	
		  XtNstring, text,
		  NULL);
    
    XtVaSetValues(ovfbelIn,	
		  XtNstring, bel,
		  NULL);
  } else
    sprintf(transNum, "%d", currentTransactionNumber()+1);
  
  XtVaSetValues(ovfTransNumInput,	
		XtNstring, transNum,
		NULL);
  
  XtSetSensitive(overfor,FALSE); 
  XtPopup(ovfShell, XtGrabNone);
  OvfIsUp = (1==1);
  jumpTo(ovfdatoIn);
}

void OvfConfirm(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char dato[128], text[128], bel[128], negBel[128], numb[32];
  String p;

  negBel[0]='-';
  negBel[1]='\0';

  XtVaGetValues(ovfdatoIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(dato,p,127);

  XtVaGetValues(ovftekstIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(text,p,127);

  XtVaGetValues(ovfbelIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(bel,p,125);

  XtVaGetValues(ovfTransNumInput, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(numb,p,sizeof(numb)-1);

  if( strlen(dato)==0 || strlen(bel)==0 ) {
    xfError(MUST_FILL_FIELDS, NONFATAL, "transfer");
    return;
  }

  XtPopdown(ovfShell);
  OvfIsUp = (0==1);
  XtSetSensitive(overfor, TRUE); 

  if( strlen(text)==0 ) {
	sprintf(text, "%s %s (%s)", TRANSFER_TO_TEXT, getKontoName(ovfTil), 
					  getKontoNr(ovfTil) );
	if(bel[0]=='-') {
	  strcpy(negBel, (bel+1));
	}
	else
	  strcat(negBel, bel);

	loadKonto(ovfFra);
  	okNyPost(0,dato, text, negBel, atoi(numb), 1, P_MONTH, 0);
	calculateCurrentSaldo();
	saveKonto();

	sprintf(text, "%s %s (%s)", TRANSFER_FROM_TEXT, getKontoName(ovfFra), 
					  getKontoNr(ovfFra) );
	loadKonto(ovfTil);
  	okNyPost(0,dato, text, bel, atoi(numb), 1, P_MONTH, 0);
	saveKonto();
  }
  else {
	loadKonto(ovfFra);
#if !STRANGE_TRANSFER
	if(bel[0]=='-') {
	  strcpy(negBel, (bel+1));
	}
	else
	  strcat(negBel, bel);

  	okNyPost(0,dato, text, negBel, atoi(numb), 1, P_MONTH, 0);
#else
  	okNyPost(0,dato, text, bel, atoi(numb), 1, P_MONTH, 0); 
#endif
	calculateCurrentSaldo();
	saveKonto();

	loadKonto(ovfTil);
  	okNyPost(0,dato, text, bel, atoi(numb), 1, P_MONTH, 0);
	saveKonto();
  }

  saveTransactionNumber(MAX(currentTransactionNumber(), atoi(numb)));
  opdaterPostList();
}

void OvfCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(ovfShell);
  OvfIsUp = (0==1);
  XtSetSensitive(overfor, TRUE);
}

void OvfClearAll(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtVaSetValues(ovfdatoIn, 
		XtNstring, "",
		NULL); 

  XtVaSetValues(ovftekstIn, 
		XtNstring, "",
		NULL); 

  XtVaSetValues(ovfbelIn, 
		XtNstring, "",
		NULL);   

  XtVaSetValues(ovfTransNumInput, 
		XtNstring, "",
		NULL);   
}

void OvfClearText(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtVaSetValues(ovftekstIn, 
		XtNstring, "",
		NULL); 
}

/* =================== Ret-Post-CallBacks ===================== */

void RetPostCallBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  Dimension width, height;
  int i, unit;
  char dato[32], text[POST_TEXT_LENGTH], bel[128], transNum[32],
       period[32];
  char catnum[32];
  category *c;

  i=editIndex=indxOfPostSelection();
  if( i<0 ) {
    xfError(ERR_DO_CLICK_POSTING, NONFATAL, "edit");
    return;
  }

  getPostAsText(i, dato, text, bel, transNum, period, catnum, &unit);
  XtVaSetValues(datoIn,	
		XtNstring, dato,
		NULL);

  XtVaSetValues(tekstIn,	
		XtNstring, text,
		NULL);

  XtVaSetValues(belIn,	
		XtNstring, bel,
		NULL);

  XtVaSetValues(periodInput,
		XtNstring, period,
		NULL);
  set_period_unit(unit, TRANSACTION_UNIT_MENU);
  
  XtVaSetValues(transNumInput,
		XtNstring, transNum,
		NULL);

#if CATEGORY_SUPPORT
  SetCategory(catNumInput, catNameLabel, catnum);
#endif

  if( !postIsPopup ) {
    postIsPopup=1;
    XtTranslateCoords(topLevel,(Position)X_PPOS, (Position)50,
		      &x, &y);
    
    XtVaSetValues(posteringShell, XtNx, x,
		  XtNy, y,
		  NULL );

    XtSetSensitive(retPost,FALSE); 
    XtPopup(posteringShell, XtGrabNone);
    jumpTo(datoIn);
  }
}

void RetPostConfirm(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char dato[128], text[128], bel[128], numb[32], peri[32], catnum[32];
  int nyindx, indx;
  String p;

/*  indx=indxOfPostSelection();
  if( indx<0 )
    xfError(ERR_SHOULDNT_HAPPEN, FATAL, "edit");
*/
  indx=editIndex;

  XtVaGetValues(datoIn, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(dato,p,127);

  XtVaGetValues(tekstIn, 
		XtNstring, &p,
		NULL);

  zeroAddStrncpy(text,p,127);

  XtVaGetValues(belIn,
		XtNstring, &p,
		NULL);

  zeroAddStrncpy(bel,p,127);

  XtVaGetValues(periodInput, 
		XtNstring, &p,
		NULL);

  zeroAddStrncpy(peri,p,sizeof(peri)-1);

  XtVaGetValues(transNumInput, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(numb,p,sizeof(numb)-1);

#if CATEGORY_SUPPORT
  XtVaGetValues(catNumInput, 
		XtNstring, &p,
		NULL); 
  zeroAddStrncpy(catnum,p,sizeof(catnum)-1);
#else
  catnum[0]=0;
#endif

  if( strlen(dato)==0 || strlen(bel)==0 ) {
    xfError(MUST_FILL_FIELDS, NONFATAL, "edit");
    return;
  }

  XtPopdown(posteringShell);
  XtSetSensitive(retPost, TRUE);
  postIsPopup=0;

  okRetPost(indx, dato, text, bel, atoi(numb), atoi(peri), 
	    get_period_unit(TRANSACTION_UNIT_MENU), atoi(catnum));
  saveKonto();
  saveTransactionNumber(MAX(currentTransactionNumber(), atoi(numb)));
  opdaterPostList();
}

void RetPostCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(posteringShell);
  XtSetSensitive(retPost, TRUE);
  postIsPopup=0;
}

/* =======================  Udskriv-callback ====================== */

void UdsPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  int i;

  if( udsIsPopup ) {
    udsIsPopup=0;
    updateMarkWithText(PRINT,udsIsPopup);
    XtPopdown(udsShell);
    return;
  }
  
  i=aktKonto();
  if( i<0 ) {
    xfError(ERR_DO_SELECT, NONFATAL, "print");
    return;
  }
  if( aktKontoType()!=ALM ) {
    xfError(ERR_CANT_PRINT, NONFATAL, "can't print");
    return;
  }

  XtTranslateCoords(topLevel, (Position)X_PPOS, (Position)50,
		    &x, &y);

  XtVaSetValues(udsShell, 
		XtNx, x,
		XtNy, y,
		NULL );

  udsIsPopup=1;
  updateMarkWithText(PRINT,udsIsPopup);
  XtPopup(udsShell, XtGrabNone);
  jumpTo(udsInput);
}

void UdsOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  String string;
  int dato;

  XtVaGetValues(udsInput, 
		XtNstring, &string,
		NULL); 

  if(strlen(string)==0)
    dato=0;
  else
    dato=parseDate(string);
  
  udsIsPopup=0;
  updateMarkWithText(PRINT,udsIsPopup);
  XtPopdown(udsShell);

  udskriv(dato);
}

void UdsCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  udsIsPopup=0;
  updateMarkWithText(PRINT,udsIsPopup);
  XtPopdown(udsShell);
}

/* ======== rente-popup-vindue-callback ========== */

void Rente(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  Dimension width, height;
  int i;

  if(renteIsPopup) {
    renteIsPopup=0;
    updateMarkWithText(INTEREST_LABEL,renteIsPopup);
    XtPopdown(renteShell);
    return;
  }
  i=aktKonto();
  if( i<0 ) {
    xfError(ERR_DO_SELECT, NONFATAL, "interest");
    return;
  }
  if( aktKontoType()!=ALM ) {
    xfError(ERR_CANT_INTEREST, NONFATAL, "contents");
    return;
  }

  XtTranslateCoords(topLevel,(Position)60, (Position)120,
		    &x, &y);

  XtVaSetValues(renteShell, XtNx, x,
		XtNy, y,
		NULL );

  XtVaSetValues(renteResult,
		XtNwidth, (POST_TEXT_LENGTH+6+2+2+9)*6+3,
		NULL );

  XtSetSensitive(renteTilskriv,FALSE); 

  renteIsPopup=1;
  updateMarkWithText(INTEREST_LABEL,renteIsPopup);
  XtPopup(renteShell, XtGrabNone);
  jumpTo(renteDato1In);
}

void RenteFortryd(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  renteIsPopup=0;
  updateMarkWithText(INTEREST_LABEL,renteIsPopup);
  XtPopdown(renteShell);
  XtVaSetValues(renteResult,
		XtNlabel, " ",
		NULL);
}

static long dato1, dato2;
static double fod1, fod2, bel;

void RenteBeregn(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char buf[32], text[256], dat1[32], dat2[32];
  String p;

  XtVaGetValues(renteDato1In, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(buf,p,31);
  dato1=parseDate(buf);

  if(dato1<=0) {
    xfError(ERR_DO_SUPPLY_DATE, NONFATAL, "interest");
    return;
  }

  XtVaGetValues(renteDato2In, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(buf,p,31);
  dato2=parseDate(buf);

  if(dato2<=0) {
    xfError(ERR_DO_SUPPLY_DATE, NONFATAL, "interest");
    return;
  }
  if(dato2<=dato1) {
    xfError(ERR_WRONG_SEQUENCE, NONFATAL, "interest");
    return;
  }


  XtVaGetValues(renteFod1In, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(buf,p,31);
  fod1=atof(nocomma(buf));

  XtVaGetValues(renteFod2In, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(buf,p,31);
  fod2=atof(nocomma(buf));
  bel=okRente(dato1, dato2, fod1, fod2);

  strcpy(dat1, dateString(dato1));
  strcpy(dat2, dateString(dato2));
  sprintf(text, "%s %s (%s-%s, %4.2f, %4.2f)    %s", dat2, INTEREST_LABEL,
		dat1, dat2, fod1, fod2, floatString(buf, bel) );

  XtVaSetValues(renteResult,
		XtNlabel, text,
		NULL);

  XtSetSensitive(renteTilskriv, TRUE); 
}

void RenteTilskriv(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  char text[128], belText[32], dat1[32], dat2[32];

  strcpy(dat1, dateString(dato1));
  strcpy(dat2, dateString(dato2));
  sprintf(text, "%s (%s-%s, %4.2f, %4.2f)", INTEREST_LABEL, dat1, dat2, 
	  fod1, fod2);

  sprintf(belText, "%.2f", bel);

  okNyPost(0, dat2, text, belText, newTransactionNumber(), 1, P_MONTH, 0);
  saveKonto();
  saveTransactionNumber(currentTransactionNumber());
  opdaterPostList();

  renteIsPopup=0;
  updateMarkWithText(INTEREST_LABEL,renteIsPopup);
  XtPopdown(renteShell);
  XtVaSetValues(renteResult,
		XtNlabel, " ",
		NULL);
}

void CommitCallback(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  i=indxOfPostSelection();
  if( i<0 ) {
    xfError(ERR_DO_CLICK_POSTING, NONFATAL, "commit");
    return;
  }
  postNpress=0;
  doCommit(i);
}

int postviewh(void) {
  int x;
  XtVaGetValues(postViewp,      
                XtNheight, &x,
                NULL);
  return x;
}

void winSetPrintCommand(char *p) {
  XtVaSetValues(printerConfigInput,
		XtNstring, p,
		NULL);
}

void printCommandConfigPopup(void) {
  if(printCommandUp)
    return;
  
  printCommandUp=1;
  XtPopup(printerConfigShell, XtGrabNone);
  jumpTo(printerConfigInput);
}

void PrinterConfigOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  String string;
  char buf[80];

  XtVaGetValues(printerConfigInput, 
		XtNstring, &string,
		NULL); 

  zeroAddStrncpy(buf,string,79);

  selectPrinter(buf);
  
  printCommandUp=0;
  XtPopdown(printerConfigShell);
}

void winSetTransactionLabel() {
  char buf[256];
  XtVaSetValues(postHeader,
		XtNlabel, transactionHeader(buf, TRANSACTION_MAX_WIDTH-10, BALANCE_LABEL),
		NULL);
}

void DateFormatSelectionOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  String string;
  char buf[80];

  XtVaGetValues(dateFormatInput, 
		XtNstring, &string,
		NULL); 

  zeroAddStrncpy(buf,string,79);

  setDateFormatString(buf);
  set_date_format(userdefined);
  date_format_change();
  XtPopdown(dateFormatShell);
}

void FloatFormatSelectionOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  String string;

  XtVaGetValues(floatFormatInput, 
		XtNstring, &string,
		NULL); 

  setFloatFormat(atoi(string)); 
  
  opdaterPostList();
  XtPopdown(floatFormatShell);
}

void SetAmountPositive(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget textField;
  String p;
  double amount;
  char buf[80];

  textField=(Widget) client_data;

  XtVaGetValues(textField, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(buf, p, 79);
  amount=ABSOLUTE(atof(nocomma(buf)));
  sprintf(buf, floatShortFormatString, amount);
  
  XtVaSetValues(textField, 
		XtNstring, buf,
		NULL); 
}

void SetAmountNegative(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Widget textField;
  String p;
  double amount;
  char buf[80];

  textField=(Widget) client_data;

  XtVaGetValues(textField, 
		XtNstring, &p,
		NULL); 

  zeroAddStrncpy(buf, p, 79);
  amount=-ABSOLUTE(atof(nocomma(buf)));
  sprintf(buf, floatShortFormatString, amount);
  
  XtVaSetValues(textField, 
		XtNstring, buf,
		NULL); 
}

void SetCategory(Widget number, Widget name, char *catnum) {
#if CATEGORY_SUPPORT
  category *c;

  XtVaSetValues(number,
		XtNstring, catnum,
		NULL);
  
  if( c=findCat(atoi(catnum)) )
    XtVaSetValues(name,
		  XtNlabel, c->name,
		  NULL);
  else
    XtVaSetValues(name,
		  XtNlabel, CAT_NOT_FOUND_LABEL,
		  NULL);
#endif
}

void DisplayLimitClearCallback(Widget w, XtPointer client_data, XtPointer call_data) {
  setDisplayFromLimit(0);
  setDisplayToLimit(0);
}
