/* $Id: sletKonto.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include "sletKontop.h"
#include "sletKonto.h"
#include "konto.h"
#include "xfError.h"
#include "xfinans.h"
#include "country.h"

extern int ovfFra, ovfTil;

void createSletKontoWidgets(void) {
  static int done=0;
  
  if(done)
    return;
  done=1;

  sletKontoShell = XtVaCreatePopupShell (
					 "sletKontoShell",
					 transientShellWidgetClass,
					 topLevel,
					 XtNtitle, WARNING_TITLE,
					 NULL );
  
  sletKontoForm = XtVaCreateManagedWidget(
				   "sletKontoForm",
				   formWidgetClass,
				   sletKontoShell,
				   NULL);
  
  sletKontoAsk = XtVaCreateManagedWidget(
				 "sletKontoAsk",
				 labelWidgetClass,
				 sletKontoForm,
				 XtNlabel, WARNING_TEXT_ACCOUNT, 
				 NULL);

  sletKontoOk = XtVaCreateManagedWidget(
					"sletKontoOk",
					commandWidgetClass,
					sletKontoForm,
					XtNfromVert, sletKontoAsk,
					XtNlabel, CONFIRM_LABEL,
					XtNwidth, BUTW,
					NULL);
  
  sletKontoCancel = XtVaCreateManagedWidget(
					    "sletKontoCancel",
					    commandWidgetClass,
					    sletKontoForm,
					    XtNfromVert, sletKontoAsk,
					    XtNfromHoriz, sletKontoOk,
					    XtNlabel, CANCEL_LABEL,
					    NULL);
  addsletKontoCallBack();
}

void addsletKontoCallBack(void) {
  XtAddCallback(sletKontoCancel, XtNcallback, SletKontoCancel, topLevel);
  XtAddCallback(sletKontoOk, XtNcallback, SletKontoOk, topLevel);
}

/* ========================================================== */     
void SletKontoPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  Position x,y;
  Dimension width, height;
  int nr;
  nr=indxOfKontoSelection();

  if(nr<0) {
    xfError(ERR_DO_CLICK, NONFATAL, "delete");
    return;
  }
  createSletKontoWidgets();
  
  XtTranslateCoords(topLevel,(Position)110, (Position)20,
		    &x, &y);
  
  XtVaSetValues(sletKontoShell, XtNx, x,
		XtNy, y,
		NULL );
  
  XtSetSensitive(sletKontoKnap,FALSE); 
  XtPopup(sletKontoShell, XtGrabNonexclusive);
}

void SletKontoOk(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int nr;
  nr=indxOfKontoSelection();

  if(nr>=0) {
    ovfFra=-1;   /* reset transfer-accounts */
    ovfTil=-1;
    sletKonto(nr);
    opdaterKontoList();
  }

  XtPopdown(sletKontoShell);
  XtSetSensitive(sletKontoKnap, TRUE); 
}

void SletKontoCancel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(sletKontoShell);
  XtSetSensitive(sletKontoKnap, TRUE); 
}









