/* $Id: saldo.c,v 4.2 1996/07/20 18:07:14 lupus Exp lupus $ */

#include <string.h>

#include "saldop.h"
#include "saldo.h"
#include "xfinans.h"
#include "post.h"
#include "konto.h"
#include "country.h"
#include "allocmem.h"

#define MAXLI MAX_KONTI
#undef BUTW
#define BUTW 75

Widget saldoShell, saldoPane, saldoBox,
  saldoViewp, saldoList,
  saldoClear, saldoClose, saldoSum;

static char *saldoStr[MAXLI];

static int kontoIndx[MAXLI];
static double kontoSaldo[MAXLI];

static int popup=0;
static double sum=0.0;
static int change=0;

saldoInit(void) {
  int i;
  sum=0.0;
  for(i=0; i<MAXLI; i++) {
    saldoStr[i]=0;
    kontoIndx[i]=-1;
    kontoSaldo[i]=0.0;
  }
}

saldoFree(void) {
  int i=0;
  while(saldoStr[i] && i<MAXLI) {
    free(saldoStr[i]);
    saldoStr[i]=0;
    i++;
  }
}

void currentSaldoValid(double currentSaldo) {
  int i=0;
  if(!popup)
    return;
  while(i<MAXLI) {
    if( aktKonto()==kontoIndx[i] ) {
      if(kontoSaldo[i]==currentSaldo)  /* if no change */
	return;
      sum-=kontoSaldo[i];
      kontoSaldo[i]=currentSaldo;
      sum+=kontoSaldo[i];
      change=1;
      opdaterSaldoList();
      return;
    }
    i++;
  }
}

char *printSaldoSum(void) {
  static char buf[40];
  char floatbuf[32];

  sprintf(buf, "Sum: %s", floatString(floatbuf, sum) );
  return buf;
}

char **saldoStrings(char *res[], int maxlines) {
  int i,j;
  char buf[256], floatbuf[32];

  j=0;i=0;
  while(i<MAXLI) {
    if(kontoIndx[i]>=0) {
      sprintf(buf, "%s %s  %s", getKontoName(kontoIndx[i]), getKontoNr(kontoIndx[i]), floatString(floatbuf, kontoSaldo[i]) );
      res[j]=(char *)AllocateMemory(strlen(buf)+1);
      strcpy(res[j],buf);
      j++;
    }
    i++;
  }
  res[j]=0;
  return res;
}

void addKontoToList(int indx) {
  static int done=0;
  int i;

  if(!popup)
    return;

  if(!done) {
    done=1;
    saldoInit();
  }
  
  i=0;
  while(i<MAXLI) {
    if(indx==kontoIndx[i]) {
      /* kontoIndx[i]=-1;  remove indx if allready present: toggle */
      return;
    }
    i++;
  }
  i=0;
  while(i<MAXLI && kontoIndx[i]>=0)
    i++;
  if(i==MAXLI)   /* table is full */
    return;
  change=1;
  kontoIndx[i]=indx;
}

void opdaterSaldoList(void) {
  if(!popup)
    return;  

  if(!change)
    return;

  change=0;
  saldoFree();
  XawListChange(saldoList, saldoStrings(saldoStr,MAXLI), 0,0, TRUE);
  XtVaSetValues(saldoSum,
		XtNlabel, printSaldoSum(),
		NULL);
}

/*
static void SaldoAddAll(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i;
  for(i=0; i<numberOfAccounts(); i++)
    addKontoToList(i);
  opdaterSaldoList();
}
*/

void createSaldoWidgets(void) {
  static int done=0;
/*  Widget saldoAddAll; */

  if(done)
    return;
  done=1;

  saldoInit();

  saldoShell = XtVaCreatePopupShell (
				      "saldoShell",
				      transientShellWidgetClass,
				      topLevel,
				      XtNtitle, BALANCE_TITLE,
				      XtNx,20,
				      XtNy,180,
				      NULL );
  
  saldoPane = XtVaCreateManagedWidget(
				       "saldoPane",
				       panedWidgetClass,
				       saldoShell,
				       XtNheight, 140,
				       XtNwidth, 300,
				       NULL);
  
  saldoBox = XtVaCreateManagedWidget(
				   "saldoBox",
				   boxWidgetClass,
				   saldoPane,
				   NULL);

  saldoClear = XtVaCreateManagedWidget(
				     "saldoClear",
				     commandWidgetClass,
				     saldoBox,
				     XtNlabel, CLEAR_ALL,
				     XtNwidth, BUTW,
				     NULL);

/*
  saldoAddAll = XtVaCreateManagedWidget(
				     "saldoAddAll",
				     commandWidgetClass,
				     saldoBox,
				     XtNlabel, ADD_ALL_LABEL,
				     XtNwidth, BUTW,
				     NULL);
  XtAddCallback(saldoAddAll, XtNcallback, SaldoAddAll, topLevel);
*/

  saldoClose = XtVaCreateManagedWidget(
				     "saldoClose",
				     commandWidgetClass,
				     saldoBox,
				     XtNlabel, CLOSE,
				     XtNwidth, BUTW,
				     NULL);

  saldoSum = XtVaCreateManagedWidget(
				     "saldoSum",
				     labelWidgetClass,
				     saldoBox,
				     XtNlabel, printSaldoSum(),
				     NULL);

  saldoViewp = XtVaCreateManagedWidget(
                                  "saldoViewp",
                                  viewportWidgetClass,
                                  saldoPane,
                                  XtNheight, 65,
                                  /* XtNwidth, 220, */
                                  XtNallowVert, TRUE,
                                  NULL);
 
  saldoList = XtVaCreateManagedWidget(
				       "saldoList",
				       listWidgetClass,
				       saldoViewp,
				       XtNlist, saldoStr,
				       XtNheight, 65,
				       XtNdefaultColumns, 1,
				       XtNpasteBuffer, TRUE,
				       XtNforceColumns, TRUE,
  				       NULL);
  
  addSaldoCallBack();
}

void addSaldoCallBack(void) {
  XtAddCallback(saldoClose, XtNcallback, SaldoClose, topLevel);
  XtAddCallback(saldoClear, XtNcallback, SaldoClear, topLevel);
  XtAddCallback(saldoList, XtNcallback, SaldoListSelectionCallBack, topLevel);
}

/* ========================================================== */     
void SaldoPopup(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  if( !popup ) {
    createSaldoWidgets();

    XtPopup(saldoShell, XtGrabNone);
    popup=1;
    updateMarkWithText(LIST_BALANCES,popup);
  }
  else {
    XtPopdown(saldoShell);
    popup=0;
    updateMarkWithText(LIST_BALANCES,popup);
  }
}

void SaldoClose(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(saldoShell);
  popup=0;
  updateMarkWithText(LIST_BALANCES,popup);
}

void SaldoClear(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  saldoInit();
  change=1;
  opdaterSaldoList();
}

static int indxOfSaldoSelection(void) {      /* returnerer -1, hvis ingen er valgt */
  XawListReturnStruct *res;
  res=XawListShowCurrent(saldoList);
  if( res->list_index==XAW_LIST_NONE )
    return -1;
  else
    return res->list_index;
}

static void SaldoListSelectionCallBack(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int i,j,h;
  i=indxOfSaldoSelection();
  if(i<0)
    return;
  
  j=0;h=-1;
  while(j<MAXLI) {
    if(kontoIndx[j]>=0) {
      h++;
      if(h==i)
	break;
    }
    j++;
  }
  if(j==MAXLI)
    return;
  kontoIndx[j]=-1;
  sum-=kontoSaldo[j];
  kontoSaldo[j]=0.0;
  change=1;
  opdaterSaldoList();
}
