/* $Id: recur.c,v 1.15 1996/01/17 13:07:34 lupus Exp lupus $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>

#include "xfinans.h"
#include "country.h"
#include "window.h"
#include "konto.h"
#include "date.h"
#include "period.h"
#include "datoPrint.h"
#include "programConfig.h"
#include "xfError.h"
#include "str.h"

#if RECURRING_TRANSFER   /* if not, skip the rest of this file */

#define TRANSFER_FILE "recurring"
#define T_TRANSFER 0
#define T_TRANSACTION 1
#define ACCOUNT_TRUNCATE_LENGTH 11  /* number of chars to display 
				       in the rec.transactions list */

#define BUTTON_WIDTH 60

static void AskConfirmDeleteTransfer();

extern Widget topLevel, buttonbox2;

Widget recurShell = NULL;
Widget recurForm;
Widget addButton;
Widget editButton;
Widget deleteButton;
Widget runButton;
Widget closeButton;
Widget recurViewPort;
Widget recurList;

static Widget transferShell = NULL;
static Widget accountListShell = NULL;
static Widget GetRecurringDateShell = NULL;
static Widget confirmShell = NULL;

static int delete_list_index;

struct tstruct {
                 char *From;
		 int  Type;         /* T_TRANSFER or T_TRANSACTION */
                 char *To;
                 char *Text;
                 Date Date;
		 int  Category;
                 double Amount;
                 int Period;
                 int Unit;
                 Date LastRun;
                 struct tstruct *Next;
               } *TransferList = NULL;

struct tstruct *TransferBeingEdited = NULL;

typedef struct {
	         Widget From;
	         Widget To;
	         Widget Text;
	         Widget Amount;
	         Widget Date;
#if CATEGORY_SUPPORT
		 Widget Category;
#endif
		 Widget Period;
		 Widget Unit;
	       } RecurringTransferWidgets;

static RecurringTransferWidgets widgets;
static int accountTurn=0;   /* used for assigning to/from accounts via the
			       main window account list */
static Boolean transferShellIsUp = False;

/* ******************** */

static void ProcessEvents()
{
extern XtAppContext app_context;

    XtAppProcessEvent(app_context,XtIMAll);
}

/* ******** */

static void FreeTransfer(struct tstruct *transfer)
{
	XtFree(transfer->From);
	XtFree(transfer->To);
	XtFree(transfer->Text);
	XtFree((void *)transfer);
}

/* ******** */

static void DeleteATransfer(struct tstruct *target)
{
  struct tstruct *tmp;

  if ((TransferBeingEdited != NULL) && (TransferBeingEdited != target))
    {
      FreeTransfer(TransferBeingEdited);
    }
  if (TransferList == target)
    {
      TransferList = target->Next;
    }
  else
    {
      tmp = TransferList;
      while (tmp->Next != NULL)
	{
	  if (tmp->Next == target)
	    {
	      tmp->Next = target->Next;
	      tmp = TransferList;
	      break;
	    }
	  else
	    {
	      tmp = tmp->Next;
	  }
	}
    }
}

/* ******** */

static void DeleteAllTransfers()
{
struct tstruct *tmp;

	tmp = TransferList;
	while (tmp != NULL)
	{
		TransferList = tmp->Next;
		FreeTransfer(tmp);
		tmp = TransferList;
	}
}

/* ******** */

void ReadTransfers()
{
  struct tstruct *tmp;
  FILE *TransferFILE;
  char text[1024];
  double amount;
  Boolean BogusTransfer;
  Date dat;

  DeleteAllTransfers();
  TransferFILE = fopen(TRANSFER_FILE,"rb");

  if( TransferFILE == NULL )
  {
    return;
  }
  
  BogusTransfer = False;
  while (!feof(TransferFILE))
    {
      if( !fgets(text,1023,TransferFILE) )
	return;
      chop(text);
      tmp = (struct tstruct *)XtMalloc(sizeof(struct tstruct));
      tmp->From = XtNewString(text);
      /* printf("fra: %s\n", text); */ 
      
      fgets(text,1023,TransferFILE);
      chop(text);
      tmp->To = XtNewString(text);
      /* printf("til: %s\n", text); */

      if(strlen(tmp->To)==0)
	tmp->Type=T_TRANSACTION;
      else
	tmp->Type=T_TRANSFER;
      
      fgets(text,1023,TransferFILE);
      chop(text);
      tmp->Text = XtNewString(text);
      
      /* printf("tekst: %s\n", text); */

      fgets(text,1023,TransferFILE);
      tmp->Date = atol(text);
      /* printf("dato : %i\n", tmp->Date); */

      fgets(text,1023,TransferFILE);
      chop(text);
      tmp->Category = atoi(text);
      /* printf("kat. : %i\n", tmp->Category); */
      
      fgets(text,1023,TransferFILE);
      chop(text);
      tmp->Period = atoi(text);
      /* printf("interval: %i\n", tmp->Period); */
      
      fgets(text,1023,TransferFILE);
      chop(text);
      tmp->Unit = atoi(text);

      /* printf("enhed: %i\n", tmp->Unit); */
      
      fgets(text,1023,TransferFILE);
      chop(text);
      tmp->Amount = atof(text);

      /* printf("bel. :%f\n", tmp->Amount); */
      
      fgets(text,1023,TransferFILE);
      chop(text);
      tmp->LastRun = atol(text);

      tmp->Next = TransferList;
      if (BogusTransfer == True)
	{
	  FreeTransfer(tmp);
	}
      else
	{
	  TransferList = tmp;
	}
    }
  fclose(TransferFILE);
}

/* ******** */

static void WriteTransfers()
{
  struct tstruct *tmp;
  FILE *TransferFILE;
  
  tmp = TransferList;
  TransferFILE = fopen(TRANSFER_FILE,"wb");
  
  if( TransferFILE == NULL )
  {
    xfError(ERR_WRITE_TRANS, NONFATAL,"can't write");
    return;
  }
  
  while (tmp != NULL)
    {
      fprintf(TransferFILE,"%s\n",tmp->From);
      fprintf(TransferFILE,"%s\n",tmp->To);
      fprintf(TransferFILE,"%s\n",tmp->Text);
      fprintf(TransferFILE,"%lu\n",tmp->Date);
      fprintf(TransferFILE,"%i\n",tmp->Category);
      fprintf(TransferFILE,"%i\n",tmp->Period);
      fprintf(TransferFILE,"%i\n",tmp->Unit);
      fprintf(TransferFILE,"%.2lf\n",tmp->Amount);
      fprintf(TransferFILE,"%lu\n",tmp->LastRun);
      tmp = tmp->Next;
    }
  fclose(TransferFILE);
}

/* ******** */

Boolean RunTransfers(Date TargetDate)
{
  struct tstruct *tmp;
  extern int OvfIsUp, postIsPopup;
  extern int ovfFra, ovfTil;
  extern Widget ovfdatoIn, ovftekstIn, ovfbelIn, postList;
  extern Widget datoIn, tekstIn, belIn, periodInput, catNumInput, catNameLabel;
  int indx;
  char buf[80];

  /* printf("RunTransfers()\n"); */

  if (XtIsRealized(topLevel) == False) return(False);
  if (TransferList == NULL)
    {
      return(True);   /* the transfer list must have been read at this point
			 otherwise an error has occurred. (ReadTransfers is 
			 now called from window.c)
		      */
    }

  tmp = TransferList;
  while (tmp != NULL)
    {
      if (tmp->Period > 0)
	{
	  while (nextDate(tmp->LastRun,tmp->Unit,tmp->Period) <= TargetDate)
	    {
	      char buf[100];
	      /*
		 printf("Run transfer >%s<\n",tmp->Text);
		 */

	      tmp->LastRun = nextDate(tmp->LastRun,tmp->Unit,tmp->Period);
	      
	      if( tmp->Type==T_TRANSFER ) {
		ovfFra = getKontoIndex(tmp->From);
		ovfTil = getKontoIndex(tmp->To);
		if( ovfFra >=0 && ovfTil >=0 ) {
		  XtVaSetValues(ovfdatoIn,
				XtNstring, dateString(tmp->LastRun),
				NULL);
		  XtVaSetValues(ovftekstIn,
				XtNstring, tmp->Text,
				NULL);
		  
		  sprintf(buf,"%.2f",tmp->Amount);
		  XtVaSetValues(ovfbelIn,
				XtNstring, buf,
				NULL);
		  XawListUnhighlight(postList);
		  OvfPopup(NULL,NULL,NULL);
		  while (OvfIsUp)
		    {
		      ProcessEvents();
		    }
		}
	      } else /* "ordinary" transaction */
		if( (indx=getKontoIndex(tmp->From)) >= 0 ) {
		  loadKonto(indx);
		  XtVaSetValues(datoIn,
				XtNstring, dateString(tmp->LastRun),
				NULL);
		  XtVaSetValues(tekstIn,
				XtNstring, tmp->Text,
				NULL);
		  
		  sprintf(buf,"%.2f",tmp->Amount);
		  XtVaSetValues(belIn,
				XtNstring, buf,
				NULL);

		  sprintf(buf, "%d", tmp->Period);
		  XtVaSetValues(periodInput,
				XtNstring, buf,
				NULL);
		  set_period_unit(tmp->Unit, TRANSACTION_UNIT_MENU);
		  
#if CATEGORY_SUPPORT
		  sprintf(buf, "%d", tmp->Category);
		  SetCategory(catNumInput, catNameLabel, buf);
#endif

		  XawListUnhighlight(postList);
		  PosteringPopup(0,(XtPointer)NYPOST,0);
		  while (postIsPopup)
		    {
		      ProcessEvents();
		    }
		}
	    }
	}
      tmp = tmp->Next;
    }
  WriteTransfers();
  /*
     printf("RunTransfers()... done\n");
     */
  return(True);
}

/* ******** */

static char **transferStrings()
{
static char **ts = NULL;
struct tstruct *tmp;
int i;
char buf[1024], buf1[1024];
char *s;

	if (ts != NULL)
	{
	  for( i=0, s=ts[0]; s!=NULL; i++, s=ts[i] )
	    XtFree(s);
	  XtFree((void *)ts);
	}
	i = 0;
	ts = (char **)XtMalloc((i + 1) * sizeof(char *));
	ts[i] = NULL;
	tmp = TransferList;
	while (tmp != NULL)
	{
		i++;
		ts = (char **)XtRealloc((void *)ts,(i + 1) * sizeof(char *));

#if VERBOSE_RECURRING_LIST
                zeroAddStrncpy(buf1, tmp->From, ACCOUNT_TRUNCATE_LENGTH);
                sprintf(buf, "%s  %s", dateString(nextDate(tmp->LastRun,tmp->Unit,tmp->Period)), buf1);
                if( tmp->Type==T_TRANSFER ) {
                  zeroAddStrncpy(buf1, tmp->To, ACCOUNT_TRUNCATE_LENGTH);
                  strcat(buf, " -> ");
                  strcat(buf, buf1);
                }

                sprintf(buf1, " : %s  %.2f", tmp->Text, tmp->Amount);
                strcat(buf, buf1);

#else
		sprintf(buf, "%s ", dateString(nextDate(tmp->LastRun,tmp->Unit,tmp->Period)));
		if (strlen(tmp->Text) == 0)
		{
			zeroAddStrncpy(&buf[strlen(buf)], tmp->From, ACCOUNT_TRUNCATE_LENGTH);
			if( tmp->Type==T_TRANSFER )
			{
			  strcat(&buf[strlen(buf)], " -> ");
			  zeroAddStrncpy(&buf[strlen(buf)], tmp->To, ACCOUNT_TRUNCATE_LENGTH);
			}
		}
		else
		{
			sprintf(&buf[strlen(buf)], "%s", tmp->Text);
		}
		sprintf(&buf[strlen(buf)]," %.2f",tmp->Amount);
#endif
		ts[i-1] = XtNewString(buf);
		ts[i] = NULL;
		tmp = tmp->Next;
	}
	return(ts);
}

/* ******** */

static XtCallbackProc CloseRecurringTransfers(Widget w, Boolean *client_data)
{
	*client_data = FALSE;
        updateMarksWithOpcode(43, 0);  /* remove check-mark on main menu */
	XtPopdown(recurShell);
	WriteTransfers();
}

/* ******** */

static XtCallbackProc ClearTextWidget(Widget w, Widget client_data)
{
  XtVaSetValues(client_data,
		XtNstring, "",
		NULL);
}

/* ******** */

static XtCallbackProc Close(Widget w, Boolean *client_data)
{
	*client_data = FALSE;
	XtPopdown(transferShell);
	if (TransferBeingEdited != NULL)
	{
		/*
		printf("put the transfer back in\n");
		*/
		TransferBeingEdited->Next = TransferList;
		TransferList = TransferBeingEdited;
		TransferBeingEdited = NULL;
		XawListChange(recurList,transferStrings(),0,0,True);
	}
	WriteTransfers();
}

/* ******** */

static XtCallbackProc AddTransfer(Widget w,RecurringTransferWidgets *widgets)
{
  char *text;
  struct tstruct *tmp;
  String *list;
  String *index;
  
  if ( TransferBeingEdited != NULL )
    {
      FreeTransfer(TransferBeingEdited);
      TransferBeingEdited = NULL;
    }
  
  tmp = (struct tstruct *)XtMalloc(sizeof(struct tstruct));
  XtVaGetValues(widgets->From,XtNstring,&text,NULL);
  tmp->From = XtNewString(text);
  
  XtVaGetValues(widgets->To,XtNstring,&text,NULL);
  tmp->To = XtNewString(text);
  if(strlen(text)==0)
    tmp->Type=T_TRANSACTION;
  else
    tmp->Type=T_TRANSFER;
  
  XtVaGetValues(widgets->Text,XtNstring,&text,NULL);
  tmp->Text = XtNewString(text);
  
  XtVaGetValues(widgets->Date,XtNstring,&text,NULL);
  tmp->Date = parseDate(text);

#if CATEGORY_SUPPORT
  XtVaGetValues(widgets->Category,XtNstring,&text,NULL);
  tmp->Category = atoi(text);
#else
  tmp->Category = 0;
#endif  

  XtVaGetValues(widgets->Amount,XtNstring,&text,NULL);
  
  tmp->Amount = strToFloat(text);
  
  XtVaGetValues(widgets->Period,XtNstring,&text,NULL);
  tmp->Period = atoi(text);
  
  tmp->Unit = get_period_unit(RECUR_UNIT_MENU);
  
  tmp->LastRun = prevDate(tmp->Date, tmp->Unit, tmp->Period);
  
  tmp->Next = TransferList;
  TransferList = tmp;
  list = transferStrings();
  XawListChange(recurList,list,0,0,True);

  transferShellIsUp = False;
  XtPopdown(transferShell);
}

/* ******** */

static Widget makeTransferDialog(struct tstruct *Transfer)
{
extern Pixmap menuButtonMark;
Position x,y;
Widget transferForm;
Widget cancelButton;
Widget okButton;
Widget fromLabel;
Widget toLabel;
Widget toClearButton;
Widget dateLabel;
#if CATEGORY_SUPPORT
Widget categoryLabel;
#endif
Widget textLabel;
Widget amountLabel;
Widget datoIn;
Widget dagsDato;
Widget plusDato;
Widget minusDato;
Widget plusPeriod;
Widget minusPeriod;
Widget periodLabel;
Widget periodInput;
Widget periodUnit;
Widget widget_above_text;

	if (transferShell == NULL)
	{
		transferShell = XtVaCreatePopupShell (
					   "recurtransferShell",
					   transientShellWidgetClass,
					   topLevel,
					   XtNtitle, RECURRING_TRANSACTION,
					   NULL );

		transferForm = XtVaCreateManagedWidget(
					    "recurtransferForm",
					    formWidgetClass,
					    transferShell,
					    NULL);

		fromLabel = XtVaCreateManagedWidget(
					  "recurfromLabel",
					  labelWidgetClass,
					  transferForm,
					  XtNlabel, RECURRING_FROM_LABEL,
					  NULL);

		widgets.From = XtVaCreateManagedWidget(
                                      "recurfromText",
                                      asciiTextWidgetClass,
                                      transferForm,
                                      XtNeditType, XawtextRead,
				      XtNdisplayCaret, False,
                                      XtNwidth, 220, 
                                      XtNfromHoriz, fromLabel,
                                      XtNresize, XawtextResizeWidth,
                                      NULL);

		toLabel = XtVaCreateManagedWidget(
					  "recurtoLabel",
					  labelWidgetClass,
					  transferForm,
					  XtNlabel, RECURRING_TO_LABEL,
					  XtNfromVert, fromLabel,
					  NULL);

		widgets.To = XtVaCreateManagedWidget(
                                      "recurtoText",
                                      asciiTextWidgetClass,
                                      transferForm,
                                      XtNeditType, XawtextRead,
				      XtNdisplayCaret, False,
                                      XtNwidth, 220,
                                      XtNfromVert, widgets.From,
                                      XtNfromHoriz, toLabel,
                                      XtNresize, XawtextResizeWidth,
                                      NULL);

		toClearButton = XtVaCreateManagedWidget(
						"recurtoClearButton",
						commandWidgetClass,
						transferForm,
						XtNlabel, CLEAR_LABEL,
						XtNfromHoriz, widgets.To,
						XtNfromVert, widgets.From,
						XtNwidth, BUTTON_WIDTH,
						NULL);
		XtAddCallback(toClearButton, XtNcallback, (XtCallbackProc) ClearTextWidget, widgets.To);

		dateLabel = XtVaCreateManagedWidget(
					  "recurdateLabel",
					  labelWidgetClass,
					  transferForm,
					  XtNlabel, DATE,
					  XtNfromVert, toLabel,
					  /* XtNfromHoriz, quit, */
					  /* XtNright, XtChainRight, */
					  NULL);

		widgets.Date = XtVaCreateManagedWidget(
                                  "recurdatoIn",
                                   asciiTextWidgetClass,
                                   transferForm,
                                   XtNeditType, XawtextEdit,
                                   XtNwidth, DATEWIDTH,
                                   XtNfromHoriz, dateLabel,
					  XtNfromVert, widgets.To,
                                   NULL);
  
		dagsDato = XtVaCreateManagedWidget(
                                     "recurdagsDato",
                                     commandWidgetClass,
                                     transferForm,
                                     XtNlabel, TODAY,
                                     XtNfromHoriz, widgets.Date,
					  XtNfromVert, widgets.To,
					  XtNwidth, BUTTON_WIDTH,
                                     NULL);
		XtAddCallback(dagsDato, XtNcallback, DagsDato, widgets.Date);
  
		plusDato = XtVaCreateManagedWidget(
                                     "recurplusDato",
                                     commandWidgetClass,
                                     transferForm,
                                     XtNlabel, INCR,
                                     XtNwidth, PLUS_BUTW,
                                     XtNfromHoriz, dagsDato,
					  XtNfromVert, widgets.To,
                                     NULL);
		XtAddCallback(plusDato, XtNcallback, PlusDato, widgets.Date);

		minusDato = XtVaCreateManagedWidget(
                                      "recurminusDato",
                                      commandWidgetClass,
                                      transferForm,
                                      XtNlabel, DECR,
                                      XtNwidth, PLUS_BUTW,
                                      XtNfromHoriz, plusDato,
					  XtNfromVert, widgets.To,
                                      NULL);
		XtAddCallback(minusDato, XtNcallback, MinusDato, widgets.Date);

		plusPeriod = XtVaCreateManagedWidget(
                                    "recurplusPeriod",
                                    commandWidgetClass,
                                    transferForm,
                                    XtNwidth, PLUS_BUTW,
                                    XtNlabel, INCR_MONTH,
                                    XtNfromHoriz, minusDato,
					  XtNfromVert, widgets.To,
                                    NULL);
		XtAddCallback(plusPeriod, XtNcallback, PlusMon, widgets.Date);

		minusPeriod = XtVaCreateManagedWidget(
                                     "recurminusPeriod",
                                     commandWidgetClass,
                                     transferForm,
                                    XtNwidth, PLUS_BUTW,
                                     XtNlabel, DECR_MONTH,
                                     XtNfromHoriz, plusPeriod,
					  XtNfromVert, widgets.To,
                                     NULL);
		XtAddCallback(minusPeriod, XtNcallback, MinusMon, widgets.Date);

		periodLabel = XtVaCreateManagedWidget(
                                    "recurperiodLabel",
                                    labelWidgetClass,
                                    transferForm,
                                    XtNlabel, RECURRING_PERIOD_LABEL,
				    XtNfromVert, widgets.Date,
                                    NULL);

		widgets.Period = XtVaCreateManagedWidget(
                                  "recurperiodInput",
                                   asciiTextWidgetClass,
                                   transferForm,
                                   XtNeditType, XawtextEdit,
                                   XtNstring, "1",
                                   XtNwidth, PERIODWIDTH,
                                   XtNfromHoriz, periodLabel,
				   XtNfromVert, widgets.Date,
                                   NULL);

		widgets.Unit =  XtVaCreateManagedWidget(
                                        "recurperiodUnit",
                                        menuButtonWidgetClass,
                                        transferForm,
                                        XtNmenuName, "recurUnitMenu",
                                        XtNlabel, UNIT_LABEL,
                                        XtNleftBitmap, menuButtonMark,
                                        XtNfromHoriz, widgets.Period,
					  XtNfromVert, widgets.Date,
                                        NULL);
		create_menu(RECUR_UNIT_MENU, "recurUnitMenu", widgets.Unit);
		set_period_unit(P_MONTH, RECUR_UNIT_MENU);

#if CATEGORY_SUPPORT
		categoryLabel = XtVaCreateManagedWidget(
				     "recurcategoryLabel",
				     labelWidgetClass,
				     transferForm,
				     XtNlabel, CAT_NUM_TEXT_LABEL,
				     XtNfromVert, periodLabel,
				     NULL);

		widgets.Category = XtVaCreateManagedWidget(
				    "recurwidgets_category",
				    asciiTextWidgetClass,
				    transferForm,
				    XtNeditType, XawtextEdit,
				    XtNwidth, DATEWIDTH,
				    XtNfromHoriz, categoryLabel,
				    XtNfromVert, periodLabel,
				    NULL);
		widget_above_text = categoryLabel;
#else
		widget_above_text = periodLabel;
#endif

		textLabel = XtVaCreateManagedWidget(
					  "recurtextLabel",
					  labelWidgetClass,
					  transferForm,
					  XtNlabel, TEXT_LABEL,
					  XtNfromVert, widget_above_text,
					  /* XtNfromHoriz, quit, */
					  /* XtNright, XtChainRight, */
					  NULL);

		widgets.Text = XtVaCreateManagedWidget(
                                      "recurtextText",
                                      asciiTextWidgetClass,
                                      transferForm,
                                      XtNeditType, XawtextEdit,
                                      XtNwidth, 300,
                                      XtNfromVert, widget_above_text,
                                      XtNfromHoriz, textLabel,
                                      XtNresize, XawtextResizeWidth,
                                      NULL);

		amountLabel = XtVaCreateManagedWidget(
					  "recuramountLabel",
					  labelWidgetClass,
					  transferForm,
					  XtNlabel, AMOUNT_LABEL,
					  XtNfromVert, textLabel,
					  /* XtNfromHoriz, quit, */
					  /* XtNright, XtChainRight, */
					  NULL);

		widgets.Amount = XtVaCreateManagedWidget(
                                      "recuramountText",
                                      asciiTextWidgetClass,
                                      transferForm,
                                      XtNeditType, XawtextEdit,
                                      /* XtNwidth, 64, */
                                      XtNfromVert, textLabel,
                                      XtNfromHoriz, amountLabel,
                                      XtNresize, XawtextResizeWidth,
                                      NULL);

		okButton = XtVaCreateManagedWidget(
						"recurokButton",
						commandWidgetClass,
						transferForm,
						XtNlabel, CONFIRM_LABEL,
						XtNfromVert, amountLabel,
						XtNwidth, BUTTON_WIDTH,
						NULL);
		XtAddCallback(okButton, XtNcallback, (XtCallbackProc) AddTransfer, &widgets);

		cancelButton = XtVaCreateManagedWidget(
						"recurcancelButton",
						commandWidgetClass,
						transferForm,
						XtNlabel, CANCEL_LABEL,
						XtNfromVert, amountLabel,
						XtNfromHoriz, okButton,
						XtNwidth, BUTTON_WIDTH,
						NULL);
		XtAddCallback(cancelButton, XtNcallback, (XtCallbackProc) Close, &transferShellIsUp);

		saveFocusInfo(widgets.Date, widgets.Period, transferForm, okButton, 1);
#if CATEGORY_SUPPORT
		saveFocusInfo(widgets.Period, widgets.Category, transferForm, okButton, 0);
		saveFocusInfo(widgets.Category, widgets.Text, transferForm, okButton, 0);
#else
		saveFocusInfo(widgets.Period, widgets.Text, transferForm, okButton, 0);
#endif
		saveFocusInfo(widgets.Text, widgets.Amount, transferForm, okButton, 0);
		saveFocusInfo(widgets.Amount, widgets.Date, transferForm, okButton, 0);
  }
  if (Transfer != NULL)
    {
      char buf[1024];
      
      XtVaSetValues(widgets.From, 
		    XtNstring, Transfer->From,
		    NULL );
      XtVaSetValues(widgets.To, 
		    XtNstring, Transfer->To,
		    NULL );
      XtVaSetValues(widgets.Text, 
		    XtNstring, Transfer->Text,
		    NULL );
      XtVaSetValues(widgets.Date, 
		    XtNstring, dateString(nextDate(Transfer->LastRun,Transfer->Unit,Transfer->Period)), 
		    NULL );
#if CATEGORY_SUPPORT
      sprintf(buf,"%i",Transfer->Category);
      XtVaSetValues(widgets.Category, 
		    XtNstring, buf,
		    NULL );
#endif
      set_period_unit(Transfer->Unit, RECUR_UNIT_MENU);
      sprintf(buf,"%i",Transfer->Period);
      XtVaSetValues(widgets.Period, 
		    XtNstring, buf,
		    NULL );
      sprintf(buf,"%.2lf",Transfer->Amount);
      XtVaSetValues(widgets.Amount, 
		    XtNstring, buf,
		    NULL );
    }
   jumpTo(widgets.Date);  /* set input focus */

   XtTranslateCoords(buttonbox2, X_PPOS, 25,
		  &x, &y);

   XtVaSetValues(transferShell, 
	      XtNx, x,
	      XtNy, y,
	      NULL );

   return(transferShell);
}

/* ******** */

static void addTransfer(Widget w, Widget List)
{
  accountTurn=0;
  transferShellIsUp=True;
  XtPopup(makeTransferDialog(NULL),XtGrabNone);
}

/* ******** */

void setToFromAccount(char *account) {
  if( !transferShellIsUp)
    return;

  if( accountTurn==0 )
    XtVaSetValues(widgets.From, XtNstring, account, NULL);
  else
    XtVaSetValues(widgets.To, XtNstring, account, NULL);
  accountTurn=!accountTurn;
  XRaiseWindow(XtDisplay(transferShell),XtWindow(transferShell));
}

/* ******** */

static void DeleteTransfer(Widget w, Widget List)
{
  XawListReturnStruct *Item;
  /*
   printf("DeleteTransfer(%s,%s)\n",XtName(w),XtName(List));
   */
  Item = XawListShowCurrent(List);
  if ((delete_list_index=Item->list_index) == XAW_LIST_NONE)
    {
      xfError(ERR_DO_CLICK_POSTING,NONFATAL,"recurring");
    }
  else
    {
      AskConfirmDeleteTransfer();
    }
}


/* ******** */

static void EditTransfer(Widget w, Widget List)
{
XawListReturnStruct *Item;
struct tstruct *Transfer;

	/*
	printf("EditTransfer(%s,%s)\n",XtName(w),XtName(List));
	*/
	Item = XawListShowCurrent(List);
	if (Item->list_index == XAW_LIST_NONE)
	{
	        xfError(ERR_DO_CLICK_POSTING,NONFATAL,"recurring");
	}
	else
	{
		/*
		printf("selected item >%s< >%i<\n",Item->string,Item->list_index);
		*/
		Transfer = TransferList;
		while(Item->list_index > 0)
		{
			Transfer = Transfer->Next;
			Item->list_index--;
		}
		accountTurn=0;
		transferShellIsUp=True;
		XtPopup(makeTransferDialog(Transfer),XtGrabNone);
		TransferBeingEdited = Transfer;
		DeleteATransfer(Transfer);
		XawListChange(recurList,transferStrings(),0,0,True);
	}
}

/* ******** */

static void CloseGetRecurringDate(Widget w)
{
        XtPopdown(GetRecurringDateShell);
}

/* ******** */

static void RunUpTo(Widget w, Widget Date)
{
String text;

/*
        printf("RunUpTo(%s,%s)\n",XtName(w),XtName(Date));
*/
        CloseGetRecurringDate(w);
        XtVaGetValues(Date,XtNstring,&text,NULL);
/*
        printf("%lu,%s\n",parseDate(text),text);
*/
        RunTransfers(parseDate(text));
        XawListChange(recurList,transferStrings(),0,0,True);
}

/* ******** */

static void GetRecurringDate()
{
extern Pixmap menuButtonMark;
static Widget Date;
static period_call_data run_recurring_period_call_data;
Widget GetRecurringDateForm;
Widget dateLabel;
Widget dagsDato;
Widget plusDato;
Widget minusDato;
Widget plusPeriod;
Widget minusPeriod;
Widget periodLabel;
static Widget Period;
static Widget Unit;
Widget okButton;
Widget cancelButton;
Position x,y;
String p;

/*
	printf("GetRecurringDate()\n");
*/
        if (GetRecurringDateShell == NULL)
        {
                GetRecurringDateShell = XtVaCreatePopupShell (
                                           "GetRecurringDateShell",
                                           transientShellWidgetClass,
                                           topLevel,
                                           XtNtitle, "Run Recurring Transfers up to?",
                                           NULL );

                GetRecurringDateForm = XtVaCreateManagedWidget(
                                            "recurGetRecurringDateForm",
                                            formWidgetClass,
                                            GetRecurringDateShell,
                                            NULL);

                dateLabel = XtVaCreateManagedWidget(
                                          "recurdateLabel",
                                          labelWidgetClass,
                                          GetRecurringDateForm,
                                          XtNlabel, DATE,
                                          /* XtNfromVert, toLabel, */
                                          /* XtNfromHoriz, quit, */
                                          /* XtNright, XtChainRight, */
                                          NULL);

		Date = XtVaCreateManagedWidget(
                                  "recurdatoIn",
                                   asciiTextWidgetClass,
                                   GetRecurringDateForm,
                                   XtNeditType, XawtextEdit,
                                   XtNwidth, DATEWIDTH,
                                   XtNstring, dateString(today()),
                                   XtNfromHoriz, dateLabel,
                                          /* XtNfromVert, widgets.To, */
                                   NULL);
  
		dagsDato = XtVaCreateManagedWidget(
                                     "recurdagsDato",
                                     commandWidgetClass,
                                     GetRecurringDateForm,
                                     XtNlabel, TODAY,
                                     XtNfromHoriz, Date,
                                     NULL);
		XtAddCallback(dagsDato, XtNcallback, DagsDato, Date);
  
		plusDato = XtVaCreateManagedWidget(
                                     "recurplusDato",
                                     commandWidgetClass,
                                     GetRecurringDateForm,
                                     XtNlabel, INCR,
                                     XtNwidth, PLUS_BUTW,
                                     XtNfromHoriz, dagsDato,
                                     NULL);
		XtAddCallback(plusDato, XtNcallback, PlusDato, Date);

		minusDato = XtVaCreateManagedWidget(
                                      "recurminusDato",
                                      commandWidgetClass,
                                      GetRecurringDateForm,
                                      XtNlabel, DECR,
                                      XtNwidth, PLUS_BUTW,
                                      XtNfromHoriz, plusDato,
                                      NULL);
		XtAddCallback(minusDato, XtNcallback, MinusDato, Date);

		plusPeriod = XtVaCreateManagedWidget(
                                    "recurplusPeriod",
                                    commandWidgetClass,
                                    GetRecurringDateForm,
                                    XtNlabel, INCR_PERIOD,
                                    XtNfromHoriz, minusDato,
                                    NULL);

		minusPeriod = XtVaCreateManagedWidget(
                                     "recurminusPeriod",
                                     commandWidgetClass,
                                     GetRecurringDateForm,
                                     XtNlabel, DECR_PERIOD,
                                     XtNfromHoriz, plusPeriod,
                                     NULL);

		periodLabel = XtVaCreateManagedWidget(
                                    "recurperiodLabel",
                                    labelWidgetClass,
                                    GetRecurringDateForm,
                                    XtNlabel, PERIOD_LABEL,
                                    XtNfromHoriz, minusPeriod,
                                    NULL);

		Period = XtVaCreateManagedWidget(
                                  "recurperiodInput",
                                   asciiTextWidgetClass,
                                   GetRecurringDateForm,
                                   XtNeditType, XawtextEdit,
                                   XtNstring, "1",
                                   XtNwidth, PERIODWIDTH,
                                   XtNfromHoriz, periodLabel,
                                   NULL);

		Unit =  XtVaCreateManagedWidget(
                                        "recurperiodUnit",
                                        menuButtonWidgetClass,
                                        GetRecurringDateForm,
                                        XtNmenuName, "runRecurUnitMenu",
                                        XtNlabel, UNIT_LABEL,
                                        XtNleftBitmap, menuButtonMark,
                                        XtNfromHoriz, Period,
                                        NULL);
		create_menu(RUN_RECUR_UNIT_MENU, "runRecurUnitMenu", Unit);
		set_period_unit(P_MONTH, RUN_RECUR_UNIT_MENU);

		run_recurring_period_call_data.dateField = Date;
		run_recurring_period_call_data.periodLengthField = Period;
		run_recurring_period_call_data.menuID = RUN_RECUR_UNIT_MENU;

		XtAddCallback(plusPeriod, XtNcallback, PlusPeriod, &run_recurring_period_call_data);
		XtAddCallback(minusPeriod, XtNcallback, MinusPeriod, &run_recurring_period_call_data);

                okButton = XtVaCreateManagedWidget(
                                                "recurokButton",
                                                commandWidgetClass,
                                                GetRecurringDateForm,
                                                XtNlabel, CONFIRM_LABEL,
                                                XtNfromVert, Date,
                                                /* XtNfromHoriz, recurViewPort, */ 
						XtNwidth, BUTTON_WIDTH,
                                                NULL);
                XtAddCallback(okButton, XtNcallback, (XtCallbackProc) RunUpTo, Date);

                cancelButton = XtVaCreateManagedWidget(
                                                "recurcancelButton",
                                                commandWidgetClass,
                                                GetRecurringDateForm,
                                                XtNlabel, CANCEL_LABEL,
                                                XtNfromVert, Date,
                                                XtNfromHoriz, okButton,
						XtNwidth, BUTTON_WIDTH,
                                                NULL);
                XtAddCallback(cancelButton, XtNcallback, (XtCallbackProc) CloseGetRecurringDate,NULL);
		saveFocusInfo(Date, Period, GetRecurringDateShell, okButton, 1);
		saveFocusInfo(Period, Date, GetRecurringDateShell, okButton, 0);
        }
        XtTranslateCoords(recurShell, X_PPOS, 25,
                    &x, &y);

        XtVaSetValues(GetRecurringDateShell, 
                XtNx, x,
                XtNy, y,
                NULL );
	XtPopup(GetRecurringDateShell,XtGrabNone);
}

/* ******** */

void EditRecurringTransfers(Widget w, XtPointer client_data, XtPointer call_data)
{
static Boolean IsUp = FALSE;
Position x,y;

	if (IsUp == TRUE) return;
	if (recurShell == NULL)
	{
		recurShell = XtVaCreatePopupShell (
					   "recurShell",
					   transientShellWidgetClass,
					   topLevel,
					   XtNtitle, RECURRING_TRANSACTIONS,
					  XtNresizable, TRUE,
					   NULL );

		recurForm = XtVaCreateManagedWidget(
					    "recurForm",
					    formWidgetClass,
					    recurShell,
					  XtNresizable, TRUE,
					    NULL);

		recurViewPort = XtVaCreateManagedWidget(
					  "recurViewPort",
					  viewportWidgetClass,
					  recurForm,
					  XtNallowVert, TRUE,
					  XtNforceBars, TRUE,
					  /*
					  XtNresizable, TRUE,
					  */
					  XtNwidth,350,
					  XtNheight,120,
					  /* XtNuseRight,True, */
					  XtNleft,XawChainLeft,
					  XtNtop,XawChainTop,
					  XtNbottom,XawChainBottom,
					  NULL);

		recurList = XtVaCreateManagedWidget(
					      "recurList",
					      listWidgetClass,
					      recurViewPort,
					      XtNlist,transferStrings(),
					      XtNforceColumns,True,
					      XtNdefaultColumns,1,
					      XtNresizable, TRUE,
					      NULL);

		addButton = XtVaCreateManagedWidget(
						"recuraddButton",
						commandWidgetClass,
						recurForm,
						XtNlabel, RECURRING_ADD_LABEL,
						XtNfromHoriz, recurViewPort,
						XtNleft,XawChainRight,
						XtNright,XawChainRight,
						XtNwidth, BUTTON_WIDTH,
						NULL);
		XtAddCallback(addButton, XtNcallback, (XtCallbackProc) addTransfer, recurList);
  
		editButton = XtVaCreateManagedWidget(
						"recureditButton",
						commandWidgetClass,
						recurForm,
						XtNlabel, RECURRING_EDIT_LABEL,
						XtNfromVert, addButton,
						XtNfromHoriz, recurViewPort,
						XtNleft,XawChainRight,
						XtNright,XawChainRight,
						XtNwidth, BUTTON_WIDTH,
						NULL);
		XtAddCallback(editButton, XtNcallback, (XtCallbackProc) EditTransfer, recurList);
  
		deleteButton = XtVaCreateManagedWidget(
						"recurdeleteButton",
						commandWidgetClass,
						recurForm,
						XtNlabel, RECURRING_DELETE_LABEL,
						XtNfromVert, editButton,
						XtNfromHoriz, recurViewPort,
						XtNleft,XawChainRight,
						XtNright,XawChainRight,
						XtNwidth, BUTTON_WIDTH,
						NULL);
		XtAddCallback(deleteButton, XtNcallback, (XtCallbackProc) DeleteTransfer, recurList);
  
                runButton = XtVaCreateManagedWidget(
                                                "recurrunButton",
                                                commandWidgetClass,
                                                recurForm,
                                                XtNlabel, RECURRING_RUN_LABEL,
                                                XtNfromVert, deleteButton,
                                                XtNfromHoriz, recurViewPort,
                                                XtNleft,XawChainRight,
                                                XtNright,XawChainRight,
						XtNwidth, BUTTON_WIDTH,
                                                NULL);
                XtAddCallback(runButton, XtNcallback, (XtCallbackProc) GetRecurringDate, (XtPointer)NULL);

		closeButton = XtVaCreateManagedWidget(
						"recurcloseButton",
						commandWidgetClass,
						recurForm,
						XtNlabel, CLOSE,
						XtNfromVert, runButton,
						XtNfromHoriz, recurViewPort,
						XtNleft,XawChainRight,
						XtNright,XawChainRight,
						XtNwidth, BUTTON_WIDTH,
						NULL);
		XtAddCallback(closeButton, XtNcallback, (XtCallbackProc) CloseRecurringTransfers, (XtPointer)&IsUp);
  

	}
	XawListChange(recurList,transferStrings(),0,0,True);
	XtTranslateCoords(buttonbox2, X_PPOS, 25,
		    &x, &y);

	XtVaSetValues(recurShell, 
		XtNx, x,
		XtNy, y,
		NULL );
	IsUp = TRUE;
        updateMarksWithOpcode(43, 1);  /* set check-mark on menu */
	XtPopup(recurShell, XtGrabNone);
}

static void CancelTransferDelete(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  XtPopdown(confirmShell);
}

static void ConfirmTransferDelete(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  struct tstruct *Transfer;
  int i;
  
  Transfer = TransferList;
  i=delete_list_index;
  if( i!= XAW_LIST_NONE ) {
    while(i > 0)
      {
	Transfer = Transfer->Next;
	i--;
      }
    DeleteATransfer(Transfer);
    XawListChange(recurList,transferStrings(),0,0,True);
  }
  XtPopdown(confirmShell);
}

static void AskConfirmDeleteTransfer()
{
  Position x,y;
  Widget conform, confirm, confirmOk, confirmCancel;

  if (confirmShell == NULL)
    {
      confirmShell = XtVaCreatePopupShell (
					   "recurconfirmShell",
					   transientShellWidgetClass,
					   topLevel,
					   XtNtitle, WARNING_TITLE,
					   NULL );
      
      conform = XtVaCreateManagedWidget(
				    "recurconform",
				    formWidgetClass,
				    confirmShell,
				    NULL);
  
      confirm = XtVaCreateManagedWidget(
				    "recurconfirm",
				    labelWidgetClass,
				    conform,
				    XtNlabel, WARNING_TEXT_POST,
				    NULL);

      confirmOk = XtVaCreateManagedWidget(
				      "recurconfirmOk",
				      commandWidgetClass,
				      conform,
				      XtNlabel, CONFIRM_LABEL,
				      XtNwidth, BUTW,
				      XtNfromVert, confirm, 
				      NULL);
      
      XtAddCallback(confirmOk, XtNcallback, ConfirmTransferDelete, 0);

      confirmCancel = XtVaCreateManagedWidget(
					  "recurconfirmCancel",
					  commandWidgetClass,
					  conform,
					  XtNlabel, CANCEL_LABEL,
					  XtNfromVert, confirm, 
					  XtNfromHoriz, confirmOk, 
					  NULL);
      XtAddCallback(confirmCancel, XtNcallback, CancelTransferDelete, 0);
    }
  XtTranslateCoords(recurShell, X_PPOS, 25,
		    &x, &y);
  
  XtVaSetValues(confirmShell, 
		XtNx, x,
		XtNy, y,
		NULL );

  XtPopup(confirmShell, XtGrabNone);
}

#endif /* RECURRING_TRANSFER */
