/* $Id: psOutput.c,v 4.1 1995/08/10 20:37:01 lupus Exp lupus $ */

#include <stdio.h>
#include "psOutput.h"
#include "post.h"

static float yPos=TOP_MARGIN;
static int currentPage;
static int anyPrint;

void initPS(FILE *f) {
  /*setSize(f,POINT);*/
  yPos=TOP_MARGIN;
  currentPage=1;
  anyPrint=0;
}

void exitPS(FILE *f) {
  fprintf(f, "\n%%%%Trailer\n%%%%Pages: %d\n%%%%EOF\n", currentPage-1);
}

void checkFirstPrint(FILE *f) {
  if( !anyPrint ) {
    anyPrint=1;
    fprintf(f, "%%%%Page: %d %d\n", currentPage, currentPage);
  }
}

void showpage(FILE *f) {
  header(f,currentPage);
  fprintf(f, "\nshowpage\n\n");
  currentPage++;
  anyPrint=0;
}

void skrivXY(FILE *f, float x, float y, char *text) {
  checkFirstPrint(f);
  fprintf(f, "%.2f cm %.2f cm moveto\n", x, PAGE_LEN-y);
  fprintf(f, "(%s) show\n", text);
}

void skrivOutlineXY(FILE *f, float x, float y, char *text) {
  checkFirstPrint(f);
  fprintf(f, ".5 setlinewidth\n");
  fprintf(f, "%.2f cm %.2f cm moveto\n", x, PAGE_LEN-y);
  fprintf(f, "(%s) oshow\n", text);
}

void skriv(FILE *f, float x, char *text) {
  checkFirstPrint(f);
  skrivXY(f, x, yPos, text);
}

void skrivRJ(FILE *f, float x, char *text) {
  checkFirstPrint(f);
  fprintf(f, "%.2f cm (%s) stringwidth pop sub %.2f cm moveto\n", x, 
	              text, PAGE_LEN-yPos);
  fprintf(f, "(%s) show\n", text);
}

void newLine(FILE *f) {
  yPos+=LINE_SPACE;
  if( yPos>PAGE_LEN-BUT_MARGIN ) {
    showpage(f);
    yPos=TOP_MARGIN;
  }
}
  
void setSize(FILE *f, int points) {
  checkFirstPrint(f);
  fprintf(f, "/%s findfont\n", FONT);
  fprintf(f, "%d scalefont setfont\n\n", points);
}

void setFontSize(FILE *f, char *font, int points) {
  checkFirstPrint(f);
  fprintf(f, "/%s findfont\n", font);
  fprintf(f, "%d scalefont setfont\n\n", points);
}

int anyLinesPrintedOnCurrentPage(void) {
  return anyPrint;
}
