/* $Id: post_io.c,v 4.1 1995/08/10 20:37:01 lupus Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "post_io.h"
#include "xfinans.h"
#include "date.h"
#include "transNum.h"

/* "private" macro definitions used for conversion between the date
   format in the data files and the internal date format: 
*/

#define YEAR(d) ((d)/10000)
#define MON(d) (((d)-10000*YEAR(d))/100)
#define DAY(d) ((d)-10000*YEAR(d)-100*MON(d))

#define DAT(y, m, d) ( (y)*10000 + (m)*100 + (d))


void save_post(FILE *f, struct postering *post)
{
  fprintf(f, "c%d\nb%d\na%c%d\n%d\n%d\n%s\n%f\n", 
	  post->category,
	  post->number,
	  post->unit+'0', post->period,
          post->committed, 
	  DAT(year(post->dato), month(post->dato), day(post->dato)),
	  post->tekst,     post->bel);
}

int load_post(FILE *fptr, struct postering *returPar) {
  int t=0,l;
  char str[81];
  int tmp;
  
   if(!feof(fptr))
     if( fgets(str,80,fptr) )	{
       if(str[0]=='c') {            /* if this file format contains
                                       category numbers */
	 returPar->category=atoi(str+1);
	 fgets(str,80,fptr); /* read new string for the next item */
       } else {
	 returPar->category=0;
       }
       if(str[0]=='b') {            /* if this file format contains
                                       transaction numbers */
	 returPar->number=atoi(str+1);
	 fgets(str,80,fptr); /* read new string for the next item */
       } else {
	 returPar->number=newTransactionNumber();
       }
       if(str[0]=='a') {            /* if this file format contains
                                       period information */
	 returPar->unit=str[1]-'0';
	 returPar->period=atoi(str+2);
	 fgets(str,80,fptr); /* read new string for the next item */
       } else {
	 returPar->unit=P_MONTH;
	 returPar->period=1;
       }
       tmp=atoi(str);                 
       if(tmp<2) {                  /* if the number is 0 or 1, then it */
	 returPar->committed=tmp;   /* is a commit-bit */
	 fgets(str,80,fptr);        /* then follows the date */
	 tmp=atoi(str);
	 returPar->dato=makedate(YEAR(tmp), MON(tmp), DAY(tmp));
       } else {                     /* else there is no commit-data */
	 returPar->committed=1;     /* (old format), and we use defaults. */
	 returPar->dato=makedate(YEAR(tmp), MON(tmp), DAY(tmp));
       }
       fgets(returPar->tekst,80,fptr);
       l=strlen(returPar->tekst);
       returPar->tekst[l-1]='\0';
#if MAKULER
       strcpy(returPar->tekst, "Dummytekst");
#endif
       fgets(str,80,fptr);
       returPar->bel=atof(str);
       t++;
     }
  return t;
}
